/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.security.config;

import jakarta.servlet.Filter;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.fineract.infrastructure.businessdate.service.BusinessDateReadPlatformService;
import org.apache.fineract.infrastructure.core.config.FineractProperties;
import org.apache.fineract.infrastructure.core.domain.FineractRequestContextHolder;
import org.apache.fineract.infrastructure.core.filters.CallerIpTrackingFilter;
import org.apache.fineract.infrastructure.core.filters.CorrelationHeaderFilter;
import org.apache.fineract.infrastructure.core.filters.IdempotencyStoreFilter;
import org.apache.fineract.infrastructure.core.filters.IdempotencyStoreHelper;
import org.apache.fineract.infrastructure.core.filters.RequestResponseFilter;
import org.apache.fineract.infrastructure.core.service.MDCWrapper;
import org.apache.fineract.infrastructure.instancemode.filter.FineractInstanceModeApiFilter;
import org.apache.fineract.infrastructure.jobs.filter.LoanCOBApiFilter;
import org.apache.fineract.infrastructure.jobs.filter.LoanCOBFilterHelper;
import org.apache.fineract.infrastructure.security.converter.FineractJwtAuthenticationTokenConverter;
import org.apache.fineract.infrastructure.security.data.TenantAuthenticationDetails;
import org.apache.fineract.infrastructure.security.filter.BusinessDateFilter;
import org.apache.fineract.infrastructure.security.filter.TenantAwareAuthenticationFilter;
import org.apache.fineract.infrastructure.security.filter.TwoFactorAuthenticationFilter;
import org.apache.fineract.infrastructure.security.service.AuthTenantDetailsService;
import org.apache.fineract.infrastructure.security.service.TenantAwareJpaPlatformUserDetailsService;
import org.apache.fineract.infrastructure.security.service.TwoFactorService;
import org.apache.fineract.useradministration.domain.AppUser;
import org.apache.fineract.useradministration.domain.Role;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.core.annotation.Order;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.crypto.factory.PasswordEncoderFactories;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.server.authorization.client.InMemoryRegisteredClientRepository;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers.OAuth2AuthorizationServerConfigurer;
import org.springframework.security.oauth2.server.authorization.settings.ClientSettings;
import org.springframework.security.oauth2.server.authorization.token.JwtEncodingContext;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenCustomizer;
import org.springframework.security.oauth2.server.resource.web.BearerTokenResolver;
import org.springframework.security.oauth2.server.resource.web.DefaultBearerTokenResolver;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.ExceptionTranslationFilter;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.context.SecurityContextHolderFilter;
import org.springframework.web.filter.OncePerRequestFilter;

@Configuration
@EnableWebSecurity
@ConditionalOnProperty(value={"fineract.security.oauth2.enabled"})
@EnableConfigurationProperties(value={FineractProperties.class})
public class AuthorizationServerConfig {
    public static final String TENANT_ID = "tenantId";
    @Autowired
    private TenantAwareJpaPlatformUserDetailsService userDetailsService;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private MDCWrapper mdcWrapper;
    @Autowired(required=false)
    private LoanCOBFilterHelper loanCOBFilterHelper;
    @Autowired
    private IdempotencyStoreHelper idempotencyStoreHelper;
    @Autowired
    private FineractRequestContextHolder fineractRequestContextHolder;
    @Autowired
    private FineractProperties fineractProperties;
    @Autowired
    private AuthTenantDetailsService tenantDetailsService;
    @Autowired
    private BusinessDateReadPlatformService businessDateReadPlatformService;

    @Bean
    @Order(value=1)
    public SecurityFilterChain publicEndpoints(HttpSecurity http) throws Exception {
        http.securityMatcher(new String[]{"/swagger-ui/**", "/fineract.json", "/actuator/**", "/legacy-docs/apiLive.htm"}).authorizeHttpRequests(auth -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.anyRequest()).permitAll()).csrf(AbstractHttpConfigurer::disable);
        return (SecurityFilterChain)http.build();
    }

    @Bean
    @Order(value=2)
    public SecurityFilterChain authorizationServerSecurityFilterChain(HttpSecurity http) throws Exception {
        OAuth2AuthorizationServerConfigurer authorizationServerConfigurer = new OAuth2AuthorizationServerConfigurer();
        http.securityMatcher(authorizationServerConfigurer.getEndpointsMatcher()).authorizeHttpRequests(auth -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.anyRequest()).authenticated()).csrf(AbstractHttpConfigurer::disable).sessionManagement(session -> session.sessionCreationPolicy(SessionCreationPolicy.IF_REQUIRED)).exceptionHandling(exceptions -> exceptions.authenticationEntryPoint((AuthenticationEntryPoint)new LoginUrlAuthenticationEntryPoint("/login"))).apply((SecurityConfigurerAdapter)authorizationServerConfigurer);
        return (SecurityFilterChain)http.build();
    }

    @Bean
    @Order(value=3)
    public SecurityFilterChain protectedEndpoints(HttpSecurity http) throws Exception {
        http.csrf(AbstractHttpConfigurer::disable).authorizeHttpRequests(auth -> {
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.anyRequest()).authenticated();
            if (this.fineractProperties.getSecurity().getTwoFactor().isEnabled()) {
                ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.anyRequest()).hasAuthority("TWOFACTOR_AUTHENTICATED");
            }
        }).formLogin(form -> ((FormLoginConfigurer)form.loginPage("/login").authenticationDetailsSource(this.tenantAuthDetailsSource())).permitAll()).oauth2ResourceServer(resourceServer -> resourceServer.jwt(jwt -> jwt.jwtAuthenticationConverter((Converter)this.authenticationConverter()))).addFilterAfter((Filter)this.tenantAwareAuthenticationFilter(), SecurityContextHolderFilter.class).addFilterAfter((Filter)this.businessDateFilter(), TenantAwareAuthenticationFilter.class).addFilterAfter((Filter)this.requestResponseFilter(), ExceptionTranslationFilter.class).addFilterAfter((Filter)this.correlationHeaderFilter(), RequestResponseFilter.class).addFilterAfter((Filter)this.fineractInstanceModeApiFilter(), CorrelationHeaderFilter.class);
        if (!Objects.isNull(this.loanCOBFilterHelper)) {
            http.addFilterAfter((Filter)this.loanCOBApiFilter(), FineractInstanceModeApiFilter.class).addFilterAfter((Filter)this.idempotencyStoreFilter(), LoanCOBApiFilter.class);
        } else {
            http.addFilterAfter((Filter)this.idempotencyStoreFilter(), FineractInstanceModeApiFilter.class);
        }
        if (this.fineractProperties.getIpTracking().isEnabled()) {
            http.addFilterAfter((Filter)this.callerIpTrackingFilter(), RequestResponseFilter.class);
        }
        if (this.fineractProperties.getSecurity().getTwoFactor().isEnabled()) {
            http.addFilterAfter((Filter)this.twoFactorAuthenticationFilter(), CorrelationHeaderFilter.class);
        }
        return (SecurityFilterChain)http.build();
    }

    @Bean
    public OncePerRequestFilter tenantAwareAuthenticationFilter() {
        return new TenantAwareAuthenticationFilter(this.resolver(), this.tenantDetailsService);
    }

    @Bean
    public OncePerRequestFilter businessDateFilter() {
        return new BusinessDateFilter(this.businessDateReadPlatformService);
    }

    @Bean
    public BearerTokenResolver resolver() {
        return new DefaultBearerTokenResolver();
    }

    @Bean
    public PasswordEncoder passwordEncoder() {
        return PasswordEncoderFactories.createDelegatingPasswordEncoder();
    }

    @Bean
    public RegisteredClientRepository registeredClientRepository(FineractProperties fineractProperties) {
        List<RegisteredClient> clients = fineractProperties.getSecurity().getOauth2().getClient().getRegistrations().values().stream().map(reg -> RegisteredClient.withId((String)UUID.randomUUID().toString()).clientId(reg.getClientId()).clientAuthenticationMethods(methods -> methods.add(ClientAuthenticationMethod.NONE)).scopes(scopes -> scopes.addAll(reg.getScopes())).authorizationGrantTypes(grants -> reg.getAuthorizationGrantTypes().forEach(grant -> grants.add(new AuthorizationGrantType(grant)))).redirectUris(uris -> uris.addAll(reg.getRedirectUris())).clientSettings(ClientSettings.builder().requireAuthorizationConsent(reg.isRequireAuthorizationConsent()).build()).build()).toList();
        return new InMemoryRegisteredClientRepository(clients);
    }

    @Bean
    @Scope(value="prototype")
    public AuthenticationDetailsSource<HttpServletRequest, TenantAuthenticationDetails> tenantAuthDetailsSource() {
        return request -> {
            String tenantId = request.getParameter(TENANT_ID);
            String username = request.getParameter("username");
            String password = request.getParameter("password");
            return new TenantAuthenticationDetails(username, tenantId, password);
        };
    }

    @Bean
    public OAuth2TokenCustomizer<JwtEncodingContext> tokenCustomizer() {
        return context -> {
            UsernamePasswordAuthenticationToken authentication = (UsernamePasswordAuthenticationToken)context.getPrincipal();
            TenantAuthenticationDetails details = (TenantAuthenticationDetails)authentication.getDetails();
            AppUser appUser = (AppUser)authentication.getPrincipal();
            List<String> roles = appUser.getRoles().stream().map(Role::getName).toList();
            List scope = appUser.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toList());
            context.getClaims().claim("scope", scope).claim("role", roles).claim("tenant", (Object)details.getTenantId());
        };
    }

    @Bean
    public FineractJwtAuthenticationTokenConverter authenticationConverter() {
        return new FineractJwtAuthenticationTokenConverter(this.userDetailsService);
    }

    public RequestResponseFilter requestResponseFilter() {
        return new RequestResponseFilter();
    }

    public LoanCOBApiFilter loanCOBApiFilter() {
        return new LoanCOBApiFilter(this.loanCOBFilterHelper);
    }

    public TwoFactorAuthenticationFilter twoFactorAuthenticationFilter() {
        TwoFactorService twoFactorService = (TwoFactorService)this.applicationContext.getBean(TwoFactorService.class);
        return new TwoFactorAuthenticationFilter(twoFactorService);
    }

    public FineractInstanceModeApiFilter fineractInstanceModeApiFilter() {
        return new FineractInstanceModeApiFilter(this.fineractProperties);
    }

    public IdempotencyStoreFilter idempotencyStoreFilter() {
        return new IdempotencyStoreFilter(this.fineractRequestContextHolder, this.idempotencyStoreHelper, this.fineractProperties);
    }

    public CorrelationHeaderFilter correlationHeaderFilter() {
        return new CorrelationHeaderFilter(this.fineractProperties, this.mdcWrapper);
    }

    public CallerIpTrackingFilter callerIpTrackingFilter() {
        return new CallerIpTrackingFilter(this.fineractProperties);
    }
}

