/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.survey.api;

import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.infrastructure.survey.data.LikeliHoodPovertyLineData;
import org.apache.fineract.infrastructure.survey.data.PpiPovertyLineData;
import org.apache.fineract.infrastructure.survey.service.PovertyLineService;
import org.springframework.stereotype.Component;

@Path(value="/v1/povertyLine")
@Component
@Tag(name="Poverty Line", description="")
public class PovertyLineApiResource {
    private final DefaultToApiJsonSerializer<PpiPovertyLineData> toApiJsonSerializer;
    private final DefaultToApiJsonSerializer<LikeliHoodPovertyLineData> likelihoodToApiJsonSerializer;
    private final PlatformSecurityContext context;
    private final PovertyLineService readService;

    @GET
    @Path(value="{ppiName}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String retrieveAll(@PathParam(value="ppiName") String ppiName) {
        this.context.authenticatedUser().validateHasReadPermission("PovertyLine");
        PpiPovertyLineData povertyLine = this.readService.retrieveAll(ppiName);
        return this.toApiJsonSerializer.serialize((Object)povertyLine);
    }

    @GET
    @Path(value="{ppiName}/{likelihoodId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String retrieveAll(@PathParam(value="ppiName") String ppiName, @PathParam(value="likelihoodId") Long likelihoodId) {
        this.context.authenticatedUser().validateHasReadPermission("PovertyLine");
        LikeliHoodPovertyLineData likeliHoodPovertyLineData = this.readService.retrieveForLikelihood(ppiName, likelihoodId);
        return this.likelihoodToApiJsonSerializer.serialize((Object)likeliHoodPovertyLineData);
    }

    @Generated
    public PovertyLineApiResource(DefaultToApiJsonSerializer<PpiPovertyLineData> toApiJsonSerializer, DefaultToApiJsonSerializer<LikeliHoodPovertyLineData> likelihoodToApiJsonSerializer, PlatformSecurityContext context, PovertyLineService readService) {
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.likelihoodToApiJsonSerializer = likelihoodToApiJsonSerializer;
        this.context = context;
        this.readService = readService;
    }
}

