/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.organisation.provisioning.api;

import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.organisation.provisioning.data.ProvisioningCategoryData;
import org.apache.fineract.organisation.provisioning.service.ProvisioningCategoryReadPlatformService;
import org.springframework.stereotype.Component;

@Path(value="/v1/provisioningcategory")
@Component
@Tag(name="Provisioning Category", description="")
public class ProvisioningCategoryApiResource {
    private final PlatformSecurityContext platformSecurityContext;
    private final ProvisioningCategoryReadPlatformService provisioningCategoryReadPlatformService;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public List<ProvisioningCategoryData> retrieveAll() {
        this.platformSecurityContext.authenticatedUser();
        return this.provisioningCategoryReadPlatformService.retrieveAllProvisionCategories();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public CommandProcessingResult createProvisioningCategory(String apiRequestBodyAsJson) {
        this.platformSecurityContext.authenticatedUser();
        CommandWrapper commandWrapper = new CommandWrapperBuilder().createProvisioningCategory().withJson(apiRequestBodyAsJson).build();
        return this.commandsSourceWritePlatformService.logCommandSource(commandWrapper);
    }

    @PUT
    @Path(value="{categoryId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public CommandProcessingResult updateProvisioningCategory(@PathParam(value="categoryId") Long categoryId, String apiRequestBodyAsJson) {
        this.platformSecurityContext.authenticatedUser();
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateProvisioningCategory(categoryId).withJson(apiRequestBodyAsJson).build();
        return this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
    }

    @DELETE
    @Path(value="{categoryId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public CommandProcessingResult deleteProvisioningCategory(@PathParam(value="categoryId") Long categoryId) {
        this.platformSecurityContext.authenticatedUser();
        CommandWrapper commandRequest = new CommandWrapperBuilder().deleteProvisioningCategory(categoryId).build();
        return this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
    }

    @Generated
    public ProvisioningCategoryApiResource(PlatformSecurityContext platformSecurityContext, ProvisioningCategoryReadPlatformService provisioningCategoryReadPlatformService, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService) {
        this.platformSecurityContext = platformSecurityContext;
        this.provisioningCategoryReadPlatformService = provisioningCategoryReadPlatformService;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
    }
}

