/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.account.domain;

import java.math.BigDecimal;
import java.time.LocalDate;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.organisation.monetary.domain.MonetaryCurrency;
import org.apache.fineract.organisation.monetary.domain.Money;
import org.apache.fineract.portfolio.account.data.AccountTransferDTO;
import org.apache.fineract.portfolio.account.domain.AccountTransferDetailAssembler;
import org.apache.fineract.portfolio.account.domain.AccountTransferDetails;
import org.apache.fineract.portfolio.account.domain.AccountTransferTransaction;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransaction;
import org.apache.fineract.portfolio.savings.domain.SavingsAccount;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountTransaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AccountTransferAssembler {
    private final AccountTransferDetailAssembler accountTransferDetailAssembler;

    @Autowired
    public AccountTransferAssembler(AccountTransferDetailAssembler accountTransferDetailAssembler) {
        this.accountTransferDetailAssembler = accountTransferDetailAssembler;
    }

    public AccountTransferDetails assembleSavingsToSavingsTransfer(JsonCommand command, SavingsAccount fromSavingsAccount, SavingsAccount toSavingsAccount, SavingsAccountTransaction withdrawal, SavingsAccountTransaction deposit) {
        AccountTransferDetails accountTransferDetails = this.accountTransferDetailAssembler.assembleSavingsToSavingsTransfer(command, fromSavingsAccount, toSavingsAccount);
        LocalDate transactionDate = command.localDateValueOfParameterNamed("transferDate");
        BigDecimal transactionAmount = command.bigDecimalValueOfParameterNamed("transferAmount");
        Money transactionMonetaryAmount = Money.of((MonetaryCurrency)fromSavingsAccount.getCurrency(), (BigDecimal)transactionAmount);
        String description = command.stringValueOfParameterNamed("transferDescription");
        AccountTransferTransaction accountTransferTransaction = AccountTransferTransaction.savingsToSavingsTransfer((AccountTransferDetails)accountTransferDetails, (SavingsAccountTransaction)withdrawal, (SavingsAccountTransaction)deposit, (LocalDate)transactionDate, (Money)transactionMonetaryAmount, (String)description);
        accountTransferDetails.addAccountTransferTransaction(accountTransferTransaction);
        return accountTransferDetails;
    }

    public AccountTransferDetails assembleSavingsToLoanTransfer(JsonCommand command, SavingsAccount fromSavingsAccount, Loan toLoanAccount, SavingsAccountTransaction withdrawal, LoanTransaction loanRepaymentTransaction) {
        AccountTransferDetails accountTransferDetails = this.accountTransferDetailAssembler.assembleSavingsToLoanTransfer(command, fromSavingsAccount, toLoanAccount);
        LocalDate transactionDate = command.localDateValueOfParameterNamed("transferDate");
        BigDecimal transactionAmount = command.bigDecimalValueOfParameterNamed("transferAmount");
        Money transactionMonetaryAmount = Money.of((MonetaryCurrency)fromSavingsAccount.getCurrency(), (BigDecimal)transactionAmount);
        String description = command.stringValueOfParameterNamed("transferDescription");
        AccountTransferTransaction accountTransferTransaction = AccountTransferTransaction.savingsToLoanTransfer((AccountTransferDetails)accountTransferDetails, (SavingsAccountTransaction)withdrawal, (LoanTransaction)loanRepaymentTransaction, (LocalDate)transactionDate, (Money)transactionMonetaryAmount, (String)description);
        accountTransferDetails.addAccountTransferTransaction(accountTransferTransaction);
        return accountTransferDetails;
    }

    public AccountTransferDetails assembleLoanToSavingsTransfer(JsonCommand command, Loan fromLoanAccount, SavingsAccount toSavingsAccount, SavingsAccountTransaction deposit, LoanTransaction loanRefundTransaction) {
        AccountTransferDetails accountTransferDetails = this.accountTransferDetailAssembler.assembleLoanToSavingsTransfer(command, fromLoanAccount, toSavingsAccount);
        LocalDate transactionDate = command.localDateValueOfParameterNamed("transferDate");
        BigDecimal transactionAmount = command.bigDecimalValueOfParameterNamed("transferAmount");
        Money transactionMonetaryAmount = Money.of((MonetaryCurrency)toSavingsAccount.getCurrency(), (BigDecimal)transactionAmount);
        String description = command.stringValueOfParameterNamed("transferDescription");
        AccountTransferTransaction accountTransferTransaction = AccountTransferTransaction.loanTosavingsTransfer((AccountTransferDetails)accountTransferDetails, (SavingsAccountTransaction)deposit, (LoanTransaction)loanRefundTransaction, (LocalDate)transactionDate, (Money)transactionMonetaryAmount, (String)description);
        accountTransferDetails.addAccountTransferTransaction(accountTransferTransaction);
        return accountTransferDetails;
    }

    public AccountTransferDetails assembleSavingsToLoanTransfer(AccountTransferDTO accountTransferDTO, SavingsAccount fromSavingsAccount, Loan toLoanAccount, SavingsAccountTransaction savingsAccountTransaction, LoanTransaction loanTransaction) {
        Money transactionMonetaryAmount = Money.of((MonetaryCurrency)fromSavingsAccount.getCurrency(), (BigDecimal)accountTransferDTO.getTransactionAmount());
        AccountTransferDetails accountTransferDetails = accountTransferDTO.getAccountTransferDetails();
        if (accountTransferDetails == null) {
            accountTransferDetails = this.accountTransferDetailAssembler.assembleSavingsToLoanTransfer(fromSavingsAccount, toLoanAccount, accountTransferDTO.getTransferType());
        }
        AccountTransferTransaction accountTransferTransaction = AccountTransferTransaction.savingsToLoanTransfer((AccountTransferDetails)accountTransferDetails, (SavingsAccountTransaction)savingsAccountTransaction, (LoanTransaction)loanTransaction, (LocalDate)accountTransferDTO.getTransactionDate(), (Money)transactionMonetaryAmount, (String)accountTransferDTO.getDescription());
        accountTransferDetails.addAccountTransferTransaction(accountTransferTransaction);
        return accountTransferDetails;
    }

    public AccountTransferDetails assembleSavingsToSavingsTransfer(AccountTransferDTO accountTransferDTO, SavingsAccount fromSavingsAccount, SavingsAccount toSavingsAccount, SavingsAccountTransaction withdrawal, SavingsAccountTransaction deposit) {
        Money transactionMonetaryAmount = Money.of((MonetaryCurrency)fromSavingsAccount.getCurrency(), (BigDecimal)accountTransferDTO.getTransactionAmount());
        AccountTransferDetails accountTransferDetails = accountTransferDTO.getAccountTransferDetails();
        if (accountTransferDetails == null) {
            accountTransferDetails = this.accountTransferDetailAssembler.assembleSavingsToSavingsTransfer(fromSavingsAccount, toSavingsAccount, accountTransferDTO.getTransferType());
        }
        AccountTransferTransaction accountTransferTransaction = AccountTransferTransaction.savingsToSavingsTransfer((AccountTransferDetails)accountTransferDetails, (SavingsAccountTransaction)withdrawal, (SavingsAccountTransaction)deposit, (LocalDate)accountTransferDTO.getTransactionDate(), (Money)transactionMonetaryAmount, (String)accountTransferDTO.getDescription());
        accountTransferDetails.addAccountTransferTransaction(accountTransferTransaction);
        return accountTransferDetails;
    }

    public AccountTransferDetails assembleLoanToSavingsTransfer(AccountTransferDTO accountTransferDTO, Loan fromLoanAccount, SavingsAccount toSavingsAccount, SavingsAccountTransaction deposit, LoanTransaction loanRefundTransaction) {
        Money transactionMonetaryAmount = Money.of((MonetaryCurrency)fromLoanAccount.getCurrency(), (BigDecimal)accountTransferDTO.getTransactionAmount());
        AccountTransferDetails accountTransferDetails = accountTransferDTO.getAccountTransferDetails();
        if (accountTransferDetails == null) {
            accountTransferDetails = this.accountTransferDetailAssembler.assembleLoanToSavingsTransfer(fromLoanAccount, toSavingsAccount, accountTransferDTO.getTransferType());
        }
        AccountTransferTransaction accountTransferTransaction = AccountTransferTransaction.loanTosavingsTransfer((AccountTransferDetails)accountTransferDetails, (SavingsAccountTransaction)deposit, (LoanTransaction)loanRefundTransaction, (LocalDate)accountTransferDTO.getTransactionDate(), (Money)transactionMonetaryAmount, (String)accountTransferDTO.getDescription());
        accountTransferDetails.addAccountTransferTransaction(accountTransferTransaction);
        return accountTransferDetails;
    }

    public AccountTransferDetails assembleLoanToLoanTransfer(AccountTransferDTO accountTransferDTO, Loan fromLoanAccount, Loan toLoanAccount, LoanTransaction disburseTransaction, LoanTransaction repaymentTransaction) {
        Money transactionMonetaryAmount = Money.of((MonetaryCurrency)fromLoanAccount.getCurrency(), (BigDecimal)accountTransferDTO.getTransactionAmount());
        AccountTransferDetails accountTransferDetails = accountTransferDTO.getAccountTransferDetails();
        if (accountTransferDetails == null) {
            accountTransferDetails = this.accountTransferDetailAssembler.assembleLoanToLoanTransfer(fromLoanAccount, toLoanAccount, accountTransferDTO.getFromTransferType());
        }
        AccountTransferTransaction accountTransferTransaction = AccountTransferTransaction.loanToLoanTransfer((AccountTransferDetails)accountTransferDetails, (LoanTransaction)disburseTransaction, (LoanTransaction)repaymentTransaction, (LocalDate)accountTransferDTO.getTransactionDate(), (Money)transactionMonetaryAmount, (String)accountTransferDTO.getDescription());
        accountTransferDetails.addAccountTransferTransaction(accountTransferTransaction);
        return accountTransferDetails;
    }
}

