/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.account.domain;

import com.google.gson.JsonElement;
import java.util.Locale;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.organisation.office.domain.Office;
import org.apache.fineract.organisation.office.domain.OfficeRepositoryWrapper;
import org.apache.fineract.portfolio.account.domain.AccountTransferDetails;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.portfolio.client.domain.ClientRepositoryWrapper;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.service.LoanAssembler;
import org.apache.fineract.portfolio.savings.domain.SavingsAccount;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountAssembler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AccountTransferDetailAssembler {
    private final ClientRepositoryWrapper clientRepository;
    private final OfficeRepositoryWrapper officeRepositoryWrapper;
    private final SavingsAccountAssembler savingsAccountAssembler;
    private final FromJsonHelper fromApiJsonHelper;
    private final LoanAssembler loanAccountAssembler;

    @Autowired
    public AccountTransferDetailAssembler(ClientRepositoryWrapper clientRepository, OfficeRepositoryWrapper officeRepositoryWrapper, SavingsAccountAssembler savingsAccountAssembler, FromJsonHelper fromApiJsonHelper, LoanAssembler loanAccountAssembler) {
        this.clientRepository = clientRepository;
        this.officeRepositoryWrapper = officeRepositoryWrapper;
        this.savingsAccountAssembler = savingsAccountAssembler;
        this.fromApiJsonHelper = fromApiJsonHelper;
        this.loanAccountAssembler = loanAccountAssembler;
    }

    public AccountTransferDetails assembleSavingsToSavingsTransfer(JsonCommand command) {
        Long fromSavingsId = command.longValueOfParameterNamed("fromAccountId");
        SavingsAccount fromSavingsAccount = this.savingsAccountAssembler.assembleFrom(fromSavingsId, false);
        boolean backdatedTxnsAllowedTill = false;
        Long toSavingsId = command.longValueOfParameterNamed("toAccountId");
        SavingsAccount toSavingsAccount = this.savingsAccountAssembler.assembleFrom(toSavingsId, false);
        return this.assembleSavingsToSavingsTransfer(command, fromSavingsAccount, toSavingsAccount);
    }

    public AccountTransferDetails assembleSavingsToLoanTransfer(JsonCommand command) {
        Long fromSavingsAccountId = command.longValueOfParameterNamed("fromAccountId");
        boolean backdatedTxnsAllowedTill = false;
        SavingsAccount fromSavingsAccount = this.savingsAccountAssembler.assembleFrom(fromSavingsAccountId, false);
        Long toLoanAccountId = command.longValueOfParameterNamed("toAccountId");
        Loan toLoanAccount = this.loanAccountAssembler.assembleFrom(toLoanAccountId);
        return this.assembleSavingsToLoanTransfer(command, fromSavingsAccount, toLoanAccount);
    }

    public AccountTransferDetails assembleLoanToSavingsTransfer(JsonCommand command) {
        Long fromLoanAccountId = command.longValueOfParameterNamed("fromAccountId");
        Loan fromLoanAccount = this.loanAccountAssembler.assembleFrom(fromLoanAccountId);
        boolean backdatedTxnsAllowedTill = false;
        Long toSavingsAccountId = command.longValueOfParameterNamed("toAccountId");
        SavingsAccount toSavingsAccount = this.savingsAccountAssembler.assembleFrom(toSavingsAccountId, false);
        return this.assembleLoanToSavingsTransfer(command, fromLoanAccount, toSavingsAccount);
    }

    public AccountTransferDetails assembleSavingsToSavingsTransfer(JsonCommand command, SavingsAccount fromSavingsAccount, SavingsAccount toSavingsAccount) {
        JsonElement element = command.parsedJson();
        Long fromOfficeId = this.fromApiJsonHelper.extractLongNamed("fromOfficeId", element);
        Office fromOffice = this.officeRepositoryWrapper.findOneWithNotFoundDetection(fromOfficeId);
        Long fromClientId = this.fromApiJsonHelper.extractLongNamed("fromClientId", element);
        Client fromClient = this.clientRepository.findOneWithNotFoundDetection(fromClientId);
        Long toOfficeId = this.fromApiJsonHelper.extractLongNamed("toOfficeId", element);
        Office toOffice = this.officeRepositoryWrapper.findOneWithNotFoundDetection(toOfficeId);
        Long toClientId = this.fromApiJsonHelper.extractLongNamed("toClientId", element);
        Client toClient = this.clientRepository.findOneWithNotFoundDetection(toClientId);
        Integer transfertype = this.fromApiJsonHelper.extractIntegerNamed("transferType", element, Locale.getDefault());
        return AccountTransferDetails.savingsToSavingsTransfer((Office)fromOffice, (Client)fromClient, (SavingsAccount)fromSavingsAccount, (Office)toOffice, (Client)toClient, (SavingsAccount)toSavingsAccount, (Integer)transfertype);
    }

    public AccountTransferDetails assembleSavingsToLoanTransfer(JsonCommand command, SavingsAccount fromSavingsAccount, Loan toLoanAccount) {
        JsonElement element = command.parsedJson();
        Long fromOfficeId = this.fromApiJsonHelper.extractLongNamed("fromOfficeId", element);
        Office fromOffice = this.officeRepositoryWrapper.findOneWithNotFoundDetection(fromOfficeId);
        Long fromClientId = this.fromApiJsonHelper.extractLongNamed("fromClientId", element);
        Client fromClient = this.clientRepository.findOneWithNotFoundDetection(fromClientId);
        Long toOfficeId = this.fromApiJsonHelper.extractLongNamed("toOfficeId", element);
        Office toOffice = this.officeRepositoryWrapper.findOneWithNotFoundDetection(toOfficeId);
        Long toClientId = this.fromApiJsonHelper.extractLongNamed("toClientId", element);
        Client toClient = this.clientRepository.findOneWithNotFoundDetection(toClientId);
        Integer transfertype = this.fromApiJsonHelper.extractIntegerNamed("transferType", element, Locale.getDefault());
        return AccountTransferDetails.savingsToLoanTransfer((Office)fromOffice, (Client)fromClient, (SavingsAccount)fromSavingsAccount, (Office)toOffice, (Client)toClient, (Loan)toLoanAccount, (Integer)transfertype);
    }

    public AccountTransferDetails assembleLoanToSavingsTransfer(JsonCommand command, Loan fromLoanAccount, SavingsAccount toSavingsAccount) {
        JsonElement element = command.parsedJson();
        Long fromOfficeId = this.fromApiJsonHelper.extractLongNamed("fromOfficeId", element);
        Office fromOffice = this.officeRepositoryWrapper.findOneWithNotFoundDetection(fromOfficeId);
        Long fromClientId = this.fromApiJsonHelper.extractLongNamed("fromClientId", element);
        Client fromClient = this.clientRepository.findOneWithNotFoundDetection(fromClientId);
        Long toOfficeId = this.fromApiJsonHelper.extractLongNamed("toOfficeId", element);
        Office toOffice = this.officeRepositoryWrapper.findOneWithNotFoundDetection(toOfficeId);
        Long toClientId = this.fromApiJsonHelper.extractLongNamed("toClientId", element);
        Client toClient = this.clientRepository.findOneWithNotFoundDetection(toClientId);
        Integer transfertype = this.fromApiJsonHelper.extractIntegerNamed("transferType", element, Locale.getDefault());
        return AccountTransferDetails.loanTosavingsTransfer((Office)fromOffice, (Client)fromClient, (Loan)fromLoanAccount, (Office)toOffice, (Client)toClient, (SavingsAccount)toSavingsAccount, (Integer)transfertype);
    }

    public AccountTransferDetails assembleSavingsToLoanTransfer(SavingsAccount fromSavingsAccount, Loan toLoanAccount, Integer transferType) {
        Office fromOffice = fromSavingsAccount.office();
        Client fromClient = fromSavingsAccount.getClient();
        Office toOffice = toLoanAccount.getOffice();
        Client toClient = toLoanAccount.client();
        return AccountTransferDetails.savingsToLoanTransfer((Office)fromOffice, (Client)fromClient, (SavingsAccount)fromSavingsAccount, (Office)toOffice, (Client)toClient, (Loan)toLoanAccount, (Integer)transferType);
    }

    public AccountTransferDetails assembleSavingsToSavingsTransfer(SavingsAccount fromSavingsAccount, SavingsAccount toSavingsAccount, Integer transferType) {
        Office fromOffice = fromSavingsAccount.office();
        Client fromClient = fromSavingsAccount.getClient();
        Office toOffice = toSavingsAccount.office();
        Client toClient = toSavingsAccount.getClient();
        return AccountTransferDetails.savingsToSavingsTransfer((Office)fromOffice, (Client)fromClient, (SavingsAccount)fromSavingsAccount, (Office)toOffice, (Client)toClient, (SavingsAccount)toSavingsAccount, (Integer)transferType);
    }

    public AccountTransferDetails assembleLoanToSavingsTransfer(Loan fromLoanAccount, SavingsAccount toSavingsAccount, Integer transferType) {
        Office fromOffice = fromLoanAccount.getOffice();
        Client fromClient = fromLoanAccount.client();
        Office toOffice = toSavingsAccount.office();
        Client toClient = toSavingsAccount.getClient();
        return AccountTransferDetails.loanTosavingsTransfer((Office)fromOffice, (Client)fromClient, (Loan)fromLoanAccount, (Office)toOffice, (Client)toClient, (SavingsAccount)toSavingsAccount, (Integer)transferType);
    }

    public AccountTransferDetails assembleLoanToLoanTransfer(Loan fromLoanAccount, Loan toLoanAccount, Integer transferType) {
        Office fromOffice = fromLoanAccount.getOffice();
        Client fromClient = fromLoanAccount.client();
        Office toOffice = toLoanAccount.getOffice();
        Client toClient = toLoanAccount.client();
        return AccountTransferDetails.loanToLoanTransfer((Office)fromOffice, (Client)fromClient, (Loan)fromLoanAccount, (Office)toOffice, (Client)toClient, (Loan)toLoanAccount, (Integer)transferType);
    }
}

