/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.client.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.address.data.AddressData;
import org.apache.fineract.portfolio.address.filter.ClientAddressSearchParam;
import org.apache.fineract.portfolio.address.service.AddressReadPlatformServiceImpl;
import org.apache.fineract.portfolio.client.api.ClientAddressApiResourcesSwagger;
import org.apache.fineract.portfolio.client.data.ClientAddressRequest;
import org.springframework.stereotype.Component;

@Path(value="/v1/client")
@Component
@Tag(name="Clients Address", description="Address module is an optional module and can be configured into the system by using GlobalConfiguration setting: enable-address. In order to activate Address module, we need to enable the configuration, enable-address by setting its value to true.")
public class ClientAddressApiResource {
    private static final String RESOURCE_NAME_FOR_PERMISSIONS = "Address";
    private final PlatformSecurityContext context;
    private final AddressReadPlatformServiceImpl readPlatformService;
    private final DefaultToApiJsonSerializer<AddressData> toApiJsonSerializer;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;

    @GET
    @Path(value="addresses/template")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public AddressData getAddressesTemplate() {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        return this.readPlatformService.retrieveTemplate();
    }

    @POST
    @Path(value="/{clientid}/addresses")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create an address for a Client", description="Mandatory Fields : \ntype and clientId")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=ClientAddressRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ClientAddressApiResourcesSwagger.PostClientClientIdAddressesResponse.class))})})
    public CommandProcessingResult addClientAddress(@QueryParam(value="type") @Parameter(description="type") long addressTypeId, @PathParam(value="clientid") @Parameter(description="clientId") long clientid, @Parameter(hidden=true) ClientAddressRequest clientAddressRequest) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().addClientAddress(clientid, addressTypeId).withJson(this.toApiJsonSerializer.serialize((Object)clientAddressRequest)).build();
        return this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
    }

    @GET
    @Path(value="/{clientid}/addresses")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List all addresses for a Client", description="Example Requests:\n\nclient/1/addresses\n\n\nclients/1/addresses?status=false,true&&type=1,2,3")
    public List<AddressData> getAddresses(@QueryParam(value="status") @Parameter(description="status") String status, @QueryParam(value="type") @Parameter(description="type") long addressTypeId, @PathParam(value="clientid") @Parameter(description="clientId") long clientid) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        return this.readPlatformService.retrieveBySearchParam(new ClientAddressSearchParam(Long.valueOf(clientid), Long.valueOf(addressTypeId), status));
    }

    @PUT
    @Path(value="/{clientid}/addresses")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update an address for a Client", description="All the address fields can be updated by using update client address API\n\nMandatory Fields\ntype and addressId")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=ClientAddressRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ClientAddressApiResourcesSwagger.PutClientClientIdAddressesResponse.class))})})
    public CommandProcessingResult updateClientAddress(@PathParam(value="clientid") @Parameter(description="clientId") long clientid, @Parameter(hidden=true) ClientAddressRequest clientAddressRequest) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateClientAddress(clientid).withJson(this.toApiJsonSerializer.serialize((Object)clientAddressRequest)).build();
        return this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
    }

    @Generated
    public ClientAddressApiResource(PlatformSecurityContext context, AddressReadPlatformServiceImpl readPlatformService, DefaultToApiJsonSerializer<AddressData> toApiJsonSerializer, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService) {
        this.context = context;
        this.readPlatformService = readPlatformService;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
    }
}

