/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.collectionsheet.serialization;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.serialization.AbstractFromApiJsonDeserializer;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.infrastructure.core.service.ExternalIdFactory;
import org.apache.fineract.portfolio.collectionsheet.command.CollectionSheetBulkRepaymentCommand;
import org.apache.fineract.portfolio.collectionsheet.command.SingleRepaymentCommand;
import org.apache.fineract.portfolio.paymentdetail.domain.PaymentDetail;
import org.apache.fineract.portfolio.paymentdetail.domain.PaymentDetailAssembler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class CollectionSheetBulkRepaymentCommandFromApiJsonDeserializer
extends AbstractFromApiJsonDeserializer<CollectionSheetBulkRepaymentCommand> {
    private final FromJsonHelper fromApiJsonHelper;
    private final PaymentDetailAssembler paymentDetailAssembler;

    @Autowired
    public CollectionSheetBulkRepaymentCommandFromApiJsonDeserializer(FromJsonHelper fromApiJsonHelper, PaymentDetailAssembler paymentDetailAssembler) {
        this.fromApiJsonHelper = fromApiJsonHelper;
        this.paymentDetailAssembler = paymentDetailAssembler;
    }

    public CollectionSheetBulkRepaymentCommand commandFromApiJson(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        JsonElement element = this.fromApiJsonHelper.parse(json);
        PaymentDetail paymentDetail = this.paymentDetailAssembler.fetchPaymentDetail(element.getAsJsonObject());
        return this.commandFromApiJson(json, paymentDetail);
    }

    public CollectionSheetBulkRepaymentCommand commandFromApiJson(String json, PaymentDetail paymentDetail) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        JsonElement element = this.fromApiJsonHelper.parse(json);
        LocalDate transactionDate = this.fromApiJsonHelper.extractLocalDateNamed("transactionDate", element);
        String note = this.fromApiJsonHelper.extractStringNamed("note", element);
        JsonObject topLevelJsonElement = element.getAsJsonObject();
        Locale locale = this.fromApiJsonHelper.extractLocaleParameter(topLevelJsonElement);
        SingleRepaymentCommand[] loanRepaymentTransactions = null;
        if (element.isJsonObject() && topLevelJsonElement.has("bulkRepaymentTransactions") && topLevelJsonElement.get("bulkRepaymentTransactions").isJsonArray()) {
            JsonArray array = topLevelJsonElement.get("bulkRepaymentTransactions").getAsJsonArray();
            loanRepaymentTransactions = new SingleRepaymentCommand[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                JsonObject loanTransactionElement = array.get(i).getAsJsonObject();
                Long loanId = this.fromApiJsonHelper.extractLongNamed("loanId", (JsonElement)loanTransactionElement);
                String externalIdStr = this.fromApiJsonHelper.extractStringNamed("externalId", (JsonElement)loanTransactionElement);
                ExternalId externalId = ExternalIdFactory.produce((String)externalIdStr);
                BigDecimal transactionAmount = this.fromApiJsonHelper.extractBigDecimalNamed("transactionAmount", (JsonElement)loanTransactionElement, locale);
                PaymentDetail detail = paymentDetail;
                if (paymentDetail == null) {
                    detail = this.paymentDetailAssembler.fetchPaymentDetail(loanTransactionElement);
                }
                if (transactionAmount == null || transactionAmount.intValue() <= 0) continue;
                loanRepaymentTransactions[i] = new SingleRepaymentCommand(loanId, externalId, transactionAmount, transactionDate, detail);
            }
        }
        return new CollectionSheetBulkRepaymentCommand(note, transactionDate, loanRepaymentTransactions);
    }
}

