/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.service;

import java.math.BigDecimal;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.portfolio.loanaccount.data.AmortizationAllocationBaseTransactionDTO;
import org.apache.fineract.portfolio.loanaccount.data.LoanAmortizationAllocationData;
import org.apache.fineract.portfolio.loanaccount.domain.AmortizationType;
import org.apache.fineract.portfolio.loanaccount.domain.LoanAmortizationAllocationMapping;
import org.apache.fineract.portfolio.loanaccount.domain.LoanAmortizationAllocationMappingRepository;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransaction;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionRepository;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionType;
import org.apache.fineract.portfolio.loanaccount.exception.InvalidLoanTransactionTypeException;
import org.apache.fineract.portfolio.loanaccount.exception.LoanTransactionNotFoundException;
import org.apache.fineract.portfolio.loanaccount.repository.LoanBuyDownFeeBalanceRepository;
import org.apache.fineract.portfolio.loanaccount.repository.LoanCapitalizedIncomeBalanceRepository;
import org.apache.fineract.portfolio.loanaccount.service.LoanAmortizationAllocationService;
import org.springframework.dao.EmptyResultDataAccessException;

public class LoanAmortizationAllocationServiceImpl
implements LoanAmortizationAllocationService {
    private final LoanAmortizationAllocationMappingRepository loanAmortizationAllocationMappingRepository;
    private final LoanTransactionRepository loanTransactionRepository;
    private final LoanCapitalizedIncomeBalanceRepository capitalizedIncomeBalanceRepository;
    private final LoanBuyDownFeeBalanceRepository buyDownFeeBalanceRepository;

    public LoanAmortizationAllocationData retrieveLoanAmortizationAllocationsForBuyDownFeeTransaction(Long loanTransactionId, Long loanId) {
        LoanTransaction loanTransaction = (LoanTransaction)this.loanTransactionRepository.findByIdAndLoanId(loanTransactionId, loanId).orElseThrow(() -> new LoanTransactionNotFoundException(loanTransactionId));
        if (!LoanTransactionType.BUY_DOWN_FEE.equals((Object)loanTransaction.getTypeOf())) {
            throw new InvalidLoanTransactionTypeException("transaction", "is.not.a.buydown.fee.transaction", "Transaction with ID " + loanTransactionId + " is not a Buy Down Fee transaction", new Object[0]);
        }
        return this.retrieveLoanAmortizationAllocationData(loanTransaction, loanId);
    }

    public LoanAmortizationAllocationData retrieveLoanAmortizationAllocationsForCapitalizedIncomeTransaction(Long loanTransactionId, Long loanId) {
        LoanTransaction loanTransaction = (LoanTransaction)this.loanTransactionRepository.findByIdAndLoanId(loanTransactionId, loanId).orElseThrow(() -> new LoanTransactionNotFoundException(loanTransactionId));
        if (!LoanTransactionType.CAPITALIZED_INCOME.equals((Object)loanTransaction.getTypeOf())) {
            throw new InvalidLoanTransactionTypeException("transaction", "is.not.a.capitalized.income.transaction", "Transaction with ID " + loanTransactionId + " is not a Capitalized Income transaction", new Object[0]);
        }
        return this.retrieveLoanAmortizationAllocationData(loanTransaction, loanId);
    }

    public BigDecimal calculateAlreadyAmortizedAmount(Long loanTransactionId, Long loanId) {
        return this.loanAmortizationAllocationMappingRepository.calculateAlreadyAmortizedAmount(loanTransactionId, loanId);
    }

    private LoanAmortizationAllocationData retrieveLoanAmortizationAllocationData(LoanTransaction loanTransaction, Long loanId) {
        try {
            Long loanTransactionId = (Long)loanTransaction.getId();
            AmortizationAllocationBaseTransactionDTO baseTransactionInfo = this.getBaseTransactionInfo(loanTransaction, loanId);
            if (baseTransactionInfo == null) {
                throw new LoanTransactionNotFoundException(loanTransactionId);
            }
            List amortizationMappings = this.loanAmortizationAllocationMappingRepository.findAmortizationMappingsByBaseTransactionAndLoan(loanTransactionId, loanId);
            List<LoanAmortizationAllocationData.AmortizationMappingData> mappings = amortizationMappings.stream().map(dto -> LoanAmortizationAllocationData.AmortizationMappingData.builder().amortizationLoanTransactionId(dto.getAmortizationLoanTransactionId()).amortizationLoanTransactionExternalId(dto.getAmortizationLoanTransactionExternalId()).date(dto.getAmortizationDate()).type(dto.getAmortizationType()).amount(dto.getAmount()).build()).toList();
            return new LoanAmortizationAllocationData(baseTransactionInfo.getLoanId(), baseTransactionInfo.getLoanExternalId(), baseTransactionInfo.getBaseLoanTransactionId(), baseTransactionInfo.getBaseLoanTransactionDate(), baseTransactionInfo.getBaseLoanTransactionAmount(), baseTransactionInfo.getUnrecognizedAmount(), baseTransactionInfo.getChargedOffAmount(), baseTransactionInfo.getAdjustmentAmount(), mappings);
        }
        catch (EmptyResultDataAccessException e) {
            throw new LoanTransactionNotFoundException((Long)loanTransaction.getId(), e);
        }
    }

    private AmortizationAllocationBaseTransactionDTO getBaseTransactionInfo(LoanTransaction loanTransaction, Long loanId) {
        if (loanTransaction.isBuyDownFee()) {
            return this.buyDownFeeBalanceRepository.findBaseTransactionInfo((Long)loanTransaction.getId(), loanId);
        }
        return this.capitalizedIncomeBalanceRepository.findBaseTransactionInfo((Long)loanTransaction.getId(), loanId);
    }

    public LoanAmortizationAllocationMapping createAmortizationAllocationMappingWithBaseLoanTransaction(LoanTransaction loanTransaction, BigDecimal amount, AmortizationType amortizationType) {
        return new LoanAmortizationAllocationMapping((Long)loanTransaction.getLoan().getId(), (Long)loanTransaction.getId(), null, null, amortizationType, amount);
    }

    public void setAmortizationTransactionDataAndSaveAmortizationAllocationMapping(LoanAmortizationAllocationMapping amortizationAllocationMapping, LoanTransaction amortizationTransaction) {
        LoanAmortizationAllocationMapping updatedMapping = new LoanAmortizationAllocationMapping(amortizationAllocationMapping.getLoanId(), amortizationAllocationMapping.getBaseLoanTransactionId(), amortizationTransaction.getTransactionDate(), (Long)amortizationTransaction.getId(), amortizationAllocationMapping.getAmortizationType(), amortizationAllocationMapping.getAmount());
        this.loanAmortizationAllocationMappingRepository.save((Object)updatedMapping);
    }

    @Generated
    public LoanAmortizationAllocationServiceImpl(LoanAmortizationAllocationMappingRepository loanAmortizationAllocationMappingRepository, LoanTransactionRepository loanTransactionRepository, LoanCapitalizedIncomeBalanceRepository capitalizedIncomeBalanceRepository, LoanBuyDownFeeBalanceRepository buyDownFeeBalanceRepository) {
        this.loanAmortizationAllocationMappingRepository = loanAmortizationAllocationMappingRepository;
        this.loanTransactionRepository = loanTransactionRepository;
        this.capitalizedIncomeBalanceRepository = capitalizedIncomeBalanceRepository;
        this.buyDownFeeBalanceRepository = buyDownFeeBalanceRepository;
    }
}

