/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.service;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.accountnumberformat.domain.AccountNumberFormat;
import org.apache.fineract.infrastructure.accountnumberformat.domain.AccountNumberFormatRepositoryWrapper;
import org.apache.fineract.infrastructure.accountnumberformat.domain.EntityAccountType;
import org.apache.fineract.infrastructure.codes.domain.CodeValue;
import org.apache.fineract.infrastructure.codes.domain.CodeValueRepositoryWrapper;
import org.apache.fineract.infrastructure.configuration.domain.ConfigurationDomainService;
import org.apache.fineract.infrastructure.configuration.service.TemporaryConfigurationServiceContainer;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.api.JsonQuery;
import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.infrastructure.core.service.ExternalIdFactory;
import org.apache.fineract.organisation.holiday.domain.HolidayRepository;
import org.apache.fineract.organisation.holiday.domain.HolidayStatusType;
import org.apache.fineract.organisation.monetary.domain.MonetaryCurrency;
import org.apache.fineract.organisation.staff.domain.Staff;
import org.apache.fineract.organisation.staff.domain.StaffRepository;
import org.apache.fineract.organisation.staff.exception.StaffNotFoundException;
import org.apache.fineract.organisation.staff.exception.StaffRoleException;
import org.apache.fineract.organisation.workingdays.domain.WorkingDays;
import org.apache.fineract.organisation.workingdays.domain.WorkingDaysRepositoryWrapper;
import org.apache.fineract.portfolio.account.service.AccountNumberGenerator;
import org.apache.fineract.portfolio.accountdetails.domain.AccountType;
import org.apache.fineract.portfolio.charge.domain.Charge;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.portfolio.client.domain.ClientRepositoryWrapper;
import org.apache.fineract.portfolio.collateralmanagement.service.LoanCollateralAssembler;
import org.apache.fineract.portfolio.common.domain.PeriodFrequencyType;
import org.apache.fineract.portfolio.fund.domain.Fund;
import org.apache.fineract.portfolio.fund.domain.FundRepository;
import org.apache.fineract.portfolio.fund.exception.FundNotFoundException;
import org.apache.fineract.portfolio.group.domain.Group;
import org.apache.fineract.portfolio.group.domain.GroupRepositoryWrapper;
import org.apache.fineract.portfolio.loanaccount.data.LoanChargeData;
import org.apache.fineract.portfolio.loanaccount.domain.GLIMAccountInfoRepository;
import org.apache.fineract.portfolio.loanaccount.domain.GroupLoanIndividualMonitoringAccount;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanCharge;
import org.apache.fineract.portfolio.loanaccount.domain.LoanCreditAllocationRule;
import org.apache.fineract.portfolio.loanaccount.domain.LoanPaymentAllocationRule;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepaymentScheduleTransactionProcessorFactory;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepositoryWrapper;
import org.apache.fineract.portfolio.loanaccount.domain.LoanStatus;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTopupDetails;
import org.apache.fineract.portfolio.loanaccount.domain.transactionprocessor.LoanRepaymentScheduleTransactionProcessor;
import org.apache.fineract.portfolio.loanaccount.exception.ExceedingTrancheCountException;
import org.apache.fineract.portfolio.loanaccount.exception.MultiDisbursementDataNotAllowedException;
import org.apache.fineract.portfolio.loanaccount.exception.MultiDisbursementDataRequiredException;
import org.apache.fineract.portfolio.loanaccount.loanschedule.domain.LoanApplicationTerms;
import org.apache.fineract.portfolio.loanaccount.loanschedule.domain.LoanScheduleModel;
import org.apache.fineract.portfolio.loanaccount.loanschedule.service.LoanScheduleAssembler;
import org.apache.fineract.portfolio.loanaccount.loanschedule.service.LoanScheduleCalculationPlatformService;
import org.apache.fineract.portfolio.loanaccount.mapper.LoanChargeMapper;
import org.apache.fineract.portfolio.loanaccount.mapper.LoanCollateralManagementMapper;
import org.apache.fineract.portfolio.loanaccount.service.GLIMAccountInfoWritePlatformService;
import org.apache.fineract.portfolio.loanaccount.service.LoanAccrualsProcessingService;
import org.apache.fineract.portfolio.loanaccount.service.LoanAssembler;
import org.apache.fineract.portfolio.loanaccount.service.LoanChargeAssembler;
import org.apache.fineract.portfolio.loanaccount.service.LoanChargeService;
import org.apache.fineract.portfolio.loanaccount.service.LoanDisbursementDetailsAssembler;
import org.apache.fineract.portfolio.loanaccount.service.LoanDisbursementService;
import org.apache.fineract.portfolio.loanaccount.service.LoanOfficerService;
import org.apache.fineract.portfolio.loanaccount.service.schedule.LoanScheduleComponent;
import org.apache.fineract.portfolio.loanproduct.domain.LoanProduct;
import org.apache.fineract.portfolio.loanproduct.domain.LoanProductRelatedDetail;
import org.apache.fineract.portfolio.loanproduct.domain.LoanProductRepository;
import org.apache.fineract.portfolio.loanproduct.exception.LoanProductNotFoundException;
import org.apache.fineract.portfolio.loanproduct.service.LoanEnumerations;
import org.apache.fineract.portfolio.rate.service.RateAssembler;
import org.apache.fineract.useradministration.domain.AppUser;

public class LoanAssemblerImpl
implements LoanAssembler {
    private final FromJsonHelper fromApiJsonHelper;
    private final LoanRepositoryWrapper loanRepository;
    private final LoanProductRepository loanProductRepository;
    private final ClientRepositoryWrapper clientRepository;
    private final GroupRepositoryWrapper groupRepository;
    private final FundRepository fundRepository;
    private final StaffRepository staffRepository;
    private final CodeValueRepositoryWrapper codeValueRepository;
    private final LoanScheduleAssembler loanScheduleAssembler;
    private final LoanChargeAssembler loanChargeAssembler;
    private final LoanCollateralAssembler collateralAssembler;
    private final LoanRepaymentScheduleTransactionProcessorFactory loanRepaymentScheduleTransactionProcessorFactory;
    private final HolidayRepository holidayRepository;
    private final ConfigurationDomainService configurationDomainService;
    private final WorkingDaysRepositoryWrapper workingDaysRepository;
    private final RateAssembler rateAssembler;
    private final ExternalIdFactory externalIdFactory;
    private final AccountNumberFormatRepositoryWrapper accountNumberFormatRepository;
    private final GLIMAccountInfoRepository glimRepository;
    private final AccountNumberGenerator accountNumberGenerator;
    private final GLIMAccountInfoWritePlatformService glimAccountInfoWritePlatformService;
    private final LoanCollateralAssembler loanCollateralAssembler;
    private final LoanScheduleCalculationPlatformService calculationPlatformService;
    private final LoanDisbursementDetailsAssembler loanDisbursementDetailsAssembler;
    private final LoanChargeMapper loanChargeMapper;
    private final LoanCollateralManagementMapper loanCollateralManagementMapper;
    private final LoanAccrualsProcessingService loanAccrualsProcessingService;
    private final LoanDisbursementService loanDisbursementService;
    private final LoanChargeService loanChargeService;
    private final LoanOfficerService loanOfficerService;
    private final LoanScheduleComponent loanSchedule;

    public Loan assembleFrom(Long accountId) {
        return this.assembleFrom(accountId, true);
    }

    public Loan assembleFrom(Long accountId, boolean loadLazyCollections) {
        return this.loanRepository.findOneWithNotFoundDetection(accountId, loadLazyCollections);
    }

    public Loan assembleFrom(ExternalId externalId) {
        return this.loanRepository.findOneWithNotFoundDetection(externalId, true);
    }

    public Loan assembleFrom(ExternalId externalId, boolean loadLazyCollections) {
        return this.loanRepository.findOneWithNotFoundDetection(externalId, loadLazyCollections);
    }

    public Loan assembleFrom(JsonCommand command) {
        Loan loanApplication;
        JsonElement element = command.parsedJson();
        Long clientId = this.fromApiJsonHelper.extractLongNamed("clientId", element);
        Long groupId = this.fromApiJsonHelper.extractLongNamed("groupId", element);
        String accountNo = this.fromApiJsonHelper.extractStringNamed("accountNo", element);
        Long productId = this.fromApiJsonHelper.extractLongNamed("productId", element);
        Long fundId = this.fromApiJsonHelper.extractLongNamed("fundId", element);
        Long loanOfficerId = this.fromApiJsonHelper.extractLongNamed("loanOfficerId", element);
        Long loanPurposeId = this.fromApiJsonHelper.extractLongNamed("loanPurposeId", element);
        Boolean syncDisbursementWithMeeting = this.fromApiJsonHelper.extractBooleanNamed("syncDisbursementWithMeeting", element);
        Boolean createStandingInstructionAtDisbursement = this.fromApiJsonHelper.extractBooleanNamed("createStandingInstructionAtDisbursement", element);
        LoanProduct loanProduct = (LoanProduct)this.loanProductRepository.findById((Object)productId).orElseThrow(() -> new LoanProductNotFoundException(productId));
        Boolean allowOverridingTransactionProcessingStrategy = loanProduct.getLoanConfigurableAttributes().getTransactionProcessingStrategyBoolean();
        String transactionProcessingStrategyCode = allowOverridingTransactionProcessingStrategy != false ? this.fromApiJsonHelper.extractStringNamed("transactionProcessingStrategyCode", element) : loanProduct.getTransactionProcessingStrategyCode();
        LoanRepaymentScheduleTransactionProcessor transactionProcessingStrategy = this.loanRepaymentScheduleTransactionProcessorFactory.determineProcessor(transactionProcessingStrategyCode);
        Fund fund = this.findFundByIdIfProvided(fundId);
        Staff loanOfficer = this.findLoanOfficerByIdIfProvided(loanOfficerId);
        CodeValue loanPurpose = null;
        if (loanPurposeId != null) {
            loanPurpose = this.codeValueRepository.findOneWithNotFoundDetection(loanPurposeId);
        }
        List disbursementDetails = new ArrayList();
        BigDecimal fixedEmiAmount = null;
        if (loanProduct.isMultiDisburseLoan() || loanProduct.isCanDefineInstallmentAmount()) {
            fixedEmiAmount = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("fixedEmiAmount", element);
        }
        BigDecimal maxOutstandingLoanBalance = null;
        if (loanProduct.isMultiDisburseLoan()) {
            Locale locale = this.fromApiJsonHelper.extractLocaleParameter(element.getAsJsonObject());
            maxOutstandingLoanBalance = this.fromApiJsonHelper.extractBigDecimalNamed("maxOutstandingLoanBalance", element, locale);
            disbursementDetails = this.loanDisbursementDetailsAssembler.fetchDisbursementData(element.getAsJsonObject());
        }
        String loanTypeStr = this.fromApiJsonHelper.extractStringNamed("loanType", element);
        Set collateral = new HashSet();
        AccountType loanAccountType = AccountType.fromName((String)loanTypeStr);
        if (loanAccountType.isIndividualAccount()) {
            collateral = this.collateralAssembler.fromParsedJson(element);
        }
        Set loanCharges = this.loanChargeAssembler.fromParsedJson(element, disbursementDetails);
        BigDecimal fixedPrincipalPercentagePerInstallment = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("fixedPrincipalPercentagePerInstallment", element);
        Client client = null;
        Group group = null;
        List rates = this.rateAssembler.fromParsedJson(element);
        LoanApplicationTerms loanApplicationTerms = this.loanScheduleAssembler.assembleLoanTerms(element);
        LoanProductRelatedDetail loanProductRelatedDetail = this.loanScheduleAssembler.assembleLoanProductRelatedDetail(loanApplicationTerms, element);
        BigDecimal interestRateDifferential = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("interestRateDifferential", element);
        Boolean isFloatingInterestRate = this.fromApiJsonHelper.extractBooleanNamed("isFloatingInterestRate", element);
        if (clientId != null) {
            client = this.clientRepository.findOneWithNotFoundDetection(clientId);
        }
        if (groupId != null) {
            group = this.groupRepository.findOneWithNotFoundDetection(groupId);
        }
        String externalIdStr = this.fromApiJsonHelper.extractStringNamed("externalId", element);
        ExternalId externalId = this.externalIdFactory.create(externalIdStr);
        LocalDate submittedOnDate = this.fromApiJsonHelper.extractLocalDateNamed("submittedOnDate", element);
        Boolean isEnableInstallmentLevelDelinquency = this.fromApiJsonHelper.extractBooleanNamed("enableInstallmentLevelDelinquency", element);
        if (isEnableInstallmentLevelDelinquency == null) {
            isEnableInstallmentLevelDelinquency = loanProduct.isEnableInstallmentLevelDelinquency();
        }
        boolean isHolidayEnabled = this.configurationDomainService.isRescheduleRepaymentsOnHolidaysEnabled();
        Long officeId = client != null ? (Long)client.getOffice().getId() : (Long)group.getOffice().getId();
        List holidays = this.holidayRepository.findByOfficeIdAndGreaterThanDate(officeId, loanApplicationTerms.getExpectedDisbursementDate(), HolidayStatusType.ACTIVE.getValue());
        WorkingDays workingDays = this.workingDaysRepository.findOne();
        LoanScheduleModel loanScheduleModel = this.loanScheduleAssembler.assembleLoanScheduleFrom(loanApplicationTerms, isHolidayEnabled, holidays, workingDays, element, disbursementDetails);
        if (client != null && group != null) {
            loanApplication = Loan.newIndividualLoanApplicationFromGroup((String)accountNo, (Client)client, (Group)group, (AccountType)loanAccountType, (LoanProduct)loanProduct, (Fund)fund, (Staff)loanOfficer, (CodeValue)loanPurpose, (LoanRepaymentScheduleTransactionProcessor)transactionProcessingStrategy, (LoanProductRelatedDetail)loanProductRelatedDetail, (Set)loanCharges, (Boolean)syncDisbursementWithMeeting, (BigDecimal)fixedEmiAmount, disbursementDetails, (BigDecimal)maxOutstandingLoanBalance, (Boolean)createStandingInstructionAtDisbursement, (Boolean)isFloatingInterestRate, (BigDecimal)interestRateDifferential, (List)rates, (BigDecimal)fixedPrincipalPercentagePerInstallment, (ExternalId)externalId, (LoanApplicationTerms)loanApplicationTerms, (Boolean)isEnableInstallmentLevelDelinquency, (LocalDate)submittedOnDate);
        } else if (group != null) {
            loanApplication = Loan.newGroupLoanApplication((String)accountNo, (Group)group, (AccountType)loanAccountType, (LoanProduct)loanProduct, (Fund)fund, (Staff)loanOfficer, (CodeValue)loanPurpose, (LoanRepaymentScheduleTransactionProcessor)transactionProcessingStrategy, (LoanProductRelatedDetail)loanProductRelatedDetail, (Set)loanCharges, (Boolean)syncDisbursementWithMeeting, (BigDecimal)fixedEmiAmount, disbursementDetails, (BigDecimal)maxOutstandingLoanBalance, (Boolean)createStandingInstructionAtDisbursement, (Boolean)isFloatingInterestRate, (BigDecimal)interestRateDifferential, (List)rates, (BigDecimal)fixedPrincipalPercentagePerInstallment, (ExternalId)externalId, (LoanApplicationTerms)loanApplicationTerms, (Boolean)isEnableInstallmentLevelDelinquency, (LocalDate)submittedOnDate);
        } else if (client != null) {
            loanApplication = Loan.newIndividualLoanApplication((String)accountNo, (Client)client, (AccountType)loanAccountType, (LoanProduct)loanProduct, (Fund)fund, (Staff)loanOfficer, (CodeValue)loanPurpose, (LoanRepaymentScheduleTransactionProcessor)transactionProcessingStrategy, (LoanProductRelatedDetail)loanProductRelatedDetail, (Set)loanCharges, collateral, (BigDecimal)fixedEmiAmount, disbursementDetails, (BigDecimal)maxOutstandingLoanBalance, (Boolean)createStandingInstructionAtDisbursement, (Boolean)isFloatingInterestRate, (BigDecimal)interestRateDifferential, (List)rates, (BigDecimal)fixedPrincipalPercentagePerInstallment, (ExternalId)externalId, (LoanApplicationTerms)loanApplicationTerms, (Boolean)isEnableInstallmentLevelDelinquency, (LocalDate)submittedOnDate);
        } else {
            throw new IllegalStateException("No loan application exists for either a client or group (or both).");
        }
        this.loanSchedule.updateLoanSchedule(loanApplication, loanScheduleModel);
        this.copyAdvancedPaymentRulesIfApplicable(transactionProcessingStrategyCode, loanProduct, loanApplication);
        this.loanChargeService.recalculateAllCharges(loanApplication);
        this.topUpLoanConfiguration(element, loanApplication);
        this.loanAccrualsProcessingService.reprocessExistingAccruals(loanApplication, false);
        return loanApplication;
    }

    public void accountNumberGeneration(JsonCommand command, Loan loan) {
        JsonElement element = command.parsedJson();
        String accountNo = this.fromApiJsonHelper.extractStringNamed("accountNo", element);
        boolean isAccountNumberRequiresAutoGeneration = StringUtils.isBlank((CharSequence)accountNo);
        if (!isAccountNumberRequiresAutoGeneration) {
            return;
        }
        AccountNumberFormat accountNumberFormat = this.accountNumberFormatRepository.findByAccountType(EntityAccountType.LOAN);
        if (loan.getLoanType().isGLIMAccount()) {
            Group group = loan.getGroup();
            BigDecimal applicationId = BigDecimal.ZERO;
            Locale locale = this.fromApiJsonHelper.extractLocaleParameter(element.getAsJsonObject());
            BigDecimal applicationIdFromParam = this.fromApiJsonHelper.extractBigDecimalNamed("applicationId", element, locale);
            BigDecimal totalLoan = this.fromApiJsonHelper.extractBigDecimalNamed("totalLoan", element, locale);
            if (applicationIdFromParam != null) {
                applicationId = applicationIdFromParam;
            }
            Boolean isLastChildApplicationFromParam = this.fromApiJsonHelper.extractBooleanNamed("lastApplication", element);
            boolean isLastChildApplication = false;
            if (isLastChildApplicationFromParam != null) {
                isLastChildApplication = isLastChildApplicationFromParam;
            }
            if (this.fromApiJsonHelper.extractBooleanNamed("isParentAccount", element) != null) {
                if (this.glimRepository.count() != 0L) {
                    this.createAndSetGLIMAccount(totalLoan, loan, accountNumberFormat, group, applicationId);
                } else {
                    this.createAndSetGLIMAccount(totalLoan, loan, accountNumberFormat, group, applicationId);
                }
            } else {
                if (this.glimRepository.count() != 0L) {
                    GroupLoanIndividualMonitoringAccount glimAccount = this.glimRepository.findOneByIsAcceptingChildAndApplicationId(true, applicationId);
                    String accountNumber = glimAccount.getAccountNumber() + (glimAccount.getChildAccountsCount() + 1L);
                    loan.setAccountNumber(accountNumber);
                    this.glimAccountInfoWritePlatformService.incrementChildAccountCount(glimAccount);
                    loan.setGlim(glimAccount);
                } else {
                    this.createAndSetGLIMAccount(totalLoan, loan, accountNumberFormat, group, applicationId);
                }
                if (isLastChildApplication) {
                    this.glimAccountInfoWritePlatformService.resetIsAcceptingChild(this.glimRepository.findOneByIsAcceptingChildAndApplicationId(true, applicationId));
                }
            }
        } else {
            loan.setAccountNumber(this.accountNumberGenerator.generate(loan, accountNumberFormat));
        }
    }

    private void createAndSetGLIMAccount(BigDecimal totalLoan, Loan loan, AccountNumberFormat accountNumberFormat, Group group, BigDecimal applicationId) {
        String accountNumber = this.accountNumberGenerator.generate(loan, accountNumberFormat);
        loan.setAccountNumber(accountNumber + "1");
        GroupLoanIndividualMonitoringAccount glimAccount = this.glimAccountInfoWritePlatformService.createGLIMAccount(accountNumber, group, totalLoan, Long.valueOf(1L), Boolean.valueOf(true), LoanStatus.SUBMITTED_AND_PENDING_APPROVAL.getValue(), applicationId);
        loan.setGlim(glimAccount);
    }

    private void topUpLoanConfiguration(JsonElement element, Loan loan) {
        if (loan.getLoanProduct().isCanUseForTopup() && loan.getClientId() != null) {
            Boolean isTopUp = this.fromApiJsonHelper.extractBooleanNamed("isTopup", element);
            if (null == isTopUp) {
                loan.setIsTopup(false);
            } else {
                loan.setIsTopup(isTopUp.booleanValue());
            }
            if (loan.isTopup()) {
                Long loanIdToClose = this.fromApiJsonHelper.extractLongNamed("loanIdToClose", element);
                loan.setTopupLoanDetails(new LoanTopupDetails(loan, loanIdToClose));
            }
        }
    }

    public CodeValue findCodeValueByIdIfProvided(Long codeValueId) {
        CodeValue codeValue = null;
        if (codeValueId != null) {
            codeValue = this.codeValueRepository.findOneWithNotFoundDetection(codeValueId);
        }
        return codeValue;
    }

    public Fund findFundByIdIfProvided(Long fundId) {
        Fund fund = null;
        if (fundId != null) {
            fund = (Fund)this.fundRepository.findById((Object)fundId).orElseThrow(() -> new FundNotFoundException(fundId));
        }
        return fund;
    }

    public Staff findLoanOfficerByIdIfProvided(Long loanOfficerId) {
        Staff staff = null;
        if (loanOfficerId != null && (staff = (Staff)this.staffRepository.findById((Object)loanOfficerId).orElseThrow(() -> new StaffNotFoundException(loanOfficerId))).isNotLoanOfficer()) {
            throw new StaffRoleException(loanOfficerId, StaffRoleException.StaffRole.LOAN_OFFICER);
        }
        return staff;
    }

    private void copyAdvancedPaymentRulesIfApplicable(String transactionProcessingStrategyCode, LoanProduct loanProduct, Loan loanApplication) {
        if (transactionProcessingStrategyCode.equals("advanced-payment-allocation-strategy")) {
            List<LoanPaymentAllocationRule> loanPaymentAllocationRules = loanProduct.getPaymentAllocationRules().stream().map(r -> new LoanPaymentAllocationRule(loanApplication, r.getTransactionType(), r.getAllocationTypes(), r.getFutureInstallmentAllocationRule())).toList();
            List paymentAllocationRules = loanApplication.getPaymentAllocationRules();
            paymentAllocationRules.clear();
            paymentAllocationRules.addAll(loanPaymentAllocationRules);
            if (loanProduct.getCreditAllocationRules() != null && !loanProduct.getCreditAllocationRules().isEmpty()) {
                List<LoanCreditAllocationRule> loanCreditAllocationRules = loanProduct.getCreditAllocationRules().stream().map(r -> new LoanCreditAllocationRule(loanApplication, r.getTransactionType(), r.getAllocationTypes())).toList();
                List creditAllocationRules = loanApplication.getCreditAllocationRules();
                creditAllocationRules.clear();
                creditAllocationRules.addAll(loanCreditAllocationRules);
            }
        }
    }

    public Map<String, Object> updateFrom(JsonCommand command, Loan loan) {
        Object valueAsInput;
        Object newValue;
        Comparable<Long> newValue2;
        Long groupId;
        Long clientId;
        String newValue3;
        HashMap<String, Object> changes = new HashMap<String, Object>();
        String productIdParamName = "productId";
        Long productId = command.longValueOfParameterNamed("productId");
        LoanProduct loanProduct = productId == null || productId.equals(loan.getLoanProduct().getId()) ? loan.getLoanProduct() : (LoanProduct)this.loanProductRepository.findById((Object)productId).orElseThrow(() -> new LoanProductNotFoundException(productId));
        Set existingCharges = loan.getActiveCharges();
        HashMap<Long, LoanChargeData> chargesMap = new HashMap<Long, LoanChargeData>();
        for (LoanCharge charge : existingCharges) {
            LoanChargeData chargeData = new LoanChargeData((Long)charge.getId(), charge.getDueLocalDate(), charge.amountOrPercentage());
            chargesMap.put((Long)charge.getId(), chargeData);
        }
        List disbursementDetails = this.loanDisbursementDetailsAssembler.fetchDisbursementData(command.parsedJson().getAsJsonObject());
        Set possiblyModifiedLoanCharges = this.loanChargeAssembler.fromParsedJson(command.parsedJson(), disbursementDetails);
        boolean isChargeModified = false;
        Set newTrancheCharges = this.loanChargeAssembler.getNewLoanTrancheCharges(command.parsedJson());
        for (Charge charge : newTrancheCharges) {
            loan.addTrancheLoanCharge(charge);
        }
        if (!possiblyModifiedLoanCharges.isEmpty() && !possiblyModifiedLoanCharges.containsAll(existingCharges)) {
            isChargeModified = true;
        }
        for (LoanCharge loanCharge : possiblyModifiedLoanCharges) {
            if (loanCharge.getId() == null) {
                isChargeModified = true;
                continue;
            }
            LoanChargeData chargeData = (LoanChargeData)chargesMap.get(loanCharge.getId());
            if (loanCharge.amountOrPercentage().compareTo(chargeData.getAmountOrPercentage()) == 0 && (!loanCharge.isSpecifiedDueDate() || loanCharge.getDueLocalDate().equals(chargeData.getDueDate()))) continue;
            isChargeModified = true;
        }
        Set possiblyModifedLoanCollateralItems = null;
        if (command.parameterExists("loanType")) {
            String loanTypeStr = command.stringValueOfParameterNamed("loanType");
            AccountType loanType = AccountType.fromName((String)loanTypeStr);
            if (!StringUtils.isBlank((CharSequence)loanTypeStr) && loanType.isIndividualAccount()) {
                possiblyModifedLoanCollateralItems = this.loanCollateralAssembler.fromParsedJson(command.parsedJson());
            }
        }
        this.loanScheduleAssembler.updateLoanApplicationAttributes(command, loan, changes);
        if (!changes.isEmpty()) {
            boolean recalculateLoanSchedule = changes.size() != 1 || !changes.containsKey("inArrearsTolerance");
            changes.put("recalculateLoanSchedule", recalculateLoanSchedule);
            isChargeModified = true;
        }
        String dateFormatAsInput = command.dateFormat();
        String localeAsInput = command.locale();
        if (command.isChangeInStringParameterNamed("accountNo", loan.getAccountNumber())) {
            newValue3 = command.stringValueOfParameterNamed("accountNo");
            changes.put("accountNo", newValue3);
            loan.setAccountNumber((String)StringUtils.defaultIfEmpty((CharSequence)newValue3, null));
        }
        if (command.isChangeInBooleanParameterNamed("createStandingInstructionAtDisbursement", loan.shouldCreateStandingInstructionAtDisbursement())) {
            Boolean valueAsInput2 = command.booleanObjectValueOfParameterNamed("createStandingInstructionAtDisbursement");
            changes.put("createStandingInstructionAtDisbursement", valueAsInput2);
            loan.setCreateStandingInstructionAtDisbursement(valueAsInput2);
        }
        if (command.isChangeInStringParameterNamed("externalId", loan.getExternalId().getValue())) {
            newValue3 = command.stringValueOfParameterNamed("externalId");
            ExternalId externalId = ExternalIdFactory.produce((String)newValue3);
            if (externalId.isEmpty() && TemporaryConfigurationServiceContainer.isExternalIdAutoGenerationEnabled()) {
                externalId = ExternalId.generate();
            }
            changes.put("externalId", externalId);
            loan.setExternalId(externalId);
        }
        Long l = clientId = loan.getClient() == null ? null : (Long)loan.getClient().getId();
        if (command.isChangeInLongParameterNamed("clientId", clientId)) {
            Long newValue4 = command.longValueOfParameterNamed("clientId");
            changes.put("clientId", newValue4);
            Client client = this.clientRepository.findOneWithNotFoundDetection(newValue4);
            loan.updateClient(client);
        }
        Long l2 = groupId = loan.getGroup() == null ? null : (Long)loan.getGroup().getId();
        if (command.isChangeInLongParameterNamed("groupId", groupId)) {
            newValue2 = command.longValueOfParameterNamed("groupId");
            changes.put("groupId", newValue2);
            Group group = this.groupRepository.findOneWithNotFoundDetection(newValue2);
            loan.updateGroup(group);
        }
        if (command.isChangeInLongParameterNamed("productId", (Long)loan.getLoanProduct().getId())) {
            newValue2 = command.longValueOfParameterNamed("productId");
            changes.put("productId", newValue2);
            loan.updateLoanProduct(loanProduct);
            MonetaryCurrency currency = new MonetaryCurrency(loanProduct.getCurrency().getCode(), loanProduct.getCurrency().getDigitsAfterDecimal(), loanProduct.getCurrency().getInMultiplesOf());
            loan.getLoanRepaymentScheduleDetail().setCurrency(currency);
            if (!changes.containsKey("interestRateFrequencyType")) {
                loan.updateInterestRateFrequencyType();
            }
            if (loanProduct.isLinkedToFloatingInterestRate()) {
                loan.getLoanProductRelatedDetail().updateForFloatingInterestRates();
            } else {
                loan.setInterestRateDifferential(null);
                loan.setIsFloatingInterestRate(null);
            }
            loan.updateIsInterestRecalculationEnabled();
            changes.put("recalculateLoanSchedule", true);
        }
        if (command.isChangeInBooleanParameterNamed("isFloatingInterestRate", loan.getIsFloatingInterestRate())) {
            newValue2 = command.booleanObjectValueOfParameterNamed("isFloatingInterestRate");
            changes.put("isFloatingInterestRate", newValue2);
            loan.setIsFloatingInterestRate((Boolean)newValue2);
        }
        if (command.isChangeInBigDecimalParameterNamed("interestRateDifferential", loan.getInterestRateDifferential())) {
            newValue2 = command.bigDecimalValueOfParameterNamed("interestRateDifferential");
            changes.put("interestRateDifferential", newValue2);
            loan.setInterestRateDifferential((BigDecimal)newValue2);
        }
        Long existingFundId = null;
        if (loan.getFund() != null) {
            existingFundId = (Long)loan.getFund().getId();
        }
        if (command.isChangeInLongParameterNamed("fundId", existingFundId)) {
            Long newValue5 = command.longValueOfParameterNamed("fundId");
            changes.put("fundId", newValue5);
            Fund fund = this.findFundByIdIfProvided(newValue5);
            loan.updateFund(fund);
        }
        Long existingLoanOfficerId = null;
        if (loan.getLoanOfficer() != null) {
            existingLoanOfficerId = (Long)loan.getLoanOfficer().getId();
        }
        if (command.isChangeInLongParameterNamed("loanOfficerId", existingLoanOfficerId)) {
            Long newValue6 = command.longValueOfParameterNamed("loanOfficerId");
            changes.put("loanOfficerId", newValue6);
            Staff newOfficer = this.findLoanOfficerByIdIfProvided(newValue6);
            this.loanOfficerService.updateLoanOfficerOnLoanApplication(loan, newOfficer);
        }
        Long existingLoanPurposeId = null;
        if (loan.getLoanPurpose() != null) {
            existingLoanPurposeId = (Long)loan.getLoanPurpose().getId();
        }
        if (command.isChangeInLongParameterNamed("loanPurposeId", existingLoanPurposeId)) {
            newValue = command.longValueOfParameterNamed("loanPurposeId");
            changes.put("loanPurposeId", newValue);
            CodeValue loanPurpose = this.findCodeValueByIdIfProvided((Long)newValue);
            loan.updateLoanPurpose(loanPurpose);
        }
        if (command.isChangeInStringParameterNamed("transactionProcessingStrategyCode", loan.getTransactionProcessingStrategyCode()) && loanProduct.getLoanConfigurableAttributes().getTransactionProcessingStrategyBoolean().booleanValue()) {
            newValue = command.stringValueOfParameterNamed("transactionProcessingStrategyCode");
            String transactionProcessingStrategyCode = command.stringValueOfParameterNamed("transactionProcessingStrategyCode");
            LoanRepaymentScheduleTransactionProcessor loanRepaymentScheduleTransactionProcessor = this.loanRepaymentScheduleTransactionProcessorFactory.determineProcessor(transactionProcessingStrategyCode);
            changes.put("transactionProcessingStrategyCode", newValue);
            loan.updateTransactionProcessingStrategy(transactionProcessingStrategyCode, loanRepaymentScheduleTransactionProcessor.getName());
        }
        if (command.isChangeInLocalDateParameterNamed("submittedOnDate", loan.getSubmittedOnDate())) {
            valueAsInput = command.stringValueOfParameterNamed("submittedOnDate");
            changes.put("submittedOnDate", valueAsInput);
            changes.put("dateFormat", dateFormatAsInput);
            changes.put("locale", localeAsInput);
            loan.setSubmittedOnDate(command.localDateValueOfParameterNamed("submittedOnDate"));
        }
        if (command.isChangeInLocalDateParameterNamed("expectedDisbursementDate", loan.getExpectedDisbursedOnLocalDate())) {
            valueAsInput = command.stringValueOfParameterNamed("expectedDisbursementDate");
            changes.put("expectedDisbursementDate", valueAsInput);
            changes.put("dateFormat", dateFormatAsInput);
            changes.put("locale", localeAsInput);
            changes.put("recalculateLoanSchedule", true);
            loan.setExpectedDisbursementDate(command.localDateValueOfParameterNamed("expectedDisbursementDate"));
        }
        if (command.isChangeInLocalDateParameterNamed("repaymentsStartingFromDate", loan.getExpectedFirstRepaymentOnDate())) {
            valueAsInput = command.stringValueOfParameterNamed("repaymentsStartingFromDate");
            changes.put("repaymentsStartingFromDate", valueAsInput);
            changes.put("dateFormat", dateFormatAsInput);
            changes.put("locale", localeAsInput);
            changes.put("recalculateLoanSchedule", true);
            loan.setExpectedFirstRepaymentOnDate(command.localDateValueOfParameterNamed("repaymentsStartingFromDate"));
        }
        if (command.isChangeInBooleanParameterNamed("syncDisbursementWithMeeting", Boolean.valueOf(loan.isSyncDisbursementWithMeeting()))) {
            valueAsInput = command.booleanObjectValueOfParameterNamed("syncDisbursementWithMeeting");
            changes.put("syncDisbursementWithMeeting", valueAsInput);
            loan.setSyncDisbursementWithMeeting((Boolean)valueAsInput);
        }
        if (command.isChangeInLocalDateParameterNamed("interestChargedFromDate", loan.getInterestChargedFromDate())) {
            valueAsInput = command.stringValueOfParameterNamed("interestChargedFromDate");
            changes.put("interestChargedFromDate", valueAsInput);
            changes.put("dateFormat", dateFormatAsInput);
            changes.put("locale", localeAsInput);
            changes.put("recalculateLoanSchedule", true);
            loan.setInterestChargedFromDate(command.localDateValueOfParameterNamed("interestChargedFromDate"));
        }
        if (isChargeModified) {
            changes.put("charges", this.loanChargeMapper.map(possiblyModifiedLoanCharges, loan.getCurrency()));
            changes.put("recalculateLoanSchedule", true);
        }
        if (command.parameterExists("collateral") && possiblyModifedLoanCollateralItems != null && possiblyModifedLoanCollateralItems.equals(loan.getLoanCollateralManagements())) {
            changes.put("collateral", this.loanCollateralManagementMapper.map(possiblyModifedLoanCollateralItems));
        }
        if (command.isChangeInIntegerParameterNamed("loanTermFrequency", loan.getTermFrequency())) {
            newValue = command.integerValueOfParameterNamed("loanTermFrequency");
            changes.put("loanTermFrequency", newValue);
            loan.setTermFrequency((Integer)newValue);
        }
        if (command.isChangeInIntegerParameterNamed("loanTermFrequencyType", loan.getTermPeriodFrequencyType().getValue())) {
            newValue = command.integerValueOfParameterNamed("loanTermFrequencyType");
            changes.put("loanTermFrequencyType", newValue);
            loan.setTermPeriodFrequencyType(PeriodFrequencyType.fromInt((Integer)newValue));
        }
        if (command.isChangeInBigDecimalParameterNamed("principal", loan.getApprovedPrincipal())) {
            loan.setApprovedPrincipal(command.bigDecimalValueOfParameterNamed("principal"));
        }
        if (command.isChangeInBigDecimalParameterNamed("principal", loan.getProposedPrincipal())) {
            newValue = command.bigDecimalValueOfParameterNamed("principal");
            changes.put("principal", newValue);
            loan.setProposedPrincipal((BigDecimal)newValue);
        }
        if (loanProduct.isMultiDisburseLoan()) {
            this.loanDisbursementService.updateDisbursementDetails(loan, command, changes);
            if (command.isChangeInBigDecimalParameterNamed("maxOutstandingLoanBalance", loan.getMaxOutstandingLoanBalance())) {
                loan.setMaxOutstandingLoanBalance(command.bigDecimalValueOfParameterNamed("maxOutstandingLoanBalance"));
            }
            JsonArray disbursementDataArray = command.arrayOfParameterNamed("disbursementData");
            if (loanProduct.isDisallowExpectedDisbursements()) {
                if (disbursementDataArray != null && !disbursementDataArray.isEmpty()) {
                    errorMessage = "For this loan product, disbursement details are not allowed";
                    throw new MultiDisbursementDataNotAllowedException("disbursementData", "For this loan product, disbursement details are not allowed", new Object[0]);
                }
            } else {
                if (disbursementDataArray == null || disbursementDataArray.isEmpty()) {
                    errorMessage = "For this loan product, disbursement details must be provided";
                    throw new MultiDisbursementDataRequiredException("disbursementData", "For this loan product, disbursement details must be provided", new Object[0]);
                }
                if (disbursementDataArray.size() > loanProduct.maxTrancheCount()) {
                    errorMessage = "Number of tranche shouldn't be greter than " + loanProduct.maxTrancheCount();
                    throw new ExceedingTrancheCountException("disbursementData", (String)errorMessage, new Object[]{loanProduct.maxTrancheCount(), disbursementDetails.size()});
                }
            }
        } else {
            loan.clearDisbursementDetails();
        }
        if (loanProduct.isMultiDisburseLoan() || loanProduct.isCanDefineInstallmentAmount()) {
            if (command.isChangeInBigDecimalParameterNamed("fixedEmiAmount", loan.getFixedEmiAmount())) {
                loan.setFixedEmiAmount(command.bigDecimalValueOfParameterNamed("fixedEmiAmount"));
                changes.put("fixedEmiAmount", loan.getFixedEmiAmount());
                changes.put("recalculateLoanSchedule", true);
            }
        } else {
            loan.setFixedEmiAmount(null);
        }
        if (command.isChangeInBigDecimalParameterNamed("fixedPrincipalPercentagePerInstallment", loan.getFixedPrincipalPercentagePerInstallment())) {
            loan.setFixedPrincipalPercentagePerInstallment(command.bigDecimalValueOfParameterNamed("fixedPrincipalPercentagePerInstallment"));
            changes.put("fixedPrincipalPercentagePerInstallment", loan.getFixedPrincipalPercentagePerInstallment());
        }
        LoanProductRelatedDetail productRelatedDetail = loan.getLoanProductRelatedDetail();
        if (loan.loanProduct().getLoanConfigurableAttributes() != null) {
            this.loanScheduleAssembler.updateProductRelatedDetails(productRelatedDetail, loan);
        }
        if (loan.getLoanProduct().isCanUseForTopup() && loan.getClientId() != null) {
            Boolean isTopup = command.booleanObjectValueOfParameterNamed("isTopup");
            if (command.isChangeInBooleanParameterNamed("isTopup", Boolean.valueOf(loan.isTopup()))) {
                loan.setIsTopup(isTopup.booleanValue());
                changes.put("isTopup", isTopup);
            }
            if (loan.isTopup()) {
                Long loanIdToClose = command.longValueOfParameterNamed("loanIdToClose");
                LoanTopupDetails existingLoanTopupDetails = loan.getTopupLoanDetails();
                if (existingLoanTopupDetails == null || !existingLoanTopupDetails.getLoanIdToClose().equals(loanIdToClose) || changes.containsKey("submittedOnDate") || changes.containsKey("expectedDisbursementDate") || changes.containsKey("principal") || changes.containsKey("disbursementData")) {
                    Long existingLoanIdToClose = null;
                    if (existingLoanTopupDetails != null) {
                        existingLoanIdToClose = existingLoanTopupDetails.getLoanIdToClose();
                    }
                    if (!loanIdToClose.equals(existingLoanIdToClose)) {
                        LoanTopupDetails topupDetails = new LoanTopupDetails(loan, loanIdToClose);
                        loan.setTopupLoanDetails(topupDetails);
                        changes.put("loanIdToClose", loanIdToClose);
                    }
                }
            } else {
                loan.setTopupLoanDetails(null);
            }
        } else if (loan.isTopup()) {
            loan.setIsTopup(false);
            loan.setTopupLoanDetails(null);
            changes.put("isTopup", false);
        }
        if (command.parameterExists("loanType")) {
            String loanTypeStr = command.stringValueOfParameterNamed("loanType");
            AccountType loanType = AccountType.fromName((String)loanTypeStr);
            if (!StringUtils.isBlank((CharSequence)loanTypeStr) && loanType.isIndividualAccount()) {
                String collateralParamName = "collateral";
                if (changes.containsKey("collateral")) {
                    loan.updateLoanCollateral(possiblyModifedLoanCollateralItems);
                }
            }
        }
        String chargesParamName = "charges";
        if (changes.containsKey("charges")) {
            this.loanChargeService.updateLoanCharges(loan, possiblyModifiedLoanCharges);
        }
        if (command.isChangeInBooleanParameterNamed("enableInstallmentLevelDelinquency", Boolean.valueOf(loan.isEnableInstallmentLevelDelinquency()))) {
            Boolean enableInstallmentLevelDelinquency = command.booleanObjectValueOfParameterNamed("enableInstallmentLevelDelinquency");
            loan.updateEnableInstallmentLevelDelinquency(enableInstallmentLevelDelinquency.booleanValue());
        }
        if (changes.containsKey("recalculateLoanSchedule")) {
            changes.remove("recalculateLoanSchedule");
            JsonElement parsedQuery = this.fromApiJsonHelper.parse(command.json());
            JsonQuery query = JsonQuery.from((String)command.json(), (JsonElement)parsedQuery, (FromJsonHelper)this.fromApiJsonHelper);
            LoanScheduleModel loanScheduleModel = this.calculationPlatformService.calculateLoanSchedule(query, Boolean.valueOf(false));
            this.loanSchedule.updateLoanSchedule(loan, loanScheduleModel);
            this.loanAccrualsProcessingService.reprocessExistingAccruals(loan, false);
            this.loanChargeService.recalculateAllCharges(loan);
        }
        if (command.hasParameter("rates")) {
            loan.updateLoanRates(this.rateAssembler.fromParsedJson(command.parsedJson()));
        }
        return changes;
    }

    public Map<String, Object> updateLoanApplicationAttributesForWithdrawal(Loan loan, JsonCommand command, AppUser currentUser) {
        LinkedHashMap<String, Object> actualChanges = new LinkedHashMap<String, Object>();
        LocalDate withdrawnOn = command.localDateValueOfParameterNamed("withdrawnOnDate");
        if (withdrawnOn == null) {
            withdrawnOn = command.localDateValueOfParameterNamed("eventDate");
        }
        loan.setWithdrawnOnDate(withdrawnOn);
        loan.setWithdrawnBy(currentUser);
        loan.setClosedOnDate(withdrawnOn);
        loan.setClosedBy(currentUser);
        Locale locale = Locale.of(command.locale());
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern(command.dateFormat()).withLocale(locale);
        actualChanges.put("status", LoanEnumerations.status((LoanStatus)loan.getStatus()));
        actualChanges.put("locale", command.locale());
        actualChanges.put("dateFormat", command.dateFormat());
        actualChanges.put("withdrawnOnDate", withdrawnOn.format(fmt));
        actualChanges.put("closedOnDate", withdrawnOn.format(fmt));
        return actualChanges;
    }

    public Map<String, Object> updateLoanApplicationAttributesForRejection(Loan loan, JsonCommand command, AppUser currentUser) {
        LinkedHashMap<String, Object> actualChanges = new LinkedHashMap<String, Object>();
        LocalDate rejectedOn = command.localDateValueOfParameterNamed("rejectedOnDate");
        loan.setRejectedOnDate(rejectedOn);
        loan.setRejectedBy(currentUser);
        loan.setClosedOnDate(rejectedOn);
        loan.setClosedBy(currentUser);
        Locale locale = Locale.of(command.locale());
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern(command.dateFormat()).withLocale(locale);
        actualChanges.put("status", LoanEnumerations.status((LoanStatus)loan.getStatus()));
        actualChanges.put("locale", command.locale());
        actualChanges.put("dateFormat", command.dateFormat());
        actualChanges.put("rejectedOnDate", rejectedOn.format(fmt));
        actualChanges.put("closedOnDate", rejectedOn.format(fmt));
        return actualChanges;
    }

    @Generated
    public LoanAssemblerImpl(FromJsonHelper fromApiJsonHelper, LoanRepositoryWrapper loanRepository, LoanProductRepository loanProductRepository, ClientRepositoryWrapper clientRepository, GroupRepositoryWrapper groupRepository, FundRepository fundRepository, StaffRepository staffRepository, CodeValueRepositoryWrapper codeValueRepository, LoanScheduleAssembler loanScheduleAssembler, LoanChargeAssembler loanChargeAssembler, LoanCollateralAssembler collateralAssembler, LoanRepaymentScheduleTransactionProcessorFactory loanRepaymentScheduleTransactionProcessorFactory, HolidayRepository holidayRepository, ConfigurationDomainService configurationDomainService, WorkingDaysRepositoryWrapper workingDaysRepository, RateAssembler rateAssembler, ExternalIdFactory externalIdFactory, AccountNumberFormatRepositoryWrapper accountNumberFormatRepository, GLIMAccountInfoRepository glimRepository, AccountNumberGenerator accountNumberGenerator, GLIMAccountInfoWritePlatformService glimAccountInfoWritePlatformService, LoanCollateralAssembler loanCollateralAssembler, LoanScheduleCalculationPlatformService calculationPlatformService, LoanDisbursementDetailsAssembler loanDisbursementDetailsAssembler, LoanChargeMapper loanChargeMapper, LoanCollateralManagementMapper loanCollateralManagementMapper, LoanAccrualsProcessingService loanAccrualsProcessingService, LoanDisbursementService loanDisbursementService, LoanChargeService loanChargeService, LoanOfficerService loanOfficerService, LoanScheduleComponent loanSchedule) {
        this.fromApiJsonHelper = fromApiJsonHelper;
        this.loanRepository = loanRepository;
        this.loanProductRepository = loanProductRepository;
        this.clientRepository = clientRepository;
        this.groupRepository = groupRepository;
        this.fundRepository = fundRepository;
        this.staffRepository = staffRepository;
        this.codeValueRepository = codeValueRepository;
        this.loanScheduleAssembler = loanScheduleAssembler;
        this.loanChargeAssembler = loanChargeAssembler;
        this.collateralAssembler = collateralAssembler;
        this.loanRepaymentScheduleTransactionProcessorFactory = loanRepaymentScheduleTransactionProcessorFactory;
        this.holidayRepository = holidayRepository;
        this.configurationDomainService = configurationDomainService;
        this.workingDaysRepository = workingDaysRepository;
        this.rateAssembler = rateAssembler;
        this.externalIdFactory = externalIdFactory;
        this.accountNumberFormatRepository = accountNumberFormatRepository;
        this.glimRepository = glimRepository;
        this.accountNumberGenerator = accountNumberGenerator;
        this.glimAccountInfoWritePlatformService = glimAccountInfoWritePlatformService;
        this.loanCollateralAssembler = loanCollateralAssembler;
        this.calculationPlatformService = calculationPlatformService;
        this.loanDisbursementDetailsAssembler = loanDisbursementDetailsAssembler;
        this.loanChargeMapper = loanChargeMapper;
        this.loanCollateralManagementMapper = loanCollateralManagementMapper;
        this.loanAccrualsProcessingService = loanAccrualsProcessingService;
        this.loanDisbursementService = loanDisbursementService;
        this.loanChargeService = loanChargeService;
        this.loanOfficerService = loanOfficerService;
        this.loanSchedule = loanSchedule;
    }
}

