/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.savings.api;

import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.core.service.Page;
import org.apache.fineract.infrastructure.core.service.SearchParameters;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.infrastructure.security.service.SqlValidator;
import org.apache.fineract.portfolio.savings.api.SavingsApiSetConstants;
import org.apache.fineract.portfolio.savings.data.DepositAccountOnHoldTransactionData;
import org.apache.fineract.portfolio.savings.service.DepositAccountOnHoldTransactionReadPlatformService;
import org.springframework.stereotype.Component;

@Path(value="/v1/savingsaccounts/{savingsId}/onholdtransactions")
@Component
@Tag(name="Deposit Account On Hold Fund Transactions", description="")
public class DepositAccountOnHoldFundTransactionsApiResource {
    private final PlatformSecurityContext context;
    private final DefaultToApiJsonSerializer<DepositAccountOnHoldTransactionData> toApiJsonSerializer;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final DepositAccountOnHoldTransactionReadPlatformService depositAccountOnHoldTransactionReadPlatformService;
    private final SqlValidator sqlValidator;

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String retrieveAll(@PathParam(value="savingsId") Long savingsId, @QueryParam(value="guarantorFundingId") Long guarantorFundingId, @Context UriInfo uriInfo, @QueryParam(value="offset") Integer offset, @QueryParam(value="limit") Integer limit, @QueryParam(value="orderBy") String orderBy, @QueryParam(value="sortOrder") String sortOrder) {
        this.context.authenticatedUser().validateHasReadPermission("savingsaccount");
        this.sqlValidator.validate(orderBy);
        this.sqlValidator.validate(sortOrder);
        SearchParameters searchParameters = SearchParameters.builder().limit(limit).offset(offset).orderBy(orderBy).sortOrder(sortOrder).build();
        Page transfers = this.depositAccountOnHoldTransactionReadPlatformService.retriveAll(savingsId, guarantorFundingId, searchParameters);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, transfers, SavingsApiSetConstants.SAVINGS_ACCOUNT_ON_HOLD_RESPONSE_DATA_PARAMETERS);
    }

    @Generated
    public DepositAccountOnHoldFundTransactionsApiResource(PlatformSecurityContext context, DefaultToApiJsonSerializer<DepositAccountOnHoldTransactionData> toApiJsonSerializer, ApiRequestParameterHelper apiRequestParameterHelper, DepositAccountOnHoldTransactionReadPlatformService depositAccountOnHoldTransactionReadPlatformService, SqlValidator sqlValidator) {
        this.context = context;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.depositAccountOnHoldTransactionReadPlatformService = depositAccountOnHoldTransactionReadPlatformService;
        this.sqlValidator = sqlValidator;
    }
}

