/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.savings.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.time.MonthDay;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.accounting.common.AccountingConstants;
import org.apache.fineract.accounting.common.AccountingValidations;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.portfolio.interestratechart.data.InterestRateChartDataValidator;
import org.apache.fineract.portfolio.savings.DepositAccountType;
import org.apache.fineract.portfolio.savings.DepositsApiConstants;
import org.apache.fineract.portfolio.savings.PreClosurePenalInterestOnType;
import org.apache.fineract.portfolio.savings.SavingsCompoundingInterestPeriodType;
import org.apache.fineract.portfolio.savings.SavingsInterestCalculationDaysInYearType;
import org.apache.fineract.portfolio.savings.SavingsInterestCalculationType;
import org.apache.fineract.portfolio.savings.SavingsPeriodFrequencyType;
import org.apache.fineract.portfolio.savings.SavingsPostingInterestPeriodType;
import org.apache.fineract.portfolio.savings.data.SavingsProductAccountingDataValidator;
import org.springframework.stereotype.Component;

@Component
public class DepositProductDataValidator {
    private final FromJsonHelper fromApiJsonHelper;
    private final InterestRateChartDataValidator chartDataValidator;
    private final SavingsProductAccountingDataValidator savingsProductAccountingDataValidator;

    public void validateForFixedDepositCreate(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)DepositsApiConstants.FIXED_DEPOSIT_PRODUCT_REQUEST_DATA_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("fixeddepositproduct");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        this.validateDepositDetailForCreate(element, this.fromApiJsonHelper, baseDataValidator, DepositAccountType.FIXED_DEPOSIT);
        this.validatePreClosureDetailForCreate(element, baseDataValidator);
        this.validateDepositTermDeatilForCreate(element, baseDataValidator);
        this.validateChartsData(element, baseDataValidator);
        this.validateDepositAmountForCreate(element, baseDataValidator);
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateForFixedDepositUpdate(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)DepositsApiConstants.FIXED_DEPOSIT_PRODUCT_REQUEST_DATA_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("fixeddepositproduct");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        this.validateDepositDetailForUpdate(element, this.fromApiJsonHelper, baseDataValidator);
        this.validatePreClosureDetailForUpdate(element, baseDataValidator);
        this.validateDepositTermDetailForUpdate(element, baseDataValidator);
        this.validateChartsData(element, baseDataValidator);
        this.validateDepositAmountForUpdate(element, baseDataValidator);
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateForRecurringDepositCreate(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)DepositsApiConstants.RECURRING_DEPOSIT_PRODUCT_REQUEST_DATA_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("recurringdepositproduct");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        this.validateDepositDetailForCreate(element, this.fromApiJsonHelper, baseDataValidator, DepositAccountType.RECURRING_DEPOSIT);
        this.validatePreClosureDetailForCreate(element, baseDataValidator);
        this.validateDepositTermDeatilForCreate(element, baseDataValidator);
        this.validateRecurringDetailForCreate(element, baseDataValidator);
        this.validateChartsData(element, baseDataValidator);
        this.validateDepositAmountForCreate(element, baseDataValidator);
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateForRecurringDepositUpdate(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)DepositsApiConstants.RECURRING_DEPOSIT_PRODUCT_REQUEST_DATA_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("recurringdepositproduct");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        this.validateDepositDetailForUpdate(element, this.fromApiJsonHelper, baseDataValidator);
        this.validatePreClosureDetailForUpdate(element, baseDataValidator);
        this.validateDepositTermDetailForUpdate(element, baseDataValidator);
        this.validateRecurringDepositUpdate(element, baseDataValidator);
        this.validateChartsData(element, baseDataValidator);
        this.validateDepositAmountForUpdate(element, baseDataValidator);
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    private void validateDepositDetailForCreate(JsonElement element, FromJsonHelper fromApiJsonHelper, DataValidatorBuilder baseDataValidator, DepositAccountType accountType) {
        String name = fromApiJsonHelper.extractStringNamed("name", element);
        baseDataValidator.reset().parameter("name").value((Object)name).notBlank().notExceedingLengthOf(Integer.valueOf(100));
        String shortName = fromApiJsonHelper.extractStringNamed("shortName", element);
        baseDataValidator.reset().parameter("shortName").value((Object)shortName).notBlank().notExceedingLengthOf(Integer.valueOf(4));
        String description = fromApiJsonHelper.extractStringNamed("description", element);
        baseDataValidator.reset().parameter("description").value((Object)description).notBlank().notExceedingLengthOf(Integer.valueOf(500));
        String currencyCode = fromApiJsonHelper.extractStringNamed("currencyCode", element);
        baseDataValidator.reset().parameter("currencyCode").value((Object)currencyCode).notBlank();
        Integer digitsAfterDecimal = fromApiJsonHelper.extractIntegerSansLocaleNamed("digitsAfterDecimal", element);
        baseDataValidator.reset().parameter("digitsAfterDecimal").value((Object)digitsAfterDecimal).notNull().inMinMaxRange(Integer.valueOf(0), Integer.valueOf(6));
        if (fromApiJsonHelper.parameterExists("inMultiplesOf", element)) {
            Integer inMultiplesOf = fromApiJsonHelper.extractIntegerNamed("inMultiplesOf", element, Locale.getDefault());
            baseDataValidator.reset().parameter("inMultiplesOf").value((Object)inMultiplesOf).ignoreIfNull().integerZeroOrGreater();
        }
        if (fromApiJsonHelper.parameterExists("nominalAnnualInterestRate", element)) {
            BigDecimal nominalAnnualInterestRate = fromApiJsonHelper.extractBigDecimalWithLocaleNamed("nominalAnnualInterestRate", element);
            baseDataValidator.reset().parameter("nominalAnnualInterestRate").value((Object)nominalAnnualInterestRate).notNull().zeroOrPositiveAmount();
        }
        Integer interestCompoundingPeriodType = fromApiJsonHelper.extractIntegerSansLocaleNamed("interestCompoundingPeriodType", element);
        baseDataValidator.reset().parameter("interestCompoundingPeriodType").value((Object)interestCompoundingPeriodType).notNull().isOneOfTheseValues(SavingsCompoundingInterestPeriodType.integerValues());
        Integer interestPostingPeriodType = fromApiJsonHelper.extractIntegerSansLocaleNamed("interestPostingPeriodType", element);
        baseDataValidator.reset().parameter("interestPostingPeriodType").value((Object)interestPostingPeriodType).notNull().isOneOfTheseValues(SavingsPostingInterestPeriodType.integerValues());
        Integer interestCalculationType = fromApiJsonHelper.extractIntegerSansLocaleNamed("interestCalculationType", element);
        baseDataValidator.reset().parameter("interestCalculationType").value((Object)interestCalculationType).notNull().isOneOfTheseValues(SavingsInterestCalculationType.integerValues());
        Integer interestCalculationDaysInYearType = fromApiJsonHelper.extractIntegerSansLocaleNamed("interestCalculationDaysInYearType", element);
        baseDataValidator.reset().parameter("interestCalculationDaysInYearType").value((Object)interestCalculationDaysInYearType).notNull().isOneOfTheseValues(SavingsInterestCalculationDaysInYearType.integerValues());
        if (fromApiJsonHelper.parameterExists("lockinPeriodFrequency", element)) {
            Integer lockinPeriodFrequency = fromApiJsonHelper.extractIntegerWithLocaleNamed("lockinPeriodFrequency", element);
            baseDataValidator.reset().parameter("lockinPeriodFrequency").value((Object)lockinPeriodFrequency).integerZeroOrGreater();
            if (lockinPeriodFrequency != null) {
                Integer lockinPeriodFrequencyType = fromApiJsonHelper.extractIntegerSansLocaleNamed("lockinPeriodFrequencyType", element);
                baseDataValidator.reset().parameter("lockinPeriodFrequencyType").value((Object)lockinPeriodFrequencyType).notNull().inMinMaxRange(Integer.valueOf(0), Integer.valueOf(3));
            }
        }
        if (fromApiJsonHelper.parameterExists("lockinPeriodFrequencyType", element)) {
            Integer lockinPeriodFrequencyType = fromApiJsonHelper.extractIntegerSansLocaleNamed("lockinPeriodFrequencyType", element);
            baseDataValidator.reset().parameter("lockinPeriodFrequencyType").value((Object)lockinPeriodFrequencyType).inMinMaxRange(Integer.valueOf(0), Integer.valueOf(3));
            if (lockinPeriodFrequencyType != null) {
                Integer lockinPeriodFrequency = fromApiJsonHelper.extractIntegerWithLocaleNamed("lockinPeriodFrequency", element);
                baseDataValidator.reset().parameter("lockinPeriodFrequency").value((Object)lockinPeriodFrequency).notNull().integerZeroOrGreater();
            }
        }
        if (this.fromApiJsonHelper.parameterExists("minBalanceForInterestCalculation", element)) {
            BigDecimal minBalanceForInterestCalculation = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("minBalanceForInterestCalculation", element);
            baseDataValidator.reset().parameter("minBalanceForInterestCalculation").value((Object)minBalanceForInterestCalculation).ignoreIfNull().zeroOrPositiveAmount();
        }
        Integer accountingRuleType = fromApiJsonHelper.extractIntegerNamed("accountingRule", element, Locale.getDefault());
        baseDataValidator.reset().parameter("accountingRule").value((Object)accountingRuleType).notNull().inMinMaxRange(Integer.valueOf(1), Integer.valueOf(3));
        Boolean isDormancyActive = this.fromApiJsonHelper.extractBooleanNamed("isDormancyTrackingActive", element);
        if (isDormancyActive == null) {
            isDormancyActive = false;
        }
        if (AccountingValidations.isCashBasedAccounting((Integer)accountingRuleType) || AccountingValidations.isAccrualPeriodicBasedAccounting((Integer)accountingRuleType)) {
            this.savingsProductAccountingDataValidator.evaluateProductAccountingData(accountingRuleType, isDormancyActive.booleanValue(), element, baseDataValidator, accountType, true);
        }
        this.validateTaxWithHoldingParams(baseDataValidator, element, true);
    }

    public void validatePreClosureDetailForCreate(JsonElement element, DataValidatorBuilder baseDataValidator) {
        boolean preClosurePenalApplicable;
        if (this.fromApiJsonHelper.parameterExists("preClosurePenalApplicable", element) && (preClosurePenalApplicable = this.fromApiJsonHelper.extractBooleanNamed("preClosurePenalApplicable", element).booleanValue())) {
            BigDecimal penalInterestRate = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("preClosurePenalInterest", element);
            baseDataValidator.reset().parameter("preClosurePenalInterest").value((Object)penalInterestRate).cantBeBlankWhenParameterProvidedIs("preClosurePenalApplicable", (Object)preClosurePenalApplicable).zeroOrPositiveAmount();
            Integer preClosurePenalInterestType = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("preClosurePenalInterestOnTypeId", element);
            baseDataValidator.reset().parameter("preClosurePenalInterestOnTypeId").value((Object)preClosurePenalInterestType).cantBeBlankWhenParameterProvidedIs("preClosurePenalApplicable", (Object)preClosurePenalApplicable).isOneOfTheseValues(PreClosurePenalInterestOnType.integerValues());
        }
    }

    public void validateDepositTermDeatilForCreate(JsonElement element, DataValidatorBuilder baseDataValidator) {
        Integer minTerm = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("minDepositTerm", element);
        baseDataValidator.reset().parameter("minDepositTerm").value((Object)minTerm).notNull().integerGreaterThanZero();
        if (this.fromApiJsonHelper.parameterExists("maxDepositTerm", element)) {
            Integer maxTerm = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("maxDepositTerm", element);
            baseDataValidator.reset().parameter("maxDepositTerm").value((Object)maxTerm).integerGreaterThanZero();
        }
        Integer minDepositTermType = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("minDepositTermTypeId", element);
        baseDataValidator.reset().parameter("minDepositTermTypeId").value((Object)minDepositTermType).ignoreIfNull().isOneOfTheseValues(SavingsPeriodFrequencyType.integerValues());
        if (this.fromApiJsonHelper.parameterExists("maxDepositTermTypeId", element)) {
            Integer maxDepositTermType = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("maxDepositTermTypeId", element);
            baseDataValidator.reset().parameter("maxDepositTermTypeId").value((Object)maxDepositTermType).isOneOfTheseValues(SavingsPeriodFrequencyType.integerValues());
        }
        if (this.fromApiJsonHelper.parameterExists("inMultiplesOfDepositTerm", element)) {
            Integer inMultiplesOfDepositTerm = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("inMultiplesOfDepositTerm", element);
            baseDataValidator.reset().parameter("inMultiplesOfDepositTerm").value((Object)inMultiplesOfDepositTerm).integerGreaterThanZero();
            Integer inMultiplesOfDepositTermType = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("inMultiplesOfDepositTermTypeId", element);
            baseDataValidator.reset().parameter("inMultiplesOfDepositTermTypeId").value((Object)inMultiplesOfDepositTermType).cantBeBlankWhenParameterProvidedIs("inMultiplesOfDepositTerm", (Object)inMultiplesOfDepositTerm).isOneOfTheseValues(SavingsPeriodFrequencyType.integerValues());
        }
    }

    private void validateChartsData(JsonElement element, DataValidatorBuilder baseDataValidator) {
        if (element.isJsonObject()) {
            JsonArray array = this.fromApiJsonHelper.extractJsonArrayNamed("charts", element);
            baseDataValidator.reset().parameter("charts").value((Object)array).notNull().jsonArrayNotEmpty();
            for (int i = 0; i < array.size(); ++i) {
                JsonObject interestRateChartElement = array.get(i).getAsJsonObject();
                String json = this.fromApiJsonHelper.toJson((JsonElement)interestRateChartElement);
                if (!this.fromApiJsonHelper.parameterExists("id", (JsonElement)interestRateChartElement)) {
                    this.chartDataValidator.validateForCreate(json, baseDataValidator);
                    continue;
                }
                this.chartDataValidator.validateForUpdate(json, baseDataValidator);
            }
        }
    }

    public void validateDepositDetailForUpdate(JsonElement element, FromJsonHelper fromApiJsonHelper, DataValidatorBuilder baseDataValidator) {
        if (fromApiJsonHelper.parameterExists("name", element)) {
            String name = fromApiJsonHelper.extractStringNamed("name", element);
            baseDataValidator.reset().parameter("name").value((Object)name).notBlank().notExceedingLengthOf(Integer.valueOf(100));
        }
        if (fromApiJsonHelper.parameterExists("shortName", element)) {
            String shortName = fromApiJsonHelper.extractStringNamed("shortName", element);
            baseDataValidator.reset().parameter("shortName").value((Object)shortName).notBlank().notExceedingLengthOf(Integer.valueOf(4));
        }
        if (fromApiJsonHelper.parameterExists("description", element)) {
            String description = fromApiJsonHelper.extractStringNamed("description", element);
            baseDataValidator.reset().parameter("description").value((Object)description).notBlank().notExceedingLengthOf(Integer.valueOf(500));
        }
        if (fromApiJsonHelper.parameterExists("currencyCode", element)) {
            String currencyCode = fromApiJsonHelper.extractStringNamed("currencyCode", element);
            baseDataValidator.reset().parameter("currencyCode").value((Object)currencyCode).notBlank();
        }
        if (fromApiJsonHelper.parameterExists("digitsAfterDecimal", element)) {
            Integer digitsAfterDecimal = fromApiJsonHelper.extractIntegerSansLocaleNamed("digitsAfterDecimal", element);
            baseDataValidator.reset().parameter("digitsAfterDecimal").value((Object)digitsAfterDecimal).notNull().inMinMaxRange(Integer.valueOf(0), Integer.valueOf(6));
        }
        if (fromApiJsonHelper.parameterExists("inMultiplesOf", element)) {
            Integer inMultiplesOf = fromApiJsonHelper.extractIntegerNamed("inMultiplesOf", element, Locale.getDefault());
            baseDataValidator.reset().parameter("inMultiplesOf").value((Object)inMultiplesOf).ignoreIfNull().integerZeroOrGreater();
        }
        if (fromApiJsonHelper.parameterExists("nominalAnnualInterestRate", element)) {
            BigDecimal interestRate = fromApiJsonHelper.extractBigDecimalWithLocaleNamed("nominalAnnualInterestRate", element);
            baseDataValidator.reset().parameter("nominalAnnualInterestRate").value((Object)interestRate).notNull().zeroOrPositiveAmount();
        }
        if (fromApiJsonHelper.parameterExists("interestCompoundingPeriodType", element)) {
            Integer interestCompoundingPeriodType = fromApiJsonHelper.extractIntegerSansLocaleNamed("interestCompoundingPeriodType", element);
            baseDataValidator.reset().parameter("interestCompoundingPeriodType").value((Object)interestCompoundingPeriodType).notNull().isOneOfTheseValues(SavingsCompoundingInterestPeriodType.integerValues());
        }
        if (fromApiJsonHelper.parameterExists("interestCalculationType", element)) {
            Integer interestCalculationType = fromApiJsonHelper.extractIntegerSansLocaleNamed("interestCalculationType", element);
            baseDataValidator.reset().parameter("interestCalculationType").value((Object)interestCalculationType).notNull().inMinMaxRange(Integer.valueOf(1), Integer.valueOf(2));
        }
        if (fromApiJsonHelper.parameterExists("interestCalculationDaysInYearType", element)) {
            Integer interestCalculationDaysInYearType = fromApiJsonHelper.extractIntegerSansLocaleNamed("interestCalculationDaysInYearType", element);
            baseDataValidator.reset().parameter("interestCalculationDaysInYearType").value((Object)interestCalculationDaysInYearType).notNull().isOneOfTheseValues(new Object[]{360, 365});
        }
        if (fromApiJsonHelper.parameterExists("minRequiredOpeningBalance", element)) {
            BigDecimal minOpeningBalance = fromApiJsonHelper.extractBigDecimalWithLocaleNamed("minRequiredOpeningBalance", element);
            baseDataValidator.reset().parameter("minRequiredOpeningBalance").value((Object)minOpeningBalance).ignoreIfNull().zeroOrPositiveAmount();
        }
        if (fromApiJsonHelper.parameterExists("lockinPeriodFrequency", element)) {
            Integer lockinPeriodFrequency = fromApiJsonHelper.extractIntegerWithLocaleNamed("lockinPeriodFrequency", element);
            baseDataValidator.reset().parameter("lockinPeriodFrequency").value((Object)lockinPeriodFrequency).ignoreIfNull().integerZeroOrGreater();
        }
        if (fromApiJsonHelper.parameterExists("lockinPeriodFrequencyType", element)) {
            Integer lockinPeriodFrequencyType = fromApiJsonHelper.extractIntegerSansLocaleNamed("lockinPeriodFrequencyType", element);
            baseDataValidator.reset().parameter("lockinPeriodFrequencyType").value((Object)lockinPeriodFrequencyType).inMinMaxRange(Integer.valueOf(0), Integer.valueOf(3));
        }
        if (fromApiJsonHelper.parameterExists("withdrawalFeeForTransfers", element)) {
            Boolean isWithdrawalFeeApplicableForTransfers = fromApiJsonHelper.extractBooleanNamed("withdrawalFeeForTransfers", element);
            baseDataValidator.reset().parameter("withdrawalFeeForTransfers").value((Object)isWithdrawalFeeApplicableForTransfers).ignoreIfNull().validateForBooleanValue();
        }
        if (fromApiJsonHelper.parameterExists("feeAmount", element)) {
            BigDecimal annualFeeAmount = fromApiJsonHelper.extractBigDecimalWithLocaleNamed("feeAmount", element);
            baseDataValidator.reset().parameter("feeAmount").value((Object)annualFeeAmount).ignoreIfNull().zeroOrPositiveAmount();
        }
        if (fromApiJsonHelper.parameterExists("feeOnMonthDay", element)) {
            MonthDay monthDayOfAnnualFee = fromApiJsonHelper.extractMonthDayNamed("feeOnMonthDay", element);
            baseDataValidator.reset().parameter("feeOnMonthDay").value((Object)monthDayOfAnnualFee).ignoreIfNull();
        }
        if (this.fromApiJsonHelper.parameterExists("minBalanceForInterestCalculation", element)) {
            BigDecimal minBalanceForInterestCalculation = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("minBalanceForInterestCalculation", element);
            baseDataValidator.reset().parameter("minBalanceForInterestCalculation").value((Object)minBalanceForInterestCalculation).ignoreIfNull().zeroOrPositiveAmount();
        }
        Long savingsControlAccountId = fromApiJsonHelper.extractLongNamed(AccountingConstants.SavingProductAccountingParams.SAVINGS_CONTROL.getValue(), element);
        baseDataValidator.reset().parameter(AccountingConstants.SavingProductAccountingParams.SAVINGS_CONTROL.getValue()).value((Object)savingsControlAccountId).ignoreIfNull().integerGreaterThanZero();
        Long savingsReferenceAccountId = fromApiJsonHelper.extractLongNamed(AccountingConstants.SavingProductAccountingParams.SAVINGS_REFERENCE.getValue(), element);
        baseDataValidator.reset().parameter(AccountingConstants.SavingProductAccountingParams.SAVINGS_REFERENCE.getValue()).value((Object)savingsReferenceAccountId).ignoreIfNull().integerGreaterThanZero();
        Long transfersInSuspenseAccountId = fromApiJsonHelper.extractLongNamed(AccountingConstants.SavingProductAccountingParams.TRANSFERS_SUSPENSE.getValue(), element);
        baseDataValidator.reset().parameter(AccountingConstants.SavingProductAccountingParams.TRANSFERS_SUSPENSE.getValue()).value((Object)transfersInSuspenseAccountId).ignoreIfNull().integerGreaterThanZero();
        Long interestOnSavingsAccountId = fromApiJsonHelper.extractLongNamed(AccountingConstants.SavingProductAccountingParams.INTEREST_ON_SAVINGS.getValue(), element);
        baseDataValidator.reset().parameter(AccountingConstants.SavingProductAccountingParams.INTEREST_ON_SAVINGS.getValue()).value((Object)interestOnSavingsAccountId).ignoreIfNull().integerGreaterThanZero();
        Long incomeFromFeeId = fromApiJsonHelper.extractLongNamed(AccountingConstants.SavingProductAccountingParams.INCOME_FROM_FEES.getValue(), element);
        baseDataValidator.reset().parameter(AccountingConstants.SavingProductAccountingParams.INCOME_FROM_FEES.getValue()).value((Object)incomeFromFeeId).ignoreIfNull().integerGreaterThanZero();
        Long incomeFromPenaltyId = fromApiJsonHelper.extractLongNamed(AccountingConstants.SavingProductAccountingParams.INCOME_FROM_PENALTIES.getValue(), element);
        baseDataValidator.reset().parameter(AccountingConstants.SavingProductAccountingParams.INCOME_FROM_PENALTIES.getValue()).value((Object)incomeFromPenaltyId).ignoreIfNull().integerGreaterThanZero();
        this.savingsProductAccountingDataValidator.validatePaymentChannelFundSourceMappings(baseDataValidator, element);
        this.savingsProductAccountingDataValidator.validateChargeToIncomeAccountMappings(baseDataValidator, element);
        this.validateTaxWithHoldingParams(baseDataValidator, element, false);
    }

    public void validatePreClosureDetailForUpdate(JsonElement element, DataValidatorBuilder baseDataValidator) {
        if (this.fromApiJsonHelper.parameterExists("preClosurePenalApplicable", element)) {
            Boolean preClosurePenalApplicable = this.fromApiJsonHelper.extractBooleanNamed("preClosurePenalApplicable", element);
            baseDataValidator.reset().parameter("preClosurePenalApplicable").value((Object)preClosurePenalApplicable).notNull();
        }
        if (this.fromApiJsonHelper.parameterExists("preClosurePenalInterest", element)) {
            BigDecimal penalInterestRate = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("preClosurePenalInterest", element);
            baseDataValidator.reset().parameter("preClosurePenalInterest").value((Object)penalInterestRate).notNull().zeroOrPositiveAmount();
        }
        if (this.fromApiJsonHelper.parameterExists("preClosurePenalInterestOnTypeId", element)) {
            Integer preClosurePenalInterestType = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("preClosurePenalInterestOnTypeId", element);
            baseDataValidator.reset().parameter("preClosurePenalInterestOnTypeId").value((Object)preClosurePenalInterestType).notNull().isOneOfTheseValues(PreClosurePenalInterestOnType.integerValues());
        }
    }

    public void validateDepositTermDetailForUpdate(JsonElement element, DataValidatorBuilder baseDataValidator) {
        if (this.fromApiJsonHelper.parameterExists("minDepositTerm", element)) {
            Integer minTerm = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("minDepositTerm", element);
            baseDataValidator.reset().parameter("minDepositTerm").value((Object)minTerm).integerGreaterThanZero();
        }
        if (this.fromApiJsonHelper.parameterExists("maxDepositTerm", element)) {
            Integer maxTerm = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("maxDepositTerm", element);
            baseDataValidator.reset().parameter("maxDepositTerm").value((Object)maxTerm).integerGreaterThanZero();
        }
        if (this.fromApiJsonHelper.parameterExists("minDepositTermTypeId", element)) {
            Integer minDepositTermType = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("minDepositTermTypeId", element);
            baseDataValidator.reset().parameter("minDepositTermTypeId").value((Object)minDepositTermType).isOneOfTheseValues(SavingsPeriodFrequencyType.integerValues());
        }
        if (this.fromApiJsonHelper.parameterExists("maxDepositTermTypeId", element)) {
            Integer maxDepositTermType = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("maxDepositTermTypeId", element);
            baseDataValidator.reset().parameter("maxDepositTermTypeId").value((Object)maxDepositTermType).isOneOfTheseValues(SavingsPeriodFrequencyType.integerValues());
        }
        if (this.fromApiJsonHelper.parameterExists("inMultiplesOfDepositTerm", element)) {
            Integer inMultiplesOfDepositTerm = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("inMultiplesOfDepositTerm", element);
            baseDataValidator.reset().parameter("inMultiplesOfDepositTerm").value((Object)inMultiplesOfDepositTerm).integerGreaterThanZero();
        }
        if (this.fromApiJsonHelper.parameterExists("inMultiplesOfDepositTermTypeId", element)) {
            Integer inMultiplesOfDepositTermType = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("inMultiplesOfDepositTermTypeId", element);
            baseDataValidator.reset().parameter("inMultiplesOfDepositTermTypeId").value((Object)inMultiplesOfDepositTermType).isOneOfTheseValues(SavingsPeriodFrequencyType.integerValues());
        }
    }

    private void throwExceptionIfValidationWarningsExist(List<ApiParameterError> dataValidationErrors) {
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }

    public void validateRecurringDetailForCreate(JsonElement element, DataValidatorBuilder baseDataValidator) {
        Boolean isMandatoryDeposit = this.fromApiJsonHelper.extractBooleanNamed("isMandatoryDeposit", element);
        baseDataValidator.reset().parameter("isMandatoryDeposit").value((Object)isMandatoryDeposit).ignoreIfNull().validateForBooleanValue();
        Boolean allowWithdrawal = this.fromApiJsonHelper.extractBooleanNamed("allowWithdrawal", element);
        baseDataValidator.reset().parameter("allowWithdrawal").value((Object)allowWithdrawal).ignoreIfNull().validateForBooleanValue();
        Boolean adjustAdvanceTowardsFuturePayments = this.fromApiJsonHelper.extractBooleanNamed("adjustAdvanceTowardsFuturePayments", element);
        baseDataValidator.reset().parameter("adjustAdvanceTowardsFuturePayments").value((Object)adjustAdvanceTowardsFuturePayments).ignoreIfNull().validateForBooleanValue();
    }

    public void validateRecurringDepositUpdate(JsonElement element, DataValidatorBuilder baseDataValidator) {
        if (this.fromApiJsonHelper.parameterExists("isMandatoryDeposit", element)) {
            Boolean isMandatoryDeposit = this.fromApiJsonHelper.extractBooleanNamed("isMandatoryDeposit", element);
            baseDataValidator.reset().parameter("isMandatoryDeposit").value((Object)isMandatoryDeposit).ignoreIfNull().validateForBooleanValue();
        }
        if (this.fromApiJsonHelper.parameterExists("allowWithdrawal", element)) {
            Boolean allowWithdrawal = this.fromApiJsonHelper.extractBooleanNamed("allowWithdrawal", element);
            baseDataValidator.reset().parameter("allowWithdrawal").value((Object)allowWithdrawal).ignoreIfNull().validateForBooleanValue();
        }
        if (this.fromApiJsonHelper.parameterExists("adjustAdvanceTowardsFuturePayments", element)) {
            Boolean adjustAdvanceTowardsFuturePayments = this.fromApiJsonHelper.extractBooleanNamed("adjustAdvanceTowardsFuturePayments", element);
            baseDataValidator.reset().parameter("adjustAdvanceTowardsFuturePayments").value((Object)adjustAdvanceTowardsFuturePayments).ignoreIfNull().validateForBooleanValue();
        }
    }

    private void validateDepositAmountForCreate(JsonElement element, DataValidatorBuilder baseDataValidator) {
        BigDecimal depositAmount = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("depositAmount", element);
        baseDataValidator.reset().parameter("depositAmount").value((Object)depositAmount).notNull().positiveAmount();
        BigDecimal depositMinAmount = null;
        if (this.fromApiJsonHelper.parameterExists("minDepositAmount", element)) {
            depositMinAmount = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("minDepositAmount", element);
            baseDataValidator.reset().parameter("minDepositAmount").value((Object)depositMinAmount).notNull().positiveAmount();
        }
        BigDecimal depositMaxAmount = null;
        if (this.fromApiJsonHelper.parameterExists("maxDepositAmount", element)) {
            depositMaxAmount = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("maxDepositAmount", element);
            baseDataValidator.reset().parameter("maxDepositAmount").value((Object)depositMaxAmount).notNull().positiveAmount();
        }
        if (depositMaxAmount != null && depositMaxAmount.compareTo(BigDecimal.ZERO) >= 0) {
            if (depositMinAmount != null && depositMinAmount.compareTo(BigDecimal.ZERO) >= 0) {
                baseDataValidator.reset().parameter("maxDepositAmount").value((Object)depositMaxAmount).notLessThanMin(depositMinAmount);
                if (depositMinAmount.compareTo(depositMaxAmount) <= 0) {
                    baseDataValidator.reset().parameter("depositAmount").value((Object)depositAmount).inMinAndMaxAmountRange(depositMinAmount, depositMaxAmount);
                }
            } else {
                baseDataValidator.reset().parameter("depositAmount").value((Object)depositAmount).notGreaterThanMax(depositMaxAmount);
            }
        } else if (depositMinAmount != null && depositMinAmount.compareTo(BigDecimal.ZERO) >= 0) {
            baseDataValidator.reset().parameter("depositAmount").value((Object)depositAmount).notLessThanMin(depositMinAmount);
        }
    }

    private void validateDepositAmountForUpdate(JsonElement element, DataValidatorBuilder baseDataValidator) {
        BigDecimal depositAmount = null;
        if (this.fromApiJsonHelper.parameterExists("depositAmount", element)) {
            depositAmount = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("depositAmount", element);
            baseDataValidator.reset().parameter("depositAmount").value((Object)depositAmount).notNull().positiveAmount();
        }
        BigDecimal depositMinAmount = null;
        if (this.fromApiJsonHelper.parameterExists("minDepositAmount", element)) {
            depositMinAmount = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("minDepositAmount", element);
            baseDataValidator.reset().parameter("minDepositAmount").value((Object)depositMinAmount).notNull().positiveAmount();
        }
        BigDecimal depositMaxAmount = null;
        if (this.fromApiJsonHelper.parameterExists("maxDepositAmount", element)) {
            depositMaxAmount = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("maxDepositAmount", element);
            baseDataValidator.reset().parameter("maxDepositAmount").value((Object)depositMaxAmount).notNull().positiveAmount();
        }
        if (depositAmount != null) {
            if (depositMaxAmount != null && depositMaxAmount.compareTo(BigDecimal.ZERO) >= 0) {
                if (depositMinAmount != null && depositMinAmount.compareTo(BigDecimal.ZERO) >= 0) {
                    baseDataValidator.reset().parameter("maxDepositAmount").value((Object)depositMaxAmount).notLessThanMin(depositMinAmount);
                    if (depositMinAmount.compareTo(depositMaxAmount) <= 0) {
                        baseDataValidator.reset().parameter("depositAmount").value((Object)depositAmount).inMinAndMaxAmountRange(depositMinAmount, depositMaxAmount);
                    }
                } else {
                    baseDataValidator.reset().parameter("depositAmount").value((Object)depositAmount).notGreaterThanMax(depositMaxAmount);
                }
            } else if (depositMinAmount != null && depositMinAmount.compareTo(BigDecimal.ZERO) >= 0) {
                baseDataValidator.reset().parameter("depositAmount").value((Object)depositAmount).notLessThanMin(depositMinAmount);
            }
        }
    }

    private void validateTaxWithHoldingParams(DataValidatorBuilder baseDataValidator, JsonElement element, boolean isCreate) {
        Object withHoldTax;
        if (this.fromApiJsonHelper.parameterExists("withHoldTax", element)) {
            withHoldTax = this.fromApiJsonHelper.extractStringNamed("withHoldTax", element);
            baseDataValidator.reset().parameter("withHoldTax").value(withHoldTax).ignoreIfNull().validateForBooleanValue();
        }
        if ((withHoldTax = this.fromApiJsonHelper.extractBooleanNamed("withHoldTax", element)) == null) {
            withHoldTax = false;
        }
        if (this.fromApiJsonHelper.parameterExists("taxGroupId", element)) {
            Long taxGroupId = this.fromApiJsonHelper.extractLongNamed("taxGroupId", element);
            baseDataValidator.reset().parameter("taxGroupId").value((Object)taxGroupId).ignoreIfNull().longGreaterThanZero();
            if (((Boolean)withHoldTax).booleanValue()) {
                baseDataValidator.reset().parameter("taxGroupId").value((Object)taxGroupId).notBlank();
            }
        } else if (((Boolean)withHoldTax).booleanValue() && isCreate) {
            Object taxGroupId = null;
            baseDataValidator.reset().parameter("taxGroupId").value(taxGroupId).notBlank();
        }
    }

    @Generated
    public DepositProductDataValidator(FromJsonHelper fromApiJsonHelper, InterestRateChartDataValidator chartDataValidator, SavingsProductAccountingDataValidator savingsProductAccountingDataValidator) {
        this.fromApiJsonHelper = fromApiJsonHelper;
        this.chartDataValidator = chartDataValidator;
        this.savingsProductAccountingDataValidator = savingsProductAccountingDataValidator;
    }
}

