/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.savings.service;

import java.util.Collection;
import java.util.List;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.core.service.database.DatabaseSpecificSQLGenerator;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.charge.data.ChargeData;
import org.apache.fineract.portfolio.charge.domain.ChargeTimeType;
import org.apache.fineract.portfolio.charge.exception.SavingsAccountChargeNotFoundException;
import org.apache.fineract.portfolio.charge.service.ChargeDropdownReadPlatformService;
import org.apache.fineract.portfolio.common.service.DropdownReadPlatformService;
import org.apache.fineract.portfolio.savings.data.SavingsAccountAnnualFeeData;
import org.apache.fineract.portfolio.savings.data.SavingsAccountChargeData;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountStatusType;
import org.apache.fineract.portfolio.savings.service.SavingsAccountChargeReadPlatformService;
import org.apache.fineract.portfolio.savings.service.SavingsAccountChargeReadPlatformServiceImpl;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class SavingsAccountChargeReadPlatformServiceImpl
implements SavingsAccountChargeReadPlatformService {
    private final JdbcTemplate jdbcTemplate;
    private final PlatformSecurityContext context;
    private final ChargeDropdownReadPlatformService chargeDropdownReadPlatformService;
    private final DropdownReadPlatformService dropdownReadPlatformService;
    private final DatabaseSpecificSQLGenerator sqlGenerator;
    private final SavingsAccountChargeDueMapper chargeDueMapper;

    public SavingsAccountChargeReadPlatformServiceImpl(PlatformSecurityContext context, ChargeDropdownReadPlatformService chargeDropdownReadPlatformService, JdbcTemplate jdbcTemplate, DropdownReadPlatformService dropdownReadPlatformService, DatabaseSpecificSQLGenerator sqlGenerator) {
        this.context = context;
        this.chargeDropdownReadPlatformService = chargeDropdownReadPlatformService;
        this.jdbcTemplate = jdbcTemplate;
        this.sqlGenerator = sqlGenerator;
        this.chargeDueMapper = new SavingsAccountChargeDueMapper();
        this.dropdownReadPlatformService = dropdownReadPlatformService;
    }

    public ChargeData retrieveSavingsAccountChargeTemplate() {
        this.context.authenticatedUser();
        List allowedChargeCalculationTypeOptions = this.chargeDropdownReadPlatformService.retrieveCalculationTypes();
        List allowedChargeTimeOptions = this.chargeDropdownReadPlatformService.retrieveCollectionTimeTypes();
        List loansChargeCalculationTypeOptions = this.chargeDropdownReadPlatformService.retrieveLoanCalculationTypes();
        List loansChargeTimeTypeOptions = this.chargeDropdownReadPlatformService.retrieveLoanCollectionTimeTypes();
        List savingsChargeCalculationTypeOptions = this.chargeDropdownReadPlatformService.retrieveSavingsCalculationTypes();
        List savingsChargeTimeTypeOptions = this.chargeDropdownReadPlatformService.retrieveSavingsCollectionTimeTypes();
        List feeFrequencyOptions = this.dropdownReadPlatformService.retrievePeriodFrequencyTypeOptions();
        return ChargeData.builder().chargeCalculationTypeOptions(allowedChargeCalculationTypeOptions).chargeTimeTypeOptions(allowedChargeTimeOptions).loanChargeCalculationTypeOptions(loansChargeCalculationTypeOptions).loanChargeTimeTypeOptions(loansChargeTimeTypeOptions).savingsChargeCalculationTypeOptions(savingsChargeCalculationTypeOptions).savingsChargeTimeTypeOptions(savingsChargeTimeTypeOptions).feeFrequencyOptions(feeFrequencyOptions).build();
    }

    public SavingsAccountChargeData retrieveSavingsAccountChargeDetails(Long id, Long savingsAccountId) {
        try {
            this.context.authenticatedUser();
            SavingsAccountChargeMapper rm = new SavingsAccountChargeMapper();
            String sql = "select " + rm.schema() + " where sc.id=? and sc.savings_account_id=?";
            return (SavingsAccountChargeData)this.jdbcTemplate.queryForObject(sql, (RowMapper)rm, new Object[]{id, savingsAccountId});
        }
        catch (EmptyResultDataAccessException e) {
            throw new SavingsAccountChargeNotFoundException(savingsAccountId, e);
        }
    }

    public Collection<SavingsAccountChargeData> retrieveSavingsAccountCharges(Long loanId, String status) {
        this.context.authenticatedUser();
        SavingsAccountChargeMapper rm = new SavingsAccountChargeMapper();
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("select ").append(rm.schema()).append(" where sc.savings_account_id=? ");
        if (status.equalsIgnoreCase("active")) {
            sqlBuilder.append(" and sc.is_active = true ");
        } else if (status.equalsIgnoreCase("inactive")) {
            sqlBuilder.append(" and sc.is_active = false ");
        }
        sqlBuilder.append(" order by sc.charge_time_enum ASC, sc.charge_due_date ASC, sc.is_penalty ASC");
        return this.jdbcTemplate.query(sqlBuilder.toString(), (RowMapper)rm, new Object[]{loanId});
    }

    public Collection<SavingsAccountAnnualFeeData> retrieveChargesWithAnnualFeeDue() {
        String sql = "select " + this.chargeDueMapper.schema() + " where sac.charge_due_date is not null and sac.charge_time_enum = ?  and sac.charge_due_date <= " + this.sqlGenerator.currentBusinessDate() + " and sa.status_enum = ? ";
        return this.jdbcTemplate.query(sql, (RowMapper)this.chargeDueMapper, new Object[]{ChargeTimeType.ANNUAL_FEE.getValue(), SavingsAccountStatusType.ACTIVE.getValue()});
    }

    public Collection<SavingsAccountAnnualFeeData> retrieveChargesWithDue() {
        String sql = "select " + this.chargeDueMapper.schema() + " where sac.charge_due_date is not null and sac.charge_due_date <= ? and sac.waived = false and sac.is_paid_derived=false and sac.is_active=true and sa.status_enum = ?  order by sac.charge_due_date ";
        return this.jdbcTemplate.query(sql, (RowMapper)this.chargeDueMapper, new Object[]{DateUtils.getBusinessLocalDate(), SavingsAccountStatusType.ACTIVE.getValue()});
    }
}

