/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.savings.service;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import io.github.resilience4j.retry.annotation.Retry;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.accounting.journalentry.service.JournalEntryWritePlatformService;
import org.apache.fineract.infrastructure.configuration.domain.ConfigurationDomainService;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.ErrorHandler;
import org.apache.fineract.infrastructure.core.exception.GeneralPlatformDomainRuleException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.exception.PlatformDataIntegrityException;
import org.apache.fineract.infrastructure.core.exception.PlatformServiceUnavailableException;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.core.service.MathUtil;
import org.apache.fineract.infrastructure.dataqueries.data.EntityTables;
import org.apache.fineract.infrastructure.dataqueries.data.StatusEnum;
import org.apache.fineract.infrastructure.dataqueries.service.EntityDatatableChecksWritePlatformService;
import org.apache.fineract.infrastructure.event.business.domain.BusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.savings.SavingsActivateBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.savings.SavingsCloseBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.savings.SavingsPostInterestBusinessEvent;
import org.apache.fineract.infrastructure.event.business.service.BusinessEventNotifierService;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.organisation.holiday.domain.HolidayRepositoryWrapper;
import org.apache.fineract.organisation.monetary.domain.MonetaryCurrency;
import org.apache.fineract.organisation.monetary.domain.Money;
import org.apache.fineract.organisation.monetary.domain.MoneyHelper;
import org.apache.fineract.organisation.office.domain.Office;
import org.apache.fineract.organisation.staff.domain.Staff;
import org.apache.fineract.organisation.staff.domain.StaffRepositoryWrapper;
import org.apache.fineract.organisation.workingdays.domain.WorkingDaysRepositoryWrapper;
import org.apache.fineract.portfolio.account.PortfolioAccountType;
import org.apache.fineract.portfolio.account.domain.AccountTransferStandingInstruction;
import org.apache.fineract.portfolio.account.domain.StandingInstructionRepository;
import org.apache.fineract.portfolio.account.domain.StandingInstructionStatus;
import org.apache.fineract.portfolio.account.service.AccountAssociationsReadPlatformService;
import org.apache.fineract.portfolio.account.service.AccountTransfersReadPlatformService;
import org.apache.fineract.portfolio.charge.domain.Charge;
import org.apache.fineract.portfolio.charge.domain.ChargeRepositoryWrapper;
import org.apache.fineract.portfolio.charge.domain.ChargeTimeType;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.portfolio.client.exception.ClientNotActiveException;
import org.apache.fineract.portfolio.group.domain.Group;
import org.apache.fineract.portfolio.group.exception.GroupNotActiveException;
import org.apache.fineract.portfolio.note.domain.Note;
import org.apache.fineract.portfolio.note.domain.NoteRepository;
import org.apache.fineract.portfolio.paymentdetail.domain.PaymentDetail;
import org.apache.fineract.portfolio.paymentdetail.service.PaymentDetailWritePlatformService;
import org.apache.fineract.portfolio.savings.SavingsAccountTransactionType;
import org.apache.fineract.portfolio.savings.SavingsTransactionBooleanValues;
import org.apache.fineract.portfolio.savings.data.SavingsAccountChargeDataValidator;
import org.apache.fineract.portfolio.savings.data.SavingsAccountData;
import org.apache.fineract.portfolio.savings.data.SavingsAccountDataValidator;
import org.apache.fineract.portfolio.savings.data.SavingsAccountTransactionDTO;
import org.apache.fineract.portfolio.savings.data.SavingsAccountTransactionData;
import org.apache.fineract.portfolio.savings.data.SavingsAccountTransactionDataValidator;
import org.apache.fineract.portfolio.savings.domain.DepositAccountOnHoldTransactionRepository;
import org.apache.fineract.portfolio.savings.domain.GSIMRepositoy;
import org.apache.fineract.portfolio.savings.domain.GroupSavingsIndividualMonitoring;
import org.apache.fineract.portfolio.savings.domain.SavingsAccount;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountAssembler;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountCharge;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountChargeRepositoryWrapper;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountRepositoryWrapper;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountStatusType;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountTransaction;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountTransactionRepository;
import org.apache.fineract.portfolio.savings.exception.PostInterestAsOnDateException;
import org.apache.fineract.portfolio.savings.exception.PostInterestClosingDateException;
import org.apache.fineract.portfolio.savings.exception.SavingsAccountClosingNotAllowedException;
import org.apache.fineract.portfolio.savings.exception.SavingsAccountTransactionNotFoundException;
import org.apache.fineract.portfolio.savings.exception.SavingsOfficerAssignmentException;
import org.apache.fineract.portfolio.savings.exception.SavingsOfficerUnassignmentException;
import org.apache.fineract.portfolio.savings.exception.TransactionUpdateNotAllowedException;
import org.apache.fineract.portfolio.savings.service.SavingsAccountDomainService;
import org.apache.fineract.portfolio.savings.service.SavingsAccountInterestPostingService;
import org.apache.fineract.portfolio.savings.service.SavingsAccountWritePlatformService;
import org.apache.fineract.useradministration.domain.AppUser;
import org.apache.fineract.useradministration.domain.AppUserRepositoryWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

public class SavingsAccountWritePlatformServiceJpaRepositoryImpl
implements SavingsAccountWritePlatformService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SavingsAccountWritePlatformServiceJpaRepositoryImpl.class);
    private final PlatformSecurityContext context;
    private final SavingsAccountDataValidator fromApiJsonDeserializer;
    private final SavingsAccountRepositoryWrapper savingAccountRepositoryWrapper;
    private final StaffRepositoryWrapper staffRepository;
    private final SavingsAccountTransactionRepository savingsAccountTransactionRepository;
    private final SavingsAccountAssembler savingAccountAssembler;
    private final SavingsAccountTransactionDataValidator savingsAccountTransactionDataValidator;
    private final SavingsAccountChargeDataValidator savingsAccountChargeDataValidator;
    private final PaymentDetailWritePlatformService paymentDetailWritePlatformService;
    private final JournalEntryWritePlatformService journalEntryWritePlatformService;
    private final SavingsAccountDomainService savingsAccountDomainService;
    private final NoteRepository noteRepository;
    private final AccountTransfersReadPlatformService accountTransfersReadPlatformService;
    private final AccountAssociationsReadPlatformService accountAssociationsReadPlatformService;
    private final ChargeRepositoryWrapper chargeRepository;
    private final SavingsAccountChargeRepositoryWrapper savingsAccountChargeRepository;
    private final HolidayRepositoryWrapper holidayRepository;
    private final WorkingDaysRepositoryWrapper workingDaysRepository;
    private final ConfigurationDomainService configurationDomainService;
    private final DepositAccountOnHoldTransactionRepository depositAccountOnHoldTransactionRepository;
    private final EntityDatatableChecksWritePlatformService entityDatatableChecksWritePlatformService;
    private final AppUserRepositoryWrapper appuserRepository;
    private final StandingInstructionRepository standingInstructionRepository;
    private final BusinessEventNotifierService businessEventNotifierService;
    private final GSIMRepositoy gsimRepository;
    private final SavingsAccountInterestPostingService savingsAccountInterestPostingService;
    private final ErrorHandler errorHandler;

    @Transactional
    public CommandProcessingResult gsimActivate(Long gsimId, JsonCommand command) {
        Long parentSavingId = gsimId;
        GroupSavingsIndividualMonitoring parentSavings = (GroupSavingsIndividualMonitoring)this.gsimRepository.findById((Object)parentSavingId).orElseThrow();
        List childSavings = this.savingAccountRepositoryWrapper.findByGsimId(gsimId);
        CommandProcessingResult result = null;
        int count = 0;
        for (SavingsAccount account : childSavings) {
            result = this.activate((Long)account.getId(), command);
            if (result == null || (long)(++count) != parentSavings.getChildAccountsCount()) continue;
            parentSavings.setSavingsStatus(SavingsAccountStatusType.ACTIVE.getValue());
            this.gsimRepository.save((Object)parentSavings);
        }
        return result;
    }

    @Transactional
    public CommandProcessingResult activate(Long savingsId, JsonCommand command) {
        AppUser user = this.context.authenticatedUser();
        this.savingsAccountTransactionDataValidator.validateActivation(command);
        SavingsAccount account = this.savingAccountAssembler.assembleFrom(savingsId, false);
        this.checkClientOrGroupActive(account);
        HashSet existingTransactionIds = new HashSet();
        HashSet existingReversedTransactionIds = new HashSet();
        this.updateExistingTransactionsDetails(account, existingTransactionIds, existingReversedTransactionIds);
        Map changes = account.activate(user, command);
        this.entityDatatableChecksWritePlatformService.runTheCheckForProduct(savingsId, EntityTables.SAVINGS.getName(), StatusEnum.ACTIVATE.getValue(), EntityTables.SAVINGS.getForeignKeyColumnNameOnDatatable(), account.productId().longValue());
        if (!changes.isEmpty()) {
            Locale locale = command.extractLocale();
            DateTimeFormatter fmt = DateTimeFormatter.ofPattern(command.dateFormat()).withLocale(locale);
            this.processPostActiveActions(account, fmt, existingTransactionIds, existingReversedTransactionIds);
            this.savingAccountRepositoryWrapper.saveAndFlush(account);
        }
        this.postJournalEntries(account, existingTransactionIds, existingReversedTransactionIds, false);
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new SavingsActivateBusinessEvent(account));
        return new CommandProcessingResultBuilder().withEntityId(savingsId).withOfficeId(account.officeId()).withClientId(account.clientId()).withGroupId(account.groupId()).withSavingsId(savingsId).with(changes).build();
    }

    public void processPostActiveActions(SavingsAccount account, DateTimeFormatter fmt, Set<Long> existingTransactionIds, Set<Long> existingReversedTransactionIds) {
        this.getAppUserIfPresent();
        boolean isSavingsInterestPostingAtCurrentPeriodEnd = this.configurationDomainService.isSavingsInterestPostingAtCurrentPeriodEnd();
        Integer financialYearBeginningMonth = this.configurationDomainService.retrieveFinancialYearBeginningMonth();
        Money amountForDeposit = account.activateWithBalance();
        boolean isRegularTransaction = false;
        if (amountForDeposit.isGreaterThanZero()) {
            boolean isAccountTransfer = false;
            this.savingsAccountDomainService.handleDeposit(account, fmt, account.getActivationDate(), amountForDeposit.getAmount(), null, isAccountTransfer, isRegularTransaction, false);
            this.updateExistingTransactionsDetails(account, existingTransactionIds, existingReversedTransactionIds);
        }
        account.processAccountUponActivation(isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth);
        List depositAccountOnHoldTransactions = null;
        if (account.getOnHoldFunds().compareTo(BigDecimal.ZERO) > 0) {
            depositAccountOnHoldTransactions = this.depositAccountOnHoldTransactionRepository.findBySavingsAccountAndReversedFalseOrderByCreatedDateAsc(account);
        }
        account.validateAccountBalanceDoesNotBecomeNegative(SavingsAccountTransactionType.PAY_CHARGE.name(), depositAccountOnHoldTransactions, false);
    }

    @Transactional
    public CommandProcessingResult gsimDeposit(Long gsimId, JsonCommand command) {
        JsonArray savingsArray = command.arrayOfParameterNamed("savingsArray");
        CommandProcessingResult result = null;
        for (JsonElement element : savingsArray) {
            result = this.deposit(Long.valueOf(element.getAsJsonObject().get("childAccountId").getAsLong()), JsonCommand.fromExistingCommand((JsonCommand)command, (JsonElement)element));
        }
        return result;
    }

    @Transactional
    public CommandProcessingResult deposit(Long savingsId, JsonCommand command) {
        String noteText;
        this.context.authenticatedUser();
        this.savingsAccountTransactionDataValidator.validate(command);
        boolean isGsim = false;
        boolean backdatedTxnsAllowedTill = this.savingAccountAssembler.getPivotConfigStatus();
        SavingsAccount account = this.savingAccountAssembler.assembleFrom(savingsId, backdatedTxnsAllowedTill);
        if (account.getGsim() != null) {
            isGsim = true;
            log.debug("is gsim");
        }
        this.checkClientOrGroupActive(account);
        Locale locale = command.extractLocale();
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern(command.dateFormat()).withLocale(locale);
        LocalDate transactionDate = command.localDateValueOfParameterNamed("transactionDate");
        BigDecimal transactionAmount = command.bigDecimalValueOfParameterNamed("transactionAmount");
        this.savingsAccountTransactionDataValidator.validateTransactionWithPivotDate(transactionDate, account);
        LinkedHashMap changes = new LinkedHashMap();
        PaymentDetail paymentDetail = this.paymentDetailWritePlatformService.createAndPersistPaymentDetail(command, changes);
        boolean isAccountTransfer = false;
        boolean isRegularTransaction = true;
        SavingsAccountTransaction deposit = this.savingsAccountDomainService.handleDeposit(account, fmt, transactionDate, transactionAmount, paymentDetail, isAccountTransfer, isRegularTransaction, backdatedTxnsAllowedTill);
        if (isGsim && deposit.getId() != null) {
            log.debug("Deposit account has been created: {} ", (Object)deposit);
            GroupSavingsIndividualMonitoring gsim = (GroupSavingsIndividualMonitoring)this.gsimRepository.findById((Object)((Long)account.getGsim().getId())).orElseThrow();
            log.debug("parent deposit : {} ", (Object)gsim.getParentDeposit());
            log.debug("child account : {} ", (Object)savingsId);
            BigDecimal currentBalance = gsim.getParentDeposit();
            BigDecimal newBalance = currentBalance.add(transactionAmount);
            gsim.setParentDeposit(newBalance);
            this.gsimRepository.save((Object)gsim);
            log.debug("balance after making deposit : {} ", (Object)((GroupSavingsIndividualMonitoring)this.gsimRepository.findById((Object)((Long)account.getGsim().getId())).orElseThrow()).getParentDeposit());
        }
        if (StringUtils.isNotBlank((CharSequence)(noteText = command.stringValueOfParameterNamed("note")))) {
            Note note = Note.savingsTransactionNote((SavingsAccount)account, (SavingsAccountTransaction)deposit, (String)noteText);
            this.noteRepository.save((Object)note);
        }
        return new CommandProcessingResultBuilder().withEntityId((Long)deposit.getId()).withOfficeId(account.officeId()).withClientId(account.clientId()).withGroupId(account.groupId()).withSavingsId(savingsId).with(changes).build();
    }

    private Long saveTransactionToGenerateTransactionId(SavingsAccountTransaction transaction) {
        this.savingsAccountTransactionRepository.saveAndFlush((Object)transaction);
        return (Long)transaction.getId();
    }

    @Transactional
    public CommandProcessingResult withdrawal(Long savingsId, JsonCommand command) {
        String noteText;
        this.savingsAccountTransactionDataValidator.validate(command);
        boolean isGsim = false;
        LocalDate transactionDate = command.localDateValueOfParameterNamed("transactionDate");
        BigDecimal transactionAmount = command.bigDecimalValueOfParameterNamed("transactionAmount");
        Locale locale = command.extractLocale();
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern(command.dateFormat()).withLocale(locale);
        LinkedHashMap changes = new LinkedHashMap();
        PaymentDetail paymentDetail = this.paymentDetailWritePlatformService.createAndPersistPaymentDetail(command, changes);
        boolean backdatedTxnsAllowedTill = this.savingAccountAssembler.getPivotConfigStatus();
        SavingsAccount account = this.savingAccountAssembler.assembleFrom(savingsId, backdatedTxnsAllowedTill);
        if (account.getGsim() != null) {
            isGsim = true;
        }
        this.checkClientOrGroupActive(account);
        this.savingsAccountTransactionDataValidator.validateTransactionWithPivotDate(transactionDate, account);
        boolean isAccountTransfer = false;
        boolean isRegularTransaction = true;
        boolean isApplyWithdrawFee = true;
        boolean isInterestTransfer = false;
        boolean isWithdrawBalance = false;
        SavingsTransactionBooleanValues transactionBooleanValues = new SavingsTransactionBooleanValues(false, true, true, false, false);
        SavingsAccountTransaction withdrawal = this.savingsAccountDomainService.handleWithdrawal(account, fmt, transactionDate, transactionAmount, paymentDetail, transactionBooleanValues, backdatedTxnsAllowedTill);
        if (isGsim && withdrawal.getId() != null) {
            GroupSavingsIndividualMonitoring gsim = (GroupSavingsIndividualMonitoring)this.gsimRepository.findById((Object)((Long)account.getGsim().getId())).orElseThrow();
            BigDecimal currentBalance = gsim.getParentDeposit().subtract(transactionAmount);
            gsim.setParentDeposit(currentBalance);
            this.gsimRepository.save((Object)gsim);
        }
        if (StringUtils.isNotBlank((CharSequence)(noteText = command.stringValueOfParameterNamed("note")))) {
            Note note = Note.savingsTransactionNote((SavingsAccount)account, (SavingsAccountTransaction)withdrawal, (String)noteText);
            this.noteRepository.save((Object)note);
        }
        return new CommandProcessingResultBuilder().withEntityId((Long)withdrawal.getId()).withOfficeId(account.officeId()).withClientId(account.clientId()).withGroupId(account.groupId()).withSavingsId(savingsId).with(changes).build();
    }

    @Transactional
    public CommandProcessingResult applyAnnualFee(Long savingsAccountChargeId, Long accountId) {
        this.getAppUserIfPresent();
        SavingsAccountCharge savingsAccountCharge = this.savingsAccountChargeRepository.findOneWithNotFoundDetection(savingsAccountChargeId, accountId);
        LocalDate currentDate = DateUtils.getBusinessLocalDate();
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern("dd MM yyyy").withZone(DateUtils.getDateTimeZoneOfTenant());
        while (DateUtils.isBefore((LocalDate)savingsAccountCharge.getDueDate(), (LocalDate)currentDate)) {
            this.payCharge(savingsAccountCharge, savingsAccountCharge.getDueDate(), savingsAccountCharge.amount(), fmt, false);
        }
        return new CommandProcessingResultBuilder().withEntityId((Long)savingsAccountCharge.getId()).withOfficeId(savingsAccountCharge.savingsAccount().officeId()).withClientId(savingsAccountCharge.savingsAccount().clientId()).withGroupId(savingsAccountCharge.savingsAccount().groupId()).withSavingsId((Long)savingsAccountCharge.savingsAccount().getId()).build();
    }

    @Transactional
    public CommandProcessingResult calculateInterest(Long savingsId) {
        boolean isSavingsInterestPostingAtCurrentPeriodEnd = this.configurationDomainService.isSavingsInterestPostingAtCurrentPeriodEnd();
        Integer financialYearBeginningMonth = this.configurationDomainService.retrieveFinancialYearBeginningMonth();
        boolean backdatedTxnsAllowedTill = this.savingAccountAssembler.getPivotConfigStatus();
        SavingsAccount account = this.savingAccountAssembler.assembleFrom(savingsId, backdatedTxnsAllowedTill);
        this.checkClientOrGroupActive(account);
        LocalDate today = DateUtils.getBusinessLocalDate();
        MathContext mc = new MathContext(15, MoneyHelper.getRoundingMode());
        boolean isInterestTransfer = false;
        LocalDate postInterestOnDate = null;
        boolean postReversals = false;
        account.calculateInterestUsing(mc, today, isInterestTransfer, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth, postInterestOnDate, backdatedTxnsAllowedTill, postReversals);
        if (backdatedTxnsAllowedTill) {
            this.savingsAccountTransactionRepository.saveAll((Iterable)account.getSavingsAccountTransactionsWithPivotConfig());
        }
        this.savingAccountRepositoryWrapper.save(account);
        return new CommandProcessingResultBuilder().withEntityId(savingsId).withOfficeId(account.officeId()).withClientId(account.clientId()).withGroupId(account.groupId()).withSavingsId(savingsId).build();
    }

    @Transactional
    public CommandProcessingResult postInterest(JsonCommand command) {
        Long savingsId = command.getSavingsId();
        boolean postInterestAs = command.booleanPrimitiveValueOfParameterNamed("isPostInterestAsOn");
        LocalDate transactionDate = command.localDateValueOfParameterNamed("transactionDate");
        boolean backdatedTxnsAllowedTill = this.savingAccountAssembler.getPivotConfigStatus();
        SavingsAccount account = this.savingAccountAssembler.assembleFrom(savingsId, backdatedTxnsAllowedTill);
        this.checkClientOrGroupActive(account);
        this.savingsAccountTransactionDataValidator.validateTransactionWithPivotDate(transactionDate, account);
        if (postInterestAs) {
            if (transactionDate == null) {
                throw new PostInterestAsOnDateException(PostInterestAsOnDateException.PostInterestAsOnExceptionType.VALID_DATE);
            }
            if (DateUtils.isBefore((LocalDate)transactionDate, (LocalDate)account.accountSubmittedOrActivationDate())) {
                throw new PostInterestAsOnDateException(PostInterestAsOnDateException.PostInterestAsOnExceptionType.ACTIVATION_DATE);
            }
            List savingTransactions = null;
            savingTransactions = backdatedTxnsAllowedTill ? account.getSavingsAccountTransactionsWithPivotConfig() : account.getTransactions();
            for (SavingsAccountTransaction savingTransaction : savingTransactions) {
                if (!DateUtils.isBefore((LocalDate)transactionDate, (LocalDate)savingTransaction.getDateOf())) continue;
                throw new PostInterestAsOnDateException(PostInterestAsOnDateException.PostInterestAsOnExceptionType.LAST_TRANSACTION_DATE);
            }
            if (DateUtils.isDateInTheFuture((LocalDate)transactionDate)) {
                throw new PostInterestAsOnDateException(PostInterestAsOnDateException.PostInterestAsOnExceptionType.FUTURE_DATE);
            }
        }
        this.postInterest(account, postInterestAs, transactionDate, backdatedTxnsAllowedTill);
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new SavingsPostInterestBusinessEvent(account));
        return new CommandProcessingResultBuilder().withEntityId(savingsId).withOfficeId(account.officeId()).withClientId(account.clientId()).withGroupId(account.groupId()).withSavingsId(savingsId).build();
    }

    @Transactional
    public void postInterest(SavingsAccount account, boolean postInterestAs, LocalDate transactionDate, boolean backdatedTxnsAllowedTill) {
        boolean isSavingsInterestPostingAtCurrentPeriodEnd = this.configurationDomainService.isSavingsInterestPostingAtCurrentPeriodEnd();
        Integer financialYearBeginningMonth = this.configurationDomainService.retrieveFinancialYearBeginningMonth();
        if (account.getNominalAnnualInterestRate().compareTo(BigDecimal.ZERO) > 0 || account.allowOverdraft() && account.getNominalAnnualInterestRateOverdraft().compareTo(BigDecimal.ZERO) > 0) {
            HashSet existingTransactionIds = new HashSet();
            HashSet existingReversedTransactionIds = new HashSet();
            if (backdatedTxnsAllowedTill) {
                this.updateSavingsTransactionsDetails(account, existingTransactionIds, existingReversedTransactionIds);
            } else {
                this.updateExistingTransactionsDetails(account, existingTransactionIds, existingReversedTransactionIds);
            }
            LocalDate today = DateUtils.getBusinessLocalDate();
            MathContext mc = new MathContext(10, MoneyHelper.getRoundingMode());
            boolean isInterestTransfer = false;
            LocalDate postInterestOnDate = null;
            if (postInterestAs) {
                postInterestOnDate = transactionDate;
            }
            boolean postReversals = false;
            account.postInterest(mc, today, isInterestTransfer, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth, postInterestOnDate, backdatedTxnsAllowedTill, postReversals);
            if (!backdatedTxnsAllowedTill) {
                List transactions = account.getTransactions();
                for (SavingsAccountTransaction accountTransaction : transactions) {
                    if (accountTransaction.getId() != null) continue;
                    this.savingsAccountTransactionRepository.save((Object)accountTransaction);
                }
            }
            if (backdatedTxnsAllowedTill) {
                this.savingsAccountTransactionRepository.saveAll((Iterable)account.getSavingsAccountTransactionsWithPivotConfig());
            }
            this.savingAccountRepositoryWrapper.saveAndFlush(account);
            this.postJournalEntries(account, existingTransactionIds, existingReversedTransactionIds, backdatedTxnsAllowedTill);
        }
    }

    @Transactional
    @Retry(name="postInterest", fallbackMethod="fallbackPostInterest")
    public SavingsAccountData postInterest(SavingsAccountData savingsAccountData, boolean postInterestAs, LocalDate transactionDate, boolean backdatedTxnsAllowedTill) {
        boolean isSavingsInterestPostingAtCurrentPeriodEnd = this.configurationDomainService.isSavingsInterestPostingAtCurrentPeriodEnd();
        Integer financialYearBeginningMonth = this.configurationDomainService.retrieveFinancialYearBeginningMonth();
        if (MathUtil.isGreaterThanZero((BigDecimal)savingsAccountData.getNominalAnnualInterestRate()) || savingsAccountData.isAllowOverdraft() && MathUtil.isGreaterThanZero((BigDecimal)savingsAccountData.getNominalAnnualInterestRateOverdraft())) {
            HashSet existingTransactionIds = new HashSet();
            HashSet existingReversedTransactionIds = new HashSet();
            this.updateExistingTransactionsDetails(savingsAccountData, existingTransactionIds, existingReversedTransactionIds);
            LocalDate today = DateUtils.getBusinessLocalDate();
            MathContext mc = new MathContext(10, MoneyHelper.getRoundingMode());
            boolean isInterestTransfer = false;
            LocalDate postInterestOnDate = null;
            if (postInterestAs) {
                postInterestOnDate = transactionDate;
            }
            savingsAccountData = this.savingsAccountInterestPostingService.postInterest(mc, today, isInterestTransfer, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth, postInterestOnDate, backdatedTxnsAllowedTill, savingsAccountData);
            if (!backdatedTxnsAllowedTill) {
                List transactions = savingsAccountData.getSavingsAccountTransactionData();
                for (SavingsAccountTransactionData accountTransaction : transactions) {
                    if (accountTransaction.getId() != null) continue;
                    savingsAccountData.setNewSavingsAccountTransactionData(accountTransaction);
                    this.selectAccountId(accountTransaction, savingsAccountData);
                }
            }
            savingsAccountData.setExistingTransactionIds(existingTransactionIds);
            savingsAccountData.setExistingReversedTransactionIds(existingReversedTransactionIds);
        }
        return savingsAccountData;
    }

    public void selectAccountId(SavingsAccountTransactionData accountTransaction, SavingsAccountData savingsAccountData) {
        SavingsAccountTransactionType transactionType = SavingsAccountTransactionType.fromInt((Integer)accountTransaction.getTransactionType().getId().intValue());
        if (transactionType.isOverDraftInterestPosting()) {
            if (MathUtil.isGreaterThanZero((BigDecimal)accountTransaction.getRunningBalance())) {
                accountTransaction.setAccountDebit(savingsAccountData.getGlAccountIdForSavingsControl());
                accountTransaction.setAccountCredit(savingsAccountData.getGlAccountIdForInterestReceivable());
            } else {
                accountTransaction.setAccountDebit(savingsAccountData.getGlAccountIdForOverdraftPorfolio());
                accountTransaction.setAccountCredit(savingsAccountData.getGlAccountIdForInterestReceivable());
            }
        } else {
            accountTransaction.setAccountDebit(savingsAccountData.getGlAccountIdForInterestPayable());
            accountTransaction.setAccountCredit(savingsAccountData.getGlAccountIdForSavingsControl());
        }
    }

    public CommandProcessingResult reverseTransaction(Long savingsId, Long transactionId, boolean allowAccountTransferModification, JsonCommand command) {
        boolean backdatedTxnsAllowedTill = this.savingAccountAssembler.getPivotConfigStatus();
        boolean isBulk = command.booleanPrimitiveValueOfParameterNamed("isBulk");
        SavingsAccount account = this.savingAccountAssembler.assembleFrom(savingsId, backdatedTxnsAllowedTill);
        SavingsAccountTransaction savingsAccountTransaction = this.savingsAccountTransactionRepository.findOneByIdAndSavingsAccountId(transactionId, savingsId);
        if (savingsAccountTransaction == null) {
            throw new SavingsAccountTransactionNotFoundException(savingsId, transactionId);
        }
        if (!allowAccountTransferModification && this.accountTransfersReadPlatformService.isAccountTransfer(transactionId, PortfolioAccountType.SAVINGS)) {
            throw new PlatformServiceUnavailableException("error.msg.saving.account.transfer.transaction.update.not.allowed", "Savings account transaction:" + transactionId + " update not allowed as it involves in account transfer", new Object[]{transactionId});
        }
        if (!account.allowModify()) {
            throw new PlatformServiceUnavailableException("error.msg.saving.account.transaction.update.not.allowed", "Savings account transaction:" + transactionId + " update not allowed for this savings type", new Object[]{transactionId});
        }
        if (account.isNotActive()) {
            this.throwValidationForActiveStatus(".undotransaction");
        }
        SavingsAccountTransaction reversal = null;
        Long reversalId = null;
        this.checkClientOrGroupActive(account);
        List savingsAccountTransactions = null;
        if (isBulk) {
            String transactionRefNo = savingsAccountTransaction.getRefNo();
            savingsAccountTransactions = this.savingsAccountTransactionRepository.findByRefNo(transactionRefNo);
            reversal = this.savingsAccountDomainService.handleReversal(account, savingsAccountTransactions, backdatedTxnsAllowedTill);
        } else {
            reversal = this.savingsAccountDomainService.handleReversal(account, Collections.singletonList(savingsAccountTransaction), backdatedTxnsAllowedTill);
        }
        reversalId = (Long)reversal.getId();
        return new CommandProcessingResultBuilder().withEntityId(reversalId).withOfficeId(account.officeId()).withClientId(account.clientId()).withGroupId(account.groupId()).withSavingsId(savingsId).build();
    }

    public CommandProcessingResult undoTransaction(Long savingsId, Long transactionId, boolean allowAccountTransferModification) {
        SavingsAccountTransaction nextSavingsAccountTransaction;
        boolean isSavingsInterestPostingAtCurrentPeriodEnd = this.configurationDomainService.isSavingsInterestPostingAtCurrentPeriodEnd();
        Integer financialYearBeginningMonth = this.configurationDomainService.retrieveFinancialYearBeginningMonth();
        SavingsAccount account = this.savingAccountAssembler.assembleFrom(savingsId, false);
        HashSet existingTransactionIds = new HashSet();
        HashSet existingReversedTransactionIds = new HashSet();
        this.updateExistingTransactionsDetails(account, existingTransactionIds, existingReversedTransactionIds);
        SavingsAccountTransaction savingsAccountTransaction = this.savingsAccountTransactionRepository.findOneByIdAndSavingsAccountId(transactionId, savingsId);
        if (savingsAccountTransaction == null) {
            throw new SavingsAccountTransactionNotFoundException(savingsId, transactionId);
        }
        this.savingsAccountTransactionDataValidator.validateTransactionWithPivotDate(savingsAccountTransaction.getTransactionDate(), account);
        if (!allowAccountTransferModification && this.accountTransfersReadPlatformService.isAccountTransfer(transactionId, PortfolioAccountType.SAVINGS)) {
            throw new PlatformServiceUnavailableException("error.msg.saving.account.transfer.transaction.update.not.allowed", "Savings account transaction:" + transactionId + " update not allowed as it involves in account transfer", new Object[]{transactionId});
        }
        if (!account.allowModify()) {
            throw new PlatformServiceUnavailableException("error.msg.saving.account.transaction.update.not.allowed", "Savings account transaction:" + transactionId + " update not allowed for this savings type", new Object[]{transactionId});
        }
        LocalDate today = DateUtils.getBusinessLocalDate();
        MathContext mc = new MathContext(15, MoneyHelper.getRoundingMode());
        if (account.isNotActive()) {
            this.throwValidationForActiveStatus(".undotransaction");
        }
        account.undoTransaction(transactionId);
        if (savingsAccountTransaction.isWithdrawal() && (nextSavingsAccountTransaction = this.savingsAccountTransactionRepository.findOneByIdAndSavingsAccountId(Long.valueOf(transactionId + 1L), savingsId)) != null && nextSavingsAccountTransaction.isWithdrawalFeeAndNotReversed()) {
            account.undoTransaction(Long.valueOf(transactionId + 1L));
        }
        boolean isInterestTransfer = false;
        LocalDate postInterestOnDate = null;
        boolean postReversals = false;
        this.checkClientOrGroupActive(account);
        if (savingsAccountTransaction.isPostInterestCalculationRequired() && account.isBeforeLastPostingPeriod(savingsAccountTransaction.getTransactionDate(), false)) {
            account.postInterest(mc, today, isInterestTransfer, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth, postInterestOnDate, false, postReversals);
        } else {
            account.calculateInterestUsing(mc, today, isInterestTransfer, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth, postInterestOnDate, false, postReversals);
        }
        List depositAccountOnHoldTransactions = null;
        if (account.getOnHoldFunds().compareTo(BigDecimal.ZERO) > 0) {
            depositAccountOnHoldTransactions = this.depositAccountOnHoldTransactionRepository.findBySavingsAccountAndReversedFalseOrderByCreatedDateAsc(account);
        }
        account.validateAccountBalanceDoesNotBecomeNegative(".undotransaction", depositAccountOnHoldTransactions, false);
        account.activateAccountBasedOnBalance();
        this.savingAccountRepositoryWrapper.saveAndFlush(account);
        this.postJournalEntries(account, existingTransactionIds, existingReversedTransactionIds, false);
        return new CommandProcessingResultBuilder().withEntityId(savingsId).withOfficeId(account.officeId()).withClientId(account.clientId()).withGroupId(account.groupId()).withSavingsId(savingsId).build();
    }

    public CommandProcessingResult adjustSavingsTransaction(Long savingsId, Long transactionId, JsonCommand command) {
        this.context.authenticatedUser();
        boolean isSavingsInterestPostingAtCurrentPeriodEnd = this.configurationDomainService.isSavingsInterestPostingAtCurrentPeriodEnd();
        Integer financialYearBeginningMonth = this.configurationDomainService.retrieveFinancialYearBeginningMonth();
        Long relaxingDaysConfigForPivotDate = this.configurationDomainService.retrieveRelaxingDaysConfigForPivotDate();
        SavingsAccountTransaction savingsAccountTransaction = this.savingsAccountTransactionRepository.findOneByIdAndSavingsAccountId(transactionId, savingsId);
        if (savingsAccountTransaction == null) {
            throw new SavingsAccountTransactionNotFoundException(savingsId, transactionId);
        }
        if (!savingsAccountTransaction.isDeposit() && !savingsAccountTransaction.isWithdrawal() || savingsAccountTransaction.isReversed()) {
            throw new TransactionUpdateNotAllowedException(savingsId, transactionId);
        }
        if (this.accountTransfersReadPlatformService.isAccountTransfer(transactionId, PortfolioAccountType.SAVINGS)) {
            throw new PlatformServiceUnavailableException("error.msg.saving.account.transfer.transaction.update.not.allowed", "Savings account transaction:" + transactionId + " update not allowed as it involves in account transfer", new Object[]{transactionId});
        }
        this.savingsAccountTransactionDataValidator.validate(command);
        LocalDate today = DateUtils.getBusinessLocalDate();
        SavingsAccount account = this.savingAccountAssembler.assembleFrom(savingsId, false);
        if (account.isNotActive()) {
            this.throwValidationForActiveStatus(".adjusttransaction");
        }
        if (!account.allowModify()) {
            throw new PlatformServiceUnavailableException("error.msg.saving.account.transaction.update.not.allowed", "Savings account transaction:" + transactionId + " update not allowed for this savings type", new Object[]{transactionId});
        }
        HashSet existingTransactionIds = new HashSet();
        HashSet existingReversedTransactionIds = new HashSet();
        this.updateExistingTransactionsDetails(account, existingTransactionIds, existingReversedTransactionIds);
        Locale locale = command.extractLocale();
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern(command.dateFormat()).withLocale(locale);
        LocalDate transactionDate = command.localDateValueOfParameterNamed("transactionDate");
        BigDecimal transactionAmount = command.bigDecimalValueOfParameterNamed("transactionAmount");
        LinkedHashMap changes = new LinkedHashMap();
        PaymentDetail paymentDetail = this.paymentDetailWritePlatformService.createAndPersistPaymentDetail(command, changes);
        MathContext mc = new MathContext(10, MoneyHelper.getRoundingMode());
        account.undoTransaction(transactionId);
        SavingsAccountTransaction nextSavingsAccountTransaction = this.savingsAccountTransactionRepository.findOneByIdAndSavingsAccountId(Long.valueOf(transactionId + 1L), savingsId);
        if (nextSavingsAccountTransaction != null && nextSavingsAccountTransaction.isWithdrawalFeeAndNotReversed()) {
            account.undoTransaction(Long.valueOf(transactionId + 1L));
        }
        SavingsAccountTransaction transaction = null;
        boolean isInterestTransfer = false;
        Integer accountType = null;
        SavingsAccountTransactionDTO transactionDTO = new SavingsAccountTransactionDTO(fmt, transactionDate, transactionAmount, paymentDetail, null, accountType);
        UUID refNo = UUID.randomUUID();
        transaction = savingsAccountTransaction.isDeposit() ? account.deposit(transactionDTO, false, relaxingDaysConfigForPivotDate, refNo.toString()) : account.withdraw(transactionDTO, true, false, relaxingDaysConfigForPivotDate, refNo.toString());
        Long newtransactionId = this.saveTransactionToGenerateTransactionId(transaction);
        LocalDate postInterestOnDate = null;
        boolean postReversals = false;
        if (account.isBeforeLastPostingPeriod(transactionDate, false) || account.isBeforeLastPostingPeriod(savingsAccountTransaction.getTransactionDate(), false)) {
            account.postInterest(mc, today, isInterestTransfer, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth, postInterestOnDate, false, postReversals);
        } else {
            account.calculateInterestUsing(mc, today, isInterestTransfer, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth, postInterestOnDate, false, postReversals);
        }
        List depositAccountOnHoldTransactions = null;
        if (account.getOnHoldFunds().compareTo(BigDecimal.ZERO) > 0) {
            depositAccountOnHoldTransactions = this.depositAccountOnHoldTransactionRepository.findBySavingsAccountAndReversedFalseOrderByCreatedDateAsc(account);
        }
        account.validateAccountBalanceDoesNotBecomeNegative(".adjusttransaction", depositAccountOnHoldTransactions, false);
        account.activateAccountBasedOnBalance();
        this.savingAccountRepositoryWrapper.saveAndFlush(account);
        this.postJournalEntries(account, existingTransactionIds, existingReversedTransactionIds, false);
        return new CommandProcessingResultBuilder().withEntityId(newtransactionId).withOfficeId(account.officeId()).withClientId(account.clientId()).withGroupId(account.groupId()).withSavingsId(savingsId).with(changes).build();
    }

    private void throwValidationForActiveStatus(String actionName) {
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("savingsaccount" + actionName);
        baseDataValidator.reset().failWithCodeNoParameterAddedToErrorCode("account.is.not.active", new Object[0]);
        throw new PlatformApiDataValidationException(dataValidationErrors);
    }

    private void checkClientOrGroupActive(SavingsAccount account) {
        Client client = account.getClient();
        if (client != null && client.isNotActive()) {
            throw new ClientNotActiveException((Long)client.getId());
        }
        Group group = account.group();
        if (group != null && group.isNotActive()) {
            throw new GroupNotActiveException((Long)group.getId());
        }
    }

    public CommandProcessingResult bulkGSIMClose(Long gsimId, JsonCommand command) {
        Long parentSavingId = gsimId;
        GroupSavingsIndividualMonitoring parentSavings = (GroupSavingsIndividualMonitoring)this.gsimRepository.findById((Object)parentSavingId).orElseThrow();
        List childSavings = this.savingAccountRepositoryWrapper.findByGsimId(gsimId);
        CommandProcessingResult result = null;
        int count = 0;
        for (SavingsAccount account : childSavings) {
            result = this.close((Long)account.getId(), command);
            if (result == null || (long)(++count) != parentSavings.getChildAccountsCount()) continue;
            parentSavings.setSavingsStatus(SavingsAccountStatusType.CLOSED.getValue());
            this.gsimRepository.save((Object)parentSavings);
        }
        return result;
    }

    public CommandProcessingResult close(Long savingsId, JsonCommand command) {
        AppUser user = this.context.authenticatedUser();
        SavingsAccount account = this.savingAccountAssembler.assembleFrom(savingsId, false);
        this.savingsAccountTransactionDataValidator.validateClosing(command, account);
        boolean isLinkedWithAnyActiveLoan = this.accountAssociationsReadPlatformService.isLinkedWithAnyActiveAccount(savingsId);
        if (isLinkedWithAnyActiveLoan) {
            String defaultUserMessage = "Closing savings account with id:" + savingsId + " is not allowed, since it is linked with one of the active accounts";
            throw new SavingsAccountClosingNotAllowedException("linked", defaultUserMessage, new Object[]{savingsId});
        }
        this.entityDatatableChecksWritePlatformService.runTheCheckForProduct(savingsId, EntityTables.SAVINGS.getName(), StatusEnum.CLOSE.getValue(), EntityTables.SAVINGS.getForeignKeyColumnNameOnDatatable(), account.productId().longValue());
        boolean isWithdrawBalance = command.booleanPrimitiveValueOfParameterNamed("withdrawBalance");
        Locale locale = command.extractLocale();
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern(command.dateFormat()).withLocale(locale);
        LocalDate closedDate = command.localDateValueOfParameterNamed("closedOnDate");
        boolean isPostInterest = command.booleanPrimitiveValueOfParameterNamed("postInterestValidationOnClosure");
        if (isPostInterest) {
            boolean postInterestOnClosingDate = false;
            List savingTransactions = account.getTransactions();
            for (SavingsAccountTransaction savingTransaction : savingTransactions) {
                if (!savingTransaction.isInterestPosting() || !savingTransaction.isNotReversed() || !DateUtils.isEqual((LocalDate)closedDate, (LocalDate)savingTransaction.getTransactionDate())) continue;
                postInterestOnClosingDate = true;
                break;
            }
            if (!postInterestOnClosingDate) {
                throw new PostInterestClosingDateException();
            }
        }
        LinkedHashMap<String, String> changes = new LinkedHashMap<String, String>();
        if (isWithdrawBalance && account.getSummary().getAccountBalance(account.getCurrency()).isGreaterThanZero()) {
            BigDecimal transactionAmount = account.getSummary().getAccountBalance();
            PaymentDetail paymentDetail = this.paymentDetailWritePlatformService.createAndPersistPaymentDetail(command, changes);
            boolean isAccountTransfer = false;
            boolean isRegularTransaction = true;
            boolean isApplyWithdrawFee = false;
            boolean isInterestTransfer = false;
            SavingsTransactionBooleanValues transactionBooleanValues = new SavingsTransactionBooleanValues(false, true, false, false, isWithdrawBalance);
            this.savingsAccountDomainService.handleWithdrawal(account, fmt, closedDate, transactionAmount, paymentDetail, transactionBooleanValues, false);
        }
        Map accountChanges = account.close(user, command);
        changes.putAll(accountChanges);
        if (!changes.isEmpty()) {
            this.savingAccountRepositoryWrapper.save(account);
            String noteText = command.stringValueOfParameterNamed("note");
            if (StringUtils.isNotBlank((CharSequence)noteText)) {
                Note note = Note.savingNote((SavingsAccount)account, (String)noteText);
                changes.put("note", noteText);
                this.noteRepository.save((Object)note);
            }
        }
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new SavingsCloseBusinessEvent(account));
        this.disableStandingInstructionsLinkedToClosedSavings(account);
        return new CommandProcessingResultBuilder().withEntityId(savingsId).withOfficeId(account.officeId()).withClientId(account.clientId()).withGroupId(account.groupId()).withSavingsId(savingsId).with(changes).build();
    }

    public SavingsAccountTransaction initiateSavingsTransfer(SavingsAccount savingsAccount, LocalDate transferDate) {
        this.getAppUserIfPresent();
        boolean isSavingsInterestPostingAtCurrentPeriodEnd = this.configurationDomainService.isSavingsInterestPostingAtCurrentPeriodEnd();
        this.validateTransactionsForTransfer(savingsAccount, transferDate);
        Integer financialYearBeginningMonth = this.configurationDomainService.retrieveFinancialYearBeginningMonth();
        this.savingAccountAssembler.setHelpers(savingsAccount);
        HashSet existingTransactionIds = new HashSet();
        HashSet existingReversedTransactionIds = new HashSet();
        this.updateExistingTransactionsDetails(savingsAccount, existingTransactionIds, existingReversedTransactionIds);
        SavingsAccountTransaction newTransferTransaction = SavingsAccountTransaction.initiateTransfer((SavingsAccount)savingsAccount, (Office)savingsAccount.office(), (LocalDate)transferDate);
        savingsAccount.addTransaction(newTransferTransaction);
        savingsAccount.setStatus(SavingsAccountStatusType.TRANSFER_IN_PROGRESS.getValue());
        MathContext mc = MathContext.DECIMAL64;
        boolean isInterestTransfer = false;
        LocalDate postInterestOnDate = null;
        boolean postReversals = false;
        savingsAccount.calculateInterestUsing(mc, transferDate, isInterestTransfer, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth, postInterestOnDate, false, postReversals);
        this.savingsAccountTransactionRepository.save((Object)newTransferTransaction);
        this.savingAccountRepositoryWrapper.saveAndFlush(savingsAccount);
        this.postJournalEntries(savingsAccount, existingTransactionIds, existingReversedTransactionIds, false);
        return newTransferTransaction;
    }

    public SavingsAccountTransaction withdrawSavingsTransfer(SavingsAccount savingsAccount, LocalDate transferDate) {
        this.getAppUserIfPresent();
        boolean isSavingsInterestPostingAtCurrentPeriodEnd = this.configurationDomainService.isSavingsInterestPostingAtCurrentPeriodEnd();
        Integer financialYearBeginningMonth = this.configurationDomainService.retrieveFinancialYearBeginningMonth();
        this.savingAccountAssembler.setHelpers(savingsAccount);
        HashSet existingTransactionIds = new HashSet();
        HashSet existingReversedTransactionIds = new HashSet();
        this.updateExistingTransactionsDetails(savingsAccount, existingTransactionIds, existingReversedTransactionIds);
        SavingsAccountTransaction withdrawtransferTransaction = SavingsAccountTransaction.withdrawTransfer((SavingsAccount)savingsAccount, (Office)savingsAccount.office(), (LocalDate)transferDate);
        savingsAccount.addTransaction(withdrawtransferTransaction);
        savingsAccount.setStatus(SavingsAccountStatusType.ACTIVE.getValue());
        MathContext mc = MathContext.DECIMAL64;
        boolean isInterestTransfer = false;
        LocalDate postInterestOnDate = null;
        boolean postReversals = false;
        savingsAccount.calculateInterestUsing(mc, transferDate, isInterestTransfer, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth, postInterestOnDate, false, postReversals);
        this.savingsAccountTransactionRepository.save((Object)withdrawtransferTransaction);
        this.savingAccountRepositoryWrapper.saveAndFlush(savingsAccount);
        this.postJournalEntries(savingsAccount, existingTransactionIds, existingReversedTransactionIds, false);
        return withdrawtransferTransaction;
    }

    public void rejectSavingsTransfer(SavingsAccount savingsAccount) {
        this.savingAccountAssembler.setHelpers(savingsAccount);
        savingsAccount.setStatus(SavingsAccountStatusType.TRANSFER_ON_HOLD.getValue());
        this.savingAccountRepositoryWrapper.save(savingsAccount);
    }

    public SavingsAccountTransaction acceptSavingsTransfer(SavingsAccount savingsAccount, LocalDate transferDate, Office acceptedInOffice, Staff fieldOfficer) {
        this.getAppUserIfPresent();
        boolean isSavingsInterestPostingAtCurrentPeriodEnd = this.configurationDomainService.isSavingsInterestPostingAtCurrentPeriodEnd();
        Integer financialYearBeginningMonth = this.configurationDomainService.retrieveFinancialYearBeginningMonth();
        this.savingAccountAssembler.setHelpers(savingsAccount);
        HashSet existingTransactionIds = new HashSet();
        HashSet existingReversedTransactionIds = new HashSet();
        this.updateExistingTransactionsDetails(savingsAccount, existingTransactionIds, existingReversedTransactionIds);
        SavingsAccountTransaction acceptTransferTransaction = SavingsAccountTransaction.approveTransfer((SavingsAccount)savingsAccount, (Office)acceptedInOffice, (LocalDate)transferDate);
        savingsAccount.addTransaction(acceptTransferTransaction);
        savingsAccount.setStatus(SavingsAccountStatusType.ACTIVE.getValue());
        if (fieldOfficer != null) {
            savingsAccount.reassignSavingsOfficer(fieldOfficer, transferDate);
        }
        boolean isInterestTransfer = false;
        MathContext mc = MathContext.DECIMAL64;
        LocalDate postInterestOnDate = null;
        boolean postReversals = false;
        savingsAccount.calculateInterestUsing(mc, transferDate, isInterestTransfer, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth, postInterestOnDate, false, postReversals);
        this.savingsAccountTransactionRepository.save((Object)acceptTransferTransaction);
        this.savingAccountRepositoryWrapper.saveAndFlush(savingsAccount);
        this.postJournalEntries(savingsAccount, existingTransactionIds, existingReversedTransactionIds, false);
        return acceptTransferTransaction;
    }

    @Transactional
    public CommandProcessingResult addSavingsAccountCharge(JsonCommand command) {
        this.context.authenticatedUser();
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("savingsaccount");
        Long savingsAccountId = command.getSavingsId();
        this.savingsAccountChargeDataValidator.validateAdd(command.json());
        SavingsAccount savingsAccount = this.savingAccountAssembler.assembleFrom(savingsAccountId, false);
        this.checkClientOrGroupActive(savingsAccount);
        Locale locale = command.extractLocale();
        String format = command.dateFormat();
        DateTimeFormatter fmt = StringUtils.isNotBlank((CharSequence)format) ? DateTimeFormatter.ofPattern(format).withLocale(locale) : DateTimeFormatter.ofPattern("dd MM yyyy");
        Long chargeDefinitionId = command.longValueOfParameterNamed("chargeId");
        Charge chargeDefinition = this.chargeRepository.findOneWithNotFoundDetection(chargeDefinitionId);
        Integer chargeTimeType = chargeDefinition.getChargeTimeType();
        LocalDate dueAsOfDateParam = command.localDateValueOfParameterNamed("dueDate");
        if ((chargeTimeType.equals(ChargeTimeType.WITHDRAWAL_FEE.getValue()) || chargeTimeType.equals(ChargeTimeType.SAVINGS_NOACTIVITY_FEE.getValue())) && dueAsOfDateParam != null) {
            baseDataValidator.reset().parameter("dueDate").value((Object)dueAsOfDateParam.format(fmt)).failWithCodeNoParameterAddedToErrorCode("charge.due.date.is.invalid.for." + ChargeTimeType.fromInt((Integer)chargeTimeType).getCode(), new Object[0]);
        }
        SavingsAccountCharge savingsAccountCharge = SavingsAccountCharge.createNewFromJson((SavingsAccount)savingsAccount, (Charge)chargeDefinition, (JsonCommand)command);
        if (chargeDefinition.isEnableFreeWithdrawal()) {
            savingsAccountCharge.setFreeWithdrawalCount(Integer.valueOf(0));
        }
        if (savingsAccountCharge.getDueDate() != null) {
            if (!this.configurationDomainService.allowTransactionsOnHolidayEnabled() && this.holidayRepository.isHoliday(savingsAccount.officeId(), savingsAccountCharge.getDueDate())) {
                baseDataValidator.reset().parameter("dueDate").value((Object)savingsAccountCharge.getDueDate().format(fmt)).failWithCodeNoParameterAddedToErrorCode("charge.due.date.is.on.holiday", new Object[0]);
            }
            if (!this.configurationDomainService.allowTransactionsOnNonWorkingDayEnabled() && !this.workingDaysRepository.isWorkingDay(savingsAccountCharge.getDueDate())) {
                baseDataValidator.reset().parameter("dueDate").value((Object)savingsAccountCharge.getDueDate().format(fmt)).failWithCodeNoParameterAddedToErrorCode("charge.due.date.is.a.nonworking.day", new Object[0]);
            }
        }
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
        savingsAccount.addCharge(fmt, savingsAccountCharge, chargeDefinition);
        this.savingsAccountChargeRepository.save(savingsAccountCharge);
        this.savingAccountRepositoryWrapper.saveAndFlush(savingsAccount);
        return new CommandProcessingResultBuilder().withEntityId((Long)savingsAccountCharge.getId()).withOfficeId(savingsAccount.officeId()).withClientId(savingsAccount.clientId()).withGroupId(savingsAccount.groupId()).withSavingsId(savingsAccountId).build();
    }

    @Transactional
    public CommandProcessingResult updateSavingsAccountCharge(JsonCommand command) {
        this.context.authenticatedUser();
        this.savingsAccountChargeDataValidator.validateUpdate(command.json());
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("savingsaccount");
        Long savingsAccountId = command.getSavingsId();
        Long savingsChargeId = command.entityId();
        SavingsAccount savingsAccount = this.savingAccountAssembler.assembleFrom(savingsAccountId, false);
        this.checkClientOrGroupActive(savingsAccount);
        SavingsAccountCharge savingsAccountCharge = this.savingsAccountChargeRepository.findOneWithNotFoundDetection(savingsChargeId, savingsAccountId);
        Map changes = savingsAccountCharge.update(command);
        if (savingsAccountCharge.getDueDate() != null) {
            Locale locale = command.extractLocale();
            DateTimeFormatter fmt = DateTimeFormatter.ofPattern(command.dateFormat()).withLocale(locale);
            if (!this.configurationDomainService.allowTransactionsOnHolidayEnabled() && this.holidayRepository.isHoliday(savingsAccount.officeId(), savingsAccountCharge.getDueDate())) {
                baseDataValidator.reset().parameter("dueDate").value((Object)savingsAccountCharge.getDueDate().format(fmt)).failWithCodeNoParameterAddedToErrorCode("charge.due.date.is.on.holiday", new Object[0]);
                if (!dataValidationErrors.isEmpty()) {
                    throw new PlatformApiDataValidationException(dataValidationErrors);
                }
            }
            if (!this.configurationDomainService.allowTransactionsOnNonWorkingDayEnabled() && !this.workingDaysRepository.isWorkingDay(savingsAccountCharge.getDueDate())) {
                baseDataValidator.reset().parameter("dueDate").value((Object)savingsAccountCharge.getDueDate().format(fmt)).failWithCodeNoParameterAddedToErrorCode("charge.due.date.is.a.nonworking.day", new Object[0]);
                if (!dataValidationErrors.isEmpty()) {
                    throw new PlatformApiDataValidationException(dataValidationErrors);
                }
            }
        }
        this.savingsAccountChargeRepository.saveAndFlush(savingsAccountCharge);
        return new CommandProcessingResultBuilder().withEntityId((Long)savingsAccountCharge.getId()).withOfficeId(savingsAccountCharge.savingsAccount().officeId()).withClientId(savingsAccountCharge.savingsAccount().clientId()).withGroupId(savingsAccountCharge.savingsAccount().groupId()).withSavingsId((Long)savingsAccountCharge.savingsAccount().getId()).with(changes).build();
    }

    @Transactional
    public CommandProcessingResult waiveCharge(Long savingsAccountId, Long savingsAccountChargeId) {
        this.context.authenticatedUser();
        boolean isSavingsInterestPostingAtCurrentPeriodEnd = this.configurationDomainService.isSavingsInterestPostingAtCurrentPeriodEnd();
        Integer financialYearBeginningMonth = this.configurationDomainService.retrieveFinancialYearBeginningMonth();
        SavingsAccountCharge savingsAccountCharge = this.savingsAccountChargeRepository.findOneWithNotFoundDetection(savingsAccountChargeId, savingsAccountId);
        SavingsAccount account = savingsAccountCharge.savingsAccount();
        boolean backdatedTxnsAllowedTill = this.savingAccountAssembler.getPivotConfigStatus();
        this.savingAccountAssembler.loadTransactionsToSavingsAccount(account, backdatedTxnsAllowedTill);
        HashSet existingTransactionIds = new HashSet();
        HashSet existingReversedTransactionIds = new HashSet();
        if (backdatedTxnsAllowedTill) {
            this.updateSavingsTransactionsDetails(account, existingTransactionIds, existingReversedTransactionIds);
        } else {
            this.updateExistingTransactionsDetails(account, existingTransactionIds, existingReversedTransactionIds);
        }
        account.waiveCharge(savingsAccountChargeId, backdatedTxnsAllowedTill);
        boolean isInterestTransfer = false;
        LocalDate postInterestOnDate = null;
        MathContext mc = MathContext.DECIMAL64;
        boolean postReversals = false;
        if (account.isBeforeLastPostingPeriod(savingsAccountCharge.getDueDate(), backdatedTxnsAllowedTill)) {
            today = DateUtils.getBusinessLocalDate();
            account.postInterest(mc, today, isInterestTransfer, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth, postInterestOnDate, backdatedTxnsAllowedTill, postReversals);
        } else {
            today = DateUtils.getBusinessLocalDate();
            account.calculateInterestUsing(mc, today, isInterestTransfer, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth, postInterestOnDate, backdatedTxnsAllowedTill, postReversals);
        }
        List depositAccountOnHoldTransactions = null;
        if (account.getOnHoldFunds().compareTo(BigDecimal.ZERO) > 0) {
            depositAccountOnHoldTransactions = this.depositAccountOnHoldTransactionRepository.findBySavingsAccountAndReversedFalseOrderByCreatedDateAsc(account);
        }
        account.validateAccountBalanceDoesNotBecomeNegative(".waivecharge", depositAccountOnHoldTransactions, backdatedTxnsAllowedTill);
        if (backdatedTxnsAllowedTill) {
            this.savingsAccountTransactionRepository.saveAll((Iterable)account.getSavingsAccountTransactionsWithPivotConfig());
        }
        this.savingAccountRepositoryWrapper.saveAndFlush(account);
        this.postJournalEntries(account, existingTransactionIds, existingReversedTransactionIds, backdatedTxnsAllowedTill);
        return new CommandProcessingResultBuilder().withEntityId(savingsAccountChargeId).withOfficeId(account.officeId()).withClientId(account.clientId()).withGroupId(account.groupId()).withSavingsId(savingsAccountId).build();
    }

    @Transactional
    public CommandProcessingResult deleteSavingsAccountCharge(Long savingsAccountId, Long savingsAccountChargeId, JsonCommand command) {
        this.context.authenticatedUser();
        SavingsAccount savingsAccount = this.savingAccountAssembler.assembleFrom(savingsAccountId, false);
        this.checkClientOrGroupActive(savingsAccount);
        SavingsAccountCharge savingsAccountCharge = this.savingsAccountChargeRepository.findOneWithNotFoundDetection(savingsAccountChargeId, savingsAccountId);
        savingsAccount.removeCharge(savingsAccountCharge);
        this.savingAccountRepositoryWrapper.saveAndFlush(savingsAccount);
        return new CommandProcessingResultBuilder().withEntityId(savingsAccountChargeId).withOfficeId(savingsAccount.officeId()).withClientId(savingsAccount.clientId()).withGroupId(savingsAccount.groupId()).withSavingsId(savingsAccountId).build();
    }

    public CommandProcessingResult payCharge(Long savingsAccountId, Long savingsAccountChargeId, JsonCommand command) {
        this.context.authenticatedUser();
        this.savingsAccountChargeDataValidator.validatePayCharge(command.json());
        Locale locale = command.extractLocale();
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern(command.dateFormat()).withLocale(locale);
        BigDecimal amountPaid = command.bigDecimalValueOfParameterNamed("amount");
        LocalDate transactionDate = command.localDateValueOfParameterNamed("dueDate");
        SavingsAccountCharge savingsAccountCharge = this.savingsAccountChargeRepository.findOneWithNotFoundDetection(savingsAccountChargeId, savingsAccountId);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("savingsaccount");
        if (!this.configurationDomainService.allowTransactionsOnHolidayEnabled() && this.holidayRepository.isHoliday(savingsAccountCharge.savingsAccount().officeId(), transactionDate)) {
            baseDataValidator.reset().parameter("dueDate").value((Object)transactionDate.format(fmt)).failWithCodeNoParameterAddedToErrorCode("transaction.not.allowed.transaction.date.is.on.holiday", new Object[0]);
            if (!dataValidationErrors.isEmpty()) {
                throw new PlatformApiDataValidationException(dataValidationErrors);
            }
        }
        if (!this.configurationDomainService.allowTransactionsOnNonWorkingDayEnabled() && !this.workingDaysRepository.isWorkingDay(transactionDate)) {
            baseDataValidator.reset().parameter("dueDate").value((Object)transactionDate.format(fmt)).failWithCodeNoParameterAddedToErrorCode("transaction.not.allowed.transaction.date.is.a.nonworking.day", new Object[0]);
            if (!dataValidationErrors.isEmpty()) {
                throw new PlatformApiDataValidationException(dataValidationErrors);
            }
        }
        boolean backdatedTxnsAllowedTill = false;
        SavingsAccountTransaction chargeTransaction = this.payCharge(savingsAccountCharge, transactionDate, amountPaid, fmt, false);
        String noteText = command.stringValueOfParameterNamed("note");
        if (StringUtils.isNotBlank((CharSequence)noteText)) {
            Note note = Note.savingsTransactionNote((SavingsAccount)savingsAccountCharge.savingsAccount(), (SavingsAccountTransaction)chargeTransaction, (String)noteText);
            this.noteRepository.save((Object)note);
        }
        return new CommandProcessingResultBuilder().withEntityId((Long)savingsAccountCharge.getId()).withOfficeId(savingsAccountCharge.savingsAccount().officeId()).withClientId(savingsAccountCharge.savingsAccount().clientId()).withGroupId(savingsAccountCharge.savingsAccount().groupId()).withSavingsId((Long)savingsAccountCharge.savingsAccount().getId()).build();
    }

    @Transactional
    public void applyChargeDue(Long savingsAccountChargeId, Long accountId) {
        LocalDate transactionDate = DateUtils.getBusinessLocalDate();
        SavingsAccountCharge savingsAccountCharge = this.savingsAccountChargeRepository.findOneWithNotFoundDetection(savingsAccountChargeId, accountId);
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern("dd MM yyyy").withZone(DateUtils.getDateTimeZoneOfTenant());
        while (savingsAccountCharge.isNotFullyPaid() && DateUtils.isBefore((LocalDate)savingsAccountCharge.getDueDate(), (LocalDate)transactionDate)) {
            this.payCharge(savingsAccountCharge, transactionDate, savingsAccountCharge.amoutOutstanding(), fmt, false);
        }
    }

    public SavingsAccountData fallbackPostInterest(SavingsAccountData savingsAccountData, boolean postInterestAs, LocalDate transactionDate, boolean backdatedTxnsAllowedTill, Throwable t) {
        throw ErrorHandler.getMappable((Throwable)t, null, null, (String)"savings.postinterest", (Object[])new Object[0]);
    }

    @Transactional
    private SavingsAccountTransaction payCharge(SavingsAccountCharge savingsAccountCharge, LocalDate transactionDate, BigDecimal amountPaid, DateTimeFormatter formatter, boolean backdatedTxnsAllowedTill) {
        boolean isSavingsInterestPostingAtCurrentPeriodEnd = this.configurationDomainService.isSavingsInterestPostingAtCurrentPeriodEnd();
        Integer financialYearBeginningMonth = this.configurationDomainService.retrieveFinancialYearBeginningMonth();
        SavingsAccount account = savingsAccountCharge.savingsAccount();
        this.savingAccountAssembler.assignSavingAccountHelpers(account);
        HashSet existingTransactionIds = new HashSet();
        HashSet existingReversedTransactionIds = new HashSet();
        PageRequest sortedByDateAndIdDesc = PageRequest.of((int)0, (int)1, (Sort)Sort.by((String[])new String[]{"dateOf", "id"}).descending());
        List savingsAccountTransaction = this.savingsAccountTransactionRepository.findBySavingsAccountIdAndLessThanDateOfAndReversedIsFalse((Long)account.getId(), transactionDate, (Pageable)sortedByDateAndIdDesc);
        account.validateAccountBalanceDoesNotViolateOverdraft(savingsAccountTransaction, amountPaid);
        this.updateExistingTransactionsDetails(account, existingTransactionIds, existingReversedTransactionIds);
        SavingsAccountTransaction chargeTransaction = account.payCharge(savingsAccountCharge, amountPaid, transactionDate, formatter, backdatedTxnsAllowedTill, null);
        boolean isInterestTransfer = false;
        LocalDate postInterestOnDate = null;
        MathContext mc = MathContext.DECIMAL64;
        boolean postReversals = false;
        if (account.isBeforeLastPostingPeriod(transactionDate, backdatedTxnsAllowedTill)) {
            today = DateUtils.getBusinessLocalDate();
            account.postInterest(mc, today, isInterestTransfer, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth, postInterestOnDate, isInterestTransfer, postReversals);
        } else {
            today = DateUtils.getBusinessLocalDate();
            account.calculateInterestUsing(mc, today, isInterestTransfer, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth, postInterestOnDate, backdatedTxnsAllowedTill, postReversals);
        }
        List depositAccountOnHoldTransactions = null;
        if (account.getOnHoldFunds().compareTo(BigDecimal.ZERO) > 0) {
            depositAccountOnHoldTransactions = this.depositAccountOnHoldTransactionRepository.findBySavingsAccountAndReversedFalseOrderByCreatedDateAsc(account);
        }
        account.validateAccountBalanceDoesNotBecomeNegative("." + SavingsAccountTransactionType.PAY_CHARGE.getCode(), depositAccountOnHoldTransactions, backdatedTxnsAllowedTill);
        this.saveTransactionToGenerateTransactionId(chargeTransaction);
        this.savingAccountRepositoryWrapper.saveAndFlush(account);
        this.postJournalEntries(account, existingTransactionIds, existingReversedTransactionIds, backdatedTxnsAllowedTill);
        return chargeTransaction;
    }

    private void updateExistingTransactionsDetails(SavingsAccount account, Set<Long> existingTransactionIds, Set<Long> existingReversedTransactionIds) {
        existingTransactionIds.addAll(account.findExistingTransactionIds());
        existingReversedTransactionIds.addAll(account.findExistingReversedTransactionIds());
    }

    private void updateExistingTransactionsDetails(SavingsAccountData account, Set<Long> existingTransactionIds, Set<Long> existingReversedTransactionIds) {
        existingTransactionIds.addAll(account.findCurrentTransactionIdsWithPivotDateConfig());
        existingReversedTransactionIds.addAll(account.findCurrentReversedTransactionIdsWithPivotDateConfig());
    }

    private void updateSavingsTransactionsDetails(SavingsAccount account, Set<Long> existingTransactionIds, Set<Long> existingReversedTransactionIds) {
        existingTransactionIds.addAll(account.findCurrentTransactionIdsWithPivotDateConfig());
        existingReversedTransactionIds.addAll(account.findCurrentReversedTransactionIdsWithPivotDateConfig());
    }

    private void postJournalEntries(SavingsAccount savingsAccount, Set<Long> existingTransactionIds, Set<Long> existingReversedTransactionIds, boolean backdatedTxnsAllowedTill) {
        boolean isAccountTransfer = false;
        Map accountingBridgeData = savingsAccount.deriveAccountingBridgeData(savingsAccount.getCurrency().getCode(), existingTransactionIds, existingReversedTransactionIds, isAccountTransfer, backdatedTxnsAllowedTill);
        this.journalEntryWritePlatformService.createJournalEntriesForSavings(accountingBridgeData);
    }

    public CommandProcessingResult inactivateCharge(Long savingsAccountId, Long savingsAccountChargeId) {
        this.context.authenticatedUser();
        SavingsAccountCharge savingsAccountCharge = this.savingsAccountChargeRepository.findOneWithNotFoundDetection(savingsAccountChargeId, savingsAccountId);
        SavingsAccount account = savingsAccountCharge.savingsAccount();
        this.savingAccountAssembler.assignSavingAccountHelpers(account);
        LocalDate inactivationOnDate = DateUtils.getBusinessLocalDate();
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("savingsaccountcharge");
        if (!savingsAccountCharge.isRecurringFee()) {
            baseDataValidator.reset().parameter(null).value((Object)savingsAccountCharge.getId()).failWithCodeNoParameterAddedToErrorCode("charge.inactivation.allowed.only.for.recurring.charges", new Object[0]);
            if (!dataValidationErrors.isEmpty()) {
                throw new PlatformApiDataValidationException(dataValidationErrors);
            }
        } else {
            LocalDate nextDueDate = savingsAccountCharge.getNextDueDateFrom(inactivationOnDate);
            if (savingsAccountCharge.isChargeIsDue(nextDueDate)) {
                baseDataValidator.reset().failWithCodeNoParameterAddedToErrorCode("inactivation.of.charge.not.allowed.when.charge.is.due", new Object[0]);
                if (!dataValidationErrors.isEmpty()) {
                    throw new PlatformApiDataValidationException(dataValidationErrors);
                }
            } else if (savingsAccountCharge.isChargeIsOverPaid(nextDueDate)) {
                ArrayList<SavingsAccountTransaction> chargePayments = new ArrayList<SavingsAccountTransaction>();
                SavingsAccountCharge updatedCharge = savingsAccountCharge;
                do {
                    chargePayments.clear();
                    for (SavingsAccountTransaction transaction : account.getTransactions()) {
                        if (!transaction.isPayCharge() || !transaction.isNotReversed() || !transaction.isPaymentForCurrentCharge(savingsAccountCharge)) continue;
                        chargePayments.add(transaction);
                    }
                    SavingsAccountTransaction lastChargePayment = this.getLastChargePayment(chargePayments);
                    this.undoTransaction((Long)savingsAccountCharge.savingsAccount().getId(), (Long)lastChargePayment.getId(), false);
                } while ((updatedCharge = account.getUpdatedChargeDetails(savingsAccountCharge)).isChargeIsOverPaid(nextDueDate));
            }
            account.inactivateCharge(savingsAccountCharge, inactivationOnDate);
        }
        return new CommandProcessingResultBuilder().withEntityId((Long)savingsAccountCharge.getId()).withOfficeId(savingsAccountCharge.savingsAccount().officeId()).withClientId(savingsAccountCharge.savingsAccount().clientId()).withGroupId(savingsAccountCharge.savingsAccount().groupId()).withSavingsId((Long)savingsAccountCharge.savingsAccount().getId()).build();
    }

    private SavingsAccountTransaction getLastChargePayment(List<SavingsAccountTransaction> chargePayments) {
        if (!CollectionUtils.isEmpty(chargePayments)) {
            return chargePayments.get(chargePayments.size() - 1);
        }
        return null;
    }

    @Transactional
    public CommandProcessingResult assignFieldOfficer(Long savingsAccountId, JsonCommand command) {
        this.context.authenticatedUser();
        LinkedHashMap<String, Serializable> actualChanges = new LinkedHashMap<String, Serializable>(5);
        Staff fromSavingsOfficer = null;
        Staff toSavingsOfficer = null;
        this.fromApiJsonDeserializer.validateForAssignSavingsOfficer(command.json());
        SavingsAccount savingsForUpdate = this.savingAccountRepositoryWrapper.findOneWithNotFoundDetection(savingsAccountId);
        Long fromSavingsOfficerId = command.longValueOfParameterNamed("fromSavingsOfficerId");
        Long toSavingsOfficerId = command.longValueOfParameterNamed("toSavingsOfficerId");
        LocalDate dateOfSavingsOfficerAssignment = command.localDateValueOfParameterNamed("assignmentDate");
        if (fromSavingsOfficerId != null) {
            fromSavingsOfficer = this.staffRepository.findByOfficeHierarchyWithNotFoundDetection(fromSavingsOfficerId, savingsForUpdate.office().getHierarchy());
        }
        if (toSavingsOfficerId != null) {
            toSavingsOfficer = this.staffRepository.findByOfficeHierarchyWithNotFoundDetection(toSavingsOfficerId, savingsForUpdate.office().getHierarchy());
            actualChanges.put("toSavingsOfficerId", toSavingsOfficer.getId());
        }
        if (!savingsForUpdate.hasSavingsOfficer(fromSavingsOfficer)) {
            throw new SavingsOfficerAssignmentException(savingsAccountId, fromSavingsOfficerId);
        }
        savingsForUpdate.reassignSavingsOfficer(toSavingsOfficer, dateOfSavingsOfficerAssignment);
        this.savingAccountRepositoryWrapper.saveAndFlush(savingsForUpdate);
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withOfficeId(savingsForUpdate.officeId()).withEntityId((Long)savingsForUpdate.getId()).withSavingsId(savingsAccountId).with(actualChanges).build();
    }

    @Transactional
    public CommandProcessingResult unassignFieldOfficer(Long savingsAccountId, JsonCommand command) {
        this.context.authenticatedUser();
        LinkedHashMap<String, Object> actualChanges = new LinkedHashMap<String, Object>(5);
        this.fromApiJsonDeserializer.validateForUnAssignSavingsOfficer(command.json());
        SavingsAccount savingsForUpdate = this.savingAccountRepositoryWrapper.findOneWithNotFoundDetection(savingsAccountId);
        if (savingsForUpdate.getSavingsOfficer() == null) {
            throw new SavingsOfficerUnassignmentException(savingsAccountId);
        }
        LocalDate dateOfSavingsOfficerUnassigned = command.localDateValueOfParameterNamed("unassignedDate");
        savingsForUpdate.removeSavingsOfficer(dateOfSavingsOfficerUnassigned);
        this.savingAccountRepositoryWrapper.saveAndFlush(savingsForUpdate);
        actualChanges.put("toSavingsOfficerId", null);
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withOfficeId(savingsForUpdate.officeId()).withEntityId((Long)savingsForUpdate.getId()).withSavingsId(savingsAccountId).with(actualChanges).build();
    }

    public CommandProcessingResult modifyWithHoldTax(Long savingsAccountId, JsonCommand command) {
        HashMap<String, Boolean> actualChanges = new HashMap<String, Boolean>(1);
        SavingsAccount savingsForUpdate = this.savingAccountRepositoryWrapper.findOneWithNotFoundDetection(savingsAccountId);
        if (command.isChangeInBooleanParameterNamed("withHoldTax", Boolean.valueOf(savingsForUpdate.withHoldTax()))) {
            boolean newValue = command.booleanPrimitiveValueOfParameterNamed("withHoldTax");
            actualChanges.put("withHoldTax", newValue);
            savingsForUpdate.setWithHoldTax(newValue);
            if (savingsForUpdate.getTaxGroup() == null) {
                ArrayList dataValidationErrors = new ArrayList();
                DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("account");
                baseDataValidator.reset().parameter("withHoldTax").failWithCode("not.supported", new Object[0]);
                throw new PlatformApiDataValidationException(dataValidationErrors);
            }
        }
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId(savingsAccountId).withSavingsId(savingsAccountId).with(actualChanges).build();
    }

    public void setSubStatusInactive(Long savingsId) {
        SavingsAccount account = this.savingAccountAssembler.assembleFrom(savingsId, false);
        HashSet existingTransactionIds = new HashSet();
        HashSet existingReversedTransactionIds = new HashSet();
        this.updateExistingTransactionsDetails(account, existingTransactionIds, existingReversedTransactionIds);
        account.setSubStatusInactive(false);
        this.savingAccountRepositoryWrapper.saveAndFlush(account);
        this.postJournalEntries(account, existingTransactionIds, existingReversedTransactionIds, false);
    }

    public void setSubStatusDormant(Long savingsId) {
        SavingsAccount account = this.savingAccountAssembler.assembleFrom(savingsId, false);
        account.setSubStatusDormant();
        this.savingAccountRepositoryWrapper.saveAndFlush(account);
    }

    public void escheat(Long savingsId) {
        SavingsAccount account = this.savingAccountAssembler.assembleFrom(savingsId, false);
        HashSet existingTransactionIds = new HashSet();
        HashSet existingReversedTransactionIds = new HashSet();
        this.updateExistingTransactionsDetails(account, existingTransactionIds, existingReversedTransactionIds);
        account.escheat(this.appuserRepository.fetchSystemUser());
        this.savingAccountRepositoryWrapper.saveAndFlush(account);
        this.postJournalEntries(account, existingTransactionIds, existingReversedTransactionIds, false);
    }

    private AppUser getAppUserIfPresent() {
        AppUser user = null;
        if (this.context != null) {
            user = this.context.getAuthenticatedUserIfPresent();
        }
        return user;
    }

    @Transactional
    private void disableStandingInstructionsLinkedToClosedSavings(SavingsAccount savingsAccount) {
        Integer standingInstructionStatus;
        Collection accountTransferStandingInstructions;
        if (savingsAccount != null && savingsAccount.isClosed() && !(accountTransferStandingInstructions = this.standingInstructionRepository.findBySavingsAccountAndStatus(savingsAccount, standingInstructionStatus = StandingInstructionStatus.ACTIVE.getValue())).isEmpty()) {
            for (AccountTransferStandingInstruction accountTransferStandingInstruction : accountTransferStandingInstructions) {
                accountTransferStandingInstruction.updateStatus(StandingInstructionStatus.DISABLED.getValue());
                this.standingInstructionRepository.save((Object)accountTransferStandingInstruction);
            }
        }
    }

    public CommandProcessingResult blockAccount(Long savingsId, JsonCommand command) {
        this.context.authenticatedUser();
        SavingsAccount account = this.savingAccountAssembler.assembleFrom(savingsId, false);
        this.checkClientOrGroupActive(account);
        Map changes = account.block();
        String reasonForBlock = command.stringValueOfParameterNamed("reasonForBlock");
        this.validateReasonForHold(reasonForBlock);
        account.updateReason(reasonForBlock);
        if (!changes.isEmpty()) {
            this.savingAccountRepositoryWrapper.save(account);
        }
        return new CommandProcessingResultBuilder().withEntityId(savingsId).withOfficeId(account.officeId()).withClientId(account.clientId()).withGroupId(account.groupId()).withSavingsId(savingsId).with(changes).build();
    }

    public CommandProcessingResult unblockAccount(Long savingsId) {
        this.context.authenticatedUser();
        SavingsAccount account = this.savingAccountAssembler.assembleFrom(savingsId, false);
        this.checkClientOrGroupActive(account);
        Map changes = account.unblock();
        account.updateReason(null);
        if (!changes.isEmpty()) {
            this.savingAccountRepositoryWrapper.save(account);
        }
        return new CommandProcessingResultBuilder().withEntityId(savingsId).withOfficeId(account.officeId()).withClientId(account.clientId()).withGroupId(account.groupId()).withSavingsId(savingsId).with(changes).build();
    }

    @Transactional
    public CommandProcessingResult holdAmount(Long savingsId, JsonCommand command) {
        AppUser submittedBy = this.context.authenticatedUser();
        boolean backdatedTxnsAllowedTill = this.savingAccountAssembler.getPivotConfigStatus();
        SavingsAccount account = this.savingAccountAssembler.assembleFrom(savingsId, backdatedTxnsAllowedTill);
        LocalDate transactionDate = command.localDateValueOfParameterNamed("transactionDate");
        boolean lienAllowed = command.booleanPrimitiveValueOfParameterNamed("lienAllowed");
        this.checkClientOrGroupActive(account);
        BigDecimal amount = command.bigDecimalValueOfParameterNamed("transactionAmount");
        Money runningBalance = Money.of((MonetaryCurrency)account.getCurrency(), (BigDecimal)account.getAccountBalance());
        runningBalance = account.getSavingsHoldAmount() != null ? runningBalance.minus(account.getSavingsHoldAmount()).minus(amount) : runningBalance.minus(amount);
        this.savingsAccountTransactionDataValidator.validateHoldAndAssembleForm(command.json(), account, submittedBy, backdatedTxnsAllowedTill);
        SavingsAccountTransaction transaction = this.savingsAccountDomainService.handleHold(account, amount, transactionDate, Boolean.valueOf(lienAllowed));
        account.holdAmount(amount);
        transaction.setRunningBalance(runningBalance);
        String reasonForBlock = command.stringValueOfParameterNamed("reasonForBlock");
        transaction.updateReason(reasonForBlock);
        account.getAccountBalance();
        this.savingsAccountTransactionDataValidator.validateTransactionWithPivotDate(transaction.getTransactionDate(), account);
        this.savingsAccountTransactionRepository.saveAndFlush((Object)transaction);
        if (backdatedTxnsAllowedTill) {
            this.savingsAccountTransactionRepository.saveAll((Iterable)account.getSavingsAccountTransactionsWithPivotConfig());
        }
        this.savingAccountRepositoryWrapper.saveAndFlush(account);
        return new CommandProcessingResultBuilder().withEntityId((Long)transaction.getId()).withOfficeId(account.officeId()).withClientId(account.clientId()).withGroupId(account.groupId()).withSavingsId(savingsId).build();
    }

    @Transactional
    public CommandProcessingResult releaseAmount(Long savingsId, Long savingsTransactionId) {
        this.context.authenticatedUser();
        SavingsAccountTransaction holdTransaction = this.savingsAccountTransactionRepository.findOneByIdAndSavingsAccountId(savingsTransactionId, savingsId);
        holdTransaction.updateReason(null);
        SavingsAccountTransaction transaction = this.savingsAccountTransactionDataValidator.validateReleaseAmountAndAssembleForm(holdTransaction);
        boolean backdatedTxnsAllowedTill = this.savingAccountAssembler.getPivotConfigStatus();
        SavingsAccount account = this.savingAccountAssembler.assembleFrom(savingsId, backdatedTxnsAllowedTill);
        this.checkClientOrGroupActive(account);
        Money runningBalance = Money.of((MonetaryCurrency)account.getCurrency(), (BigDecimal)account.getAccountBalance());
        Money savingsOnHold = Money.of((MonetaryCurrency)account.getCurrency(), (BigDecimal)account.getSavingsHoldAmount());
        runningBalance = runningBalance.minus(savingsOnHold);
        runningBalance = runningBalance.plus(transaction.getAmount());
        transaction.setRunningBalance(runningBalance);
        this.savingsAccountTransactionDataValidator.validateTransactionWithPivotDate(transaction.getTransactionDate(), account);
        account.releaseOnHoldAmount(transaction.getAmount());
        this.savingsAccountTransactionRepository.saveAndFlush((Object)transaction);
        holdTransaction.updateReleaseId((Long)transaction.getId());
        if (backdatedTxnsAllowedTill) {
            this.savingsAccountTransactionRepository.saveAll((Iterable)account.getSavingsAccountTransactionsWithPivotConfig());
        } else {
            account.addTransaction(transaction);
        }
        this.savingAccountRepositoryWrapper.save(account);
        return new CommandProcessingResultBuilder().withEntityId((Long)transaction.getId()).withOfficeId(account.officeId()).withClientId(account.clientId()).withGroupId(account.groupId()).withSavingsId((Long)account.getId()).build();
    }

    @Transactional
    public CommandProcessingResult blockCredits(Long savingsId, JsonCommand command) {
        this.context.authenticatedUser();
        SavingsAccount account = this.savingAccountAssembler.assembleFrom(savingsId, false);
        this.checkClientOrGroupActive(account);
        String reasonForBlock = command.stringValueOfParameterNamed("reasonForBlock");
        this.validateReasonForHold(reasonForBlock);
        account.updateReason(reasonForBlock);
        Map changes = account.blockCredits(account.getSubStatus());
        if (!changes.isEmpty()) {
            this.savingAccountRepositoryWrapper.save(account);
        }
        return new CommandProcessingResultBuilder().withEntityId(savingsId).withOfficeId(account.officeId()).withClientId(account.clientId()).withGroupId(account.groupId()).withSavingsId(savingsId).with(changes).build();
    }

    @Transactional
    public CommandProcessingResult unblockCredits(Long savingsId) {
        this.context.authenticatedUser();
        SavingsAccount account = this.savingAccountAssembler.assembleFrom(savingsId, false);
        this.checkClientOrGroupActive(account);
        account.updateReason(null);
        Map changes = account.unblockCredits();
        if (!changes.isEmpty()) {
            this.savingAccountRepositoryWrapper.save(account);
        }
        return new CommandProcessingResultBuilder().withEntityId(savingsId).withOfficeId(account.officeId()).withClientId(account.clientId()).withGroupId(account.groupId()).withSavingsId(savingsId).with(changes).build();
    }

    @Transactional
    public CommandProcessingResult blockDebits(Long savingsId, JsonCommand command) {
        this.context.authenticatedUser();
        SavingsAccount account = this.savingAccountAssembler.assembleFrom(savingsId, false);
        this.checkClientOrGroupActive(account);
        String reasonForBlock = command.stringValueOfParameterNamed("reasonForBlock");
        this.validateReasonForHold(reasonForBlock);
        account.updateReason(reasonForBlock);
        Map changes = account.blockDebits(account.getSubStatus());
        if (!changes.isEmpty()) {
            this.savingAccountRepositoryWrapper.save(account);
        }
        return new CommandProcessingResultBuilder().withEntityId(savingsId).withOfficeId(account.officeId()).withClientId(account.clientId()).withGroupId(account.groupId()).withSavingsId(savingsId).with(changes).build();
    }

    @Transactional
    public CommandProcessingResult unblockDebits(Long savingsId) {
        this.context.authenticatedUser();
        SavingsAccount account = this.savingAccountAssembler.assembleFrom(savingsId, false);
        this.checkClientOrGroupActive(account);
        account.updateReason(null);
        Map changes = account.unblockDebits();
        if (!changes.isEmpty()) {
            this.savingAccountRepositoryWrapper.save(account);
        }
        return new CommandProcessingResultBuilder().withEntityId(savingsId).withOfficeId(account.officeId()).withClientId(account.clientId()).withGroupId(account.groupId()).withSavingsId(savingsId).with(changes).build();
    }

    private void validateTransactionsForTransfer(SavingsAccount savingsAccount, LocalDate transferDate) {
        for (SavingsAccountTransaction transaction : savingsAccount.getTransactions()) {
            if ((!DateUtils.isEqual((LocalDate)transferDate, (LocalDate)transaction.getTransactionDate()) || !DateUtils.isEqual((LocalDate)transferDate, (LocalDate)transaction.getSubmittedOnDate())) && !DateUtils.isBefore((LocalDate)transferDate, (LocalDate)transaction.getTransactionDate())) continue;
            throw new GeneralPlatformDomainRuleException("error.msg.cannot.transfer.client.as.savings.transaction.present.on.or.after.transfer.date", "error.msg.cannot.transfer.client.as.savings.transaction.present.on.or.after.transfer.date", new Object[]{transaction.getTransactionDate(), transferDate});
        }
    }

    private void validateReasonForHold(String reasonForBlock) {
        if (StringUtils.isBlank((CharSequence)reasonForBlock)) {
            throw new PlatformDataIntegrityException("Reason For Block is Mandatory", "error.msg.reason.for.block.mandatory", new Object[0]);
        }
    }

    @Generated
    public SavingsAccountWritePlatformServiceJpaRepositoryImpl(PlatformSecurityContext context, SavingsAccountDataValidator fromApiJsonDeserializer, SavingsAccountRepositoryWrapper savingAccountRepositoryWrapper, StaffRepositoryWrapper staffRepository, SavingsAccountTransactionRepository savingsAccountTransactionRepository, SavingsAccountAssembler savingAccountAssembler, SavingsAccountTransactionDataValidator savingsAccountTransactionDataValidator, SavingsAccountChargeDataValidator savingsAccountChargeDataValidator, PaymentDetailWritePlatformService paymentDetailWritePlatformService, JournalEntryWritePlatformService journalEntryWritePlatformService, SavingsAccountDomainService savingsAccountDomainService, NoteRepository noteRepository, AccountTransfersReadPlatformService accountTransfersReadPlatformService, AccountAssociationsReadPlatformService accountAssociationsReadPlatformService, ChargeRepositoryWrapper chargeRepository, SavingsAccountChargeRepositoryWrapper savingsAccountChargeRepository, HolidayRepositoryWrapper holidayRepository, WorkingDaysRepositoryWrapper workingDaysRepository, ConfigurationDomainService configurationDomainService, DepositAccountOnHoldTransactionRepository depositAccountOnHoldTransactionRepository, EntityDatatableChecksWritePlatformService entityDatatableChecksWritePlatformService, AppUserRepositoryWrapper appuserRepository, StandingInstructionRepository standingInstructionRepository, BusinessEventNotifierService businessEventNotifierService, GSIMRepositoy gsimRepository, SavingsAccountInterestPostingService savingsAccountInterestPostingService, ErrorHandler errorHandler) {
        this.context = context;
        this.fromApiJsonDeserializer = fromApiJsonDeserializer;
        this.savingAccountRepositoryWrapper = savingAccountRepositoryWrapper;
        this.staffRepository = staffRepository;
        this.savingsAccountTransactionRepository = savingsAccountTransactionRepository;
        this.savingAccountAssembler = savingAccountAssembler;
        this.savingsAccountTransactionDataValidator = savingsAccountTransactionDataValidator;
        this.savingsAccountChargeDataValidator = savingsAccountChargeDataValidator;
        this.paymentDetailWritePlatformService = paymentDetailWritePlatformService;
        this.journalEntryWritePlatformService = journalEntryWritePlatformService;
        this.savingsAccountDomainService = savingsAccountDomainService;
        this.noteRepository = noteRepository;
        this.accountTransfersReadPlatformService = accountTransfersReadPlatformService;
        this.accountAssociationsReadPlatformService = accountAssociationsReadPlatformService;
        this.chargeRepository = chargeRepository;
        this.savingsAccountChargeRepository = savingsAccountChargeRepository;
        this.holidayRepository = holidayRepository;
        this.workingDaysRepository = workingDaysRepository;
        this.configurationDomainService = configurationDomainService;
        this.depositAccountOnHoldTransactionRepository = depositAccountOnHoldTransactionRepository;
        this.entityDatatableChecksWritePlatformService = entityDatatableChecksWritePlatformService;
        this.appuserRepository = appuserRepository;
        this.standingInstructionRepository = standingInstructionRepository;
        this.businessEventNotifierService = businessEventNotifierService;
        this.gsimRepository = gsimRepository;
        this.savingsAccountInterestPostingService = savingsAccountInterestPostingService;
        this.errorHandler = errorHandler;
    }
}

