/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.self.security.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import lombok.Generated;
import org.apache.fineract.infrastructure.security.api.UserDetailsApiResource;
import org.apache.fineract.portfolio.self.config.SelfServiceModuleIsEnabledCondition;
import org.apache.fineract.portfolio.self.security.api.SelfUserDetailsApiResourceSwagger;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Path(value="/v1/self/userdetails")
@Component
@ConditionalOnProperty(value={"fineract.security.oauth2.enabled"})
@Tag(name="Self User Details", description="")
@Conditional(value={SelfServiceModuleIsEnabledCondition.class})
public class SelfUserDetailsApiResource {
    private final UserDetailsApiResource userDetailsApiResource;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Fetch authenticated user details", description="Checks the Authentication and returns the set roles and permissions allowed\n\nFor more info visit this link - https://fineract.apache.org/docs/legacy/#selfoauth")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SelfUserDetailsApiResourceSwagger.GetSelfUserDetailsResponse.class))})})
    public String fetchAuthenticatedUserData() {
        return this.userDetailsApiResource.fetchAuthenticatedUserData();
    }

    @Generated
    public SelfUserDetailsApiResource(UserDetailsApiResource userDetailsApiResource) {
        this.userDetailsApiResource = userDetailsApiResource;
    }
}

