/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.shareaccounts.jobs.postdividentsforshares;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.jobs.exception.JobExecutionException;
import org.apache.fineract.portfolio.shareaccounts.service.ShareAccountDividendReadPlatformService;
import org.apache.fineract.portfolio.shareaccounts.service.ShareAccountSchedularService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;

public class PostDividentsForSharesTasklet
implements Tasklet {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PostDividentsForSharesTasklet.class);
    private final ShareAccountDividendReadPlatformService shareAccountDividendReadPlatformService;
    private final ShareAccountSchedularService shareAccountSchedularService;

    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        List dividendDetails = this.shareAccountDividendReadPlatformService.retriveDividendDetailsForPostDividents();
        for (Map dividendMap : dividendDetails) {
            Long savingsId;
            Long id;
            if (dividendMap.get("id") instanceof BigInteger) {
                id = ((BigInteger)dividendMap.get("id")).longValue();
                savingsId = ((BigInteger)dividendMap.get("savingsAccountId")).longValue();
            } else {
                id = (Long)dividendMap.get("id");
                savingsId = (Long)dividendMap.get("savingsAccountId");
            }
            try {
                this.shareAccountSchedularService.postDividend(id, savingsId);
            }
            catch (PlatformApiDataValidationException e) {
                exceptions.add(e);
                List errors = e.getErrors();
                for (ApiParameterError error : errors) {
                    log.error("Post Dividends to savings failed due to ApiParameterError for Divident detail Id: {} and savings Id: {} with message: {}", new Object[]{id, savingsId, error.getDeveloperMessage(), e});
                }
            }
            catch (Exception e) {
                log.error("Post Dividends to savings failed for Divident detail Id: {} and savings Id: {}", new Object[]{id, savingsId, e});
                exceptions.add(e);
            }
        }
        if (!exceptions.isEmpty()) {
            throw new JobExecutionException(exceptions);
        }
        return RepeatStatus.FINISHED;
    }

    @Generated
    public PostDividentsForSharesTasklet(ShareAccountDividendReadPlatformService shareAccountDividendReadPlatformService, ShareAccountSchedularService shareAccountSchedularService) {
        this.shareAccountDividendReadPlatformService = shareAccountDividendReadPlatformService;
        this.shareAccountSchedularService = shareAccountSchedularService;
    }
}

