/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.useradministration.service;

import java.util.Collection;
import org.apache.fineract.useradministration.data.RoleData;
import org.apache.fineract.useradministration.exception.RoleNotFoundException;
import org.apache.fineract.useradministration.service.RoleReadPlatformService;
import org.apache.fineract.useradministration.service.RoleReadPlatformServiceImpl;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class RoleReadPlatformServiceImpl
implements RoleReadPlatformService {
    private final JdbcTemplate jdbcTemplate;
    private final RoleMapper roleRowMapper;

    public RoleReadPlatformServiceImpl(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
        this.roleRowMapper = new RoleMapper();
    }

    public Collection<RoleData> retrieveAll() {
        String sql = "select " + this.roleRowMapper.schema() + " order by r.id";
        return this.jdbcTemplate.query(sql, (RowMapper)this.roleRowMapper);
    }

    public Collection<RoleData> retrieveAllActiveRoles() {
        String sql = "select " + this.roleRowMapper.schema() + " where r.is_disabled = false order by r.id";
        return this.jdbcTemplate.query(sql, (RowMapper)this.roleRowMapper);
    }

    public Collection<RoleData> retrieveAllSelfServiceRoles() {
        String role = "Self Service User";
        String sql = "select " + this.roleRowMapper.schema() + " where r.name = ? order by r.id";
        return this.jdbcTemplate.query(sql, (RowMapper)this.roleRowMapper, new Object[]{"Self Service User"});
    }

    public RoleData retrieveOne(Long id) {
        try {
            String sql = "select " + this.roleRowMapper.schema() + " where r.id=?";
            return (RoleData)this.jdbcTemplate.queryForObject(sql, (RowMapper)this.roleRowMapper, new Object[]{id});
        }
        catch (EmptyResultDataAccessException e) {
            throw new RoleNotFoundException(id, e);
        }
    }

    public Collection<RoleData> retrieveAppUserRoles(Long appUserId) {
        String sql = "select " + this.roleRowMapper.schema() + " inner join m_appuser_role ar on ar.role_id = r.id where ar.appuser_id= ?";
        return this.jdbcTemplate.query(sql, (RowMapper)this.roleRowMapper, new Object[]{appUserId});
    }
}

