/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.client.models;

import com.google.gson.annotations.SerializedName;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.fineract.client.models.EnumOptionData;
import org.apache.fineract.client.models.GuarantorTransactionData;
import org.apache.fineract.client.models.PortfolioAccountData;

public class GuarantorFundingData {
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private BigDecimal amount;
    public static final String SERIALIZED_NAME_AMOUNT_RELEASED = "amountReleased";
    @SerializedName(value="amountReleased")
    private BigDecimal amountReleased;
    public static final String SERIALIZED_NAME_AMOUNT_REMAINING = "amountRemaining";
    @SerializedName(value="amountRemaining")
    private BigDecimal amountRemaining;
    public static final String SERIALIZED_NAME_AMOUNT_TRANSFERED = "amountTransfered";
    @SerializedName(value="amountTransfered")
    private BigDecimal amountTransfered;
    public static final String SERIALIZED_NAME_GUARANTOR_TRANSACTIONS = "guarantorTransactions";
    @SerializedName(value="guarantorTransactions")
    private List<GuarantorTransactionData> guarantorTransactions;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private Long id;
    public static final String SERIALIZED_NAME_SAVINGS_ACCOUNT = "savingsAccount";
    @SerializedName(value="savingsAccount")
    private PortfolioAccountData savingsAccount;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private EnumOptionData status;

    public GuarantorFundingData amount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    @Nullable
    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public GuarantorFundingData amountReleased(BigDecimal amountReleased) {
        this.amountReleased = amountReleased;
        return this;
    }

    @Nullable
    public BigDecimal getAmountReleased() {
        return this.amountReleased;
    }

    public void setAmountReleased(BigDecimal amountReleased) {
        this.amountReleased = amountReleased;
    }

    public GuarantorFundingData amountRemaining(BigDecimal amountRemaining) {
        this.amountRemaining = amountRemaining;
        return this;
    }

    @Nullable
    public BigDecimal getAmountRemaining() {
        return this.amountRemaining;
    }

    public void setAmountRemaining(BigDecimal amountRemaining) {
        this.amountRemaining = amountRemaining;
    }

    public GuarantorFundingData amountTransfered(BigDecimal amountTransfered) {
        this.amountTransfered = amountTransfered;
        return this;
    }

    @Nullable
    public BigDecimal getAmountTransfered() {
        return this.amountTransfered;
    }

    public void setAmountTransfered(BigDecimal amountTransfered) {
        this.amountTransfered = amountTransfered;
    }

    public GuarantorFundingData guarantorTransactions(List<GuarantorTransactionData> guarantorTransactions) {
        this.guarantorTransactions = guarantorTransactions;
        return this;
    }

    public GuarantorFundingData addGuarantorTransactionsItem(GuarantorTransactionData guarantorTransactionsItem) {
        if (this.guarantorTransactions == null) {
            this.guarantorTransactions = new ArrayList<GuarantorTransactionData>();
        }
        this.guarantorTransactions.add(guarantorTransactionsItem);
        return this;
    }

    @Nullable
    public List<GuarantorTransactionData> getGuarantorTransactions() {
        return this.guarantorTransactions;
    }

    public void setGuarantorTransactions(List<GuarantorTransactionData> guarantorTransactions) {
        this.guarantorTransactions = guarantorTransactions;
    }

    public GuarantorFundingData id(Long id) {
        this.id = id;
        return this;
    }

    @Nullable
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public GuarantorFundingData savingsAccount(PortfolioAccountData savingsAccount) {
        this.savingsAccount = savingsAccount;
        return this;
    }

    @Nullable
    public PortfolioAccountData getSavingsAccount() {
        return this.savingsAccount;
    }

    public void setSavingsAccount(PortfolioAccountData savingsAccount) {
        this.savingsAccount = savingsAccount;
    }

    public GuarantorFundingData status(EnumOptionData status) {
        this.status = status;
        return this;
    }

    @Nullable
    public EnumOptionData getStatus() {
        return this.status;
    }

    public void setStatus(EnumOptionData status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GuarantorFundingData guarantorFundingData = (GuarantorFundingData)o;
        return Objects.equals(this.amount, guarantorFundingData.amount) && Objects.equals(this.amountReleased, guarantorFundingData.amountReleased) && Objects.equals(this.amountRemaining, guarantorFundingData.amountRemaining) && Objects.equals(this.amountTransfered, guarantorFundingData.amountTransfered) && Objects.equals(this.guarantorTransactions, guarantorFundingData.guarantorTransactions) && Objects.equals(this.id, guarantorFundingData.id) && Objects.equals(this.savingsAccount, guarantorFundingData.savingsAccount) && Objects.equals(this.status, guarantorFundingData.status);
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.amountReleased, this.amountRemaining, this.amountTransfered, this.guarantorTransactions, this.id, this.savingsAccount, this.status);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GuarantorFundingData {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    amountReleased: ").append(this.toIndentedString(this.amountReleased)).append("\n");
        sb.append("    amountRemaining: ").append(this.toIndentedString(this.amountRemaining)).append("\n");
        sb.append("    amountTransfered: ").append(this.toIndentedString(this.amountTransfered)).append("\n");
        sb.append("    guarantorTransactions: ").append(this.toIndentedString(this.guarantorTransactions)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    savingsAccount: ").append(this.toIndentedString(this.savingsAccount)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

