/*
 * Apache Fineract REST API
 * Apache Fineract is a secure, multi-tenanted microfinance platform. The goal of the Apache Fineract API is to empower developers to build apps on top of the Apache Fineract Platform. The [reference app](https://cui.fineract.dev) (username: mifos, password: password) works on the same demo tenant as the interactive links in this documentation. Until we complete the new REST API documentation you still have the legacy documentation available [here](https://fineract.apache.org/docs/legacy/). Please check [the current Fineract documentation](https://fineract.apache.org/docs/current/) for more information.
 *
 * The version of the OpenAPI document: 1.13.0
 * Contact: dev@fineract.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.fineract.client.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.fineract.client.models.GetLoanProductsAccountingRule;
import org.apache.fineract.client.models.GetLoanProductsAmortizationType;
import org.apache.fineract.client.models.GetLoanProductsCurrency;
import org.apache.fineract.client.models.GetLoanProductsDaysInMonthType;
import org.apache.fineract.client.models.GetLoanProductsDaysInYearCustomStrategy;
import org.apache.fineract.client.models.GetLoanProductsDaysInYearType;
import org.apache.fineract.client.models.GetLoanProductsInterestRateFrequencyType;
import org.apache.fineract.client.models.GetLoanProductsInterestRecalculationData;
import org.apache.fineract.client.models.GetLoanProductsInterestType;
import org.apache.fineract.client.models.GetLoanProductsRepaymentFrequencyType;
import org.apache.fineract.client.models.GetLoanProductsRepaymentStartDateType;
import org.apache.fineract.client.models.GetLoansProductsInterestCalculationPeriodType;
import org.apache.fineract.client.models.StringEnumOptionData;

/**
 * GetLoanProductsResponse
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
public class GetLoanProductsResponse {
  public static final String SERIALIZED_NAME_ACCOUNTING_RULE = "accountingRule";
  @SerializedName(SERIALIZED_NAME_ACCOUNTING_RULE)
  private GetLoanProductsAccountingRule accountingRule;

  public static final String SERIALIZED_NAME_AMORTIZATION_TYPE = "amortizationType";
  @SerializedName(SERIALIZED_NAME_AMORTIZATION_TYPE)
  private GetLoanProductsAmortizationType amortizationType;

  public static final String SERIALIZED_NAME_ANNUAL_INTEREST_RATE = "annualInterestRate";
  @SerializedName(SERIALIZED_NAME_ANNUAL_INTEREST_RATE)
  private Double annualInterestRate;

  public static final String SERIALIZED_NAME_BUY_DOWN_FEE_CALCULATION_TYPE = "buyDownFeeCalculationType";
  @SerializedName(SERIALIZED_NAME_BUY_DOWN_FEE_CALCULATION_TYPE)
  private StringEnumOptionData buyDownFeeCalculationType;

  public static final String SERIALIZED_NAME_BUY_DOWN_FEE_INCOME_TYPE = "buyDownFeeIncomeType";
  @SerializedName(SERIALIZED_NAME_BUY_DOWN_FEE_INCOME_TYPE)
  private StringEnumOptionData buyDownFeeIncomeType;

  public static final String SERIALIZED_NAME_BUY_DOWN_FEE_STRATEGY = "buyDownFeeStrategy";
  @SerializedName(SERIALIZED_NAME_BUY_DOWN_FEE_STRATEGY)
  private StringEnumOptionData buyDownFeeStrategy;

  public static final String SERIALIZED_NAME_CAPITALIZED_INCOME_CALCULATION_TYPE = "capitalizedIncomeCalculationType";
  @SerializedName(SERIALIZED_NAME_CAPITALIZED_INCOME_CALCULATION_TYPE)
  private StringEnumOptionData capitalizedIncomeCalculationType;

  public static final String SERIALIZED_NAME_CAPITALIZED_INCOME_STRATEGY = "capitalizedIncomeStrategy";
  @SerializedName(SERIALIZED_NAME_CAPITALIZED_INCOME_STRATEGY)
  private StringEnumOptionData capitalizedIncomeStrategy;

  public static final String SERIALIZED_NAME_CAPITALIZED_INCOME_TYPE = "capitalizedIncomeType";
  @SerializedName(SERIALIZED_NAME_CAPITALIZED_INCOME_TYPE)
  private StringEnumOptionData capitalizedIncomeType;

  public static final String SERIALIZED_NAME_CHARGE_OFF_BEHAVIOUR = "chargeOffBehaviour";
  @SerializedName(SERIALIZED_NAME_CHARGE_OFF_BEHAVIOUR)
  private StringEnumOptionData chargeOffBehaviour;

  public static final String SERIALIZED_NAME_CURRENCY = "currency";
  @SerializedName(SERIALIZED_NAME_CURRENCY)
  private GetLoanProductsCurrency currency;

  public static final String SERIALIZED_NAME_DAYS_IN_MONTH_TYPE = "daysInMonthType";
  @SerializedName(SERIALIZED_NAME_DAYS_IN_MONTH_TYPE)
  private GetLoanProductsDaysInMonthType daysInMonthType;

  public static final String SERIALIZED_NAME_DAYS_IN_YEAR_CUSTOM_STRATEGY = "daysInYearCustomStrategy";
  @SerializedName(SERIALIZED_NAME_DAYS_IN_YEAR_CUSTOM_STRATEGY)
  private GetLoanProductsDaysInYearCustomStrategy daysInYearCustomStrategy;

  public static final String SERIALIZED_NAME_DAYS_IN_YEAR_TYPE = "daysInYearType";
  @SerializedName(SERIALIZED_NAME_DAYS_IN_YEAR_TYPE)
  private GetLoanProductsDaysInYearType daysInYearType;

  public static final String SERIALIZED_NAME_ENABLE_BUY_DOWN_FEE = "enableBuyDownFee";
  @SerializedName(SERIALIZED_NAME_ENABLE_BUY_DOWN_FEE)
  private Boolean enableBuyDownFee;

  public static final String SERIALIZED_NAME_ENABLE_INCOME_CAPITALIZATION = "enableIncomeCapitalization";
  @SerializedName(SERIALIZED_NAME_ENABLE_INCOME_CAPITALIZATION)
  private Boolean enableIncomeCapitalization;

  public static final String SERIALIZED_NAME_END_DATE = "endDate";
  @SerializedName(SERIALIZED_NAME_END_DATE)
  private LocalDate endDate;

  public static final String SERIALIZED_NAME_FIXED_LENGTH = "fixedLength";
  @SerializedName(SERIALIZED_NAME_FIXED_LENGTH)
  private Integer fixedLength;

  public static final String SERIALIZED_NAME_FIXED_PRINCIPAL_PERCENTAGE_PER_INSTALLMENT = "fixedPrincipalPercentagePerInstallment";
  @SerializedName(SERIALIZED_NAME_FIXED_PRINCIPAL_PERCENTAGE_PER_INSTALLMENT)
  private BigDecimal fixedPrincipalPercentagePerInstallment;

  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private Long id;

  public static final String SERIALIZED_NAME_INCLUDE_IN_BORROWER_CYCLE = "includeInBorrowerCycle";
  @SerializedName(SERIALIZED_NAME_INCLUDE_IN_BORROWER_CYCLE)
  private Boolean includeInBorrowerCycle;

  public static final String SERIALIZED_NAME_INTEREST_CALCULATION_PERIOD_TYPE = "interestCalculationPeriodType";
  @SerializedName(SERIALIZED_NAME_INTEREST_CALCULATION_PERIOD_TYPE)
  private GetLoansProductsInterestCalculationPeriodType interestCalculationPeriodType;

  public static final String SERIALIZED_NAME_INTEREST_RATE_FREQUENCY_TYPE = "interestRateFrequencyType";
  @SerializedName(SERIALIZED_NAME_INTEREST_RATE_FREQUENCY_TYPE)
  private GetLoanProductsInterestRateFrequencyType interestRateFrequencyType;

  public static final String SERIALIZED_NAME_INTEREST_RATE_PER_PERIOD = "interestRatePerPeriod";
  @SerializedName(SERIALIZED_NAME_INTEREST_RATE_PER_PERIOD)
  private Double interestRatePerPeriod;

  public static final String SERIALIZED_NAME_INTEREST_RATE_VARIATIONS_FOR_BORROWER_CYCLE = "interestRateVariationsForBorrowerCycle";
  @SerializedName(SERIALIZED_NAME_INTEREST_RATE_VARIATIONS_FOR_BORROWER_CYCLE)
  private List<Integer> interestRateVariationsForBorrowerCycle;

  public static final String SERIALIZED_NAME_INTEREST_RECALCULATION_DATA = "interestRecalculationData";
  @SerializedName(SERIALIZED_NAME_INTEREST_RECALCULATION_DATA)
  private GetLoanProductsInterestRecalculationData interestRecalculationData;

  public static final String SERIALIZED_NAME_INTEREST_RECOGNITION_ON_DISBURSEMENT_DATE = "interestRecognitionOnDisbursementDate";
  @SerializedName(SERIALIZED_NAME_INTEREST_RECOGNITION_ON_DISBURSEMENT_DATE)
  private Boolean interestRecognitionOnDisbursementDate;

  public static final String SERIALIZED_NAME_INTEREST_TYPE = "interestType";
  @SerializedName(SERIALIZED_NAME_INTEREST_TYPE)
  private GetLoanProductsInterestType interestType;

  public static final String SERIALIZED_NAME_IS_INTEREST_RECALCULATION_ENABLED = "isInterestRecalculationEnabled";
  @SerializedName(SERIALIZED_NAME_IS_INTEREST_RECALCULATION_ENABLED)
  private Boolean isInterestRecalculationEnabled;

  public static final String SERIALIZED_NAME_MAX_NUMBER_OF_REPAYMENTS = "maxNumberOfRepayments";
  @SerializedName(SERIALIZED_NAME_MAX_NUMBER_OF_REPAYMENTS)
  private Integer maxNumberOfRepayments;

  public static final String SERIALIZED_NAME_MAX_PRINCIPAL = "maxPrincipal";
  @SerializedName(SERIALIZED_NAME_MAX_PRINCIPAL)
  private Double maxPrincipal;

  public static final String SERIALIZED_NAME_MERCHANT_BUY_DOWN_FEE = "merchantBuyDownFee";
  @SerializedName(SERIALIZED_NAME_MERCHANT_BUY_DOWN_FEE)
  private Boolean merchantBuyDownFee;

  public static final String SERIALIZED_NAME_MIN_NUMBER_OF_REPAYMENTS = "minNumberOfRepayments";
  @SerializedName(SERIALIZED_NAME_MIN_NUMBER_OF_REPAYMENTS)
  private Integer minNumberOfRepayments;

  public static final String SERIALIZED_NAME_MIN_PRINCIPAL = "minPrincipal";
  @SerializedName(SERIALIZED_NAME_MIN_PRINCIPAL)
  private Double minPrincipal;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_NUMBER_OF_REPAYMENT_VARIATIONS_FOR_BORROWER_CYCLE = "numberOfRepaymentVariationsForBorrowerCycle";
  @SerializedName(SERIALIZED_NAME_NUMBER_OF_REPAYMENT_VARIATIONS_FOR_BORROWER_CYCLE)
  private List<Integer> numberOfRepaymentVariationsForBorrowerCycle;

  public static final String SERIALIZED_NAME_NUMBER_OF_REPAYMENTS = "numberOfRepayments";
  @SerializedName(SERIALIZED_NAME_NUMBER_OF_REPAYMENTS)
  private Integer numberOfRepayments;

  public static final String SERIALIZED_NAME_PRINCIPAL = "principal";
  @SerializedName(SERIALIZED_NAME_PRINCIPAL)
  private Double principal;

  public static final String SERIALIZED_NAME_PRINCIPAL_THRESHOLD_FOR_LAST_INSTALMENT = "principalThresholdForLastInstalment";
  @SerializedName(SERIALIZED_NAME_PRINCIPAL_THRESHOLD_FOR_LAST_INSTALMENT)
  private Integer principalThresholdForLastInstalment;

  public static final String SERIALIZED_NAME_PRINCIPAL_VARIATIONS_FOR_BORROWER_CYCLE = "principalVariationsForBorrowerCycle";
  @SerializedName(SERIALIZED_NAME_PRINCIPAL_VARIATIONS_FOR_BORROWER_CYCLE)
  private List<Integer> principalVariationsForBorrowerCycle;

  public static final String SERIALIZED_NAME_REPAYMENT_EVERY = "repaymentEvery";
  @SerializedName(SERIALIZED_NAME_REPAYMENT_EVERY)
  private Integer repaymentEvery;

  public static final String SERIALIZED_NAME_REPAYMENT_FREQUENCY_TYPE = "repaymentFrequencyType";
  @SerializedName(SERIALIZED_NAME_REPAYMENT_FREQUENCY_TYPE)
  private GetLoanProductsRepaymentFrequencyType repaymentFrequencyType;

  public static final String SERIALIZED_NAME_REPAYMENT_START_DATE_TYPE = "repaymentStartDateType";
  @SerializedName(SERIALIZED_NAME_REPAYMENT_START_DATE_TYPE)
  private GetLoanProductsRepaymentStartDateType repaymentStartDateType;

  public static final String SERIALIZED_NAME_SHORT_NAME = "shortName";
  @SerializedName(SERIALIZED_NAME_SHORT_NAME)
  private String shortName;

  public static final String SERIALIZED_NAME_START_DATE = "startDate";
  @SerializedName(SERIALIZED_NAME_START_DATE)
  private LocalDate startDate;

  public static final String SERIALIZED_NAME_STATUS = "status";
  @SerializedName(SERIALIZED_NAME_STATUS)
  private String status;

  public static final String SERIALIZED_NAME_SUPPORTED_INTEREST_REFUND_TYPES = "supportedInterestRefundTypes";
  @SerializedName(SERIALIZED_NAME_SUPPORTED_INTEREST_REFUND_TYPES)
  private List<StringEnumOptionData> supportedInterestRefundTypes;

  public static final String SERIALIZED_NAME_TRANSACTION_PROCESSING_STRATEGY = "transactionProcessingStrategy";
  @SerializedName(SERIALIZED_NAME_TRANSACTION_PROCESSING_STRATEGY)
  private String transactionProcessingStrategy;

  public static final String SERIALIZED_NAME_TRANSACTION_PROCESSING_STRATEGY_NAME = "transactionProcessingStrategyName";
  @SerializedName(SERIALIZED_NAME_TRANSACTION_PROCESSING_STRATEGY_NAME)
  private String transactionProcessingStrategyName;

  public static final String SERIALIZED_NAME_USE_BORROWER_CYCLE = "useBorrowerCycle";
  @SerializedName(SERIALIZED_NAME_USE_BORROWER_CYCLE)
  private Boolean useBorrowerCycle;

  public GetLoanProductsResponse() {
  }

  public GetLoanProductsResponse accountingRule(GetLoanProductsAccountingRule accountingRule) {
    
    this.accountingRule = accountingRule;
    return this;
  }

  /**
   * Get accountingRule
   * @return accountingRule
   */
  @javax.annotation.Nullable

  public GetLoanProductsAccountingRule getAccountingRule() {
    return accountingRule;
  }


  public void setAccountingRule(GetLoanProductsAccountingRule accountingRule) {
    this.accountingRule = accountingRule;
  }

  public GetLoanProductsResponse amortizationType(GetLoanProductsAmortizationType amortizationType) {
    
    this.amortizationType = amortizationType;
    return this;
  }

  /**
   * Get amortizationType
   * @return amortizationType
   */
  @javax.annotation.Nullable

  public GetLoanProductsAmortizationType getAmortizationType() {
    return amortizationType;
  }


  public void setAmortizationType(GetLoanProductsAmortizationType amortizationType) {
    this.amortizationType = amortizationType;
  }

  public GetLoanProductsResponse annualInterestRate(Double annualInterestRate) {
    
    this.annualInterestRate = annualInterestRate;
    return this;
  }

  /**
   * Get annualInterestRate
   * @return annualInterestRate
   */
  @javax.annotation.Nullable

  public Double getAnnualInterestRate() {
    return annualInterestRate;
  }


  public void setAnnualInterestRate(Double annualInterestRate) {
    this.annualInterestRate = annualInterestRate;
  }

  public GetLoanProductsResponse buyDownFeeCalculationType(StringEnumOptionData buyDownFeeCalculationType) {
    
    this.buyDownFeeCalculationType = buyDownFeeCalculationType;
    return this;
  }

  /**
   * Get buyDownFeeCalculationType
   * @return buyDownFeeCalculationType
   */
  @javax.annotation.Nullable

  public StringEnumOptionData getBuyDownFeeCalculationType() {
    return buyDownFeeCalculationType;
  }


  public void setBuyDownFeeCalculationType(StringEnumOptionData buyDownFeeCalculationType) {
    this.buyDownFeeCalculationType = buyDownFeeCalculationType;
  }

  public GetLoanProductsResponse buyDownFeeIncomeType(StringEnumOptionData buyDownFeeIncomeType) {
    
    this.buyDownFeeIncomeType = buyDownFeeIncomeType;
    return this;
  }

  /**
   * Get buyDownFeeIncomeType
   * @return buyDownFeeIncomeType
   */
  @javax.annotation.Nullable

  public StringEnumOptionData getBuyDownFeeIncomeType() {
    return buyDownFeeIncomeType;
  }


  public void setBuyDownFeeIncomeType(StringEnumOptionData buyDownFeeIncomeType) {
    this.buyDownFeeIncomeType = buyDownFeeIncomeType;
  }

  public GetLoanProductsResponse buyDownFeeStrategy(StringEnumOptionData buyDownFeeStrategy) {
    
    this.buyDownFeeStrategy = buyDownFeeStrategy;
    return this;
  }

  /**
   * Get buyDownFeeStrategy
   * @return buyDownFeeStrategy
   */
  @javax.annotation.Nullable

  public StringEnumOptionData getBuyDownFeeStrategy() {
    return buyDownFeeStrategy;
  }


  public void setBuyDownFeeStrategy(StringEnumOptionData buyDownFeeStrategy) {
    this.buyDownFeeStrategy = buyDownFeeStrategy;
  }

  public GetLoanProductsResponse capitalizedIncomeCalculationType(StringEnumOptionData capitalizedIncomeCalculationType) {
    
    this.capitalizedIncomeCalculationType = capitalizedIncomeCalculationType;
    return this;
  }

  /**
   * Get capitalizedIncomeCalculationType
   * @return capitalizedIncomeCalculationType
   */
  @javax.annotation.Nullable

  public StringEnumOptionData getCapitalizedIncomeCalculationType() {
    return capitalizedIncomeCalculationType;
  }


  public void setCapitalizedIncomeCalculationType(StringEnumOptionData capitalizedIncomeCalculationType) {
    this.capitalizedIncomeCalculationType = capitalizedIncomeCalculationType;
  }

  public GetLoanProductsResponse capitalizedIncomeStrategy(StringEnumOptionData capitalizedIncomeStrategy) {
    
    this.capitalizedIncomeStrategy = capitalizedIncomeStrategy;
    return this;
  }

  /**
   * Get capitalizedIncomeStrategy
   * @return capitalizedIncomeStrategy
   */
  @javax.annotation.Nullable

  public StringEnumOptionData getCapitalizedIncomeStrategy() {
    return capitalizedIncomeStrategy;
  }


  public void setCapitalizedIncomeStrategy(StringEnumOptionData capitalizedIncomeStrategy) {
    this.capitalizedIncomeStrategy = capitalizedIncomeStrategy;
  }

  public GetLoanProductsResponse capitalizedIncomeType(StringEnumOptionData capitalizedIncomeType) {
    
    this.capitalizedIncomeType = capitalizedIncomeType;
    return this;
  }

  /**
   * Get capitalizedIncomeType
   * @return capitalizedIncomeType
   */
  @javax.annotation.Nullable

  public StringEnumOptionData getCapitalizedIncomeType() {
    return capitalizedIncomeType;
  }


  public void setCapitalizedIncomeType(StringEnumOptionData capitalizedIncomeType) {
    this.capitalizedIncomeType = capitalizedIncomeType;
  }

  public GetLoanProductsResponse chargeOffBehaviour(StringEnumOptionData chargeOffBehaviour) {
    
    this.chargeOffBehaviour = chargeOffBehaviour;
    return this;
  }

  /**
   * Get chargeOffBehaviour
   * @return chargeOffBehaviour
   */
  @javax.annotation.Nullable

  public StringEnumOptionData getChargeOffBehaviour() {
    return chargeOffBehaviour;
  }


  public void setChargeOffBehaviour(StringEnumOptionData chargeOffBehaviour) {
    this.chargeOffBehaviour = chargeOffBehaviour;
  }

  public GetLoanProductsResponse currency(GetLoanProductsCurrency currency) {
    
    this.currency = currency;
    return this;
  }

  /**
   * Get currency
   * @return currency
   */
  @javax.annotation.Nullable

  public GetLoanProductsCurrency getCurrency() {
    return currency;
  }


  public void setCurrency(GetLoanProductsCurrency currency) {
    this.currency = currency;
  }

  public GetLoanProductsResponse daysInMonthType(GetLoanProductsDaysInMonthType daysInMonthType) {
    
    this.daysInMonthType = daysInMonthType;
    return this;
  }

  /**
   * Get daysInMonthType
   * @return daysInMonthType
   */
  @javax.annotation.Nullable

  public GetLoanProductsDaysInMonthType getDaysInMonthType() {
    return daysInMonthType;
  }


  public void setDaysInMonthType(GetLoanProductsDaysInMonthType daysInMonthType) {
    this.daysInMonthType = daysInMonthType;
  }

  public GetLoanProductsResponse daysInYearCustomStrategy(GetLoanProductsDaysInYearCustomStrategy daysInYearCustomStrategy) {
    
    this.daysInYearCustomStrategy = daysInYearCustomStrategy;
    return this;
  }

  /**
   * Get daysInYearCustomStrategy
   * @return daysInYearCustomStrategy
   */
  @javax.annotation.Nullable

  public GetLoanProductsDaysInYearCustomStrategy getDaysInYearCustomStrategy() {
    return daysInYearCustomStrategy;
  }


  public void setDaysInYearCustomStrategy(GetLoanProductsDaysInYearCustomStrategy daysInYearCustomStrategy) {
    this.daysInYearCustomStrategy = daysInYearCustomStrategy;
  }

  public GetLoanProductsResponse daysInYearType(GetLoanProductsDaysInYearType daysInYearType) {
    
    this.daysInYearType = daysInYearType;
    return this;
  }

  /**
   * Get daysInYearType
   * @return daysInYearType
   */
  @javax.annotation.Nullable

  public GetLoanProductsDaysInYearType getDaysInYearType() {
    return daysInYearType;
  }


  public void setDaysInYearType(GetLoanProductsDaysInYearType daysInYearType) {
    this.daysInYearType = daysInYearType;
  }

  public GetLoanProductsResponse enableBuyDownFee(Boolean enableBuyDownFee) {
    
    this.enableBuyDownFee = enableBuyDownFee;
    return this;
  }

  /**
   * Get enableBuyDownFee
   * @return enableBuyDownFee
   */
  @javax.annotation.Nullable

  public Boolean getEnableBuyDownFee() {
    return enableBuyDownFee;
  }


  public void setEnableBuyDownFee(Boolean enableBuyDownFee) {
    this.enableBuyDownFee = enableBuyDownFee;
  }

  public GetLoanProductsResponse enableIncomeCapitalization(Boolean enableIncomeCapitalization) {
    
    this.enableIncomeCapitalization = enableIncomeCapitalization;
    return this;
  }

  /**
   * Get enableIncomeCapitalization
   * @return enableIncomeCapitalization
   */
  @javax.annotation.Nullable

  public Boolean getEnableIncomeCapitalization() {
    return enableIncomeCapitalization;
  }


  public void setEnableIncomeCapitalization(Boolean enableIncomeCapitalization) {
    this.enableIncomeCapitalization = enableIncomeCapitalization;
  }

  public GetLoanProductsResponse endDate(LocalDate endDate) {
    
    this.endDate = endDate;
    return this;
  }

  /**
   * Get endDate
   * @return endDate
   */
  @javax.annotation.Nullable

  public LocalDate getEndDate() {
    return endDate;
  }


  public void setEndDate(LocalDate endDate) {
    this.endDate = endDate;
  }

  public GetLoanProductsResponse fixedLength(Integer fixedLength) {
    
    this.fixedLength = fixedLength;
    return this;
  }

  /**
   * Get fixedLength
   * @return fixedLength
   */
  @javax.annotation.Nullable

  public Integer getFixedLength() {
    return fixedLength;
  }


  public void setFixedLength(Integer fixedLength) {
    this.fixedLength = fixedLength;
  }

  public GetLoanProductsResponse fixedPrincipalPercentagePerInstallment(BigDecimal fixedPrincipalPercentagePerInstallment) {
    
    this.fixedPrincipalPercentagePerInstallment = fixedPrincipalPercentagePerInstallment;
    return this;
  }

  /**
   * Get fixedPrincipalPercentagePerInstallment
   * @return fixedPrincipalPercentagePerInstallment
   */
  @javax.annotation.Nullable

  public BigDecimal getFixedPrincipalPercentagePerInstallment() {
    return fixedPrincipalPercentagePerInstallment;
  }


  public void setFixedPrincipalPercentagePerInstallment(BigDecimal fixedPrincipalPercentagePerInstallment) {
    this.fixedPrincipalPercentagePerInstallment = fixedPrincipalPercentagePerInstallment;
  }

  public GetLoanProductsResponse id(Long id) {
    
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
   */
  @javax.annotation.Nullable

  public Long getId() {
    return id;
  }


  public void setId(Long id) {
    this.id = id;
  }

  public GetLoanProductsResponse includeInBorrowerCycle(Boolean includeInBorrowerCycle) {
    
    this.includeInBorrowerCycle = includeInBorrowerCycle;
    return this;
  }

  /**
   * Get includeInBorrowerCycle
   * @return includeInBorrowerCycle
   */
  @javax.annotation.Nullable

  public Boolean getIncludeInBorrowerCycle() {
    return includeInBorrowerCycle;
  }


  public void setIncludeInBorrowerCycle(Boolean includeInBorrowerCycle) {
    this.includeInBorrowerCycle = includeInBorrowerCycle;
  }

  public GetLoanProductsResponse interestCalculationPeriodType(GetLoansProductsInterestCalculationPeriodType interestCalculationPeriodType) {
    
    this.interestCalculationPeriodType = interestCalculationPeriodType;
    return this;
  }

  /**
   * Get interestCalculationPeriodType
   * @return interestCalculationPeriodType
   */
  @javax.annotation.Nullable

  public GetLoansProductsInterestCalculationPeriodType getInterestCalculationPeriodType() {
    return interestCalculationPeriodType;
  }


  public void setInterestCalculationPeriodType(GetLoansProductsInterestCalculationPeriodType interestCalculationPeriodType) {
    this.interestCalculationPeriodType = interestCalculationPeriodType;
  }

  public GetLoanProductsResponse interestRateFrequencyType(GetLoanProductsInterestRateFrequencyType interestRateFrequencyType) {
    
    this.interestRateFrequencyType = interestRateFrequencyType;
    return this;
  }

  /**
   * Get interestRateFrequencyType
   * @return interestRateFrequencyType
   */
  @javax.annotation.Nullable

  public GetLoanProductsInterestRateFrequencyType getInterestRateFrequencyType() {
    return interestRateFrequencyType;
  }


  public void setInterestRateFrequencyType(GetLoanProductsInterestRateFrequencyType interestRateFrequencyType) {
    this.interestRateFrequencyType = interestRateFrequencyType;
  }

  public GetLoanProductsResponse interestRatePerPeriod(Double interestRatePerPeriod) {
    
    this.interestRatePerPeriod = interestRatePerPeriod;
    return this;
  }

  /**
   * Get interestRatePerPeriod
   * @return interestRatePerPeriod
   */
  @javax.annotation.Nullable

  public Double getInterestRatePerPeriod() {
    return interestRatePerPeriod;
  }


  public void setInterestRatePerPeriod(Double interestRatePerPeriod) {
    this.interestRatePerPeriod = interestRatePerPeriod;
  }

  public GetLoanProductsResponse interestRateVariationsForBorrowerCycle(List<Integer> interestRateVariationsForBorrowerCycle) {
    
    this.interestRateVariationsForBorrowerCycle = interestRateVariationsForBorrowerCycle;
    return this;
  }

  public GetLoanProductsResponse addInterestRateVariationsForBorrowerCycleItem(Integer interestRateVariationsForBorrowerCycleItem) {
    if (this.interestRateVariationsForBorrowerCycle == null) {
      this.interestRateVariationsForBorrowerCycle = new ArrayList<>();
    }
    this.interestRateVariationsForBorrowerCycle.add(interestRateVariationsForBorrowerCycleItem);
    return this;
  }

  /**
   * Get interestRateVariationsForBorrowerCycle
   * @return interestRateVariationsForBorrowerCycle
   */
  @javax.annotation.Nullable

  public List<Integer> getInterestRateVariationsForBorrowerCycle() {
    return interestRateVariationsForBorrowerCycle;
  }


  public void setInterestRateVariationsForBorrowerCycle(List<Integer> interestRateVariationsForBorrowerCycle) {
    this.interestRateVariationsForBorrowerCycle = interestRateVariationsForBorrowerCycle;
  }

  public GetLoanProductsResponse interestRecalculationData(GetLoanProductsInterestRecalculationData interestRecalculationData) {
    
    this.interestRecalculationData = interestRecalculationData;
    return this;
  }

  /**
   * Get interestRecalculationData
   * @return interestRecalculationData
   */
  @javax.annotation.Nullable

  public GetLoanProductsInterestRecalculationData getInterestRecalculationData() {
    return interestRecalculationData;
  }


  public void setInterestRecalculationData(GetLoanProductsInterestRecalculationData interestRecalculationData) {
    this.interestRecalculationData = interestRecalculationData;
  }

  public GetLoanProductsResponse interestRecognitionOnDisbursementDate(Boolean interestRecognitionOnDisbursementDate) {
    
    this.interestRecognitionOnDisbursementDate = interestRecognitionOnDisbursementDate;
    return this;
  }

  /**
   * Get interestRecognitionOnDisbursementDate
   * @return interestRecognitionOnDisbursementDate
   */
  @javax.annotation.Nullable

  public Boolean getInterestRecognitionOnDisbursementDate() {
    return interestRecognitionOnDisbursementDate;
  }


  public void setInterestRecognitionOnDisbursementDate(Boolean interestRecognitionOnDisbursementDate) {
    this.interestRecognitionOnDisbursementDate = interestRecognitionOnDisbursementDate;
  }

  public GetLoanProductsResponse interestType(GetLoanProductsInterestType interestType) {
    
    this.interestType = interestType;
    return this;
  }

  /**
   * Get interestType
   * @return interestType
   */
  @javax.annotation.Nullable

  public GetLoanProductsInterestType getInterestType() {
    return interestType;
  }


  public void setInterestType(GetLoanProductsInterestType interestType) {
    this.interestType = interestType;
  }

  public GetLoanProductsResponse isInterestRecalculationEnabled(Boolean isInterestRecalculationEnabled) {
    
    this.isInterestRecalculationEnabled = isInterestRecalculationEnabled;
    return this;
  }

  /**
   * Get isInterestRecalculationEnabled
   * @return isInterestRecalculationEnabled
   */
  @javax.annotation.Nullable

  public Boolean getIsInterestRecalculationEnabled() {
    return isInterestRecalculationEnabled;
  }


  public void setIsInterestRecalculationEnabled(Boolean isInterestRecalculationEnabled) {
    this.isInterestRecalculationEnabled = isInterestRecalculationEnabled;
  }

  public GetLoanProductsResponse maxNumberOfRepayments(Integer maxNumberOfRepayments) {
    
    this.maxNumberOfRepayments = maxNumberOfRepayments;
    return this;
  }

  /**
   * Get maxNumberOfRepayments
   * @return maxNumberOfRepayments
   */
  @javax.annotation.Nullable

  public Integer getMaxNumberOfRepayments() {
    return maxNumberOfRepayments;
  }


  public void setMaxNumberOfRepayments(Integer maxNumberOfRepayments) {
    this.maxNumberOfRepayments = maxNumberOfRepayments;
  }

  public GetLoanProductsResponse maxPrincipal(Double maxPrincipal) {
    
    this.maxPrincipal = maxPrincipal;
    return this;
  }

  /**
   * Get maxPrincipal
   * @return maxPrincipal
   */
  @javax.annotation.Nullable

  public Double getMaxPrincipal() {
    return maxPrincipal;
  }


  public void setMaxPrincipal(Double maxPrincipal) {
    this.maxPrincipal = maxPrincipal;
  }

  public GetLoanProductsResponse merchantBuyDownFee(Boolean merchantBuyDownFee) {
    
    this.merchantBuyDownFee = merchantBuyDownFee;
    return this;
  }

  /**
   * Get merchantBuyDownFee
   * @return merchantBuyDownFee
   */
  @javax.annotation.Nullable

  public Boolean getMerchantBuyDownFee() {
    return merchantBuyDownFee;
  }


  public void setMerchantBuyDownFee(Boolean merchantBuyDownFee) {
    this.merchantBuyDownFee = merchantBuyDownFee;
  }

  public GetLoanProductsResponse minNumberOfRepayments(Integer minNumberOfRepayments) {
    
    this.minNumberOfRepayments = minNumberOfRepayments;
    return this;
  }

  /**
   * Get minNumberOfRepayments
   * @return minNumberOfRepayments
   */
  @javax.annotation.Nullable

  public Integer getMinNumberOfRepayments() {
    return minNumberOfRepayments;
  }


  public void setMinNumberOfRepayments(Integer minNumberOfRepayments) {
    this.minNumberOfRepayments = minNumberOfRepayments;
  }

  public GetLoanProductsResponse minPrincipal(Double minPrincipal) {
    
    this.minPrincipal = minPrincipal;
    return this;
  }

  /**
   * Get minPrincipal
   * @return minPrincipal
   */
  @javax.annotation.Nullable

  public Double getMinPrincipal() {
    return minPrincipal;
  }


  public void setMinPrincipal(Double minPrincipal) {
    this.minPrincipal = minPrincipal;
  }

  public GetLoanProductsResponse name(String name) {
    
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
   */
  @javax.annotation.Nullable

  public String getName() {
    return name;
  }


  public void setName(String name) {
    this.name = name;
  }

  public GetLoanProductsResponse numberOfRepaymentVariationsForBorrowerCycle(List<Integer> numberOfRepaymentVariationsForBorrowerCycle) {
    
    this.numberOfRepaymentVariationsForBorrowerCycle = numberOfRepaymentVariationsForBorrowerCycle;
    return this;
  }

  public GetLoanProductsResponse addNumberOfRepaymentVariationsForBorrowerCycleItem(Integer numberOfRepaymentVariationsForBorrowerCycleItem) {
    if (this.numberOfRepaymentVariationsForBorrowerCycle == null) {
      this.numberOfRepaymentVariationsForBorrowerCycle = new ArrayList<>();
    }
    this.numberOfRepaymentVariationsForBorrowerCycle.add(numberOfRepaymentVariationsForBorrowerCycleItem);
    return this;
  }

  /**
   * Get numberOfRepaymentVariationsForBorrowerCycle
   * @return numberOfRepaymentVariationsForBorrowerCycle
   */
  @javax.annotation.Nullable

  public List<Integer> getNumberOfRepaymentVariationsForBorrowerCycle() {
    return numberOfRepaymentVariationsForBorrowerCycle;
  }


  public void setNumberOfRepaymentVariationsForBorrowerCycle(List<Integer> numberOfRepaymentVariationsForBorrowerCycle) {
    this.numberOfRepaymentVariationsForBorrowerCycle = numberOfRepaymentVariationsForBorrowerCycle;
  }

  public GetLoanProductsResponse numberOfRepayments(Integer numberOfRepayments) {
    
    this.numberOfRepayments = numberOfRepayments;
    return this;
  }

  /**
   * Get numberOfRepayments
   * @return numberOfRepayments
   */
  @javax.annotation.Nullable

  public Integer getNumberOfRepayments() {
    return numberOfRepayments;
  }


  public void setNumberOfRepayments(Integer numberOfRepayments) {
    this.numberOfRepayments = numberOfRepayments;
  }

  public GetLoanProductsResponse principal(Double principal) {
    
    this.principal = principal;
    return this;
  }

  /**
   * Get principal
   * @return principal
   */
  @javax.annotation.Nullable

  public Double getPrincipal() {
    return principal;
  }


  public void setPrincipal(Double principal) {
    this.principal = principal;
  }

  public GetLoanProductsResponse principalThresholdForLastInstalment(Integer principalThresholdForLastInstalment) {
    
    this.principalThresholdForLastInstalment = principalThresholdForLastInstalment;
    return this;
  }

  /**
   * Get principalThresholdForLastInstalment
   * @return principalThresholdForLastInstalment
   */
  @javax.annotation.Nullable

  public Integer getPrincipalThresholdForLastInstalment() {
    return principalThresholdForLastInstalment;
  }


  public void setPrincipalThresholdForLastInstalment(Integer principalThresholdForLastInstalment) {
    this.principalThresholdForLastInstalment = principalThresholdForLastInstalment;
  }

  public GetLoanProductsResponse principalVariationsForBorrowerCycle(List<Integer> principalVariationsForBorrowerCycle) {
    
    this.principalVariationsForBorrowerCycle = principalVariationsForBorrowerCycle;
    return this;
  }

  public GetLoanProductsResponse addPrincipalVariationsForBorrowerCycleItem(Integer principalVariationsForBorrowerCycleItem) {
    if (this.principalVariationsForBorrowerCycle == null) {
      this.principalVariationsForBorrowerCycle = new ArrayList<>();
    }
    this.principalVariationsForBorrowerCycle.add(principalVariationsForBorrowerCycleItem);
    return this;
  }

  /**
   * Get principalVariationsForBorrowerCycle
   * @return principalVariationsForBorrowerCycle
   */
  @javax.annotation.Nullable

  public List<Integer> getPrincipalVariationsForBorrowerCycle() {
    return principalVariationsForBorrowerCycle;
  }


  public void setPrincipalVariationsForBorrowerCycle(List<Integer> principalVariationsForBorrowerCycle) {
    this.principalVariationsForBorrowerCycle = principalVariationsForBorrowerCycle;
  }

  public GetLoanProductsResponse repaymentEvery(Integer repaymentEvery) {
    
    this.repaymentEvery = repaymentEvery;
    return this;
  }

  /**
   * Get repaymentEvery
   * @return repaymentEvery
   */
  @javax.annotation.Nullable

  public Integer getRepaymentEvery() {
    return repaymentEvery;
  }


  public void setRepaymentEvery(Integer repaymentEvery) {
    this.repaymentEvery = repaymentEvery;
  }

  public GetLoanProductsResponse repaymentFrequencyType(GetLoanProductsRepaymentFrequencyType repaymentFrequencyType) {
    
    this.repaymentFrequencyType = repaymentFrequencyType;
    return this;
  }

  /**
   * Get repaymentFrequencyType
   * @return repaymentFrequencyType
   */
  @javax.annotation.Nullable

  public GetLoanProductsRepaymentFrequencyType getRepaymentFrequencyType() {
    return repaymentFrequencyType;
  }


  public void setRepaymentFrequencyType(GetLoanProductsRepaymentFrequencyType repaymentFrequencyType) {
    this.repaymentFrequencyType = repaymentFrequencyType;
  }

  public GetLoanProductsResponse repaymentStartDateType(GetLoanProductsRepaymentStartDateType repaymentStartDateType) {
    
    this.repaymentStartDateType = repaymentStartDateType;
    return this;
  }

  /**
   * Get repaymentStartDateType
   * @return repaymentStartDateType
   */
  @javax.annotation.Nullable

  public GetLoanProductsRepaymentStartDateType getRepaymentStartDateType() {
    return repaymentStartDateType;
  }


  public void setRepaymentStartDateType(GetLoanProductsRepaymentStartDateType repaymentStartDateType) {
    this.repaymentStartDateType = repaymentStartDateType;
  }

  public GetLoanProductsResponse shortName(String shortName) {
    
    this.shortName = shortName;
    return this;
  }

  /**
   * Get shortName
   * @return shortName
   */
  @javax.annotation.Nullable

  public String getShortName() {
    return shortName;
  }


  public void setShortName(String shortName) {
    this.shortName = shortName;
  }

  public GetLoanProductsResponse startDate(LocalDate startDate) {
    
    this.startDate = startDate;
    return this;
  }

  /**
   * Get startDate
   * @return startDate
   */
  @javax.annotation.Nullable

  public LocalDate getStartDate() {
    return startDate;
  }


  public void setStartDate(LocalDate startDate) {
    this.startDate = startDate;
  }

  public GetLoanProductsResponse status(String status) {
    
    this.status = status;
    return this;
  }

  /**
   * Get status
   * @return status
   */
  @javax.annotation.Nullable

  public String getStatus() {
    return status;
  }


  public void setStatus(String status) {
    this.status = status;
  }

  public GetLoanProductsResponse supportedInterestRefundTypes(List<StringEnumOptionData> supportedInterestRefundTypes) {
    
    this.supportedInterestRefundTypes = supportedInterestRefundTypes;
    return this;
  }

  public GetLoanProductsResponse addSupportedInterestRefundTypesItem(StringEnumOptionData supportedInterestRefundTypesItem) {
    if (this.supportedInterestRefundTypes == null) {
      this.supportedInterestRefundTypes = new ArrayList<>();
    }
    this.supportedInterestRefundTypes.add(supportedInterestRefundTypesItem);
    return this;
  }

  /**
   * Get supportedInterestRefundTypes
   * @return supportedInterestRefundTypes
   */
  @javax.annotation.Nullable

  public List<StringEnumOptionData> getSupportedInterestRefundTypes() {
    return supportedInterestRefundTypes;
  }


  public void setSupportedInterestRefundTypes(List<StringEnumOptionData> supportedInterestRefundTypes) {
    this.supportedInterestRefundTypes = supportedInterestRefundTypes;
  }

  public GetLoanProductsResponse transactionProcessingStrategy(String transactionProcessingStrategy) {
    
    this.transactionProcessingStrategy = transactionProcessingStrategy;
    return this;
  }

  /**
   * Get transactionProcessingStrategy
   * @return transactionProcessingStrategy
   */
  @javax.annotation.Nullable

  public String getTransactionProcessingStrategy() {
    return transactionProcessingStrategy;
  }


  public void setTransactionProcessingStrategy(String transactionProcessingStrategy) {
    this.transactionProcessingStrategy = transactionProcessingStrategy;
  }

  public GetLoanProductsResponse transactionProcessingStrategyName(String transactionProcessingStrategyName) {
    
    this.transactionProcessingStrategyName = transactionProcessingStrategyName;
    return this;
  }

  /**
   * Get transactionProcessingStrategyName
   * @return transactionProcessingStrategyName
   */
  @javax.annotation.Nullable

  public String getTransactionProcessingStrategyName() {
    return transactionProcessingStrategyName;
  }


  public void setTransactionProcessingStrategyName(String transactionProcessingStrategyName) {
    this.transactionProcessingStrategyName = transactionProcessingStrategyName;
  }

  public GetLoanProductsResponse useBorrowerCycle(Boolean useBorrowerCycle) {
    
    this.useBorrowerCycle = useBorrowerCycle;
    return this;
  }

  /**
   * Get useBorrowerCycle
   * @return useBorrowerCycle
   */
  @javax.annotation.Nullable

  public Boolean getUseBorrowerCycle() {
    return useBorrowerCycle;
  }


  public void setUseBorrowerCycle(Boolean useBorrowerCycle) {
    this.useBorrowerCycle = useBorrowerCycle;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GetLoanProductsResponse getLoanProductsResponse = (GetLoanProductsResponse) o;
    return Objects.equals(this.accountingRule, getLoanProductsResponse.accountingRule) &&
        Objects.equals(this.amortizationType, getLoanProductsResponse.amortizationType) &&
        Objects.equals(this.annualInterestRate, getLoanProductsResponse.annualInterestRate) &&
        Objects.equals(this.buyDownFeeCalculationType, getLoanProductsResponse.buyDownFeeCalculationType) &&
        Objects.equals(this.buyDownFeeIncomeType, getLoanProductsResponse.buyDownFeeIncomeType) &&
        Objects.equals(this.buyDownFeeStrategy, getLoanProductsResponse.buyDownFeeStrategy) &&
        Objects.equals(this.capitalizedIncomeCalculationType, getLoanProductsResponse.capitalizedIncomeCalculationType) &&
        Objects.equals(this.capitalizedIncomeStrategy, getLoanProductsResponse.capitalizedIncomeStrategy) &&
        Objects.equals(this.capitalizedIncomeType, getLoanProductsResponse.capitalizedIncomeType) &&
        Objects.equals(this.chargeOffBehaviour, getLoanProductsResponse.chargeOffBehaviour) &&
        Objects.equals(this.currency, getLoanProductsResponse.currency) &&
        Objects.equals(this.daysInMonthType, getLoanProductsResponse.daysInMonthType) &&
        Objects.equals(this.daysInYearCustomStrategy, getLoanProductsResponse.daysInYearCustomStrategy) &&
        Objects.equals(this.daysInYearType, getLoanProductsResponse.daysInYearType) &&
        Objects.equals(this.enableBuyDownFee, getLoanProductsResponse.enableBuyDownFee) &&
        Objects.equals(this.enableIncomeCapitalization, getLoanProductsResponse.enableIncomeCapitalization) &&
        Objects.equals(this.endDate, getLoanProductsResponse.endDate) &&
        Objects.equals(this.fixedLength, getLoanProductsResponse.fixedLength) &&
        Objects.equals(this.fixedPrincipalPercentagePerInstallment, getLoanProductsResponse.fixedPrincipalPercentagePerInstallment) &&
        Objects.equals(this.id, getLoanProductsResponse.id) &&
        Objects.equals(this.includeInBorrowerCycle, getLoanProductsResponse.includeInBorrowerCycle) &&
        Objects.equals(this.interestCalculationPeriodType, getLoanProductsResponse.interestCalculationPeriodType) &&
        Objects.equals(this.interestRateFrequencyType, getLoanProductsResponse.interestRateFrequencyType) &&
        Objects.equals(this.interestRatePerPeriod, getLoanProductsResponse.interestRatePerPeriod) &&
        Objects.equals(this.interestRateVariationsForBorrowerCycle, getLoanProductsResponse.interestRateVariationsForBorrowerCycle) &&
        Objects.equals(this.interestRecalculationData, getLoanProductsResponse.interestRecalculationData) &&
        Objects.equals(this.interestRecognitionOnDisbursementDate, getLoanProductsResponse.interestRecognitionOnDisbursementDate) &&
        Objects.equals(this.interestType, getLoanProductsResponse.interestType) &&
        Objects.equals(this.isInterestRecalculationEnabled, getLoanProductsResponse.isInterestRecalculationEnabled) &&
        Objects.equals(this.maxNumberOfRepayments, getLoanProductsResponse.maxNumberOfRepayments) &&
        Objects.equals(this.maxPrincipal, getLoanProductsResponse.maxPrincipal) &&
        Objects.equals(this.merchantBuyDownFee, getLoanProductsResponse.merchantBuyDownFee) &&
        Objects.equals(this.minNumberOfRepayments, getLoanProductsResponse.minNumberOfRepayments) &&
        Objects.equals(this.minPrincipal, getLoanProductsResponse.minPrincipal) &&
        Objects.equals(this.name, getLoanProductsResponse.name) &&
        Objects.equals(this.numberOfRepaymentVariationsForBorrowerCycle, getLoanProductsResponse.numberOfRepaymentVariationsForBorrowerCycle) &&
        Objects.equals(this.numberOfRepayments, getLoanProductsResponse.numberOfRepayments) &&
        Objects.equals(this.principal, getLoanProductsResponse.principal) &&
        Objects.equals(this.principalThresholdForLastInstalment, getLoanProductsResponse.principalThresholdForLastInstalment) &&
        Objects.equals(this.principalVariationsForBorrowerCycle, getLoanProductsResponse.principalVariationsForBorrowerCycle) &&
        Objects.equals(this.repaymentEvery, getLoanProductsResponse.repaymentEvery) &&
        Objects.equals(this.repaymentFrequencyType, getLoanProductsResponse.repaymentFrequencyType) &&
        Objects.equals(this.repaymentStartDateType, getLoanProductsResponse.repaymentStartDateType) &&
        Objects.equals(this.shortName, getLoanProductsResponse.shortName) &&
        Objects.equals(this.startDate, getLoanProductsResponse.startDate) &&
        Objects.equals(this.status, getLoanProductsResponse.status) &&
        Objects.equals(this.supportedInterestRefundTypes, getLoanProductsResponse.supportedInterestRefundTypes) &&
        Objects.equals(this.transactionProcessingStrategy, getLoanProductsResponse.transactionProcessingStrategy) &&
        Objects.equals(this.transactionProcessingStrategyName, getLoanProductsResponse.transactionProcessingStrategyName) &&
        Objects.equals(this.useBorrowerCycle, getLoanProductsResponse.useBorrowerCycle);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountingRule, amortizationType, annualInterestRate, buyDownFeeCalculationType, buyDownFeeIncomeType, buyDownFeeStrategy, capitalizedIncomeCalculationType, capitalizedIncomeStrategy, capitalizedIncomeType, chargeOffBehaviour, currency, daysInMonthType, daysInYearCustomStrategy, daysInYearType, enableBuyDownFee, enableIncomeCapitalization, endDate, fixedLength, fixedPrincipalPercentagePerInstallment, id, includeInBorrowerCycle, interestCalculationPeriodType, interestRateFrequencyType, interestRatePerPeriod, interestRateVariationsForBorrowerCycle, interestRecalculationData, interestRecognitionOnDisbursementDate, interestType, isInterestRecalculationEnabled, maxNumberOfRepayments, maxPrincipal, merchantBuyDownFee, minNumberOfRepayments, minPrincipal, name, numberOfRepaymentVariationsForBorrowerCycle, numberOfRepayments, principal, principalThresholdForLastInstalment, principalVariationsForBorrowerCycle, repaymentEvery, repaymentFrequencyType, repaymentStartDateType, shortName, startDate, status, supportedInterestRefundTypes, transactionProcessingStrategy, transactionProcessingStrategyName, useBorrowerCycle);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetLoanProductsResponse {\n");
    sb.append("    accountingRule: ").append(toIndentedString(accountingRule)).append("\n");
    sb.append("    amortizationType: ").append(toIndentedString(amortizationType)).append("\n");
    sb.append("    annualInterestRate: ").append(toIndentedString(annualInterestRate)).append("\n");
    sb.append("    buyDownFeeCalculationType: ").append(toIndentedString(buyDownFeeCalculationType)).append("\n");
    sb.append("    buyDownFeeIncomeType: ").append(toIndentedString(buyDownFeeIncomeType)).append("\n");
    sb.append("    buyDownFeeStrategy: ").append(toIndentedString(buyDownFeeStrategy)).append("\n");
    sb.append("    capitalizedIncomeCalculationType: ").append(toIndentedString(capitalizedIncomeCalculationType)).append("\n");
    sb.append("    capitalizedIncomeStrategy: ").append(toIndentedString(capitalizedIncomeStrategy)).append("\n");
    sb.append("    capitalizedIncomeType: ").append(toIndentedString(capitalizedIncomeType)).append("\n");
    sb.append("    chargeOffBehaviour: ").append(toIndentedString(chargeOffBehaviour)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    daysInMonthType: ").append(toIndentedString(daysInMonthType)).append("\n");
    sb.append("    daysInYearCustomStrategy: ").append(toIndentedString(daysInYearCustomStrategy)).append("\n");
    sb.append("    daysInYearType: ").append(toIndentedString(daysInYearType)).append("\n");
    sb.append("    enableBuyDownFee: ").append(toIndentedString(enableBuyDownFee)).append("\n");
    sb.append("    enableIncomeCapitalization: ").append(toIndentedString(enableIncomeCapitalization)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    fixedLength: ").append(toIndentedString(fixedLength)).append("\n");
    sb.append("    fixedPrincipalPercentagePerInstallment: ").append(toIndentedString(fixedPrincipalPercentagePerInstallment)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    includeInBorrowerCycle: ").append(toIndentedString(includeInBorrowerCycle)).append("\n");
    sb.append("    interestCalculationPeriodType: ").append(toIndentedString(interestCalculationPeriodType)).append("\n");
    sb.append("    interestRateFrequencyType: ").append(toIndentedString(interestRateFrequencyType)).append("\n");
    sb.append("    interestRatePerPeriod: ").append(toIndentedString(interestRatePerPeriod)).append("\n");
    sb.append("    interestRateVariationsForBorrowerCycle: ").append(toIndentedString(interestRateVariationsForBorrowerCycle)).append("\n");
    sb.append("    interestRecalculationData: ").append(toIndentedString(interestRecalculationData)).append("\n");
    sb.append("    interestRecognitionOnDisbursementDate: ").append(toIndentedString(interestRecognitionOnDisbursementDate)).append("\n");
    sb.append("    interestType: ").append(toIndentedString(interestType)).append("\n");
    sb.append("    isInterestRecalculationEnabled: ").append(toIndentedString(isInterestRecalculationEnabled)).append("\n");
    sb.append("    maxNumberOfRepayments: ").append(toIndentedString(maxNumberOfRepayments)).append("\n");
    sb.append("    maxPrincipal: ").append(toIndentedString(maxPrincipal)).append("\n");
    sb.append("    merchantBuyDownFee: ").append(toIndentedString(merchantBuyDownFee)).append("\n");
    sb.append("    minNumberOfRepayments: ").append(toIndentedString(minNumberOfRepayments)).append("\n");
    sb.append("    minPrincipal: ").append(toIndentedString(minPrincipal)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    numberOfRepaymentVariationsForBorrowerCycle: ").append(toIndentedString(numberOfRepaymentVariationsForBorrowerCycle)).append("\n");
    sb.append("    numberOfRepayments: ").append(toIndentedString(numberOfRepayments)).append("\n");
    sb.append("    principal: ").append(toIndentedString(principal)).append("\n");
    sb.append("    principalThresholdForLastInstalment: ").append(toIndentedString(principalThresholdForLastInstalment)).append("\n");
    sb.append("    principalVariationsForBorrowerCycle: ").append(toIndentedString(principalVariationsForBorrowerCycle)).append("\n");
    sb.append("    repaymentEvery: ").append(toIndentedString(repaymentEvery)).append("\n");
    sb.append("    repaymentFrequencyType: ").append(toIndentedString(repaymentFrequencyType)).append("\n");
    sb.append("    repaymentStartDateType: ").append(toIndentedString(repaymentStartDateType)).append("\n");
    sb.append("    shortName: ").append(toIndentedString(shortName)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    supportedInterestRefundTypes: ").append(toIndentedString(supportedInterestRefundTypes)).append("\n");
    sb.append("    transactionProcessingStrategy: ").append(toIndentedString(transactionProcessingStrategy)).append("\n");
    sb.append("    transactionProcessingStrategyName: ").append(toIndentedString(transactionProcessingStrategyName)).append("\n");
    sb.append("    useBorrowerCycle: ").append(toIndentedString(useBorrowerCycle)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

