/*
 * Apache Fineract REST API
 * Apache Fineract is a secure, multi-tenanted microfinance platform. The goal of the Apache Fineract API is to empower developers to build apps on top of the Apache Fineract Platform. The [reference app](https://cui.fineract.dev) (username: mifos, password: password) works on the same demo tenant as the interactive links in this documentation. Until we complete the new REST API documentation you still have the legacy documentation available [here](https://fineract.apache.org/docs/legacy/). Please check [the current Fineract documentation](https://fineract.apache.org/docs/current/) for more information.
 *
 * The version of the OpenAPI document: 1.13.0
 * Contact: dev@fineract.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.fineract.client.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

/**
 * InteropTransactionTypeData
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
public class InteropTransactionTypeData {
  /**
   * Gets or Sets initiator
   */
  @JsonAdapter(InitiatorEnum.Adapter.class)
  public enum InitiatorEnum {
    PAYER("PAYER"),
    
    PAYEE("PAYEE");

    private String value;

    InitiatorEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static InitiatorEnum fromValue(String value) {
      for (InitiatorEnum b : InitiatorEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<InitiatorEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final InitiatorEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public InitiatorEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return InitiatorEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_INITIATOR = "initiator";
  @SerializedName(SERIALIZED_NAME_INITIATOR)
  private InitiatorEnum initiator;

  /**
   * Gets or Sets initiatorType
   */
  @JsonAdapter(InitiatorTypeEnum.Adapter.class)
  public enum InitiatorTypeEnum {
    CONSUMER("CONSUMER"),
    
    AGENT("AGENT"),
    
    BUSINESS("BUSINESS"),
    
    DEVICE("DEVICE");

    private String value;

    InitiatorTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static InitiatorTypeEnum fromValue(String value) {
      for (InitiatorTypeEnum b : InitiatorTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<InitiatorTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final InitiatorTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public InitiatorTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return InitiatorTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_INITIATOR_TYPE = "initiatorType";
  @SerializedName(SERIALIZED_NAME_INITIATOR_TYPE)
  private InitiatorTypeEnum initiatorType;

  /**
   * Gets or Sets scenario
   */
  @JsonAdapter(ScenarioEnum.Adapter.class)
  public enum ScenarioEnum {
    DEPOSIT("DEPOSIT"),
    
    WITHDRAWAL("WITHDRAWAL"),
    
    TRANSFER("TRANSFER"),
    
    PAYMENT("PAYMENT"),
    
    REFUND("REFUND");

    private String value;

    ScenarioEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static ScenarioEnum fromValue(String value) {
      for (ScenarioEnum b : ScenarioEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<ScenarioEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final ScenarioEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public ScenarioEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return ScenarioEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_SCENARIO = "scenario";
  @SerializedName(SERIALIZED_NAME_SCENARIO)
  private ScenarioEnum scenario;

  public static final String SERIALIZED_NAME_SUB_SCENARIO = "subScenario";
  @SerializedName(SERIALIZED_NAME_SUB_SCENARIO)
  private String subScenario;

  public InteropTransactionTypeData() {
  }

  public InteropTransactionTypeData initiator(InitiatorEnum initiator) {
    
    this.initiator = initiator;
    return this;
  }

  /**
   * Get initiator
   * @return initiator
   */
  @javax.annotation.Nonnull

  public InitiatorEnum getInitiator() {
    return initiator;
  }


  public void setInitiator(InitiatorEnum initiator) {
    this.initiator = initiator;
  }

  public InteropTransactionTypeData initiatorType(InitiatorTypeEnum initiatorType) {
    
    this.initiatorType = initiatorType;
    return this;
  }

  /**
   * Get initiatorType
   * @return initiatorType
   */
  @javax.annotation.Nonnull

  public InitiatorTypeEnum getInitiatorType() {
    return initiatorType;
  }


  public void setInitiatorType(InitiatorTypeEnum initiatorType) {
    this.initiatorType = initiatorType;
  }

  public InteropTransactionTypeData scenario(ScenarioEnum scenario) {
    
    this.scenario = scenario;
    return this;
  }

  /**
   * Get scenario
   * @return scenario
   */
  @javax.annotation.Nonnull

  public ScenarioEnum getScenario() {
    return scenario;
  }


  public void setScenario(ScenarioEnum scenario) {
    this.scenario = scenario;
  }

  public InteropTransactionTypeData subScenario(String subScenario) {
    
    this.subScenario = subScenario;
    return this;
  }

  /**
   * Get subScenario
   * @return subScenario
   */
  @javax.annotation.Nullable

  public String getSubScenario() {
    return subScenario;
  }


  public void setSubScenario(String subScenario) {
    this.subScenario = subScenario;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InteropTransactionTypeData interopTransactionTypeData = (InteropTransactionTypeData) o;
    return Objects.equals(this.initiator, interopTransactionTypeData.initiator) &&
        Objects.equals(this.initiatorType, interopTransactionTypeData.initiatorType) &&
        Objects.equals(this.scenario, interopTransactionTypeData.scenario) &&
        Objects.equals(this.subScenario, interopTransactionTypeData.subScenario);
  }

  @Override
  public int hashCode() {
    return Objects.hash(initiator, initiatorType, scenario, subScenario);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InteropTransactionTypeData {\n");
    sb.append("    initiator: ").append(toIndentedString(initiator)).append("\n");
    sb.append("    initiatorType: ").append(toIndentedString(initiatorType)).append("\n");
    sb.append("    scenario: ").append(toIndentedString(scenario)).append("\n");
    sb.append("    subScenario: ").append(toIndentedString(subScenario)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

