/*
 * Apache Fineract REST API
 * Apache Fineract is a secure, multi-tenanted microfinance platform. The goal of the Apache Fineract API is to empower developers to build apps on top of the Apache Fineract Platform. The [reference app](https://cui.fineract.dev) (username: mifos, password: password) works on the same demo tenant as the interactive links in this documentation. Until we complete the new REST API documentation you still have the legacy documentation available [here](https://fineract.apache.org/docs/legacy/). Please check [the current Fineract documentation](https://fineract.apache.org/docs/current/) for more information.
 *
 * The version of the OpenAPI document: 1.13.0
 * Contact: dev@fineract.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.fineract.client.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;

/**
 * LoanProductBorrowerCycleVariations
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
public class LoanProductBorrowerCycleVariations {
  public static final String SERIALIZED_NAME_BORROWER_CYCLE_NUMBER = "borrowerCycleNumber";
  @SerializedName(SERIALIZED_NAME_BORROWER_CYCLE_NUMBER)
  private Integer borrowerCycleNumber;

  public static final String SERIALIZED_NAME_DEFAULT_VALUE = "defaultValue";
  @SerializedName(SERIALIZED_NAME_DEFAULT_VALUE)
  private BigDecimal defaultValue;

  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private Long id;

  public static final String SERIALIZED_NAME_MAX_VALUE = "maxValue";
  @SerializedName(SERIALIZED_NAME_MAX_VALUE)
  private BigDecimal maxValue;

  public static final String SERIALIZED_NAME_MIN_VALUE = "minValue";
  @SerializedName(SERIALIZED_NAME_MIN_VALUE)
  private BigDecimal minValue;

  public static final String SERIALIZED_NAME_NEW = "new";
  @SerializedName(SERIALIZED_NAME_NEW)
  private Boolean _new;

  /**
   * Gets or Sets paramType
   */
  @JsonAdapter(ParamTypeEnum.Adapter.class)
  public enum ParamTypeEnum {
    INVALID("INVALID"),
    
    PRINCIPAL("PRINCIPAL"),
    
    INTERESTRATE("INTERESTRATE"),
    
    REPAYMENT("REPAYMENT");

    private String value;

    ParamTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static ParamTypeEnum fromValue(String value) {
      for (ParamTypeEnum b : ParamTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<ParamTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final ParamTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public ParamTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return ParamTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_PARAM_TYPE = "paramType";
  @SerializedName(SERIALIZED_NAME_PARAM_TYPE)
  private ParamTypeEnum paramType;

  /**
   * Gets or Sets valueConditionType
   */
  @JsonAdapter(ValueConditionTypeEnum.Adapter.class)
  public enum ValueConditionTypeEnum {
    INVALID("INVALID"),
    
    EQUAL("EQUAL"),
    
    GREATERTHAN("GREATERTHAN");

    private String value;

    ValueConditionTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static ValueConditionTypeEnum fromValue(String value) {
      for (ValueConditionTypeEnum b : ValueConditionTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<ValueConditionTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final ValueConditionTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public ValueConditionTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return ValueConditionTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_VALUE_CONDITION_TYPE = "valueConditionType";
  @SerializedName(SERIALIZED_NAME_VALUE_CONDITION_TYPE)
  private ValueConditionTypeEnum valueConditionType;

  public LoanProductBorrowerCycleVariations() {
  }

  public LoanProductBorrowerCycleVariations borrowerCycleNumber(Integer borrowerCycleNumber) {
    
    this.borrowerCycleNumber = borrowerCycleNumber;
    return this;
  }

  /**
   * Get borrowerCycleNumber
   * @return borrowerCycleNumber
   */
  @javax.annotation.Nullable

  public Integer getBorrowerCycleNumber() {
    return borrowerCycleNumber;
  }


  public void setBorrowerCycleNumber(Integer borrowerCycleNumber) {
    this.borrowerCycleNumber = borrowerCycleNumber;
  }

  public LoanProductBorrowerCycleVariations defaultValue(BigDecimal defaultValue) {
    
    this.defaultValue = defaultValue;
    return this;
  }

  /**
   * Get defaultValue
   * @return defaultValue
   */
  @javax.annotation.Nullable

  public BigDecimal getDefaultValue() {
    return defaultValue;
  }


  public void setDefaultValue(BigDecimal defaultValue) {
    this.defaultValue = defaultValue;
  }

  public LoanProductBorrowerCycleVariations id(Long id) {
    
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
   */
  @javax.annotation.Nullable

  public Long getId() {
    return id;
  }


  public void setId(Long id) {
    this.id = id;
  }

  public LoanProductBorrowerCycleVariations maxValue(BigDecimal maxValue) {
    
    this.maxValue = maxValue;
    return this;
  }

  /**
   * Get maxValue
   * @return maxValue
   */
  @javax.annotation.Nullable

  public BigDecimal getMaxValue() {
    return maxValue;
  }


  public void setMaxValue(BigDecimal maxValue) {
    this.maxValue = maxValue;
  }

  public LoanProductBorrowerCycleVariations minValue(BigDecimal minValue) {
    
    this.minValue = minValue;
    return this;
  }

  /**
   * Get minValue
   * @return minValue
   */
  @javax.annotation.Nullable

  public BigDecimal getMinValue() {
    return minValue;
  }


  public void setMinValue(BigDecimal minValue) {
    this.minValue = minValue;
  }

  public LoanProductBorrowerCycleVariations _new(Boolean _new) {
    
    this._new = _new;
    return this;
  }

  /**
   * Get _new
   * @return _new
   */
  @javax.annotation.Nullable

  public Boolean getNew() {
    return _new;
  }


  public void setNew(Boolean _new) {
    this._new = _new;
  }

  public LoanProductBorrowerCycleVariations paramType(ParamTypeEnum paramType) {
    
    this.paramType = paramType;
    return this;
  }

  /**
   * Get paramType
   * @return paramType
   */
  @javax.annotation.Nullable

  public ParamTypeEnum getParamType() {
    return paramType;
  }


  public void setParamType(ParamTypeEnum paramType) {
    this.paramType = paramType;
  }

  public LoanProductBorrowerCycleVariations valueConditionType(ValueConditionTypeEnum valueConditionType) {
    
    this.valueConditionType = valueConditionType;
    return this;
  }

  /**
   * Get valueConditionType
   * @return valueConditionType
   */
  @javax.annotation.Nullable

  public ValueConditionTypeEnum getValueConditionType() {
    return valueConditionType;
  }


  public void setValueConditionType(ValueConditionTypeEnum valueConditionType) {
    this.valueConditionType = valueConditionType;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LoanProductBorrowerCycleVariations loanProductBorrowerCycleVariations = (LoanProductBorrowerCycleVariations) o;
    return Objects.equals(this.borrowerCycleNumber, loanProductBorrowerCycleVariations.borrowerCycleNumber) &&
        Objects.equals(this.defaultValue, loanProductBorrowerCycleVariations.defaultValue) &&
        Objects.equals(this.id, loanProductBorrowerCycleVariations.id) &&
        Objects.equals(this.maxValue, loanProductBorrowerCycleVariations.maxValue) &&
        Objects.equals(this.minValue, loanProductBorrowerCycleVariations.minValue) &&
        Objects.equals(this._new, loanProductBorrowerCycleVariations._new) &&
        Objects.equals(this.paramType, loanProductBorrowerCycleVariations.paramType) &&
        Objects.equals(this.valueConditionType, loanProductBorrowerCycleVariations.valueConditionType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(borrowerCycleNumber, defaultValue, id, maxValue, minValue, _new, paramType, valueConditionType);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LoanProductBorrowerCycleVariations {\n");
    sb.append("    borrowerCycleNumber: ").append(toIndentedString(borrowerCycleNumber)).append("\n");
    sb.append("    defaultValue: ").append(toIndentedString(defaultValue)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    maxValue: ").append(toIndentedString(maxValue)).append("\n");
    sb.append("    minValue: ").append(toIndentedString(minValue)).append("\n");
    sb.append("    _new: ").append(toIndentedString(_new)).append("\n");
    sb.append("    paramType: ").append(toIndentedString(paramType)).append("\n");
    sb.append("    valueConditionType: ").append(toIndentedString(valueConditionType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

