/*
 * Apache Fineract REST API
 * Apache Fineract is a secure, multi-tenanted microfinance platform. The goal of the Apache Fineract API is to empower developers to build apps on top of the Apache Fineract Platform. The [reference app](https://cui.fineract.dev) (username: mifos, password: password) works on the same demo tenant as the interactive links in this documentation. Until we complete the new REST API documentation you still have the legacy documentation available [here](https://fineract.apache.org/docs/legacy/). Please check [the current Fineract documentation](https://fineract.apache.org/docs/current/) for more information.
 *
 * The version of the OpenAPI document: 1.13.0
 * Contact: dev@fineract.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.fineract.client.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.fineract.client.models.AdvancedPaymentData;
import org.apache.fineract.client.models.AllowAttributeOverrides;
import org.apache.fineract.client.models.CreditAllocationData;
import org.apache.fineract.client.models.GetLoanPaymentChannelToFundSourceMappings;
import org.apache.fineract.client.models.LoanProductChargeData;
import org.apache.fineract.client.models.LoanProductChargeToGLAccountMapper;
import org.apache.fineract.client.models.PostChargeOffReasonToExpenseAccountMappings;
import org.apache.fineract.client.models.PostClassificationToIncomeAccountMappings;
import org.apache.fineract.client.models.PostWriteOffReasonToExpenseAccountMappings;
import org.apache.fineract.client.models.RateData;

/**
 * PostLoanProductsRequest
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
public class PostLoanProductsRequest {
  public static final String SERIALIZED_NAME_ACCOUNT_MOVES_OUT_OF_N_P_A_ONLY_ON_ARREARS_COMPLETION = "accountMovesOutOfNPAOnlyOnArrearsCompletion";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_MOVES_OUT_OF_N_P_A_ONLY_ON_ARREARS_COMPLETION)
  private Boolean accountMovesOutOfNPAOnlyOnArrearsCompletion;

  public static final String SERIALIZED_NAME_ACCOUNTING_RULE = "accountingRule";
  @SerializedName(SERIALIZED_NAME_ACCOUNTING_RULE)
  private Integer accountingRule;

  public static final String SERIALIZED_NAME_ALLOW_APPROVED_DISBURSED_AMOUNTS_OVER_APPLIED = "allowApprovedDisbursedAmountsOverApplied";
  @SerializedName(SERIALIZED_NAME_ALLOW_APPROVED_DISBURSED_AMOUNTS_OVER_APPLIED)
  private Boolean allowApprovedDisbursedAmountsOverApplied;

  public static final String SERIALIZED_NAME_ALLOW_ATTRIBUTE_OVERRIDES = "allowAttributeOverrides";
  @SerializedName(SERIALIZED_NAME_ALLOW_ATTRIBUTE_OVERRIDES)
  private AllowAttributeOverrides allowAttributeOverrides;

  public static final String SERIALIZED_NAME_ALLOW_COMPOUNDING_ON_EOD = "allowCompoundingOnEod";
  @SerializedName(SERIALIZED_NAME_ALLOW_COMPOUNDING_ON_EOD)
  private Boolean allowCompoundingOnEod;

  public static final String SERIALIZED_NAME_ALLOW_PARTIAL_PERIOD_INTEREST_CALCUALTION = "allowPartialPeriodInterestCalcualtion";
  @SerializedName(SERIALIZED_NAME_ALLOW_PARTIAL_PERIOD_INTEREST_CALCUALTION)
  private Boolean allowPartialPeriodInterestCalcualtion;

  public static final String SERIALIZED_NAME_ALLOW_VARIABLE_INSTALLMENTS = "allowVariableInstallments";
  @SerializedName(SERIALIZED_NAME_ALLOW_VARIABLE_INSTALLMENTS)
  private Boolean allowVariableInstallments;

  public static final String SERIALIZED_NAME_AMORTIZATION_TYPE = "amortizationType";
  @SerializedName(SERIALIZED_NAME_AMORTIZATION_TYPE)
  private Integer amortizationType;

  public static final String SERIALIZED_NAME_BUY_DOWN_EXPENSE_ACCOUNT_ID = "buyDownExpenseAccountId";
  @SerializedName(SERIALIZED_NAME_BUY_DOWN_EXPENSE_ACCOUNT_ID)
  private Long buyDownExpenseAccountId;

  /**
   * Gets or Sets buyDownFeeCalculationType
   */
  @JsonAdapter(BuyDownFeeCalculationTypeEnum.Adapter.class)
  public enum BuyDownFeeCalculationTypeEnum {
    FLAT("FLAT");

    private String value;

    BuyDownFeeCalculationTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static BuyDownFeeCalculationTypeEnum fromValue(String value) {
      for (BuyDownFeeCalculationTypeEnum b : BuyDownFeeCalculationTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<BuyDownFeeCalculationTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final BuyDownFeeCalculationTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public BuyDownFeeCalculationTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return BuyDownFeeCalculationTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_BUY_DOWN_FEE_CALCULATION_TYPE = "buyDownFeeCalculationType";
  @SerializedName(SERIALIZED_NAME_BUY_DOWN_FEE_CALCULATION_TYPE)
  private BuyDownFeeCalculationTypeEnum buyDownFeeCalculationType;

  /**
   * Gets or Sets buyDownFeeIncomeType
   */
  @JsonAdapter(BuyDownFeeIncomeTypeEnum.Adapter.class)
  public enum BuyDownFeeIncomeTypeEnum {
    FEE("FEE"),
    
    INTEREST("INTEREST");

    private String value;

    BuyDownFeeIncomeTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static BuyDownFeeIncomeTypeEnum fromValue(String value) {
      for (BuyDownFeeIncomeTypeEnum b : BuyDownFeeIncomeTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<BuyDownFeeIncomeTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final BuyDownFeeIncomeTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public BuyDownFeeIncomeTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return BuyDownFeeIncomeTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_BUY_DOWN_FEE_INCOME_TYPE = "buyDownFeeIncomeType";
  @SerializedName(SERIALIZED_NAME_BUY_DOWN_FEE_INCOME_TYPE)
  private BuyDownFeeIncomeTypeEnum buyDownFeeIncomeType;

  /**
   * Gets or Sets buyDownFeeStrategy
   */
  @JsonAdapter(BuyDownFeeStrategyEnum.Adapter.class)
  public enum BuyDownFeeStrategyEnum {
    EQUAL_AMORTIZATION("EQUAL_AMORTIZATION");

    private String value;

    BuyDownFeeStrategyEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static BuyDownFeeStrategyEnum fromValue(String value) {
      for (BuyDownFeeStrategyEnum b : BuyDownFeeStrategyEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<BuyDownFeeStrategyEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final BuyDownFeeStrategyEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public BuyDownFeeStrategyEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return BuyDownFeeStrategyEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_BUY_DOWN_FEE_STRATEGY = "buyDownFeeStrategy";
  @SerializedName(SERIALIZED_NAME_BUY_DOWN_FEE_STRATEGY)
  private BuyDownFeeStrategyEnum buyDownFeeStrategy;

  public static final String SERIALIZED_NAME_BUYDOWNFEE_CLASSIFICATION_TO_INCOME_ACCOUNT_MAPPINGS = "buydownfeeClassificationToIncomeAccountMappings";
  @SerializedName(SERIALIZED_NAME_BUYDOWNFEE_CLASSIFICATION_TO_INCOME_ACCOUNT_MAPPINGS)
  private List<PostClassificationToIncomeAccountMappings> buydownfeeClassificationToIncomeAccountMappings;

  public static final String SERIALIZED_NAME_CAN_DEFINE_INSTALLMENT_AMOUNT = "canDefineInstallmentAmount";
  @SerializedName(SERIALIZED_NAME_CAN_DEFINE_INSTALLMENT_AMOUNT)
  private Boolean canDefineInstallmentAmount;

  public static final String SERIALIZED_NAME_CAN_USE_FOR_TOPUP = "canUseForTopup";
  @SerializedName(SERIALIZED_NAME_CAN_USE_FOR_TOPUP)
  private Boolean canUseForTopup;

  /**
   * Gets or Sets capitalizedIncomeCalculationType
   */
  @JsonAdapter(CapitalizedIncomeCalculationTypeEnum.Adapter.class)
  public enum CapitalizedIncomeCalculationTypeEnum {
    FLAT("FLAT");

    private String value;

    CapitalizedIncomeCalculationTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static CapitalizedIncomeCalculationTypeEnum fromValue(String value) {
      for (CapitalizedIncomeCalculationTypeEnum b : CapitalizedIncomeCalculationTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<CapitalizedIncomeCalculationTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final CapitalizedIncomeCalculationTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public CapitalizedIncomeCalculationTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return CapitalizedIncomeCalculationTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_CAPITALIZED_INCOME_CALCULATION_TYPE = "capitalizedIncomeCalculationType";
  @SerializedName(SERIALIZED_NAME_CAPITALIZED_INCOME_CALCULATION_TYPE)
  private CapitalizedIncomeCalculationTypeEnum capitalizedIncomeCalculationType;

  public static final String SERIALIZED_NAME_CAPITALIZED_INCOME_CLASSIFICATION_TO_INCOME_ACCOUNT_MAPPINGS = "capitalizedIncomeClassificationToIncomeAccountMappings";
  @SerializedName(SERIALIZED_NAME_CAPITALIZED_INCOME_CLASSIFICATION_TO_INCOME_ACCOUNT_MAPPINGS)
  private List<PostClassificationToIncomeAccountMappings> capitalizedIncomeClassificationToIncomeAccountMappings;

  /**
   * Gets or Sets capitalizedIncomeStrategy
   */
  @JsonAdapter(CapitalizedIncomeStrategyEnum.Adapter.class)
  public enum CapitalizedIncomeStrategyEnum {
    EQUAL_AMORTIZATION("EQUAL_AMORTIZATION");

    private String value;

    CapitalizedIncomeStrategyEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static CapitalizedIncomeStrategyEnum fromValue(String value) {
      for (CapitalizedIncomeStrategyEnum b : CapitalizedIncomeStrategyEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<CapitalizedIncomeStrategyEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final CapitalizedIncomeStrategyEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public CapitalizedIncomeStrategyEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return CapitalizedIncomeStrategyEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_CAPITALIZED_INCOME_STRATEGY = "capitalizedIncomeStrategy";
  @SerializedName(SERIALIZED_NAME_CAPITALIZED_INCOME_STRATEGY)
  private CapitalizedIncomeStrategyEnum capitalizedIncomeStrategy;

  /**
   * Gets or Sets capitalizedIncomeType
   */
  @JsonAdapter(CapitalizedIncomeTypeEnum.Adapter.class)
  public enum CapitalizedIncomeTypeEnum {
    FEE("FEE"),
    
    INTEREST("INTEREST");

    private String value;

    CapitalizedIncomeTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static CapitalizedIncomeTypeEnum fromValue(String value) {
      for (CapitalizedIncomeTypeEnum b : CapitalizedIncomeTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<CapitalizedIncomeTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final CapitalizedIncomeTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public CapitalizedIncomeTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return CapitalizedIncomeTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_CAPITALIZED_INCOME_TYPE = "capitalizedIncomeType";
  @SerializedName(SERIALIZED_NAME_CAPITALIZED_INCOME_TYPE)
  private CapitalizedIncomeTypeEnum capitalizedIncomeType;

  public static final String SERIALIZED_NAME_CHARGE_OFF_BEHAVIOUR = "chargeOffBehaviour";
  @SerializedName(SERIALIZED_NAME_CHARGE_OFF_BEHAVIOUR)
  private String chargeOffBehaviour;

  public static final String SERIALIZED_NAME_CHARGE_OFF_EXPENSE_ACCOUNT_ID = "chargeOffExpenseAccountId";
  @SerializedName(SERIALIZED_NAME_CHARGE_OFF_EXPENSE_ACCOUNT_ID)
  private Long chargeOffExpenseAccountId;

  public static final String SERIALIZED_NAME_CHARGE_OFF_FRAUD_EXPENSE_ACCOUNT_ID = "chargeOffFraudExpenseAccountId";
  @SerializedName(SERIALIZED_NAME_CHARGE_OFF_FRAUD_EXPENSE_ACCOUNT_ID)
  private Long chargeOffFraudExpenseAccountId;

  public static final String SERIALIZED_NAME_CHARGE_OFF_REASON_TO_EXPENSE_ACCOUNT_MAPPINGS = "chargeOffReasonToExpenseAccountMappings";
  @SerializedName(SERIALIZED_NAME_CHARGE_OFF_REASON_TO_EXPENSE_ACCOUNT_MAPPINGS)
  private List<PostChargeOffReasonToExpenseAccountMappings> chargeOffReasonToExpenseAccountMappings;

  public static final String SERIALIZED_NAME_CHARGES = "charges";
  @SerializedName(SERIALIZED_NAME_CHARGES)
  private List<LoanProductChargeData> charges;

  public static final String SERIALIZED_NAME_CLOSE_DATE = "closeDate";
  @SerializedName(SERIALIZED_NAME_CLOSE_DATE)
  private String closeDate;

  public static final String SERIALIZED_NAME_CREDIT_ALLOCATION = "creditAllocation";
  @SerializedName(SERIALIZED_NAME_CREDIT_ALLOCATION)
  private List<CreditAllocationData> creditAllocation;

  public static final String SERIALIZED_NAME_CURRENCY_CODE = "currencyCode";
  @SerializedName(SERIALIZED_NAME_CURRENCY_CODE)
  private String currencyCode;

  public static final String SERIALIZED_NAME_DATE_FORMAT = "dateFormat";
  @SerializedName(SERIALIZED_NAME_DATE_FORMAT)
  private String dateFormat;

  public static final String SERIALIZED_NAME_DAYS_IN_MONTH_TYPE = "daysInMonthType";
  @SerializedName(SERIALIZED_NAME_DAYS_IN_MONTH_TYPE)
  private Integer daysInMonthType;

  public static final String SERIALIZED_NAME_DAYS_IN_YEAR_CUSTOM_STRATEGY = "daysInYearCustomStrategy";
  @SerializedName(SERIALIZED_NAME_DAYS_IN_YEAR_CUSTOM_STRATEGY)
  private String daysInYearCustomStrategy;

  public static final String SERIALIZED_NAME_DAYS_IN_YEAR_TYPE = "daysInYearType";
  @SerializedName(SERIALIZED_NAME_DAYS_IN_YEAR_TYPE)
  private Integer daysInYearType;

  public static final String SERIALIZED_NAME_DEFERRED_INCOME_LIABILITY_ACCOUNT_ID = "deferredIncomeLiabilityAccountId";
  @SerializedName(SERIALIZED_NAME_DEFERRED_INCOME_LIABILITY_ACCOUNT_ID)
  private Long deferredIncomeLiabilityAccountId;

  public static final String SERIALIZED_NAME_DELINQUENCY_BUCKET_ID = "delinquencyBucketId";
  @SerializedName(SERIALIZED_NAME_DELINQUENCY_BUCKET_ID)
  private Long delinquencyBucketId;

  public static final String SERIALIZED_NAME_DESCRIPTION = "description";
  @SerializedName(SERIALIZED_NAME_DESCRIPTION)
  private String description;

  public static final String SERIALIZED_NAME_DIGITS_AFTER_DECIMAL = "digitsAfterDecimal";
  @SerializedName(SERIALIZED_NAME_DIGITS_AFTER_DECIMAL)
  private Integer digitsAfterDecimal;

  public static final String SERIALIZED_NAME_DISALLOW_EXPECTED_DISBURSEMENTS = "disallowExpectedDisbursements";
  @SerializedName(SERIALIZED_NAME_DISALLOW_EXPECTED_DISBURSEMENTS)
  private Boolean disallowExpectedDisbursements;

  public static final String SERIALIZED_NAME_DISALLOW_INTEREST_CALCULATION_ON_PAST_DUE = "disallowInterestCalculationOnPastDue";
  @SerializedName(SERIALIZED_NAME_DISALLOW_INTEREST_CALCULATION_ON_PAST_DUE)
  private Boolean disallowInterestCalculationOnPastDue;

  public static final String SERIALIZED_NAME_DISBURSED_AMOUNT_PERCENTAGE_FOR_DOWN_PAYMENT = "disbursedAmountPercentageForDownPayment";
  @SerializedName(SERIALIZED_NAME_DISBURSED_AMOUNT_PERCENTAGE_FOR_DOWN_PAYMENT)
  private BigDecimal disbursedAmountPercentageForDownPayment;

  public static final String SERIALIZED_NAME_DUE_DAYS_FOR_REPAYMENT_EVENT = "dueDaysForRepaymentEvent";
  @SerializedName(SERIALIZED_NAME_DUE_DAYS_FOR_REPAYMENT_EVENT)
  private Integer dueDaysForRepaymentEvent;

  public static final String SERIALIZED_NAME_ENABLE_ACCRUAL_ACTIVITY_POSTING = "enableAccrualActivityPosting";
  @SerializedName(SERIALIZED_NAME_ENABLE_ACCRUAL_ACTIVITY_POSTING)
  private Boolean enableAccrualActivityPosting;

  public static final String SERIALIZED_NAME_ENABLE_AUTO_REPAYMENT_FOR_DOWN_PAYMENT = "enableAutoRepaymentForDownPayment";
  @SerializedName(SERIALIZED_NAME_ENABLE_AUTO_REPAYMENT_FOR_DOWN_PAYMENT)
  private Boolean enableAutoRepaymentForDownPayment;

  public static final String SERIALIZED_NAME_ENABLE_BUY_DOWN_FEE = "enableBuyDownFee";
  @SerializedName(SERIALIZED_NAME_ENABLE_BUY_DOWN_FEE)
  private Boolean enableBuyDownFee;

  public static final String SERIALIZED_NAME_ENABLE_DOWN_PAYMENT = "enableDownPayment";
  @SerializedName(SERIALIZED_NAME_ENABLE_DOWN_PAYMENT)
  private Boolean enableDownPayment;

  public static final String SERIALIZED_NAME_ENABLE_INCOME_CAPITALIZATION = "enableIncomeCapitalization";
  @SerializedName(SERIALIZED_NAME_ENABLE_INCOME_CAPITALIZATION)
  private Boolean enableIncomeCapitalization;

  public static final String SERIALIZED_NAME_ENABLE_INSTALLMENT_LEVEL_DELINQUENCY = "enableInstallmentLevelDelinquency";
  @SerializedName(SERIALIZED_NAME_ENABLE_INSTALLMENT_LEVEL_DELINQUENCY)
  private Boolean enableInstallmentLevelDelinquency;

  public static final String SERIALIZED_NAME_EXTERNAL_ID = "externalId";
  @SerializedName(SERIALIZED_NAME_EXTERNAL_ID)
  private String externalId;

  public static final String SERIALIZED_NAME_FEE_TO_INCOME_ACCOUNT_MAPPINGS = "feeToIncomeAccountMappings";
  @SerializedName(SERIALIZED_NAME_FEE_TO_INCOME_ACCOUNT_MAPPINGS)
  private List<LoanProductChargeToGLAccountMapper> feeToIncomeAccountMappings;

  public static final String SERIALIZED_NAME_FIXED_LENGTH = "fixedLength";
  @SerializedName(SERIALIZED_NAME_FIXED_LENGTH)
  private Integer fixedLength;

  public static final String SERIALIZED_NAME_FIXED_PRINCIPAL_PERCENTAGE_PER_INSTALLMENT = "fixedPrincipalPercentagePerInstallment";
  @SerializedName(SERIALIZED_NAME_FIXED_PRINCIPAL_PERCENTAGE_PER_INSTALLMENT)
  private BigDecimal fixedPrincipalPercentagePerInstallment;

  public static final String SERIALIZED_NAME_FUND_ID = "fundId";
  @SerializedName(SERIALIZED_NAME_FUND_ID)
  private Long fundId;

  public static final String SERIALIZED_NAME_FUND_SOURCE_ACCOUNT_ID = "fundSourceAccountId";
  @SerializedName(SERIALIZED_NAME_FUND_SOURCE_ACCOUNT_ID)
  private Long fundSourceAccountId;

  public static final String SERIALIZED_NAME_GOODWILL_CREDIT_ACCOUNT_ID = "goodwillCreditAccountId";
  @SerializedName(SERIALIZED_NAME_GOODWILL_CREDIT_ACCOUNT_ID)
  private Long goodwillCreditAccountId;

  public static final String SERIALIZED_NAME_GRACE_ON_ARREARS_AGEING = "graceOnArrearsAgeing";
  @SerializedName(SERIALIZED_NAME_GRACE_ON_ARREARS_AGEING)
  private Integer graceOnArrearsAgeing;

  public static final String SERIALIZED_NAME_GRACE_ON_INTEREST_PAYMENT = "graceOnInterestPayment";
  @SerializedName(SERIALIZED_NAME_GRACE_ON_INTEREST_PAYMENT)
  private Integer graceOnInterestPayment;

  public static final String SERIALIZED_NAME_GRACE_ON_PRINCIPAL_PAYMENT = "graceOnPrincipalPayment";
  @SerializedName(SERIALIZED_NAME_GRACE_ON_PRINCIPAL_PAYMENT)
  private Integer graceOnPrincipalPayment;

  public static final String SERIALIZED_NAME_HOLD_GUARANTEE_FUNDS = "holdGuaranteeFunds";
  @SerializedName(SERIALIZED_NAME_HOLD_GUARANTEE_FUNDS)
  private Boolean holdGuaranteeFunds;

  public static final String SERIALIZED_NAME_IN_ARREARS_TOLERANCE = "inArrearsTolerance";
  @SerializedName(SERIALIZED_NAME_IN_ARREARS_TOLERANCE)
  private Integer inArrearsTolerance;

  public static final String SERIALIZED_NAME_IN_MULTIPLES_OF = "inMultiplesOf";
  @SerializedName(SERIALIZED_NAME_IN_MULTIPLES_OF)
  private Integer inMultiplesOf;

  public static final String SERIALIZED_NAME_INCLUDE_IN_BORROWER_CYCLE = "includeInBorrowerCycle";
  @SerializedName(SERIALIZED_NAME_INCLUDE_IN_BORROWER_CYCLE)
  private Boolean includeInBorrowerCycle;

  public static final String SERIALIZED_NAME_INCOME_FROM_BUY_DOWN_ACCOUNT_ID = "incomeFromBuyDownAccountId";
  @SerializedName(SERIALIZED_NAME_INCOME_FROM_BUY_DOWN_ACCOUNT_ID)
  private Long incomeFromBuyDownAccountId;

  public static final String SERIALIZED_NAME_INCOME_FROM_CAPITALIZATION_ACCOUNT_ID = "incomeFromCapitalizationAccountId";
  @SerializedName(SERIALIZED_NAME_INCOME_FROM_CAPITALIZATION_ACCOUNT_ID)
  private Long incomeFromCapitalizationAccountId;

  public static final String SERIALIZED_NAME_INCOME_FROM_CHARGE_OFF_FEES_ACCOUNT_ID = "incomeFromChargeOffFeesAccountId";
  @SerializedName(SERIALIZED_NAME_INCOME_FROM_CHARGE_OFF_FEES_ACCOUNT_ID)
  private Long incomeFromChargeOffFeesAccountId;

  public static final String SERIALIZED_NAME_INCOME_FROM_CHARGE_OFF_INTEREST_ACCOUNT_ID = "incomeFromChargeOffInterestAccountId";
  @SerializedName(SERIALIZED_NAME_INCOME_FROM_CHARGE_OFF_INTEREST_ACCOUNT_ID)
  private Long incomeFromChargeOffInterestAccountId;

  public static final String SERIALIZED_NAME_INCOME_FROM_CHARGE_OFF_PENALTY_ACCOUNT_ID = "incomeFromChargeOffPenaltyAccountId";
  @SerializedName(SERIALIZED_NAME_INCOME_FROM_CHARGE_OFF_PENALTY_ACCOUNT_ID)
  private Long incomeFromChargeOffPenaltyAccountId;

  public static final String SERIALIZED_NAME_INCOME_FROM_FEE_ACCOUNT_ID = "incomeFromFeeAccountId";
  @SerializedName(SERIALIZED_NAME_INCOME_FROM_FEE_ACCOUNT_ID)
  private Long incomeFromFeeAccountId;

  public static final String SERIALIZED_NAME_INCOME_FROM_GOODWILL_CREDIT_FEES_ACCOUNT_ID = "incomeFromGoodwillCreditFeesAccountId";
  @SerializedName(SERIALIZED_NAME_INCOME_FROM_GOODWILL_CREDIT_FEES_ACCOUNT_ID)
  private Long incomeFromGoodwillCreditFeesAccountId;

  public static final String SERIALIZED_NAME_INCOME_FROM_GOODWILL_CREDIT_INTEREST_ACCOUNT_ID = "incomeFromGoodwillCreditInterestAccountId";
  @SerializedName(SERIALIZED_NAME_INCOME_FROM_GOODWILL_CREDIT_INTEREST_ACCOUNT_ID)
  private Long incomeFromGoodwillCreditInterestAccountId;

  public static final String SERIALIZED_NAME_INCOME_FROM_GOODWILL_CREDIT_PENALTY_ACCOUNT_ID = "incomeFromGoodwillCreditPenaltyAccountId";
  @SerializedName(SERIALIZED_NAME_INCOME_FROM_GOODWILL_CREDIT_PENALTY_ACCOUNT_ID)
  private Long incomeFromGoodwillCreditPenaltyAccountId;

  public static final String SERIALIZED_NAME_INCOME_FROM_PENALTY_ACCOUNT_ID = "incomeFromPenaltyAccountId";
  @SerializedName(SERIALIZED_NAME_INCOME_FROM_PENALTY_ACCOUNT_ID)
  private Long incomeFromPenaltyAccountId;

  public static final String SERIALIZED_NAME_INCOME_FROM_RECOVERY_ACCOUNT_ID = "incomeFromRecoveryAccountId";
  @SerializedName(SERIALIZED_NAME_INCOME_FROM_RECOVERY_ACCOUNT_ID)
  private Long incomeFromRecoveryAccountId;

  public static final String SERIALIZED_NAME_INSTALLMENT_AMOUNT_IN_MULTIPLES_OF = "installmentAmountInMultiplesOf";
  @SerializedName(SERIALIZED_NAME_INSTALLMENT_AMOUNT_IN_MULTIPLES_OF)
  private Integer installmentAmountInMultiplesOf;

  public static final String SERIALIZED_NAME_INTEREST_CALCULATION_PERIOD_TYPE = "interestCalculationPeriodType";
  @SerializedName(SERIALIZED_NAME_INTEREST_CALCULATION_PERIOD_TYPE)
  private Integer interestCalculationPeriodType;

  public static final String SERIALIZED_NAME_INTEREST_ON_LOAN_ACCOUNT_ID = "interestOnLoanAccountId";
  @SerializedName(SERIALIZED_NAME_INTEREST_ON_LOAN_ACCOUNT_ID)
  private Long interestOnLoanAccountId;

  public static final String SERIALIZED_NAME_INTEREST_RATE_FREQUENCY_TYPE = "interestRateFrequencyType";
  @SerializedName(SERIALIZED_NAME_INTEREST_RATE_FREQUENCY_TYPE)
  private Integer interestRateFrequencyType;

  public static final String SERIALIZED_NAME_INTEREST_RATE_PER_PERIOD = "interestRatePerPeriod";
  @SerializedName(SERIALIZED_NAME_INTEREST_RATE_PER_PERIOD)
  private Double interestRatePerPeriod;

  public static final String SERIALIZED_NAME_INTEREST_RATE_VARIATIONS_FOR_BORROWER_CYCLE = "interestRateVariationsForBorrowerCycle";
  @SerializedName(SERIALIZED_NAME_INTEREST_RATE_VARIATIONS_FOR_BORROWER_CYCLE)
  private List<Integer> interestRateVariationsForBorrowerCycle;

  public static final String SERIALIZED_NAME_INTEREST_RECALCULATION_COMPOUNDING_METHOD = "interestRecalculationCompoundingMethod";
  @SerializedName(SERIALIZED_NAME_INTEREST_RECALCULATION_COMPOUNDING_METHOD)
  private Integer interestRecalculationCompoundingMethod;

  public static final String SERIALIZED_NAME_INTEREST_RECOGNITION_ON_DISBURSEMENT_DATE = "interestRecognitionOnDisbursementDate";
  @SerializedName(SERIALIZED_NAME_INTEREST_RECOGNITION_ON_DISBURSEMENT_DATE)
  private Boolean interestRecognitionOnDisbursementDate;

  public static final String SERIALIZED_NAME_INTEREST_TYPE = "interestType";
  @SerializedName(SERIALIZED_NAME_INTEREST_TYPE)
  private Integer interestType;

  public static final String SERIALIZED_NAME_IS_ARREARS_BASED_ON_ORIGINAL_SCHEDULE = "isArrearsBasedOnOriginalSchedule";
  @SerializedName(SERIALIZED_NAME_IS_ARREARS_BASED_ON_ORIGINAL_SCHEDULE)
  private Boolean isArrearsBasedOnOriginalSchedule;

  public static final String SERIALIZED_NAME_IS_COMPOUNDING_TO_BE_POSTED_AS_TRANSACTION = "isCompoundingToBePostedAsTransaction";
  @SerializedName(SERIALIZED_NAME_IS_COMPOUNDING_TO_BE_POSTED_AS_TRANSACTION)
  private Boolean isCompoundingToBePostedAsTransaction;

  public static final String SERIALIZED_NAME_IS_EQUAL_AMORTIZATION = "isEqualAmortization";
  @SerializedName(SERIALIZED_NAME_IS_EQUAL_AMORTIZATION)
  private Boolean isEqualAmortization;

  public static final String SERIALIZED_NAME_IS_INTEREST_RECALCULATION_ENABLED = "isInterestRecalculationEnabled";
  @SerializedName(SERIALIZED_NAME_IS_INTEREST_RECALCULATION_ENABLED)
  private Boolean isInterestRecalculationEnabled;

  public static final String SERIALIZED_NAME_IS_LINKED_TO_FLOATING_INTEREST_RATES = "isLinkedToFloatingInterestRates";
  @SerializedName(SERIALIZED_NAME_IS_LINKED_TO_FLOATING_INTEREST_RATES)
  private Boolean isLinkedToFloatingInterestRates;

  public static final String SERIALIZED_NAME_LOAN_PORTFOLIO_ACCOUNT_ID = "loanPortfolioAccountId";
  @SerializedName(SERIALIZED_NAME_LOAN_PORTFOLIO_ACCOUNT_ID)
  private Long loanPortfolioAccountId;

  public static final String SERIALIZED_NAME_LOAN_SCHEDULE_PROCESSING_TYPE = "loanScheduleProcessingType";
  @SerializedName(SERIALIZED_NAME_LOAN_SCHEDULE_PROCESSING_TYPE)
  private String loanScheduleProcessingType;

  public static final String SERIALIZED_NAME_LOAN_SCHEDULE_TYPE = "loanScheduleType";
  @SerializedName(SERIALIZED_NAME_LOAN_SCHEDULE_TYPE)
  private String loanScheduleType;

  public static final String SERIALIZED_NAME_LOCALE = "locale";
  @SerializedName(SERIALIZED_NAME_LOCALE)
  private String locale;

  public static final String SERIALIZED_NAME_MAX_INTEREST_RATE_PER_PERIOD = "maxInterestRatePerPeriod";
  @SerializedName(SERIALIZED_NAME_MAX_INTEREST_RATE_PER_PERIOD)
  private Double maxInterestRatePerPeriod;

  public static final String SERIALIZED_NAME_MAX_NUMBER_OF_REPAYMENTS = "maxNumberOfRepayments";
  @SerializedName(SERIALIZED_NAME_MAX_NUMBER_OF_REPAYMENTS)
  private Integer maxNumberOfRepayments;

  public static final String SERIALIZED_NAME_MAX_PRINCIPAL = "maxPrincipal";
  @SerializedName(SERIALIZED_NAME_MAX_PRINCIPAL)
  private Double maxPrincipal;

  public static final String SERIALIZED_NAME_MAX_TRANCHE_COUNT = "maxTrancheCount";
  @SerializedName(SERIALIZED_NAME_MAX_TRANCHE_COUNT)
  private Integer maxTrancheCount;

  public static final String SERIALIZED_NAME_MERCHANT_BUY_DOWN_FEE = "merchantBuyDownFee";
  @SerializedName(SERIALIZED_NAME_MERCHANT_BUY_DOWN_FEE)
  private Boolean merchantBuyDownFee;

  public static final String SERIALIZED_NAME_MIN_INTEREST_RATE_PER_PERIOD = "minInterestRatePerPeriod";
  @SerializedName(SERIALIZED_NAME_MIN_INTEREST_RATE_PER_PERIOD)
  private Double minInterestRatePerPeriod;

  public static final String SERIALIZED_NAME_MIN_NUMBER_OF_REPAYMENTS = "minNumberOfRepayments";
  @SerializedName(SERIALIZED_NAME_MIN_NUMBER_OF_REPAYMENTS)
  private Integer minNumberOfRepayments;

  public static final String SERIALIZED_NAME_MIN_PRINCIPAL = "minPrincipal";
  @SerializedName(SERIALIZED_NAME_MIN_PRINCIPAL)
  private Double minPrincipal;

  public static final String SERIALIZED_NAME_MINIMUM_DAYS_BETWEEN_DISBURSAL_AND_FIRST_REPAYMENT = "minimumDaysBetweenDisbursalAndFirstRepayment";
  @SerializedName(SERIALIZED_NAME_MINIMUM_DAYS_BETWEEN_DISBURSAL_AND_FIRST_REPAYMENT)
  private Integer minimumDaysBetweenDisbursalAndFirstRepayment;

  public static final String SERIALIZED_NAME_MULTI_DISBURSE_LOAN = "multiDisburseLoan";
  @SerializedName(SERIALIZED_NAME_MULTI_DISBURSE_LOAN)
  private Boolean multiDisburseLoan;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_NUMBER_OF_REPAYMENT_VARIATIONS_FOR_BORROWER_CYCLE = "numberOfRepaymentVariationsForBorrowerCycle";
  @SerializedName(SERIALIZED_NAME_NUMBER_OF_REPAYMENT_VARIATIONS_FOR_BORROWER_CYCLE)
  private List<Integer> numberOfRepaymentVariationsForBorrowerCycle;

  public static final String SERIALIZED_NAME_NUMBER_OF_REPAYMENTS = "numberOfRepayments";
  @SerializedName(SERIALIZED_NAME_NUMBER_OF_REPAYMENTS)
  private Integer numberOfRepayments;

  public static final String SERIALIZED_NAME_OUTSTANDING_LOAN_BALANCE = "outstandingLoanBalance";
  @SerializedName(SERIALIZED_NAME_OUTSTANDING_LOAN_BALANCE)
  private Double outstandingLoanBalance;

  public static final String SERIALIZED_NAME_OVER_APPLIED_CALCULATION_TYPE = "overAppliedCalculationType";
  @SerializedName(SERIALIZED_NAME_OVER_APPLIED_CALCULATION_TYPE)
  private String overAppliedCalculationType;

  public static final String SERIALIZED_NAME_OVER_APPLIED_NUMBER = "overAppliedNumber";
  @SerializedName(SERIALIZED_NAME_OVER_APPLIED_NUMBER)
  private Integer overAppliedNumber;

  public static final String SERIALIZED_NAME_OVER_DUE_DAYS_FOR_REPAYMENT_EVENT = "overDueDaysForRepaymentEvent";
  @SerializedName(SERIALIZED_NAME_OVER_DUE_DAYS_FOR_REPAYMENT_EVENT)
  private Integer overDueDaysForRepaymentEvent;

  public static final String SERIALIZED_NAME_OVERDUE_DAYS_FOR_N_P_A = "overdueDaysForNPA";
  @SerializedName(SERIALIZED_NAME_OVERDUE_DAYS_FOR_N_P_A)
  private Integer overdueDaysForNPA;

  public static final String SERIALIZED_NAME_OVERPAYMENT_LIABILITY_ACCOUNT_ID = "overpaymentLiabilityAccountId";
  @SerializedName(SERIALIZED_NAME_OVERPAYMENT_LIABILITY_ACCOUNT_ID)
  private Long overpaymentLiabilityAccountId;

  public static final String SERIALIZED_NAME_PAYMENT_ALLOCATION = "paymentAllocation";
  @SerializedName(SERIALIZED_NAME_PAYMENT_ALLOCATION)
  private List<AdvancedPaymentData> paymentAllocation;

  public static final String SERIALIZED_NAME_PAYMENT_CHANNEL_TO_FUND_SOURCE_MAPPINGS = "paymentChannelToFundSourceMappings";
  @SerializedName(SERIALIZED_NAME_PAYMENT_CHANNEL_TO_FUND_SOURCE_MAPPINGS)
  private List<GetLoanPaymentChannelToFundSourceMappings> paymentChannelToFundSourceMappings;

  public static final String SERIALIZED_NAME_PENALTY_TO_INCOME_ACCOUNT_MAPPINGS = "penaltyToIncomeAccountMappings";
  @SerializedName(SERIALIZED_NAME_PENALTY_TO_INCOME_ACCOUNT_MAPPINGS)
  private List<LoanProductChargeToGLAccountMapper> penaltyToIncomeAccountMappings;

  public static final String SERIALIZED_NAME_PRE_CLOSURE_INTEREST_CALCULATION_STRATEGY = "preClosureInterestCalculationStrategy";
  @SerializedName(SERIALIZED_NAME_PRE_CLOSURE_INTEREST_CALCULATION_STRATEGY)
  private Integer preClosureInterestCalculationStrategy;

  public static final String SERIALIZED_NAME_PRINCIPAL = "principal";
  @SerializedName(SERIALIZED_NAME_PRINCIPAL)
  private Double principal;

  public static final String SERIALIZED_NAME_PRINCIPAL_THRESHOLD_FOR_LAST_INSTALLMENT = "principalThresholdForLastInstallment";
  @SerializedName(SERIALIZED_NAME_PRINCIPAL_THRESHOLD_FOR_LAST_INSTALLMENT)
  private Integer principalThresholdForLastInstallment;

  public static final String SERIALIZED_NAME_PRINCIPAL_VARIATIONS_FOR_BORROWER_CYCLE = "principalVariationsForBorrowerCycle";
  @SerializedName(SERIALIZED_NAME_PRINCIPAL_VARIATIONS_FOR_BORROWER_CYCLE)
  private List<Integer> principalVariationsForBorrowerCycle;

  public static final String SERIALIZED_NAME_RATES = "rates";
  @SerializedName(SERIALIZED_NAME_RATES)
  private List<RateData> rates;

  public static final String SERIALIZED_NAME_RECALCULATION_COMPOUNDING_FREQUENCY_INTERVAL = "recalculationCompoundingFrequencyInterval";
  @SerializedName(SERIALIZED_NAME_RECALCULATION_COMPOUNDING_FREQUENCY_INTERVAL)
  private Integer recalculationCompoundingFrequencyInterval;

  public static final String SERIALIZED_NAME_RECALCULATION_COMPOUNDING_FREQUENCY_ON_DAY_TYPE = "recalculationCompoundingFrequencyOnDayType";
  @SerializedName(SERIALIZED_NAME_RECALCULATION_COMPOUNDING_FREQUENCY_ON_DAY_TYPE)
  private Integer recalculationCompoundingFrequencyOnDayType;

  public static final String SERIALIZED_NAME_RECALCULATION_COMPOUNDING_FREQUENCY_TYPE = "recalculationCompoundingFrequencyType";
  @SerializedName(SERIALIZED_NAME_RECALCULATION_COMPOUNDING_FREQUENCY_TYPE)
  private Integer recalculationCompoundingFrequencyType;

  public static final String SERIALIZED_NAME_RECALCULATION_REST_FREQUENCY_INTERVAL = "recalculationRestFrequencyInterval";
  @SerializedName(SERIALIZED_NAME_RECALCULATION_REST_FREQUENCY_INTERVAL)
  private Integer recalculationRestFrequencyInterval;

  public static final String SERIALIZED_NAME_RECALCULATION_REST_FREQUENCY_TYPE = "recalculationRestFrequencyType";
  @SerializedName(SERIALIZED_NAME_RECALCULATION_REST_FREQUENCY_TYPE)
  private Integer recalculationRestFrequencyType;

  public static final String SERIALIZED_NAME_RECEIVABLE_FEE_ACCOUNT_ID = "receivableFeeAccountId";
  @SerializedName(SERIALIZED_NAME_RECEIVABLE_FEE_ACCOUNT_ID)
  private Long receivableFeeAccountId;

  public static final String SERIALIZED_NAME_RECEIVABLE_INTEREST_ACCOUNT_ID = "receivableInterestAccountId";
  @SerializedName(SERIALIZED_NAME_RECEIVABLE_INTEREST_ACCOUNT_ID)
  private Long receivableInterestAccountId;

  public static final String SERIALIZED_NAME_RECEIVABLE_PENALTY_ACCOUNT_ID = "receivablePenaltyAccountId";
  @SerializedName(SERIALIZED_NAME_RECEIVABLE_PENALTY_ACCOUNT_ID)
  private Long receivablePenaltyAccountId;

  public static final String SERIALIZED_NAME_REPAYMENT_EVERY = "repaymentEvery";
  @SerializedName(SERIALIZED_NAME_REPAYMENT_EVERY)
  private Integer repaymentEvery;

  public static final String SERIALIZED_NAME_REPAYMENT_FREQUENCY_TYPE = "repaymentFrequencyType";
  @SerializedName(SERIALIZED_NAME_REPAYMENT_FREQUENCY_TYPE)
  private Long repaymentFrequencyType;

  public static final String SERIALIZED_NAME_REPAYMENT_START_DATE_TYPE = "repaymentStartDateType";
  @SerializedName(SERIALIZED_NAME_REPAYMENT_START_DATE_TYPE)
  private Integer repaymentStartDateType;

  public static final String SERIALIZED_NAME_RESCHEDULE_STRATEGY_METHOD = "rescheduleStrategyMethod";
  @SerializedName(SERIALIZED_NAME_RESCHEDULE_STRATEGY_METHOD)
  private Integer rescheduleStrategyMethod;

  public static final String SERIALIZED_NAME_SHORT_NAME = "shortName";
  @SerializedName(SERIALIZED_NAME_SHORT_NAME)
  private String shortName;

  public static final String SERIALIZED_NAME_START_DATE = "startDate";
  @SerializedName(SERIALIZED_NAME_START_DATE)
  private String startDate;

  public static final String SERIALIZED_NAME_SUPPORTED_INTEREST_REFUND_TYPES = "supportedInterestRefundTypes";
  @SerializedName(SERIALIZED_NAME_SUPPORTED_INTEREST_REFUND_TYPES)
  private List<String> supportedInterestRefundTypes;

  public static final String SERIALIZED_NAME_TRANSACTION_PROCESSING_STRATEGY_CODE = "transactionProcessingStrategyCode";
  @SerializedName(SERIALIZED_NAME_TRANSACTION_PROCESSING_STRATEGY_CODE)
  private String transactionProcessingStrategyCode;

  public static final String SERIALIZED_NAME_TRANSFERS_IN_SUSPENSE_ACCOUNT_ID = "transfersInSuspenseAccountId";
  @SerializedName(SERIALIZED_NAME_TRANSFERS_IN_SUSPENSE_ACCOUNT_ID)
  private Long transfersInSuspenseAccountId;

  public static final String SERIALIZED_NAME_USE_BORROWER_CYCLE = "useBorrowerCycle";
  @SerializedName(SERIALIZED_NAME_USE_BORROWER_CYCLE)
  private Boolean useBorrowerCycle;

  public static final String SERIALIZED_NAME_WRITE_OFF_ACCOUNT_ID = "writeOffAccountId";
  @SerializedName(SERIALIZED_NAME_WRITE_OFF_ACCOUNT_ID)
  private Long writeOffAccountId;

  public static final String SERIALIZED_NAME_WRITE_OFF_REASONS_TO_EXPENSE_MAPPINGS = "writeOffReasonsToExpenseMappings";
  @SerializedName(SERIALIZED_NAME_WRITE_OFF_REASONS_TO_EXPENSE_MAPPINGS)
  private List<PostWriteOffReasonToExpenseAccountMappings> writeOffReasonsToExpenseMappings;

  public PostLoanProductsRequest() {
  }

  public PostLoanProductsRequest accountMovesOutOfNPAOnlyOnArrearsCompletion(Boolean accountMovesOutOfNPAOnlyOnArrearsCompletion) {
    
    this.accountMovesOutOfNPAOnlyOnArrearsCompletion = accountMovesOutOfNPAOnlyOnArrearsCompletion;
    return this;
  }

  /**
   * Get accountMovesOutOfNPAOnlyOnArrearsCompletion
   * @return accountMovesOutOfNPAOnlyOnArrearsCompletion
   */
  @javax.annotation.Nullable

  public Boolean getAccountMovesOutOfNPAOnlyOnArrearsCompletion() {
    return accountMovesOutOfNPAOnlyOnArrearsCompletion;
  }


  public void setAccountMovesOutOfNPAOnlyOnArrearsCompletion(Boolean accountMovesOutOfNPAOnlyOnArrearsCompletion) {
    this.accountMovesOutOfNPAOnlyOnArrearsCompletion = accountMovesOutOfNPAOnlyOnArrearsCompletion;
  }

  public PostLoanProductsRequest accountingRule(Integer accountingRule) {
    
    this.accountingRule = accountingRule;
    return this;
  }

  /**
   * Get accountingRule
   * @return accountingRule
   */
  @javax.annotation.Nullable

  public Integer getAccountingRule() {
    return accountingRule;
  }


  public void setAccountingRule(Integer accountingRule) {
    this.accountingRule = accountingRule;
  }

  public PostLoanProductsRequest allowApprovedDisbursedAmountsOverApplied(Boolean allowApprovedDisbursedAmountsOverApplied) {
    
    this.allowApprovedDisbursedAmountsOverApplied = allowApprovedDisbursedAmountsOverApplied;
    return this;
  }

  /**
   * Get allowApprovedDisbursedAmountsOverApplied
   * @return allowApprovedDisbursedAmountsOverApplied
   */
  @javax.annotation.Nullable

  public Boolean getAllowApprovedDisbursedAmountsOverApplied() {
    return allowApprovedDisbursedAmountsOverApplied;
  }


  public void setAllowApprovedDisbursedAmountsOverApplied(Boolean allowApprovedDisbursedAmountsOverApplied) {
    this.allowApprovedDisbursedAmountsOverApplied = allowApprovedDisbursedAmountsOverApplied;
  }

  public PostLoanProductsRequest allowAttributeOverrides(AllowAttributeOverrides allowAttributeOverrides) {
    
    this.allowAttributeOverrides = allowAttributeOverrides;
    return this;
  }

  /**
   * Get allowAttributeOverrides
   * @return allowAttributeOverrides
   */
  @javax.annotation.Nullable

  public AllowAttributeOverrides getAllowAttributeOverrides() {
    return allowAttributeOverrides;
  }


  public void setAllowAttributeOverrides(AllowAttributeOverrides allowAttributeOverrides) {
    this.allowAttributeOverrides = allowAttributeOverrides;
  }

  public PostLoanProductsRequest allowCompoundingOnEod(Boolean allowCompoundingOnEod) {
    
    this.allowCompoundingOnEod = allowCompoundingOnEod;
    return this;
  }

  /**
   * Get allowCompoundingOnEod
   * @return allowCompoundingOnEod
   */
  @javax.annotation.Nullable

  public Boolean getAllowCompoundingOnEod() {
    return allowCompoundingOnEod;
  }


  public void setAllowCompoundingOnEod(Boolean allowCompoundingOnEod) {
    this.allowCompoundingOnEod = allowCompoundingOnEod;
  }

  public PostLoanProductsRequest allowPartialPeriodInterestCalcualtion(Boolean allowPartialPeriodInterestCalcualtion) {
    
    this.allowPartialPeriodInterestCalcualtion = allowPartialPeriodInterestCalcualtion;
    return this;
  }

  /**
   * Get allowPartialPeriodInterestCalcualtion
   * @return allowPartialPeriodInterestCalcualtion
   */
  @javax.annotation.Nullable

  public Boolean getAllowPartialPeriodInterestCalcualtion() {
    return allowPartialPeriodInterestCalcualtion;
  }


  public void setAllowPartialPeriodInterestCalcualtion(Boolean allowPartialPeriodInterestCalcualtion) {
    this.allowPartialPeriodInterestCalcualtion = allowPartialPeriodInterestCalcualtion;
  }

  public PostLoanProductsRequest allowVariableInstallments(Boolean allowVariableInstallments) {
    
    this.allowVariableInstallments = allowVariableInstallments;
    return this;
  }

  /**
   * Get allowVariableInstallments
   * @return allowVariableInstallments
   */
  @javax.annotation.Nullable

  public Boolean getAllowVariableInstallments() {
    return allowVariableInstallments;
  }


  public void setAllowVariableInstallments(Boolean allowVariableInstallments) {
    this.allowVariableInstallments = allowVariableInstallments;
  }

  public PostLoanProductsRequest amortizationType(Integer amortizationType) {
    
    this.amortizationType = amortizationType;
    return this;
  }

  /**
   * Get amortizationType
   * @return amortizationType
   */
  @javax.annotation.Nullable

  public Integer getAmortizationType() {
    return amortizationType;
  }


  public void setAmortizationType(Integer amortizationType) {
    this.amortizationType = amortizationType;
  }

  public PostLoanProductsRequest buyDownExpenseAccountId(Long buyDownExpenseAccountId) {
    
    this.buyDownExpenseAccountId = buyDownExpenseAccountId;
    return this;
  }

  /**
   * Get buyDownExpenseAccountId
   * @return buyDownExpenseAccountId
   */
  @javax.annotation.Nullable

  public Long getBuyDownExpenseAccountId() {
    return buyDownExpenseAccountId;
  }


  public void setBuyDownExpenseAccountId(Long buyDownExpenseAccountId) {
    this.buyDownExpenseAccountId = buyDownExpenseAccountId;
  }

  public PostLoanProductsRequest buyDownFeeCalculationType(BuyDownFeeCalculationTypeEnum buyDownFeeCalculationType) {
    
    this.buyDownFeeCalculationType = buyDownFeeCalculationType;
    return this;
  }

  /**
   * Get buyDownFeeCalculationType
   * @return buyDownFeeCalculationType
   */
  @javax.annotation.Nullable

  public BuyDownFeeCalculationTypeEnum getBuyDownFeeCalculationType() {
    return buyDownFeeCalculationType;
  }


  public void setBuyDownFeeCalculationType(BuyDownFeeCalculationTypeEnum buyDownFeeCalculationType) {
    this.buyDownFeeCalculationType = buyDownFeeCalculationType;
  }

  public PostLoanProductsRequest buyDownFeeIncomeType(BuyDownFeeIncomeTypeEnum buyDownFeeIncomeType) {
    
    this.buyDownFeeIncomeType = buyDownFeeIncomeType;
    return this;
  }

  /**
   * Get buyDownFeeIncomeType
   * @return buyDownFeeIncomeType
   */
  @javax.annotation.Nullable

  public BuyDownFeeIncomeTypeEnum getBuyDownFeeIncomeType() {
    return buyDownFeeIncomeType;
  }


  public void setBuyDownFeeIncomeType(BuyDownFeeIncomeTypeEnum buyDownFeeIncomeType) {
    this.buyDownFeeIncomeType = buyDownFeeIncomeType;
  }

  public PostLoanProductsRequest buyDownFeeStrategy(BuyDownFeeStrategyEnum buyDownFeeStrategy) {
    
    this.buyDownFeeStrategy = buyDownFeeStrategy;
    return this;
  }

  /**
   * Get buyDownFeeStrategy
   * @return buyDownFeeStrategy
   */
  @javax.annotation.Nullable

  public BuyDownFeeStrategyEnum getBuyDownFeeStrategy() {
    return buyDownFeeStrategy;
  }


  public void setBuyDownFeeStrategy(BuyDownFeeStrategyEnum buyDownFeeStrategy) {
    this.buyDownFeeStrategy = buyDownFeeStrategy;
  }

  public PostLoanProductsRequest buydownfeeClassificationToIncomeAccountMappings(List<PostClassificationToIncomeAccountMappings> buydownfeeClassificationToIncomeAccountMappings) {
    
    this.buydownfeeClassificationToIncomeAccountMappings = buydownfeeClassificationToIncomeAccountMappings;
    return this;
  }

  public PostLoanProductsRequest addBuydownfeeClassificationToIncomeAccountMappingsItem(PostClassificationToIncomeAccountMappings buydownfeeClassificationToIncomeAccountMappingsItem) {
    if (this.buydownfeeClassificationToIncomeAccountMappings == null) {
      this.buydownfeeClassificationToIncomeAccountMappings = new ArrayList<>();
    }
    this.buydownfeeClassificationToIncomeAccountMappings.add(buydownfeeClassificationToIncomeAccountMappingsItem);
    return this;
  }

  /**
   * Get buydownfeeClassificationToIncomeAccountMappings
   * @return buydownfeeClassificationToIncomeAccountMappings
   */
  @javax.annotation.Nullable

  public List<PostClassificationToIncomeAccountMappings> getBuydownfeeClassificationToIncomeAccountMappings() {
    return buydownfeeClassificationToIncomeAccountMappings;
  }


  public void setBuydownfeeClassificationToIncomeAccountMappings(List<PostClassificationToIncomeAccountMappings> buydownfeeClassificationToIncomeAccountMappings) {
    this.buydownfeeClassificationToIncomeAccountMappings = buydownfeeClassificationToIncomeAccountMappings;
  }

  public PostLoanProductsRequest canDefineInstallmentAmount(Boolean canDefineInstallmentAmount) {
    
    this.canDefineInstallmentAmount = canDefineInstallmentAmount;
    return this;
  }

  /**
   * Get canDefineInstallmentAmount
   * @return canDefineInstallmentAmount
   */
  @javax.annotation.Nullable

  public Boolean getCanDefineInstallmentAmount() {
    return canDefineInstallmentAmount;
  }


  public void setCanDefineInstallmentAmount(Boolean canDefineInstallmentAmount) {
    this.canDefineInstallmentAmount = canDefineInstallmentAmount;
  }

  public PostLoanProductsRequest canUseForTopup(Boolean canUseForTopup) {
    
    this.canUseForTopup = canUseForTopup;
    return this;
  }

  /**
   * Get canUseForTopup
   * @return canUseForTopup
   */
  @javax.annotation.Nullable

  public Boolean getCanUseForTopup() {
    return canUseForTopup;
  }


  public void setCanUseForTopup(Boolean canUseForTopup) {
    this.canUseForTopup = canUseForTopup;
  }

  public PostLoanProductsRequest capitalizedIncomeCalculationType(CapitalizedIncomeCalculationTypeEnum capitalizedIncomeCalculationType) {
    
    this.capitalizedIncomeCalculationType = capitalizedIncomeCalculationType;
    return this;
  }

  /**
   * Get capitalizedIncomeCalculationType
   * @return capitalizedIncomeCalculationType
   */
  @javax.annotation.Nullable

  public CapitalizedIncomeCalculationTypeEnum getCapitalizedIncomeCalculationType() {
    return capitalizedIncomeCalculationType;
  }


  public void setCapitalizedIncomeCalculationType(CapitalizedIncomeCalculationTypeEnum capitalizedIncomeCalculationType) {
    this.capitalizedIncomeCalculationType = capitalizedIncomeCalculationType;
  }

  public PostLoanProductsRequest capitalizedIncomeClassificationToIncomeAccountMappings(List<PostClassificationToIncomeAccountMappings> capitalizedIncomeClassificationToIncomeAccountMappings) {
    
    this.capitalizedIncomeClassificationToIncomeAccountMappings = capitalizedIncomeClassificationToIncomeAccountMappings;
    return this;
  }

  public PostLoanProductsRequest addCapitalizedIncomeClassificationToIncomeAccountMappingsItem(PostClassificationToIncomeAccountMappings capitalizedIncomeClassificationToIncomeAccountMappingsItem) {
    if (this.capitalizedIncomeClassificationToIncomeAccountMappings == null) {
      this.capitalizedIncomeClassificationToIncomeAccountMappings = new ArrayList<>();
    }
    this.capitalizedIncomeClassificationToIncomeAccountMappings.add(capitalizedIncomeClassificationToIncomeAccountMappingsItem);
    return this;
  }

  /**
   * Get capitalizedIncomeClassificationToIncomeAccountMappings
   * @return capitalizedIncomeClassificationToIncomeAccountMappings
   */
  @javax.annotation.Nullable

  public List<PostClassificationToIncomeAccountMappings> getCapitalizedIncomeClassificationToIncomeAccountMappings() {
    return capitalizedIncomeClassificationToIncomeAccountMappings;
  }


  public void setCapitalizedIncomeClassificationToIncomeAccountMappings(List<PostClassificationToIncomeAccountMappings> capitalizedIncomeClassificationToIncomeAccountMappings) {
    this.capitalizedIncomeClassificationToIncomeAccountMappings = capitalizedIncomeClassificationToIncomeAccountMappings;
  }

  public PostLoanProductsRequest capitalizedIncomeStrategy(CapitalizedIncomeStrategyEnum capitalizedIncomeStrategy) {
    
    this.capitalizedIncomeStrategy = capitalizedIncomeStrategy;
    return this;
  }

  /**
   * Get capitalizedIncomeStrategy
   * @return capitalizedIncomeStrategy
   */
  @javax.annotation.Nullable

  public CapitalizedIncomeStrategyEnum getCapitalizedIncomeStrategy() {
    return capitalizedIncomeStrategy;
  }


  public void setCapitalizedIncomeStrategy(CapitalizedIncomeStrategyEnum capitalizedIncomeStrategy) {
    this.capitalizedIncomeStrategy = capitalizedIncomeStrategy;
  }

  public PostLoanProductsRequest capitalizedIncomeType(CapitalizedIncomeTypeEnum capitalizedIncomeType) {
    
    this.capitalizedIncomeType = capitalizedIncomeType;
    return this;
  }

  /**
   * Get capitalizedIncomeType
   * @return capitalizedIncomeType
   */
  @javax.annotation.Nullable

  public CapitalizedIncomeTypeEnum getCapitalizedIncomeType() {
    return capitalizedIncomeType;
  }


  public void setCapitalizedIncomeType(CapitalizedIncomeTypeEnum capitalizedIncomeType) {
    this.capitalizedIncomeType = capitalizedIncomeType;
  }

  public PostLoanProductsRequest chargeOffBehaviour(String chargeOffBehaviour) {
    
    this.chargeOffBehaviour = chargeOffBehaviour;
    return this;
  }

  /**
   * Get chargeOffBehaviour
   * @return chargeOffBehaviour
   */
  @javax.annotation.Nullable

  public String getChargeOffBehaviour() {
    return chargeOffBehaviour;
  }


  public void setChargeOffBehaviour(String chargeOffBehaviour) {
    this.chargeOffBehaviour = chargeOffBehaviour;
  }

  public PostLoanProductsRequest chargeOffExpenseAccountId(Long chargeOffExpenseAccountId) {
    
    this.chargeOffExpenseAccountId = chargeOffExpenseAccountId;
    return this;
  }

  /**
   * Get chargeOffExpenseAccountId
   * @return chargeOffExpenseAccountId
   */
  @javax.annotation.Nullable

  public Long getChargeOffExpenseAccountId() {
    return chargeOffExpenseAccountId;
  }


  public void setChargeOffExpenseAccountId(Long chargeOffExpenseAccountId) {
    this.chargeOffExpenseAccountId = chargeOffExpenseAccountId;
  }

  public PostLoanProductsRequest chargeOffFraudExpenseAccountId(Long chargeOffFraudExpenseAccountId) {
    
    this.chargeOffFraudExpenseAccountId = chargeOffFraudExpenseAccountId;
    return this;
  }

  /**
   * Get chargeOffFraudExpenseAccountId
   * @return chargeOffFraudExpenseAccountId
   */
  @javax.annotation.Nullable

  public Long getChargeOffFraudExpenseAccountId() {
    return chargeOffFraudExpenseAccountId;
  }


  public void setChargeOffFraudExpenseAccountId(Long chargeOffFraudExpenseAccountId) {
    this.chargeOffFraudExpenseAccountId = chargeOffFraudExpenseAccountId;
  }

  public PostLoanProductsRequest chargeOffReasonToExpenseAccountMappings(List<PostChargeOffReasonToExpenseAccountMappings> chargeOffReasonToExpenseAccountMappings) {
    
    this.chargeOffReasonToExpenseAccountMappings = chargeOffReasonToExpenseAccountMappings;
    return this;
  }

  public PostLoanProductsRequest addChargeOffReasonToExpenseAccountMappingsItem(PostChargeOffReasonToExpenseAccountMappings chargeOffReasonToExpenseAccountMappingsItem) {
    if (this.chargeOffReasonToExpenseAccountMappings == null) {
      this.chargeOffReasonToExpenseAccountMappings = new ArrayList<>();
    }
    this.chargeOffReasonToExpenseAccountMappings.add(chargeOffReasonToExpenseAccountMappingsItem);
    return this;
  }

  /**
   * Get chargeOffReasonToExpenseAccountMappings
   * @return chargeOffReasonToExpenseAccountMappings
   */
  @javax.annotation.Nullable

  public List<PostChargeOffReasonToExpenseAccountMappings> getChargeOffReasonToExpenseAccountMappings() {
    return chargeOffReasonToExpenseAccountMappings;
  }


  public void setChargeOffReasonToExpenseAccountMappings(List<PostChargeOffReasonToExpenseAccountMappings> chargeOffReasonToExpenseAccountMappings) {
    this.chargeOffReasonToExpenseAccountMappings = chargeOffReasonToExpenseAccountMappings;
  }

  public PostLoanProductsRequest charges(List<LoanProductChargeData> charges) {
    
    this.charges = charges;
    return this;
  }

  public PostLoanProductsRequest addChargesItem(LoanProductChargeData chargesItem) {
    if (this.charges == null) {
      this.charges = new ArrayList<>();
    }
    this.charges.add(chargesItem);
    return this;
  }

  /**
   * Get charges
   * @return charges
   */
  @javax.annotation.Nullable

  public List<LoanProductChargeData> getCharges() {
    return charges;
  }


  public void setCharges(List<LoanProductChargeData> charges) {
    this.charges = charges;
  }

  public PostLoanProductsRequest closeDate(String closeDate) {
    
    this.closeDate = closeDate;
    return this;
  }

  /**
   * Get closeDate
   * @return closeDate
   */
  @javax.annotation.Nullable

  public String getCloseDate() {
    return closeDate;
  }


  public void setCloseDate(String closeDate) {
    this.closeDate = closeDate;
  }

  public PostLoanProductsRequest creditAllocation(List<CreditAllocationData> creditAllocation) {
    
    this.creditAllocation = creditAllocation;
    return this;
  }

  public PostLoanProductsRequest addCreditAllocationItem(CreditAllocationData creditAllocationItem) {
    if (this.creditAllocation == null) {
      this.creditAllocation = new ArrayList<>();
    }
    this.creditAllocation.add(creditAllocationItem);
    return this;
  }

  /**
   * Get creditAllocation
   * @return creditAllocation
   */
  @javax.annotation.Nullable

  public List<CreditAllocationData> getCreditAllocation() {
    return creditAllocation;
  }


  public void setCreditAllocation(List<CreditAllocationData> creditAllocation) {
    this.creditAllocation = creditAllocation;
  }

  public PostLoanProductsRequest currencyCode(String currencyCode) {
    
    this.currencyCode = currencyCode;
    return this;
  }

  /**
   * Get currencyCode
   * @return currencyCode
   */
  @javax.annotation.Nullable

  public String getCurrencyCode() {
    return currencyCode;
  }


  public void setCurrencyCode(String currencyCode) {
    this.currencyCode = currencyCode;
  }

  public PostLoanProductsRequest dateFormat(String dateFormat) {
    
    this.dateFormat = dateFormat;
    return this;
  }

  /**
   * Get dateFormat
   * @return dateFormat
   */
  @javax.annotation.Nullable

  public String getDateFormat() {
    return dateFormat;
  }


  public void setDateFormat(String dateFormat) {
    this.dateFormat = dateFormat;
  }

  public PostLoanProductsRequest daysInMonthType(Integer daysInMonthType) {
    
    this.daysInMonthType = daysInMonthType;
    return this;
  }

  /**
   * Get daysInMonthType
   * @return daysInMonthType
   */
  @javax.annotation.Nullable

  public Integer getDaysInMonthType() {
    return daysInMonthType;
  }


  public void setDaysInMonthType(Integer daysInMonthType) {
    this.daysInMonthType = daysInMonthType;
  }

  public PostLoanProductsRequest daysInYearCustomStrategy(String daysInYearCustomStrategy) {
    
    this.daysInYearCustomStrategy = daysInYearCustomStrategy;
    return this;
  }

  /**
   * Get daysInYearCustomStrategy
   * @return daysInYearCustomStrategy
   */
  @javax.annotation.Nullable

  public String getDaysInYearCustomStrategy() {
    return daysInYearCustomStrategy;
  }


  public void setDaysInYearCustomStrategy(String daysInYearCustomStrategy) {
    this.daysInYearCustomStrategy = daysInYearCustomStrategy;
  }

  public PostLoanProductsRequest daysInYearType(Integer daysInYearType) {
    
    this.daysInYearType = daysInYearType;
    return this;
  }

  /**
   * Get daysInYearType
   * @return daysInYearType
   */
  @javax.annotation.Nullable

  public Integer getDaysInYearType() {
    return daysInYearType;
  }


  public void setDaysInYearType(Integer daysInYearType) {
    this.daysInYearType = daysInYearType;
  }

  public PostLoanProductsRequest deferredIncomeLiabilityAccountId(Long deferredIncomeLiabilityAccountId) {
    
    this.deferredIncomeLiabilityAccountId = deferredIncomeLiabilityAccountId;
    return this;
  }

  /**
   * Get deferredIncomeLiabilityAccountId
   * @return deferredIncomeLiabilityAccountId
   */
  @javax.annotation.Nullable

  public Long getDeferredIncomeLiabilityAccountId() {
    return deferredIncomeLiabilityAccountId;
  }


  public void setDeferredIncomeLiabilityAccountId(Long deferredIncomeLiabilityAccountId) {
    this.deferredIncomeLiabilityAccountId = deferredIncomeLiabilityAccountId;
  }

  public PostLoanProductsRequest delinquencyBucketId(Long delinquencyBucketId) {
    
    this.delinquencyBucketId = delinquencyBucketId;
    return this;
  }

  /**
   * Get delinquencyBucketId
   * @return delinquencyBucketId
   */
  @javax.annotation.Nullable

  public Long getDelinquencyBucketId() {
    return delinquencyBucketId;
  }


  public void setDelinquencyBucketId(Long delinquencyBucketId) {
    this.delinquencyBucketId = delinquencyBucketId;
  }

  public PostLoanProductsRequest description(String description) {
    
    this.description = description;
    return this;
  }

  /**
   * Get description
   * @return description
   */
  @javax.annotation.Nullable

  public String getDescription() {
    return description;
  }


  public void setDescription(String description) {
    this.description = description;
  }

  public PostLoanProductsRequest digitsAfterDecimal(Integer digitsAfterDecimal) {
    
    this.digitsAfterDecimal = digitsAfterDecimal;
    return this;
  }

  /**
   * Get digitsAfterDecimal
   * @return digitsAfterDecimal
   */
  @javax.annotation.Nullable

  public Integer getDigitsAfterDecimal() {
    return digitsAfterDecimal;
  }


  public void setDigitsAfterDecimal(Integer digitsAfterDecimal) {
    this.digitsAfterDecimal = digitsAfterDecimal;
  }

  public PostLoanProductsRequest disallowExpectedDisbursements(Boolean disallowExpectedDisbursements) {
    
    this.disallowExpectedDisbursements = disallowExpectedDisbursements;
    return this;
  }

  /**
   * Get disallowExpectedDisbursements
   * @return disallowExpectedDisbursements
   */
  @javax.annotation.Nullable

  public Boolean getDisallowExpectedDisbursements() {
    return disallowExpectedDisbursements;
  }


  public void setDisallowExpectedDisbursements(Boolean disallowExpectedDisbursements) {
    this.disallowExpectedDisbursements = disallowExpectedDisbursements;
  }

  public PostLoanProductsRequest disallowInterestCalculationOnPastDue(Boolean disallowInterestCalculationOnPastDue) {
    
    this.disallowInterestCalculationOnPastDue = disallowInterestCalculationOnPastDue;
    return this;
  }

  /**
   * Get disallowInterestCalculationOnPastDue
   * @return disallowInterestCalculationOnPastDue
   */
  @javax.annotation.Nullable

  public Boolean getDisallowInterestCalculationOnPastDue() {
    return disallowInterestCalculationOnPastDue;
  }


  public void setDisallowInterestCalculationOnPastDue(Boolean disallowInterestCalculationOnPastDue) {
    this.disallowInterestCalculationOnPastDue = disallowInterestCalculationOnPastDue;
  }

  public PostLoanProductsRequest disbursedAmountPercentageForDownPayment(BigDecimal disbursedAmountPercentageForDownPayment) {
    
    this.disbursedAmountPercentageForDownPayment = disbursedAmountPercentageForDownPayment;
    return this;
  }

  /**
   * Get disbursedAmountPercentageForDownPayment
   * @return disbursedAmountPercentageForDownPayment
   */
  @javax.annotation.Nullable

  public BigDecimal getDisbursedAmountPercentageForDownPayment() {
    return disbursedAmountPercentageForDownPayment;
  }


  public void setDisbursedAmountPercentageForDownPayment(BigDecimal disbursedAmountPercentageForDownPayment) {
    this.disbursedAmountPercentageForDownPayment = disbursedAmountPercentageForDownPayment;
  }

  public PostLoanProductsRequest dueDaysForRepaymentEvent(Integer dueDaysForRepaymentEvent) {
    
    this.dueDaysForRepaymentEvent = dueDaysForRepaymentEvent;
    return this;
  }

  /**
   * Get dueDaysForRepaymentEvent
   * @return dueDaysForRepaymentEvent
   */
  @javax.annotation.Nullable

  public Integer getDueDaysForRepaymentEvent() {
    return dueDaysForRepaymentEvent;
  }


  public void setDueDaysForRepaymentEvent(Integer dueDaysForRepaymentEvent) {
    this.dueDaysForRepaymentEvent = dueDaysForRepaymentEvent;
  }

  public PostLoanProductsRequest enableAccrualActivityPosting(Boolean enableAccrualActivityPosting) {
    
    this.enableAccrualActivityPosting = enableAccrualActivityPosting;
    return this;
  }

  /**
   * Get enableAccrualActivityPosting
   * @return enableAccrualActivityPosting
   */
  @javax.annotation.Nullable

  public Boolean getEnableAccrualActivityPosting() {
    return enableAccrualActivityPosting;
  }


  public void setEnableAccrualActivityPosting(Boolean enableAccrualActivityPosting) {
    this.enableAccrualActivityPosting = enableAccrualActivityPosting;
  }

  public PostLoanProductsRequest enableAutoRepaymentForDownPayment(Boolean enableAutoRepaymentForDownPayment) {
    
    this.enableAutoRepaymentForDownPayment = enableAutoRepaymentForDownPayment;
    return this;
  }

  /**
   * Get enableAutoRepaymentForDownPayment
   * @return enableAutoRepaymentForDownPayment
   */
  @javax.annotation.Nullable

  public Boolean getEnableAutoRepaymentForDownPayment() {
    return enableAutoRepaymentForDownPayment;
  }


  public void setEnableAutoRepaymentForDownPayment(Boolean enableAutoRepaymentForDownPayment) {
    this.enableAutoRepaymentForDownPayment = enableAutoRepaymentForDownPayment;
  }

  public PostLoanProductsRequest enableBuyDownFee(Boolean enableBuyDownFee) {
    
    this.enableBuyDownFee = enableBuyDownFee;
    return this;
  }

  /**
   * Get enableBuyDownFee
   * @return enableBuyDownFee
   */
  @javax.annotation.Nullable

  public Boolean getEnableBuyDownFee() {
    return enableBuyDownFee;
  }


  public void setEnableBuyDownFee(Boolean enableBuyDownFee) {
    this.enableBuyDownFee = enableBuyDownFee;
  }

  public PostLoanProductsRequest enableDownPayment(Boolean enableDownPayment) {
    
    this.enableDownPayment = enableDownPayment;
    return this;
  }

  /**
   * Get enableDownPayment
   * @return enableDownPayment
   */
  @javax.annotation.Nullable

  public Boolean getEnableDownPayment() {
    return enableDownPayment;
  }


  public void setEnableDownPayment(Boolean enableDownPayment) {
    this.enableDownPayment = enableDownPayment;
  }

  public PostLoanProductsRequest enableIncomeCapitalization(Boolean enableIncomeCapitalization) {
    
    this.enableIncomeCapitalization = enableIncomeCapitalization;
    return this;
  }

  /**
   * Get enableIncomeCapitalization
   * @return enableIncomeCapitalization
   */
  @javax.annotation.Nullable

  public Boolean getEnableIncomeCapitalization() {
    return enableIncomeCapitalization;
  }


  public void setEnableIncomeCapitalization(Boolean enableIncomeCapitalization) {
    this.enableIncomeCapitalization = enableIncomeCapitalization;
  }

  public PostLoanProductsRequest enableInstallmentLevelDelinquency(Boolean enableInstallmentLevelDelinquency) {
    
    this.enableInstallmentLevelDelinquency = enableInstallmentLevelDelinquency;
    return this;
  }

  /**
   * Get enableInstallmentLevelDelinquency
   * @return enableInstallmentLevelDelinquency
   */
  @javax.annotation.Nullable

  public Boolean getEnableInstallmentLevelDelinquency() {
    return enableInstallmentLevelDelinquency;
  }


  public void setEnableInstallmentLevelDelinquency(Boolean enableInstallmentLevelDelinquency) {
    this.enableInstallmentLevelDelinquency = enableInstallmentLevelDelinquency;
  }

  public PostLoanProductsRequest externalId(String externalId) {
    
    this.externalId = externalId;
    return this;
  }

  /**
   * Get externalId
   * @return externalId
   */
  @javax.annotation.Nullable

  public String getExternalId() {
    return externalId;
  }


  public void setExternalId(String externalId) {
    this.externalId = externalId;
  }

  public PostLoanProductsRequest feeToIncomeAccountMappings(List<LoanProductChargeToGLAccountMapper> feeToIncomeAccountMappings) {
    
    this.feeToIncomeAccountMappings = feeToIncomeAccountMappings;
    return this;
  }

  public PostLoanProductsRequest addFeeToIncomeAccountMappingsItem(LoanProductChargeToGLAccountMapper feeToIncomeAccountMappingsItem) {
    if (this.feeToIncomeAccountMappings == null) {
      this.feeToIncomeAccountMappings = new ArrayList<>();
    }
    this.feeToIncomeAccountMappings.add(feeToIncomeAccountMappingsItem);
    return this;
  }

  /**
   * Get feeToIncomeAccountMappings
   * @return feeToIncomeAccountMappings
   */
  @javax.annotation.Nullable

  public List<LoanProductChargeToGLAccountMapper> getFeeToIncomeAccountMappings() {
    return feeToIncomeAccountMappings;
  }


  public void setFeeToIncomeAccountMappings(List<LoanProductChargeToGLAccountMapper> feeToIncomeAccountMappings) {
    this.feeToIncomeAccountMappings = feeToIncomeAccountMappings;
  }

  public PostLoanProductsRequest fixedLength(Integer fixedLength) {
    
    this.fixedLength = fixedLength;
    return this;
  }

  /**
   * Get fixedLength
   * @return fixedLength
   */
  @javax.annotation.Nullable

  public Integer getFixedLength() {
    return fixedLength;
  }


  public void setFixedLength(Integer fixedLength) {
    this.fixedLength = fixedLength;
  }

  public PostLoanProductsRequest fixedPrincipalPercentagePerInstallment(BigDecimal fixedPrincipalPercentagePerInstallment) {
    
    this.fixedPrincipalPercentagePerInstallment = fixedPrincipalPercentagePerInstallment;
    return this;
  }

  /**
   * Get fixedPrincipalPercentagePerInstallment
   * @return fixedPrincipalPercentagePerInstallment
   */
  @javax.annotation.Nullable

  public BigDecimal getFixedPrincipalPercentagePerInstallment() {
    return fixedPrincipalPercentagePerInstallment;
  }


  public void setFixedPrincipalPercentagePerInstallment(BigDecimal fixedPrincipalPercentagePerInstallment) {
    this.fixedPrincipalPercentagePerInstallment = fixedPrincipalPercentagePerInstallment;
  }

  public PostLoanProductsRequest fundId(Long fundId) {
    
    this.fundId = fundId;
    return this;
  }

  /**
   * Get fundId
   * @return fundId
   */
  @javax.annotation.Nullable

  public Long getFundId() {
    return fundId;
  }


  public void setFundId(Long fundId) {
    this.fundId = fundId;
  }

  public PostLoanProductsRequest fundSourceAccountId(Long fundSourceAccountId) {
    
    this.fundSourceAccountId = fundSourceAccountId;
    return this;
  }

  /**
   * Get fundSourceAccountId
   * @return fundSourceAccountId
   */
  @javax.annotation.Nullable

  public Long getFundSourceAccountId() {
    return fundSourceAccountId;
  }


  public void setFundSourceAccountId(Long fundSourceAccountId) {
    this.fundSourceAccountId = fundSourceAccountId;
  }

  public PostLoanProductsRequest goodwillCreditAccountId(Long goodwillCreditAccountId) {
    
    this.goodwillCreditAccountId = goodwillCreditAccountId;
    return this;
  }

  /**
   * Get goodwillCreditAccountId
   * @return goodwillCreditAccountId
   */
  @javax.annotation.Nullable

  public Long getGoodwillCreditAccountId() {
    return goodwillCreditAccountId;
  }


  public void setGoodwillCreditAccountId(Long goodwillCreditAccountId) {
    this.goodwillCreditAccountId = goodwillCreditAccountId;
  }

  public PostLoanProductsRequest graceOnArrearsAgeing(Integer graceOnArrearsAgeing) {
    
    this.graceOnArrearsAgeing = graceOnArrearsAgeing;
    return this;
  }

  /**
   * Get graceOnArrearsAgeing
   * @return graceOnArrearsAgeing
   */
  @javax.annotation.Nullable

  public Integer getGraceOnArrearsAgeing() {
    return graceOnArrearsAgeing;
  }


  public void setGraceOnArrearsAgeing(Integer graceOnArrearsAgeing) {
    this.graceOnArrearsAgeing = graceOnArrearsAgeing;
  }

  public PostLoanProductsRequest graceOnInterestPayment(Integer graceOnInterestPayment) {
    
    this.graceOnInterestPayment = graceOnInterestPayment;
    return this;
  }

  /**
   * Get graceOnInterestPayment
   * @return graceOnInterestPayment
   */
  @javax.annotation.Nullable

  public Integer getGraceOnInterestPayment() {
    return graceOnInterestPayment;
  }


  public void setGraceOnInterestPayment(Integer graceOnInterestPayment) {
    this.graceOnInterestPayment = graceOnInterestPayment;
  }

  public PostLoanProductsRequest graceOnPrincipalPayment(Integer graceOnPrincipalPayment) {
    
    this.graceOnPrincipalPayment = graceOnPrincipalPayment;
    return this;
  }

  /**
   * Get graceOnPrincipalPayment
   * @return graceOnPrincipalPayment
   */
  @javax.annotation.Nullable

  public Integer getGraceOnPrincipalPayment() {
    return graceOnPrincipalPayment;
  }


  public void setGraceOnPrincipalPayment(Integer graceOnPrincipalPayment) {
    this.graceOnPrincipalPayment = graceOnPrincipalPayment;
  }

  public PostLoanProductsRequest holdGuaranteeFunds(Boolean holdGuaranteeFunds) {
    
    this.holdGuaranteeFunds = holdGuaranteeFunds;
    return this;
  }

  /**
   * Get holdGuaranteeFunds
   * @return holdGuaranteeFunds
   */
  @javax.annotation.Nullable

  public Boolean getHoldGuaranteeFunds() {
    return holdGuaranteeFunds;
  }


  public void setHoldGuaranteeFunds(Boolean holdGuaranteeFunds) {
    this.holdGuaranteeFunds = holdGuaranteeFunds;
  }

  public PostLoanProductsRequest inArrearsTolerance(Integer inArrearsTolerance) {
    
    this.inArrearsTolerance = inArrearsTolerance;
    return this;
  }

  /**
   * Get inArrearsTolerance
   * @return inArrearsTolerance
   */
  @javax.annotation.Nullable

  public Integer getInArrearsTolerance() {
    return inArrearsTolerance;
  }


  public void setInArrearsTolerance(Integer inArrearsTolerance) {
    this.inArrearsTolerance = inArrearsTolerance;
  }

  public PostLoanProductsRequest inMultiplesOf(Integer inMultiplesOf) {
    
    this.inMultiplesOf = inMultiplesOf;
    return this;
  }

  /**
   * Get inMultiplesOf
   * @return inMultiplesOf
   */
  @javax.annotation.Nullable

  public Integer getInMultiplesOf() {
    return inMultiplesOf;
  }


  public void setInMultiplesOf(Integer inMultiplesOf) {
    this.inMultiplesOf = inMultiplesOf;
  }

  public PostLoanProductsRequest includeInBorrowerCycle(Boolean includeInBorrowerCycle) {
    
    this.includeInBorrowerCycle = includeInBorrowerCycle;
    return this;
  }

  /**
   * Get includeInBorrowerCycle
   * @return includeInBorrowerCycle
   */
  @javax.annotation.Nullable

  public Boolean getIncludeInBorrowerCycle() {
    return includeInBorrowerCycle;
  }


  public void setIncludeInBorrowerCycle(Boolean includeInBorrowerCycle) {
    this.includeInBorrowerCycle = includeInBorrowerCycle;
  }

  public PostLoanProductsRequest incomeFromBuyDownAccountId(Long incomeFromBuyDownAccountId) {
    
    this.incomeFromBuyDownAccountId = incomeFromBuyDownAccountId;
    return this;
  }

  /**
   * Get incomeFromBuyDownAccountId
   * @return incomeFromBuyDownAccountId
   */
  @javax.annotation.Nullable

  public Long getIncomeFromBuyDownAccountId() {
    return incomeFromBuyDownAccountId;
  }


  public void setIncomeFromBuyDownAccountId(Long incomeFromBuyDownAccountId) {
    this.incomeFromBuyDownAccountId = incomeFromBuyDownAccountId;
  }

  public PostLoanProductsRequest incomeFromCapitalizationAccountId(Long incomeFromCapitalizationAccountId) {
    
    this.incomeFromCapitalizationAccountId = incomeFromCapitalizationAccountId;
    return this;
  }

  /**
   * Get incomeFromCapitalizationAccountId
   * @return incomeFromCapitalizationAccountId
   */
  @javax.annotation.Nullable

  public Long getIncomeFromCapitalizationAccountId() {
    return incomeFromCapitalizationAccountId;
  }


  public void setIncomeFromCapitalizationAccountId(Long incomeFromCapitalizationAccountId) {
    this.incomeFromCapitalizationAccountId = incomeFromCapitalizationAccountId;
  }

  public PostLoanProductsRequest incomeFromChargeOffFeesAccountId(Long incomeFromChargeOffFeesAccountId) {
    
    this.incomeFromChargeOffFeesAccountId = incomeFromChargeOffFeesAccountId;
    return this;
  }

  /**
   * Get incomeFromChargeOffFeesAccountId
   * @return incomeFromChargeOffFeesAccountId
   */
  @javax.annotation.Nullable

  public Long getIncomeFromChargeOffFeesAccountId() {
    return incomeFromChargeOffFeesAccountId;
  }


  public void setIncomeFromChargeOffFeesAccountId(Long incomeFromChargeOffFeesAccountId) {
    this.incomeFromChargeOffFeesAccountId = incomeFromChargeOffFeesAccountId;
  }

  public PostLoanProductsRequest incomeFromChargeOffInterestAccountId(Long incomeFromChargeOffInterestAccountId) {
    
    this.incomeFromChargeOffInterestAccountId = incomeFromChargeOffInterestAccountId;
    return this;
  }

  /**
   * Get incomeFromChargeOffInterestAccountId
   * @return incomeFromChargeOffInterestAccountId
   */
  @javax.annotation.Nullable

  public Long getIncomeFromChargeOffInterestAccountId() {
    return incomeFromChargeOffInterestAccountId;
  }


  public void setIncomeFromChargeOffInterestAccountId(Long incomeFromChargeOffInterestAccountId) {
    this.incomeFromChargeOffInterestAccountId = incomeFromChargeOffInterestAccountId;
  }

  public PostLoanProductsRequest incomeFromChargeOffPenaltyAccountId(Long incomeFromChargeOffPenaltyAccountId) {
    
    this.incomeFromChargeOffPenaltyAccountId = incomeFromChargeOffPenaltyAccountId;
    return this;
  }

  /**
   * Get incomeFromChargeOffPenaltyAccountId
   * @return incomeFromChargeOffPenaltyAccountId
   */
  @javax.annotation.Nullable

  public Long getIncomeFromChargeOffPenaltyAccountId() {
    return incomeFromChargeOffPenaltyAccountId;
  }


  public void setIncomeFromChargeOffPenaltyAccountId(Long incomeFromChargeOffPenaltyAccountId) {
    this.incomeFromChargeOffPenaltyAccountId = incomeFromChargeOffPenaltyAccountId;
  }

  public PostLoanProductsRequest incomeFromFeeAccountId(Long incomeFromFeeAccountId) {
    
    this.incomeFromFeeAccountId = incomeFromFeeAccountId;
    return this;
  }

  /**
   * Get incomeFromFeeAccountId
   * @return incomeFromFeeAccountId
   */
  @javax.annotation.Nullable

  public Long getIncomeFromFeeAccountId() {
    return incomeFromFeeAccountId;
  }


  public void setIncomeFromFeeAccountId(Long incomeFromFeeAccountId) {
    this.incomeFromFeeAccountId = incomeFromFeeAccountId;
  }

  public PostLoanProductsRequest incomeFromGoodwillCreditFeesAccountId(Long incomeFromGoodwillCreditFeesAccountId) {
    
    this.incomeFromGoodwillCreditFeesAccountId = incomeFromGoodwillCreditFeesAccountId;
    return this;
  }

  /**
   * Get incomeFromGoodwillCreditFeesAccountId
   * @return incomeFromGoodwillCreditFeesAccountId
   */
  @javax.annotation.Nullable

  public Long getIncomeFromGoodwillCreditFeesAccountId() {
    return incomeFromGoodwillCreditFeesAccountId;
  }


  public void setIncomeFromGoodwillCreditFeesAccountId(Long incomeFromGoodwillCreditFeesAccountId) {
    this.incomeFromGoodwillCreditFeesAccountId = incomeFromGoodwillCreditFeesAccountId;
  }

  public PostLoanProductsRequest incomeFromGoodwillCreditInterestAccountId(Long incomeFromGoodwillCreditInterestAccountId) {
    
    this.incomeFromGoodwillCreditInterestAccountId = incomeFromGoodwillCreditInterestAccountId;
    return this;
  }

  /**
   * Get incomeFromGoodwillCreditInterestAccountId
   * @return incomeFromGoodwillCreditInterestAccountId
   */
  @javax.annotation.Nullable

  public Long getIncomeFromGoodwillCreditInterestAccountId() {
    return incomeFromGoodwillCreditInterestAccountId;
  }


  public void setIncomeFromGoodwillCreditInterestAccountId(Long incomeFromGoodwillCreditInterestAccountId) {
    this.incomeFromGoodwillCreditInterestAccountId = incomeFromGoodwillCreditInterestAccountId;
  }

  public PostLoanProductsRequest incomeFromGoodwillCreditPenaltyAccountId(Long incomeFromGoodwillCreditPenaltyAccountId) {
    
    this.incomeFromGoodwillCreditPenaltyAccountId = incomeFromGoodwillCreditPenaltyAccountId;
    return this;
  }

  /**
   * Get incomeFromGoodwillCreditPenaltyAccountId
   * @return incomeFromGoodwillCreditPenaltyAccountId
   */
  @javax.annotation.Nullable

  public Long getIncomeFromGoodwillCreditPenaltyAccountId() {
    return incomeFromGoodwillCreditPenaltyAccountId;
  }


  public void setIncomeFromGoodwillCreditPenaltyAccountId(Long incomeFromGoodwillCreditPenaltyAccountId) {
    this.incomeFromGoodwillCreditPenaltyAccountId = incomeFromGoodwillCreditPenaltyAccountId;
  }

  public PostLoanProductsRequest incomeFromPenaltyAccountId(Long incomeFromPenaltyAccountId) {
    
    this.incomeFromPenaltyAccountId = incomeFromPenaltyAccountId;
    return this;
  }

  /**
   * Get incomeFromPenaltyAccountId
   * @return incomeFromPenaltyAccountId
   */
  @javax.annotation.Nullable

  public Long getIncomeFromPenaltyAccountId() {
    return incomeFromPenaltyAccountId;
  }


  public void setIncomeFromPenaltyAccountId(Long incomeFromPenaltyAccountId) {
    this.incomeFromPenaltyAccountId = incomeFromPenaltyAccountId;
  }

  public PostLoanProductsRequest incomeFromRecoveryAccountId(Long incomeFromRecoveryAccountId) {
    
    this.incomeFromRecoveryAccountId = incomeFromRecoveryAccountId;
    return this;
  }

  /**
   * Get incomeFromRecoveryAccountId
   * @return incomeFromRecoveryAccountId
   */
  @javax.annotation.Nullable

  public Long getIncomeFromRecoveryAccountId() {
    return incomeFromRecoveryAccountId;
  }


  public void setIncomeFromRecoveryAccountId(Long incomeFromRecoveryAccountId) {
    this.incomeFromRecoveryAccountId = incomeFromRecoveryAccountId;
  }

  public PostLoanProductsRequest installmentAmountInMultiplesOf(Integer installmentAmountInMultiplesOf) {
    
    this.installmentAmountInMultiplesOf = installmentAmountInMultiplesOf;
    return this;
  }

  /**
   * Get installmentAmountInMultiplesOf
   * @return installmentAmountInMultiplesOf
   */
  @javax.annotation.Nullable

  public Integer getInstallmentAmountInMultiplesOf() {
    return installmentAmountInMultiplesOf;
  }


  public void setInstallmentAmountInMultiplesOf(Integer installmentAmountInMultiplesOf) {
    this.installmentAmountInMultiplesOf = installmentAmountInMultiplesOf;
  }

  public PostLoanProductsRequest interestCalculationPeriodType(Integer interestCalculationPeriodType) {
    
    this.interestCalculationPeriodType = interestCalculationPeriodType;
    return this;
  }

  /**
   * Get interestCalculationPeriodType
   * @return interestCalculationPeriodType
   */
  @javax.annotation.Nullable

  public Integer getInterestCalculationPeriodType() {
    return interestCalculationPeriodType;
  }


  public void setInterestCalculationPeriodType(Integer interestCalculationPeriodType) {
    this.interestCalculationPeriodType = interestCalculationPeriodType;
  }

  public PostLoanProductsRequest interestOnLoanAccountId(Long interestOnLoanAccountId) {
    
    this.interestOnLoanAccountId = interestOnLoanAccountId;
    return this;
  }

  /**
   * Get interestOnLoanAccountId
   * @return interestOnLoanAccountId
   */
  @javax.annotation.Nullable

  public Long getInterestOnLoanAccountId() {
    return interestOnLoanAccountId;
  }


  public void setInterestOnLoanAccountId(Long interestOnLoanAccountId) {
    this.interestOnLoanAccountId = interestOnLoanAccountId;
  }

  public PostLoanProductsRequest interestRateFrequencyType(Integer interestRateFrequencyType) {
    
    this.interestRateFrequencyType = interestRateFrequencyType;
    return this;
  }

  /**
   * Get interestRateFrequencyType
   * @return interestRateFrequencyType
   */
  @javax.annotation.Nullable

  public Integer getInterestRateFrequencyType() {
    return interestRateFrequencyType;
  }


  public void setInterestRateFrequencyType(Integer interestRateFrequencyType) {
    this.interestRateFrequencyType = interestRateFrequencyType;
  }

  public PostLoanProductsRequest interestRatePerPeriod(Double interestRatePerPeriod) {
    
    this.interestRatePerPeriod = interestRatePerPeriod;
    return this;
  }

  /**
   * Get interestRatePerPeriod
   * @return interestRatePerPeriod
   */
  @javax.annotation.Nullable

  public Double getInterestRatePerPeriod() {
    return interestRatePerPeriod;
  }


  public void setInterestRatePerPeriod(Double interestRatePerPeriod) {
    this.interestRatePerPeriod = interestRatePerPeriod;
  }

  public PostLoanProductsRequest interestRateVariationsForBorrowerCycle(List<Integer> interestRateVariationsForBorrowerCycle) {
    
    this.interestRateVariationsForBorrowerCycle = interestRateVariationsForBorrowerCycle;
    return this;
  }

  public PostLoanProductsRequest addInterestRateVariationsForBorrowerCycleItem(Integer interestRateVariationsForBorrowerCycleItem) {
    if (this.interestRateVariationsForBorrowerCycle == null) {
      this.interestRateVariationsForBorrowerCycle = new ArrayList<>();
    }
    this.interestRateVariationsForBorrowerCycle.add(interestRateVariationsForBorrowerCycleItem);
    return this;
  }

  /**
   * Get interestRateVariationsForBorrowerCycle
   * @return interestRateVariationsForBorrowerCycle
   */
  @javax.annotation.Nullable

  public List<Integer> getInterestRateVariationsForBorrowerCycle() {
    return interestRateVariationsForBorrowerCycle;
  }


  public void setInterestRateVariationsForBorrowerCycle(List<Integer> interestRateVariationsForBorrowerCycle) {
    this.interestRateVariationsForBorrowerCycle = interestRateVariationsForBorrowerCycle;
  }

  public PostLoanProductsRequest interestRecalculationCompoundingMethod(Integer interestRecalculationCompoundingMethod) {
    
    this.interestRecalculationCompoundingMethod = interestRecalculationCompoundingMethod;
    return this;
  }

  /**
   * Get interestRecalculationCompoundingMethod
   * @return interestRecalculationCompoundingMethod
   */
  @javax.annotation.Nullable

  public Integer getInterestRecalculationCompoundingMethod() {
    return interestRecalculationCompoundingMethod;
  }


  public void setInterestRecalculationCompoundingMethod(Integer interestRecalculationCompoundingMethod) {
    this.interestRecalculationCompoundingMethod = interestRecalculationCompoundingMethod;
  }

  public PostLoanProductsRequest interestRecognitionOnDisbursementDate(Boolean interestRecognitionOnDisbursementDate) {
    
    this.interestRecognitionOnDisbursementDate = interestRecognitionOnDisbursementDate;
    return this;
  }

  /**
   * Get interestRecognitionOnDisbursementDate
   * @return interestRecognitionOnDisbursementDate
   */
  @javax.annotation.Nullable

  public Boolean getInterestRecognitionOnDisbursementDate() {
    return interestRecognitionOnDisbursementDate;
  }


  public void setInterestRecognitionOnDisbursementDate(Boolean interestRecognitionOnDisbursementDate) {
    this.interestRecognitionOnDisbursementDate = interestRecognitionOnDisbursementDate;
  }

  public PostLoanProductsRequest interestType(Integer interestType) {
    
    this.interestType = interestType;
    return this;
  }

  /**
   * Get interestType
   * @return interestType
   */
  @javax.annotation.Nullable

  public Integer getInterestType() {
    return interestType;
  }


  public void setInterestType(Integer interestType) {
    this.interestType = interestType;
  }

  public PostLoanProductsRequest isArrearsBasedOnOriginalSchedule(Boolean isArrearsBasedOnOriginalSchedule) {
    
    this.isArrearsBasedOnOriginalSchedule = isArrearsBasedOnOriginalSchedule;
    return this;
  }

  /**
   * Get isArrearsBasedOnOriginalSchedule
   * @return isArrearsBasedOnOriginalSchedule
   */
  @javax.annotation.Nullable

  public Boolean getIsArrearsBasedOnOriginalSchedule() {
    return isArrearsBasedOnOriginalSchedule;
  }


  public void setIsArrearsBasedOnOriginalSchedule(Boolean isArrearsBasedOnOriginalSchedule) {
    this.isArrearsBasedOnOriginalSchedule = isArrearsBasedOnOriginalSchedule;
  }

  public PostLoanProductsRequest isCompoundingToBePostedAsTransaction(Boolean isCompoundingToBePostedAsTransaction) {
    
    this.isCompoundingToBePostedAsTransaction = isCompoundingToBePostedAsTransaction;
    return this;
  }

  /**
   * Get isCompoundingToBePostedAsTransaction
   * @return isCompoundingToBePostedAsTransaction
   */
  @javax.annotation.Nullable

  public Boolean getIsCompoundingToBePostedAsTransaction() {
    return isCompoundingToBePostedAsTransaction;
  }


  public void setIsCompoundingToBePostedAsTransaction(Boolean isCompoundingToBePostedAsTransaction) {
    this.isCompoundingToBePostedAsTransaction = isCompoundingToBePostedAsTransaction;
  }

  public PostLoanProductsRequest isEqualAmortization(Boolean isEqualAmortization) {
    
    this.isEqualAmortization = isEqualAmortization;
    return this;
  }

  /**
   * Get isEqualAmortization
   * @return isEqualAmortization
   */
  @javax.annotation.Nullable

  public Boolean getIsEqualAmortization() {
    return isEqualAmortization;
  }


  public void setIsEqualAmortization(Boolean isEqualAmortization) {
    this.isEqualAmortization = isEqualAmortization;
  }

  public PostLoanProductsRequest isInterestRecalculationEnabled(Boolean isInterestRecalculationEnabled) {
    
    this.isInterestRecalculationEnabled = isInterestRecalculationEnabled;
    return this;
  }

  /**
   * Get isInterestRecalculationEnabled
   * @return isInterestRecalculationEnabled
   */
  @javax.annotation.Nullable

  public Boolean getIsInterestRecalculationEnabled() {
    return isInterestRecalculationEnabled;
  }


  public void setIsInterestRecalculationEnabled(Boolean isInterestRecalculationEnabled) {
    this.isInterestRecalculationEnabled = isInterestRecalculationEnabled;
  }

  public PostLoanProductsRequest isLinkedToFloatingInterestRates(Boolean isLinkedToFloatingInterestRates) {
    
    this.isLinkedToFloatingInterestRates = isLinkedToFloatingInterestRates;
    return this;
  }

  /**
   * Get isLinkedToFloatingInterestRates
   * @return isLinkedToFloatingInterestRates
   */
  @javax.annotation.Nullable

  public Boolean getIsLinkedToFloatingInterestRates() {
    return isLinkedToFloatingInterestRates;
  }


  public void setIsLinkedToFloatingInterestRates(Boolean isLinkedToFloatingInterestRates) {
    this.isLinkedToFloatingInterestRates = isLinkedToFloatingInterestRates;
  }

  public PostLoanProductsRequest loanPortfolioAccountId(Long loanPortfolioAccountId) {
    
    this.loanPortfolioAccountId = loanPortfolioAccountId;
    return this;
  }

  /**
   * Get loanPortfolioAccountId
   * @return loanPortfolioAccountId
   */
  @javax.annotation.Nullable

  public Long getLoanPortfolioAccountId() {
    return loanPortfolioAccountId;
  }


  public void setLoanPortfolioAccountId(Long loanPortfolioAccountId) {
    this.loanPortfolioAccountId = loanPortfolioAccountId;
  }

  public PostLoanProductsRequest loanScheduleProcessingType(String loanScheduleProcessingType) {
    
    this.loanScheduleProcessingType = loanScheduleProcessingType;
    return this;
  }

  /**
   * Get loanScheduleProcessingType
   * @return loanScheduleProcessingType
   */
  @javax.annotation.Nullable

  public String getLoanScheduleProcessingType() {
    return loanScheduleProcessingType;
  }


  public void setLoanScheduleProcessingType(String loanScheduleProcessingType) {
    this.loanScheduleProcessingType = loanScheduleProcessingType;
  }

  public PostLoanProductsRequest loanScheduleType(String loanScheduleType) {
    
    this.loanScheduleType = loanScheduleType;
    return this;
  }

  /**
   * Get loanScheduleType
   * @return loanScheduleType
   */
  @javax.annotation.Nullable

  public String getLoanScheduleType() {
    return loanScheduleType;
  }


  public void setLoanScheduleType(String loanScheduleType) {
    this.loanScheduleType = loanScheduleType;
  }

  public PostLoanProductsRequest locale(String locale) {
    
    this.locale = locale;
    return this;
  }

  /**
   * Get locale
   * @return locale
   */
  @javax.annotation.Nullable

  public String getLocale() {
    return locale;
  }


  public void setLocale(String locale) {
    this.locale = locale;
  }

  public PostLoanProductsRequest maxInterestRatePerPeriod(Double maxInterestRatePerPeriod) {
    
    this.maxInterestRatePerPeriod = maxInterestRatePerPeriod;
    return this;
  }

  /**
   * Get maxInterestRatePerPeriod
   * @return maxInterestRatePerPeriod
   */
  @javax.annotation.Nullable

  public Double getMaxInterestRatePerPeriod() {
    return maxInterestRatePerPeriod;
  }


  public void setMaxInterestRatePerPeriod(Double maxInterestRatePerPeriod) {
    this.maxInterestRatePerPeriod = maxInterestRatePerPeriod;
  }

  public PostLoanProductsRequest maxNumberOfRepayments(Integer maxNumberOfRepayments) {
    
    this.maxNumberOfRepayments = maxNumberOfRepayments;
    return this;
  }

  /**
   * Get maxNumberOfRepayments
   * @return maxNumberOfRepayments
   */
  @javax.annotation.Nullable

  public Integer getMaxNumberOfRepayments() {
    return maxNumberOfRepayments;
  }


  public void setMaxNumberOfRepayments(Integer maxNumberOfRepayments) {
    this.maxNumberOfRepayments = maxNumberOfRepayments;
  }

  public PostLoanProductsRequest maxPrincipal(Double maxPrincipal) {
    
    this.maxPrincipal = maxPrincipal;
    return this;
  }

  /**
   * Get maxPrincipal
   * @return maxPrincipal
   */
  @javax.annotation.Nullable

  public Double getMaxPrincipal() {
    return maxPrincipal;
  }


  public void setMaxPrincipal(Double maxPrincipal) {
    this.maxPrincipal = maxPrincipal;
  }

  public PostLoanProductsRequest maxTrancheCount(Integer maxTrancheCount) {
    
    this.maxTrancheCount = maxTrancheCount;
    return this;
  }

  /**
   * Get maxTrancheCount
   * @return maxTrancheCount
   */
  @javax.annotation.Nullable

  public Integer getMaxTrancheCount() {
    return maxTrancheCount;
  }


  public void setMaxTrancheCount(Integer maxTrancheCount) {
    this.maxTrancheCount = maxTrancheCount;
  }

  public PostLoanProductsRequest merchantBuyDownFee(Boolean merchantBuyDownFee) {
    
    this.merchantBuyDownFee = merchantBuyDownFee;
    return this;
  }

  /**
   * Get merchantBuyDownFee
   * @return merchantBuyDownFee
   */
  @javax.annotation.Nullable

  public Boolean getMerchantBuyDownFee() {
    return merchantBuyDownFee;
  }


  public void setMerchantBuyDownFee(Boolean merchantBuyDownFee) {
    this.merchantBuyDownFee = merchantBuyDownFee;
  }

  public PostLoanProductsRequest minInterestRatePerPeriod(Double minInterestRatePerPeriod) {
    
    this.minInterestRatePerPeriod = minInterestRatePerPeriod;
    return this;
  }

  /**
   * Get minInterestRatePerPeriod
   * @return minInterestRatePerPeriod
   */
  @javax.annotation.Nullable

  public Double getMinInterestRatePerPeriod() {
    return minInterestRatePerPeriod;
  }


  public void setMinInterestRatePerPeriod(Double minInterestRatePerPeriod) {
    this.minInterestRatePerPeriod = minInterestRatePerPeriod;
  }

  public PostLoanProductsRequest minNumberOfRepayments(Integer minNumberOfRepayments) {
    
    this.minNumberOfRepayments = minNumberOfRepayments;
    return this;
  }

  /**
   * Get minNumberOfRepayments
   * @return minNumberOfRepayments
   */
  @javax.annotation.Nullable

  public Integer getMinNumberOfRepayments() {
    return minNumberOfRepayments;
  }


  public void setMinNumberOfRepayments(Integer minNumberOfRepayments) {
    this.minNumberOfRepayments = minNumberOfRepayments;
  }

  public PostLoanProductsRequest minPrincipal(Double minPrincipal) {
    
    this.minPrincipal = minPrincipal;
    return this;
  }

  /**
   * Get minPrincipal
   * @return minPrincipal
   */
  @javax.annotation.Nullable

  public Double getMinPrincipal() {
    return minPrincipal;
  }


  public void setMinPrincipal(Double minPrincipal) {
    this.minPrincipal = minPrincipal;
  }

  public PostLoanProductsRequest minimumDaysBetweenDisbursalAndFirstRepayment(Integer minimumDaysBetweenDisbursalAndFirstRepayment) {
    
    this.minimumDaysBetweenDisbursalAndFirstRepayment = minimumDaysBetweenDisbursalAndFirstRepayment;
    return this;
  }

  /**
   * Get minimumDaysBetweenDisbursalAndFirstRepayment
   * @return minimumDaysBetweenDisbursalAndFirstRepayment
   */
  @javax.annotation.Nullable

  public Integer getMinimumDaysBetweenDisbursalAndFirstRepayment() {
    return minimumDaysBetweenDisbursalAndFirstRepayment;
  }


  public void setMinimumDaysBetweenDisbursalAndFirstRepayment(Integer minimumDaysBetweenDisbursalAndFirstRepayment) {
    this.minimumDaysBetweenDisbursalAndFirstRepayment = minimumDaysBetweenDisbursalAndFirstRepayment;
  }

  public PostLoanProductsRequest multiDisburseLoan(Boolean multiDisburseLoan) {
    
    this.multiDisburseLoan = multiDisburseLoan;
    return this;
  }

  /**
   * Get multiDisburseLoan
   * @return multiDisburseLoan
   */
  @javax.annotation.Nullable

  public Boolean getMultiDisburseLoan() {
    return multiDisburseLoan;
  }


  public void setMultiDisburseLoan(Boolean multiDisburseLoan) {
    this.multiDisburseLoan = multiDisburseLoan;
  }

  public PostLoanProductsRequest name(String name) {
    
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
   */
  @javax.annotation.Nullable

  public String getName() {
    return name;
  }


  public void setName(String name) {
    this.name = name;
  }

  public PostLoanProductsRequest numberOfRepaymentVariationsForBorrowerCycle(List<Integer> numberOfRepaymentVariationsForBorrowerCycle) {
    
    this.numberOfRepaymentVariationsForBorrowerCycle = numberOfRepaymentVariationsForBorrowerCycle;
    return this;
  }

  public PostLoanProductsRequest addNumberOfRepaymentVariationsForBorrowerCycleItem(Integer numberOfRepaymentVariationsForBorrowerCycleItem) {
    if (this.numberOfRepaymentVariationsForBorrowerCycle == null) {
      this.numberOfRepaymentVariationsForBorrowerCycle = new ArrayList<>();
    }
    this.numberOfRepaymentVariationsForBorrowerCycle.add(numberOfRepaymentVariationsForBorrowerCycleItem);
    return this;
  }

  /**
   * Get numberOfRepaymentVariationsForBorrowerCycle
   * @return numberOfRepaymentVariationsForBorrowerCycle
   */
  @javax.annotation.Nullable

  public List<Integer> getNumberOfRepaymentVariationsForBorrowerCycle() {
    return numberOfRepaymentVariationsForBorrowerCycle;
  }


  public void setNumberOfRepaymentVariationsForBorrowerCycle(List<Integer> numberOfRepaymentVariationsForBorrowerCycle) {
    this.numberOfRepaymentVariationsForBorrowerCycle = numberOfRepaymentVariationsForBorrowerCycle;
  }

  public PostLoanProductsRequest numberOfRepayments(Integer numberOfRepayments) {
    
    this.numberOfRepayments = numberOfRepayments;
    return this;
  }

  /**
   * Get numberOfRepayments
   * @return numberOfRepayments
   */
  @javax.annotation.Nullable

  public Integer getNumberOfRepayments() {
    return numberOfRepayments;
  }


  public void setNumberOfRepayments(Integer numberOfRepayments) {
    this.numberOfRepayments = numberOfRepayments;
  }

  public PostLoanProductsRequest outstandingLoanBalance(Double outstandingLoanBalance) {
    
    this.outstandingLoanBalance = outstandingLoanBalance;
    return this;
  }

  /**
   * Get outstandingLoanBalance
   * @return outstandingLoanBalance
   */
  @javax.annotation.Nullable

  public Double getOutstandingLoanBalance() {
    return outstandingLoanBalance;
  }


  public void setOutstandingLoanBalance(Double outstandingLoanBalance) {
    this.outstandingLoanBalance = outstandingLoanBalance;
  }

  public PostLoanProductsRequest overAppliedCalculationType(String overAppliedCalculationType) {
    
    this.overAppliedCalculationType = overAppliedCalculationType;
    return this;
  }

  /**
   * Get overAppliedCalculationType
   * @return overAppliedCalculationType
   */
  @javax.annotation.Nullable

  public String getOverAppliedCalculationType() {
    return overAppliedCalculationType;
  }


  public void setOverAppliedCalculationType(String overAppliedCalculationType) {
    this.overAppliedCalculationType = overAppliedCalculationType;
  }

  public PostLoanProductsRequest overAppliedNumber(Integer overAppliedNumber) {
    
    this.overAppliedNumber = overAppliedNumber;
    return this;
  }

  /**
   * Get overAppliedNumber
   * @return overAppliedNumber
   */
  @javax.annotation.Nullable

  public Integer getOverAppliedNumber() {
    return overAppliedNumber;
  }


  public void setOverAppliedNumber(Integer overAppliedNumber) {
    this.overAppliedNumber = overAppliedNumber;
  }

  public PostLoanProductsRequest overDueDaysForRepaymentEvent(Integer overDueDaysForRepaymentEvent) {
    
    this.overDueDaysForRepaymentEvent = overDueDaysForRepaymentEvent;
    return this;
  }

  /**
   * Get overDueDaysForRepaymentEvent
   * @return overDueDaysForRepaymentEvent
   */
  @javax.annotation.Nullable

  public Integer getOverDueDaysForRepaymentEvent() {
    return overDueDaysForRepaymentEvent;
  }


  public void setOverDueDaysForRepaymentEvent(Integer overDueDaysForRepaymentEvent) {
    this.overDueDaysForRepaymentEvent = overDueDaysForRepaymentEvent;
  }

  public PostLoanProductsRequest overdueDaysForNPA(Integer overdueDaysForNPA) {
    
    this.overdueDaysForNPA = overdueDaysForNPA;
    return this;
  }

  /**
   * Get overdueDaysForNPA
   * @return overdueDaysForNPA
   */
  @javax.annotation.Nullable

  public Integer getOverdueDaysForNPA() {
    return overdueDaysForNPA;
  }


  public void setOverdueDaysForNPA(Integer overdueDaysForNPA) {
    this.overdueDaysForNPA = overdueDaysForNPA;
  }

  public PostLoanProductsRequest overpaymentLiabilityAccountId(Long overpaymentLiabilityAccountId) {
    
    this.overpaymentLiabilityAccountId = overpaymentLiabilityAccountId;
    return this;
  }

  /**
   * Get overpaymentLiabilityAccountId
   * @return overpaymentLiabilityAccountId
   */
  @javax.annotation.Nullable

  public Long getOverpaymentLiabilityAccountId() {
    return overpaymentLiabilityAccountId;
  }


  public void setOverpaymentLiabilityAccountId(Long overpaymentLiabilityAccountId) {
    this.overpaymentLiabilityAccountId = overpaymentLiabilityAccountId;
  }

  public PostLoanProductsRequest paymentAllocation(List<AdvancedPaymentData> paymentAllocation) {
    
    this.paymentAllocation = paymentAllocation;
    return this;
  }

  public PostLoanProductsRequest addPaymentAllocationItem(AdvancedPaymentData paymentAllocationItem) {
    if (this.paymentAllocation == null) {
      this.paymentAllocation = new ArrayList<>();
    }
    this.paymentAllocation.add(paymentAllocationItem);
    return this;
  }

  /**
   * Get paymentAllocation
   * @return paymentAllocation
   */
  @javax.annotation.Nullable

  public List<AdvancedPaymentData> getPaymentAllocation() {
    return paymentAllocation;
  }


  public void setPaymentAllocation(List<AdvancedPaymentData> paymentAllocation) {
    this.paymentAllocation = paymentAllocation;
  }

  public PostLoanProductsRequest paymentChannelToFundSourceMappings(List<GetLoanPaymentChannelToFundSourceMappings> paymentChannelToFundSourceMappings) {
    
    this.paymentChannelToFundSourceMappings = paymentChannelToFundSourceMappings;
    return this;
  }

  public PostLoanProductsRequest addPaymentChannelToFundSourceMappingsItem(GetLoanPaymentChannelToFundSourceMappings paymentChannelToFundSourceMappingsItem) {
    if (this.paymentChannelToFundSourceMappings == null) {
      this.paymentChannelToFundSourceMappings = new ArrayList<>();
    }
    this.paymentChannelToFundSourceMappings.add(paymentChannelToFundSourceMappingsItem);
    return this;
  }

  /**
   * Get paymentChannelToFundSourceMappings
   * @return paymentChannelToFundSourceMappings
   */
  @javax.annotation.Nullable

  public List<GetLoanPaymentChannelToFundSourceMappings> getPaymentChannelToFundSourceMappings() {
    return paymentChannelToFundSourceMappings;
  }


  public void setPaymentChannelToFundSourceMappings(List<GetLoanPaymentChannelToFundSourceMappings> paymentChannelToFundSourceMappings) {
    this.paymentChannelToFundSourceMappings = paymentChannelToFundSourceMappings;
  }

  public PostLoanProductsRequest penaltyToIncomeAccountMappings(List<LoanProductChargeToGLAccountMapper> penaltyToIncomeAccountMappings) {
    
    this.penaltyToIncomeAccountMappings = penaltyToIncomeAccountMappings;
    return this;
  }

  public PostLoanProductsRequest addPenaltyToIncomeAccountMappingsItem(LoanProductChargeToGLAccountMapper penaltyToIncomeAccountMappingsItem) {
    if (this.penaltyToIncomeAccountMappings == null) {
      this.penaltyToIncomeAccountMappings = new ArrayList<>();
    }
    this.penaltyToIncomeAccountMappings.add(penaltyToIncomeAccountMappingsItem);
    return this;
  }

  /**
   * Get penaltyToIncomeAccountMappings
   * @return penaltyToIncomeAccountMappings
   */
  @javax.annotation.Nullable

  public List<LoanProductChargeToGLAccountMapper> getPenaltyToIncomeAccountMappings() {
    return penaltyToIncomeAccountMappings;
  }


  public void setPenaltyToIncomeAccountMappings(List<LoanProductChargeToGLAccountMapper> penaltyToIncomeAccountMappings) {
    this.penaltyToIncomeAccountMappings = penaltyToIncomeAccountMappings;
  }

  public PostLoanProductsRequest preClosureInterestCalculationStrategy(Integer preClosureInterestCalculationStrategy) {
    
    this.preClosureInterestCalculationStrategy = preClosureInterestCalculationStrategy;
    return this;
  }

  /**
   * Get preClosureInterestCalculationStrategy
   * @return preClosureInterestCalculationStrategy
   */
  @javax.annotation.Nullable

  public Integer getPreClosureInterestCalculationStrategy() {
    return preClosureInterestCalculationStrategy;
  }


  public void setPreClosureInterestCalculationStrategy(Integer preClosureInterestCalculationStrategy) {
    this.preClosureInterestCalculationStrategy = preClosureInterestCalculationStrategy;
  }

  public PostLoanProductsRequest principal(Double principal) {
    
    this.principal = principal;
    return this;
  }

  /**
   * Get principal
   * @return principal
   */
  @javax.annotation.Nullable

  public Double getPrincipal() {
    return principal;
  }


  public void setPrincipal(Double principal) {
    this.principal = principal;
  }

  public PostLoanProductsRequest principalThresholdForLastInstallment(Integer principalThresholdForLastInstallment) {
    
    this.principalThresholdForLastInstallment = principalThresholdForLastInstallment;
    return this;
  }

  /**
   * Get principalThresholdForLastInstallment
   * @return principalThresholdForLastInstallment
   */
  @javax.annotation.Nullable

  public Integer getPrincipalThresholdForLastInstallment() {
    return principalThresholdForLastInstallment;
  }


  public void setPrincipalThresholdForLastInstallment(Integer principalThresholdForLastInstallment) {
    this.principalThresholdForLastInstallment = principalThresholdForLastInstallment;
  }

  public PostLoanProductsRequest principalVariationsForBorrowerCycle(List<Integer> principalVariationsForBorrowerCycle) {
    
    this.principalVariationsForBorrowerCycle = principalVariationsForBorrowerCycle;
    return this;
  }

  public PostLoanProductsRequest addPrincipalVariationsForBorrowerCycleItem(Integer principalVariationsForBorrowerCycleItem) {
    if (this.principalVariationsForBorrowerCycle == null) {
      this.principalVariationsForBorrowerCycle = new ArrayList<>();
    }
    this.principalVariationsForBorrowerCycle.add(principalVariationsForBorrowerCycleItem);
    return this;
  }

  /**
   * Get principalVariationsForBorrowerCycle
   * @return principalVariationsForBorrowerCycle
   */
  @javax.annotation.Nullable

  public List<Integer> getPrincipalVariationsForBorrowerCycle() {
    return principalVariationsForBorrowerCycle;
  }


  public void setPrincipalVariationsForBorrowerCycle(List<Integer> principalVariationsForBorrowerCycle) {
    this.principalVariationsForBorrowerCycle = principalVariationsForBorrowerCycle;
  }

  public PostLoanProductsRequest rates(List<RateData> rates) {
    
    this.rates = rates;
    return this;
  }

  public PostLoanProductsRequest addRatesItem(RateData ratesItem) {
    if (this.rates == null) {
      this.rates = new ArrayList<>();
    }
    this.rates.add(ratesItem);
    return this;
  }

  /**
   * Get rates
   * @return rates
   */
  @javax.annotation.Nullable

  public List<RateData> getRates() {
    return rates;
  }


  public void setRates(List<RateData> rates) {
    this.rates = rates;
  }

  public PostLoanProductsRequest recalculationCompoundingFrequencyInterval(Integer recalculationCompoundingFrequencyInterval) {
    
    this.recalculationCompoundingFrequencyInterval = recalculationCompoundingFrequencyInterval;
    return this;
  }

  /**
   * Get recalculationCompoundingFrequencyInterval
   * @return recalculationCompoundingFrequencyInterval
   */
  @javax.annotation.Nullable

  public Integer getRecalculationCompoundingFrequencyInterval() {
    return recalculationCompoundingFrequencyInterval;
  }


  public void setRecalculationCompoundingFrequencyInterval(Integer recalculationCompoundingFrequencyInterval) {
    this.recalculationCompoundingFrequencyInterval = recalculationCompoundingFrequencyInterval;
  }

  public PostLoanProductsRequest recalculationCompoundingFrequencyOnDayType(Integer recalculationCompoundingFrequencyOnDayType) {
    
    this.recalculationCompoundingFrequencyOnDayType = recalculationCompoundingFrequencyOnDayType;
    return this;
  }

  /**
   * Get recalculationCompoundingFrequencyOnDayType
   * @return recalculationCompoundingFrequencyOnDayType
   */
  @javax.annotation.Nullable

  public Integer getRecalculationCompoundingFrequencyOnDayType() {
    return recalculationCompoundingFrequencyOnDayType;
  }


  public void setRecalculationCompoundingFrequencyOnDayType(Integer recalculationCompoundingFrequencyOnDayType) {
    this.recalculationCompoundingFrequencyOnDayType = recalculationCompoundingFrequencyOnDayType;
  }

  public PostLoanProductsRequest recalculationCompoundingFrequencyType(Integer recalculationCompoundingFrequencyType) {
    
    this.recalculationCompoundingFrequencyType = recalculationCompoundingFrequencyType;
    return this;
  }

  /**
   * Get recalculationCompoundingFrequencyType
   * @return recalculationCompoundingFrequencyType
   */
  @javax.annotation.Nullable

  public Integer getRecalculationCompoundingFrequencyType() {
    return recalculationCompoundingFrequencyType;
  }


  public void setRecalculationCompoundingFrequencyType(Integer recalculationCompoundingFrequencyType) {
    this.recalculationCompoundingFrequencyType = recalculationCompoundingFrequencyType;
  }

  public PostLoanProductsRequest recalculationRestFrequencyInterval(Integer recalculationRestFrequencyInterval) {
    
    this.recalculationRestFrequencyInterval = recalculationRestFrequencyInterval;
    return this;
  }

  /**
   * Get recalculationRestFrequencyInterval
   * @return recalculationRestFrequencyInterval
   */
  @javax.annotation.Nullable

  public Integer getRecalculationRestFrequencyInterval() {
    return recalculationRestFrequencyInterval;
  }


  public void setRecalculationRestFrequencyInterval(Integer recalculationRestFrequencyInterval) {
    this.recalculationRestFrequencyInterval = recalculationRestFrequencyInterval;
  }

  public PostLoanProductsRequest recalculationRestFrequencyType(Integer recalculationRestFrequencyType) {
    
    this.recalculationRestFrequencyType = recalculationRestFrequencyType;
    return this;
  }

  /**
   * Get recalculationRestFrequencyType
   * @return recalculationRestFrequencyType
   */
  @javax.annotation.Nullable

  public Integer getRecalculationRestFrequencyType() {
    return recalculationRestFrequencyType;
  }


  public void setRecalculationRestFrequencyType(Integer recalculationRestFrequencyType) {
    this.recalculationRestFrequencyType = recalculationRestFrequencyType;
  }

  public PostLoanProductsRequest receivableFeeAccountId(Long receivableFeeAccountId) {
    
    this.receivableFeeAccountId = receivableFeeAccountId;
    return this;
  }

  /**
   * Get receivableFeeAccountId
   * @return receivableFeeAccountId
   */
  @javax.annotation.Nullable

  public Long getReceivableFeeAccountId() {
    return receivableFeeAccountId;
  }


  public void setReceivableFeeAccountId(Long receivableFeeAccountId) {
    this.receivableFeeAccountId = receivableFeeAccountId;
  }

  public PostLoanProductsRequest receivableInterestAccountId(Long receivableInterestAccountId) {
    
    this.receivableInterestAccountId = receivableInterestAccountId;
    return this;
  }

  /**
   * Get receivableInterestAccountId
   * @return receivableInterestAccountId
   */
  @javax.annotation.Nullable

  public Long getReceivableInterestAccountId() {
    return receivableInterestAccountId;
  }


  public void setReceivableInterestAccountId(Long receivableInterestAccountId) {
    this.receivableInterestAccountId = receivableInterestAccountId;
  }

  public PostLoanProductsRequest receivablePenaltyAccountId(Long receivablePenaltyAccountId) {
    
    this.receivablePenaltyAccountId = receivablePenaltyAccountId;
    return this;
  }

  /**
   * Get receivablePenaltyAccountId
   * @return receivablePenaltyAccountId
   */
  @javax.annotation.Nullable

  public Long getReceivablePenaltyAccountId() {
    return receivablePenaltyAccountId;
  }


  public void setReceivablePenaltyAccountId(Long receivablePenaltyAccountId) {
    this.receivablePenaltyAccountId = receivablePenaltyAccountId;
  }

  public PostLoanProductsRequest repaymentEvery(Integer repaymentEvery) {
    
    this.repaymentEvery = repaymentEvery;
    return this;
  }

  /**
   * Get repaymentEvery
   * @return repaymentEvery
   */
  @javax.annotation.Nullable

  public Integer getRepaymentEvery() {
    return repaymentEvery;
  }


  public void setRepaymentEvery(Integer repaymentEvery) {
    this.repaymentEvery = repaymentEvery;
  }

  public PostLoanProductsRequest repaymentFrequencyType(Long repaymentFrequencyType) {
    
    this.repaymentFrequencyType = repaymentFrequencyType;
    return this;
  }

  /**
   * Get repaymentFrequencyType
   * @return repaymentFrequencyType
   */
  @javax.annotation.Nullable

  public Long getRepaymentFrequencyType() {
    return repaymentFrequencyType;
  }


  public void setRepaymentFrequencyType(Long repaymentFrequencyType) {
    this.repaymentFrequencyType = repaymentFrequencyType;
  }

  public PostLoanProductsRequest repaymentStartDateType(Integer repaymentStartDateType) {
    
    this.repaymentStartDateType = repaymentStartDateType;
    return this;
  }

  /**
   * Get repaymentStartDateType
   * @return repaymentStartDateType
   */
  @javax.annotation.Nullable

  public Integer getRepaymentStartDateType() {
    return repaymentStartDateType;
  }


  public void setRepaymentStartDateType(Integer repaymentStartDateType) {
    this.repaymentStartDateType = repaymentStartDateType;
  }

  public PostLoanProductsRequest rescheduleStrategyMethod(Integer rescheduleStrategyMethod) {
    
    this.rescheduleStrategyMethod = rescheduleStrategyMethod;
    return this;
  }

  /**
   * Get rescheduleStrategyMethod
   * @return rescheduleStrategyMethod
   */
  @javax.annotation.Nullable

  public Integer getRescheduleStrategyMethod() {
    return rescheduleStrategyMethod;
  }


  public void setRescheduleStrategyMethod(Integer rescheduleStrategyMethod) {
    this.rescheduleStrategyMethod = rescheduleStrategyMethod;
  }

  public PostLoanProductsRequest shortName(String shortName) {
    
    this.shortName = shortName;
    return this;
  }

  /**
   * Get shortName
   * @return shortName
   */
  @javax.annotation.Nullable

  public String getShortName() {
    return shortName;
  }


  public void setShortName(String shortName) {
    this.shortName = shortName;
  }

  public PostLoanProductsRequest startDate(String startDate) {
    
    this.startDate = startDate;
    return this;
  }

  /**
   * Get startDate
   * @return startDate
   */
  @javax.annotation.Nullable

  public String getStartDate() {
    return startDate;
  }


  public void setStartDate(String startDate) {
    this.startDate = startDate;
  }

  public PostLoanProductsRequest supportedInterestRefundTypes(List<String> supportedInterestRefundTypes) {
    
    this.supportedInterestRefundTypes = supportedInterestRefundTypes;
    return this;
  }

  public PostLoanProductsRequest addSupportedInterestRefundTypesItem(String supportedInterestRefundTypesItem) {
    if (this.supportedInterestRefundTypes == null) {
      this.supportedInterestRefundTypes = new ArrayList<>();
    }
    this.supportedInterestRefundTypes.add(supportedInterestRefundTypesItem);
    return this;
  }

  /**
   * Get supportedInterestRefundTypes
   * @return supportedInterestRefundTypes
   */
  @javax.annotation.Nullable

  public List<String> getSupportedInterestRefundTypes() {
    return supportedInterestRefundTypes;
  }


  public void setSupportedInterestRefundTypes(List<String> supportedInterestRefundTypes) {
    this.supportedInterestRefundTypes = supportedInterestRefundTypes;
  }

  public PostLoanProductsRequest transactionProcessingStrategyCode(String transactionProcessingStrategyCode) {
    
    this.transactionProcessingStrategyCode = transactionProcessingStrategyCode;
    return this;
  }

  /**
   * Get transactionProcessingStrategyCode
   * @return transactionProcessingStrategyCode
   */
  @javax.annotation.Nullable

  public String getTransactionProcessingStrategyCode() {
    return transactionProcessingStrategyCode;
  }


  public void setTransactionProcessingStrategyCode(String transactionProcessingStrategyCode) {
    this.transactionProcessingStrategyCode = transactionProcessingStrategyCode;
  }

  public PostLoanProductsRequest transfersInSuspenseAccountId(Long transfersInSuspenseAccountId) {
    
    this.transfersInSuspenseAccountId = transfersInSuspenseAccountId;
    return this;
  }

  /**
   * Get transfersInSuspenseAccountId
   * @return transfersInSuspenseAccountId
   */
  @javax.annotation.Nullable

  public Long getTransfersInSuspenseAccountId() {
    return transfersInSuspenseAccountId;
  }


  public void setTransfersInSuspenseAccountId(Long transfersInSuspenseAccountId) {
    this.transfersInSuspenseAccountId = transfersInSuspenseAccountId;
  }

  public PostLoanProductsRequest useBorrowerCycle(Boolean useBorrowerCycle) {
    
    this.useBorrowerCycle = useBorrowerCycle;
    return this;
  }

  /**
   * Get useBorrowerCycle
   * @return useBorrowerCycle
   */
  @javax.annotation.Nullable

  public Boolean getUseBorrowerCycle() {
    return useBorrowerCycle;
  }


  public void setUseBorrowerCycle(Boolean useBorrowerCycle) {
    this.useBorrowerCycle = useBorrowerCycle;
  }

  public PostLoanProductsRequest writeOffAccountId(Long writeOffAccountId) {
    
    this.writeOffAccountId = writeOffAccountId;
    return this;
  }

  /**
   * Get writeOffAccountId
   * @return writeOffAccountId
   */
  @javax.annotation.Nullable

  public Long getWriteOffAccountId() {
    return writeOffAccountId;
  }


  public void setWriteOffAccountId(Long writeOffAccountId) {
    this.writeOffAccountId = writeOffAccountId;
  }

  public PostLoanProductsRequest writeOffReasonsToExpenseMappings(List<PostWriteOffReasonToExpenseAccountMappings> writeOffReasonsToExpenseMappings) {
    
    this.writeOffReasonsToExpenseMappings = writeOffReasonsToExpenseMappings;
    return this;
  }

  public PostLoanProductsRequest addWriteOffReasonsToExpenseMappingsItem(PostWriteOffReasonToExpenseAccountMappings writeOffReasonsToExpenseMappingsItem) {
    if (this.writeOffReasonsToExpenseMappings == null) {
      this.writeOffReasonsToExpenseMappings = new ArrayList<>();
    }
    this.writeOffReasonsToExpenseMappings.add(writeOffReasonsToExpenseMappingsItem);
    return this;
  }

  /**
   * Get writeOffReasonsToExpenseMappings
   * @return writeOffReasonsToExpenseMappings
   */
  @javax.annotation.Nullable

  public List<PostWriteOffReasonToExpenseAccountMappings> getWriteOffReasonsToExpenseMappings() {
    return writeOffReasonsToExpenseMappings;
  }


  public void setWriteOffReasonsToExpenseMappings(List<PostWriteOffReasonToExpenseAccountMappings> writeOffReasonsToExpenseMappings) {
    this.writeOffReasonsToExpenseMappings = writeOffReasonsToExpenseMappings;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PostLoanProductsRequest postLoanProductsRequest = (PostLoanProductsRequest) o;
    return Objects.equals(this.accountMovesOutOfNPAOnlyOnArrearsCompletion, postLoanProductsRequest.accountMovesOutOfNPAOnlyOnArrearsCompletion) &&
        Objects.equals(this.accountingRule, postLoanProductsRequest.accountingRule) &&
        Objects.equals(this.allowApprovedDisbursedAmountsOverApplied, postLoanProductsRequest.allowApprovedDisbursedAmountsOverApplied) &&
        Objects.equals(this.allowAttributeOverrides, postLoanProductsRequest.allowAttributeOverrides) &&
        Objects.equals(this.allowCompoundingOnEod, postLoanProductsRequest.allowCompoundingOnEod) &&
        Objects.equals(this.allowPartialPeriodInterestCalcualtion, postLoanProductsRequest.allowPartialPeriodInterestCalcualtion) &&
        Objects.equals(this.allowVariableInstallments, postLoanProductsRequest.allowVariableInstallments) &&
        Objects.equals(this.amortizationType, postLoanProductsRequest.amortizationType) &&
        Objects.equals(this.buyDownExpenseAccountId, postLoanProductsRequest.buyDownExpenseAccountId) &&
        Objects.equals(this.buyDownFeeCalculationType, postLoanProductsRequest.buyDownFeeCalculationType) &&
        Objects.equals(this.buyDownFeeIncomeType, postLoanProductsRequest.buyDownFeeIncomeType) &&
        Objects.equals(this.buyDownFeeStrategy, postLoanProductsRequest.buyDownFeeStrategy) &&
        Objects.equals(this.buydownfeeClassificationToIncomeAccountMappings, postLoanProductsRequest.buydownfeeClassificationToIncomeAccountMappings) &&
        Objects.equals(this.canDefineInstallmentAmount, postLoanProductsRequest.canDefineInstallmentAmount) &&
        Objects.equals(this.canUseForTopup, postLoanProductsRequest.canUseForTopup) &&
        Objects.equals(this.capitalizedIncomeCalculationType, postLoanProductsRequest.capitalizedIncomeCalculationType) &&
        Objects.equals(this.capitalizedIncomeClassificationToIncomeAccountMappings, postLoanProductsRequest.capitalizedIncomeClassificationToIncomeAccountMappings) &&
        Objects.equals(this.capitalizedIncomeStrategy, postLoanProductsRequest.capitalizedIncomeStrategy) &&
        Objects.equals(this.capitalizedIncomeType, postLoanProductsRequest.capitalizedIncomeType) &&
        Objects.equals(this.chargeOffBehaviour, postLoanProductsRequest.chargeOffBehaviour) &&
        Objects.equals(this.chargeOffExpenseAccountId, postLoanProductsRequest.chargeOffExpenseAccountId) &&
        Objects.equals(this.chargeOffFraudExpenseAccountId, postLoanProductsRequest.chargeOffFraudExpenseAccountId) &&
        Objects.equals(this.chargeOffReasonToExpenseAccountMappings, postLoanProductsRequest.chargeOffReasonToExpenseAccountMappings) &&
        Objects.equals(this.charges, postLoanProductsRequest.charges) &&
        Objects.equals(this.closeDate, postLoanProductsRequest.closeDate) &&
        Objects.equals(this.creditAllocation, postLoanProductsRequest.creditAllocation) &&
        Objects.equals(this.currencyCode, postLoanProductsRequest.currencyCode) &&
        Objects.equals(this.dateFormat, postLoanProductsRequest.dateFormat) &&
        Objects.equals(this.daysInMonthType, postLoanProductsRequest.daysInMonthType) &&
        Objects.equals(this.daysInYearCustomStrategy, postLoanProductsRequest.daysInYearCustomStrategy) &&
        Objects.equals(this.daysInYearType, postLoanProductsRequest.daysInYearType) &&
        Objects.equals(this.deferredIncomeLiabilityAccountId, postLoanProductsRequest.deferredIncomeLiabilityAccountId) &&
        Objects.equals(this.delinquencyBucketId, postLoanProductsRequest.delinquencyBucketId) &&
        Objects.equals(this.description, postLoanProductsRequest.description) &&
        Objects.equals(this.digitsAfterDecimal, postLoanProductsRequest.digitsAfterDecimal) &&
        Objects.equals(this.disallowExpectedDisbursements, postLoanProductsRequest.disallowExpectedDisbursements) &&
        Objects.equals(this.disallowInterestCalculationOnPastDue, postLoanProductsRequest.disallowInterestCalculationOnPastDue) &&
        Objects.equals(this.disbursedAmountPercentageForDownPayment, postLoanProductsRequest.disbursedAmountPercentageForDownPayment) &&
        Objects.equals(this.dueDaysForRepaymentEvent, postLoanProductsRequest.dueDaysForRepaymentEvent) &&
        Objects.equals(this.enableAccrualActivityPosting, postLoanProductsRequest.enableAccrualActivityPosting) &&
        Objects.equals(this.enableAutoRepaymentForDownPayment, postLoanProductsRequest.enableAutoRepaymentForDownPayment) &&
        Objects.equals(this.enableBuyDownFee, postLoanProductsRequest.enableBuyDownFee) &&
        Objects.equals(this.enableDownPayment, postLoanProductsRequest.enableDownPayment) &&
        Objects.equals(this.enableIncomeCapitalization, postLoanProductsRequest.enableIncomeCapitalization) &&
        Objects.equals(this.enableInstallmentLevelDelinquency, postLoanProductsRequest.enableInstallmentLevelDelinquency) &&
        Objects.equals(this.externalId, postLoanProductsRequest.externalId) &&
        Objects.equals(this.feeToIncomeAccountMappings, postLoanProductsRequest.feeToIncomeAccountMappings) &&
        Objects.equals(this.fixedLength, postLoanProductsRequest.fixedLength) &&
        Objects.equals(this.fixedPrincipalPercentagePerInstallment, postLoanProductsRequest.fixedPrincipalPercentagePerInstallment) &&
        Objects.equals(this.fundId, postLoanProductsRequest.fundId) &&
        Objects.equals(this.fundSourceAccountId, postLoanProductsRequest.fundSourceAccountId) &&
        Objects.equals(this.goodwillCreditAccountId, postLoanProductsRequest.goodwillCreditAccountId) &&
        Objects.equals(this.graceOnArrearsAgeing, postLoanProductsRequest.graceOnArrearsAgeing) &&
        Objects.equals(this.graceOnInterestPayment, postLoanProductsRequest.graceOnInterestPayment) &&
        Objects.equals(this.graceOnPrincipalPayment, postLoanProductsRequest.graceOnPrincipalPayment) &&
        Objects.equals(this.holdGuaranteeFunds, postLoanProductsRequest.holdGuaranteeFunds) &&
        Objects.equals(this.inArrearsTolerance, postLoanProductsRequest.inArrearsTolerance) &&
        Objects.equals(this.inMultiplesOf, postLoanProductsRequest.inMultiplesOf) &&
        Objects.equals(this.includeInBorrowerCycle, postLoanProductsRequest.includeInBorrowerCycle) &&
        Objects.equals(this.incomeFromBuyDownAccountId, postLoanProductsRequest.incomeFromBuyDownAccountId) &&
        Objects.equals(this.incomeFromCapitalizationAccountId, postLoanProductsRequest.incomeFromCapitalizationAccountId) &&
        Objects.equals(this.incomeFromChargeOffFeesAccountId, postLoanProductsRequest.incomeFromChargeOffFeesAccountId) &&
        Objects.equals(this.incomeFromChargeOffInterestAccountId, postLoanProductsRequest.incomeFromChargeOffInterestAccountId) &&
        Objects.equals(this.incomeFromChargeOffPenaltyAccountId, postLoanProductsRequest.incomeFromChargeOffPenaltyAccountId) &&
        Objects.equals(this.incomeFromFeeAccountId, postLoanProductsRequest.incomeFromFeeAccountId) &&
        Objects.equals(this.incomeFromGoodwillCreditFeesAccountId, postLoanProductsRequest.incomeFromGoodwillCreditFeesAccountId) &&
        Objects.equals(this.incomeFromGoodwillCreditInterestAccountId, postLoanProductsRequest.incomeFromGoodwillCreditInterestAccountId) &&
        Objects.equals(this.incomeFromGoodwillCreditPenaltyAccountId, postLoanProductsRequest.incomeFromGoodwillCreditPenaltyAccountId) &&
        Objects.equals(this.incomeFromPenaltyAccountId, postLoanProductsRequest.incomeFromPenaltyAccountId) &&
        Objects.equals(this.incomeFromRecoveryAccountId, postLoanProductsRequest.incomeFromRecoveryAccountId) &&
        Objects.equals(this.installmentAmountInMultiplesOf, postLoanProductsRequest.installmentAmountInMultiplesOf) &&
        Objects.equals(this.interestCalculationPeriodType, postLoanProductsRequest.interestCalculationPeriodType) &&
        Objects.equals(this.interestOnLoanAccountId, postLoanProductsRequest.interestOnLoanAccountId) &&
        Objects.equals(this.interestRateFrequencyType, postLoanProductsRequest.interestRateFrequencyType) &&
        Objects.equals(this.interestRatePerPeriod, postLoanProductsRequest.interestRatePerPeriod) &&
        Objects.equals(this.interestRateVariationsForBorrowerCycle, postLoanProductsRequest.interestRateVariationsForBorrowerCycle) &&
        Objects.equals(this.interestRecalculationCompoundingMethod, postLoanProductsRequest.interestRecalculationCompoundingMethod) &&
        Objects.equals(this.interestRecognitionOnDisbursementDate, postLoanProductsRequest.interestRecognitionOnDisbursementDate) &&
        Objects.equals(this.interestType, postLoanProductsRequest.interestType) &&
        Objects.equals(this.isArrearsBasedOnOriginalSchedule, postLoanProductsRequest.isArrearsBasedOnOriginalSchedule) &&
        Objects.equals(this.isCompoundingToBePostedAsTransaction, postLoanProductsRequest.isCompoundingToBePostedAsTransaction) &&
        Objects.equals(this.isEqualAmortization, postLoanProductsRequest.isEqualAmortization) &&
        Objects.equals(this.isInterestRecalculationEnabled, postLoanProductsRequest.isInterestRecalculationEnabled) &&
        Objects.equals(this.isLinkedToFloatingInterestRates, postLoanProductsRequest.isLinkedToFloatingInterestRates) &&
        Objects.equals(this.loanPortfolioAccountId, postLoanProductsRequest.loanPortfolioAccountId) &&
        Objects.equals(this.loanScheduleProcessingType, postLoanProductsRequest.loanScheduleProcessingType) &&
        Objects.equals(this.loanScheduleType, postLoanProductsRequest.loanScheduleType) &&
        Objects.equals(this.locale, postLoanProductsRequest.locale) &&
        Objects.equals(this.maxInterestRatePerPeriod, postLoanProductsRequest.maxInterestRatePerPeriod) &&
        Objects.equals(this.maxNumberOfRepayments, postLoanProductsRequest.maxNumberOfRepayments) &&
        Objects.equals(this.maxPrincipal, postLoanProductsRequest.maxPrincipal) &&
        Objects.equals(this.maxTrancheCount, postLoanProductsRequest.maxTrancheCount) &&
        Objects.equals(this.merchantBuyDownFee, postLoanProductsRequest.merchantBuyDownFee) &&
        Objects.equals(this.minInterestRatePerPeriod, postLoanProductsRequest.minInterestRatePerPeriod) &&
        Objects.equals(this.minNumberOfRepayments, postLoanProductsRequest.minNumberOfRepayments) &&
        Objects.equals(this.minPrincipal, postLoanProductsRequest.minPrincipal) &&
        Objects.equals(this.minimumDaysBetweenDisbursalAndFirstRepayment, postLoanProductsRequest.minimumDaysBetweenDisbursalAndFirstRepayment) &&
        Objects.equals(this.multiDisburseLoan, postLoanProductsRequest.multiDisburseLoan) &&
        Objects.equals(this.name, postLoanProductsRequest.name) &&
        Objects.equals(this.numberOfRepaymentVariationsForBorrowerCycle, postLoanProductsRequest.numberOfRepaymentVariationsForBorrowerCycle) &&
        Objects.equals(this.numberOfRepayments, postLoanProductsRequest.numberOfRepayments) &&
        Objects.equals(this.outstandingLoanBalance, postLoanProductsRequest.outstandingLoanBalance) &&
        Objects.equals(this.overAppliedCalculationType, postLoanProductsRequest.overAppliedCalculationType) &&
        Objects.equals(this.overAppliedNumber, postLoanProductsRequest.overAppliedNumber) &&
        Objects.equals(this.overDueDaysForRepaymentEvent, postLoanProductsRequest.overDueDaysForRepaymentEvent) &&
        Objects.equals(this.overdueDaysForNPA, postLoanProductsRequest.overdueDaysForNPA) &&
        Objects.equals(this.overpaymentLiabilityAccountId, postLoanProductsRequest.overpaymentLiabilityAccountId) &&
        Objects.equals(this.paymentAllocation, postLoanProductsRequest.paymentAllocation) &&
        Objects.equals(this.paymentChannelToFundSourceMappings, postLoanProductsRequest.paymentChannelToFundSourceMappings) &&
        Objects.equals(this.penaltyToIncomeAccountMappings, postLoanProductsRequest.penaltyToIncomeAccountMappings) &&
        Objects.equals(this.preClosureInterestCalculationStrategy, postLoanProductsRequest.preClosureInterestCalculationStrategy) &&
        Objects.equals(this.principal, postLoanProductsRequest.principal) &&
        Objects.equals(this.principalThresholdForLastInstallment, postLoanProductsRequest.principalThresholdForLastInstallment) &&
        Objects.equals(this.principalVariationsForBorrowerCycle, postLoanProductsRequest.principalVariationsForBorrowerCycle) &&
        Objects.equals(this.rates, postLoanProductsRequest.rates) &&
        Objects.equals(this.recalculationCompoundingFrequencyInterval, postLoanProductsRequest.recalculationCompoundingFrequencyInterval) &&
        Objects.equals(this.recalculationCompoundingFrequencyOnDayType, postLoanProductsRequest.recalculationCompoundingFrequencyOnDayType) &&
        Objects.equals(this.recalculationCompoundingFrequencyType, postLoanProductsRequest.recalculationCompoundingFrequencyType) &&
        Objects.equals(this.recalculationRestFrequencyInterval, postLoanProductsRequest.recalculationRestFrequencyInterval) &&
        Objects.equals(this.recalculationRestFrequencyType, postLoanProductsRequest.recalculationRestFrequencyType) &&
        Objects.equals(this.receivableFeeAccountId, postLoanProductsRequest.receivableFeeAccountId) &&
        Objects.equals(this.receivableInterestAccountId, postLoanProductsRequest.receivableInterestAccountId) &&
        Objects.equals(this.receivablePenaltyAccountId, postLoanProductsRequest.receivablePenaltyAccountId) &&
        Objects.equals(this.repaymentEvery, postLoanProductsRequest.repaymentEvery) &&
        Objects.equals(this.repaymentFrequencyType, postLoanProductsRequest.repaymentFrequencyType) &&
        Objects.equals(this.repaymentStartDateType, postLoanProductsRequest.repaymentStartDateType) &&
        Objects.equals(this.rescheduleStrategyMethod, postLoanProductsRequest.rescheduleStrategyMethod) &&
        Objects.equals(this.shortName, postLoanProductsRequest.shortName) &&
        Objects.equals(this.startDate, postLoanProductsRequest.startDate) &&
        Objects.equals(this.supportedInterestRefundTypes, postLoanProductsRequest.supportedInterestRefundTypes) &&
        Objects.equals(this.transactionProcessingStrategyCode, postLoanProductsRequest.transactionProcessingStrategyCode) &&
        Objects.equals(this.transfersInSuspenseAccountId, postLoanProductsRequest.transfersInSuspenseAccountId) &&
        Objects.equals(this.useBorrowerCycle, postLoanProductsRequest.useBorrowerCycle) &&
        Objects.equals(this.writeOffAccountId, postLoanProductsRequest.writeOffAccountId) &&
        Objects.equals(this.writeOffReasonsToExpenseMappings, postLoanProductsRequest.writeOffReasonsToExpenseMappings);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountMovesOutOfNPAOnlyOnArrearsCompletion, accountingRule, allowApprovedDisbursedAmountsOverApplied, allowAttributeOverrides, allowCompoundingOnEod, allowPartialPeriodInterestCalcualtion, allowVariableInstallments, amortizationType, buyDownExpenseAccountId, buyDownFeeCalculationType, buyDownFeeIncomeType, buyDownFeeStrategy, buydownfeeClassificationToIncomeAccountMappings, canDefineInstallmentAmount, canUseForTopup, capitalizedIncomeCalculationType, capitalizedIncomeClassificationToIncomeAccountMappings, capitalizedIncomeStrategy, capitalizedIncomeType, chargeOffBehaviour, chargeOffExpenseAccountId, chargeOffFraudExpenseAccountId, chargeOffReasonToExpenseAccountMappings, charges, closeDate, creditAllocation, currencyCode, dateFormat, daysInMonthType, daysInYearCustomStrategy, daysInYearType, deferredIncomeLiabilityAccountId, delinquencyBucketId, description, digitsAfterDecimal, disallowExpectedDisbursements, disallowInterestCalculationOnPastDue, disbursedAmountPercentageForDownPayment, dueDaysForRepaymentEvent, enableAccrualActivityPosting, enableAutoRepaymentForDownPayment, enableBuyDownFee, enableDownPayment, enableIncomeCapitalization, enableInstallmentLevelDelinquency, externalId, feeToIncomeAccountMappings, fixedLength, fixedPrincipalPercentagePerInstallment, fundId, fundSourceAccountId, goodwillCreditAccountId, graceOnArrearsAgeing, graceOnInterestPayment, graceOnPrincipalPayment, holdGuaranteeFunds, inArrearsTolerance, inMultiplesOf, includeInBorrowerCycle, incomeFromBuyDownAccountId, incomeFromCapitalizationAccountId, incomeFromChargeOffFeesAccountId, incomeFromChargeOffInterestAccountId, incomeFromChargeOffPenaltyAccountId, incomeFromFeeAccountId, incomeFromGoodwillCreditFeesAccountId, incomeFromGoodwillCreditInterestAccountId, incomeFromGoodwillCreditPenaltyAccountId, incomeFromPenaltyAccountId, incomeFromRecoveryAccountId, installmentAmountInMultiplesOf, interestCalculationPeriodType, interestOnLoanAccountId, interestRateFrequencyType, interestRatePerPeriod, interestRateVariationsForBorrowerCycle, interestRecalculationCompoundingMethod, interestRecognitionOnDisbursementDate, interestType, isArrearsBasedOnOriginalSchedule, isCompoundingToBePostedAsTransaction, isEqualAmortization, isInterestRecalculationEnabled, isLinkedToFloatingInterestRates, loanPortfolioAccountId, loanScheduleProcessingType, loanScheduleType, locale, maxInterestRatePerPeriod, maxNumberOfRepayments, maxPrincipal, maxTrancheCount, merchantBuyDownFee, minInterestRatePerPeriod, minNumberOfRepayments, minPrincipal, minimumDaysBetweenDisbursalAndFirstRepayment, multiDisburseLoan, name, numberOfRepaymentVariationsForBorrowerCycle, numberOfRepayments, outstandingLoanBalance, overAppliedCalculationType, overAppliedNumber, overDueDaysForRepaymentEvent, overdueDaysForNPA, overpaymentLiabilityAccountId, paymentAllocation, paymentChannelToFundSourceMappings, penaltyToIncomeAccountMappings, preClosureInterestCalculationStrategy, principal, principalThresholdForLastInstallment, principalVariationsForBorrowerCycle, rates, recalculationCompoundingFrequencyInterval, recalculationCompoundingFrequencyOnDayType, recalculationCompoundingFrequencyType, recalculationRestFrequencyInterval, recalculationRestFrequencyType, receivableFeeAccountId, receivableInterestAccountId, receivablePenaltyAccountId, repaymentEvery, repaymentFrequencyType, repaymentStartDateType, rescheduleStrategyMethod, shortName, startDate, supportedInterestRefundTypes, transactionProcessingStrategyCode, transfersInSuspenseAccountId, useBorrowerCycle, writeOffAccountId, writeOffReasonsToExpenseMappings);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PostLoanProductsRequest {\n");
    sb.append("    accountMovesOutOfNPAOnlyOnArrearsCompletion: ").append(toIndentedString(accountMovesOutOfNPAOnlyOnArrearsCompletion)).append("\n");
    sb.append("    accountingRule: ").append(toIndentedString(accountingRule)).append("\n");
    sb.append("    allowApprovedDisbursedAmountsOverApplied: ").append(toIndentedString(allowApprovedDisbursedAmountsOverApplied)).append("\n");
    sb.append("    allowAttributeOverrides: ").append(toIndentedString(allowAttributeOverrides)).append("\n");
    sb.append("    allowCompoundingOnEod: ").append(toIndentedString(allowCompoundingOnEod)).append("\n");
    sb.append("    allowPartialPeriodInterestCalcualtion: ").append(toIndentedString(allowPartialPeriodInterestCalcualtion)).append("\n");
    sb.append("    allowVariableInstallments: ").append(toIndentedString(allowVariableInstallments)).append("\n");
    sb.append("    amortizationType: ").append(toIndentedString(amortizationType)).append("\n");
    sb.append("    buyDownExpenseAccountId: ").append(toIndentedString(buyDownExpenseAccountId)).append("\n");
    sb.append("    buyDownFeeCalculationType: ").append(toIndentedString(buyDownFeeCalculationType)).append("\n");
    sb.append("    buyDownFeeIncomeType: ").append(toIndentedString(buyDownFeeIncomeType)).append("\n");
    sb.append("    buyDownFeeStrategy: ").append(toIndentedString(buyDownFeeStrategy)).append("\n");
    sb.append("    buydownfeeClassificationToIncomeAccountMappings: ").append(toIndentedString(buydownfeeClassificationToIncomeAccountMappings)).append("\n");
    sb.append("    canDefineInstallmentAmount: ").append(toIndentedString(canDefineInstallmentAmount)).append("\n");
    sb.append("    canUseForTopup: ").append(toIndentedString(canUseForTopup)).append("\n");
    sb.append("    capitalizedIncomeCalculationType: ").append(toIndentedString(capitalizedIncomeCalculationType)).append("\n");
    sb.append("    capitalizedIncomeClassificationToIncomeAccountMappings: ").append(toIndentedString(capitalizedIncomeClassificationToIncomeAccountMappings)).append("\n");
    sb.append("    capitalizedIncomeStrategy: ").append(toIndentedString(capitalizedIncomeStrategy)).append("\n");
    sb.append("    capitalizedIncomeType: ").append(toIndentedString(capitalizedIncomeType)).append("\n");
    sb.append("    chargeOffBehaviour: ").append(toIndentedString(chargeOffBehaviour)).append("\n");
    sb.append("    chargeOffExpenseAccountId: ").append(toIndentedString(chargeOffExpenseAccountId)).append("\n");
    sb.append("    chargeOffFraudExpenseAccountId: ").append(toIndentedString(chargeOffFraudExpenseAccountId)).append("\n");
    sb.append("    chargeOffReasonToExpenseAccountMappings: ").append(toIndentedString(chargeOffReasonToExpenseAccountMappings)).append("\n");
    sb.append("    charges: ").append(toIndentedString(charges)).append("\n");
    sb.append("    closeDate: ").append(toIndentedString(closeDate)).append("\n");
    sb.append("    creditAllocation: ").append(toIndentedString(creditAllocation)).append("\n");
    sb.append("    currencyCode: ").append(toIndentedString(currencyCode)).append("\n");
    sb.append("    dateFormat: ").append(toIndentedString(dateFormat)).append("\n");
    sb.append("    daysInMonthType: ").append(toIndentedString(daysInMonthType)).append("\n");
    sb.append("    daysInYearCustomStrategy: ").append(toIndentedString(daysInYearCustomStrategy)).append("\n");
    sb.append("    daysInYearType: ").append(toIndentedString(daysInYearType)).append("\n");
    sb.append("    deferredIncomeLiabilityAccountId: ").append(toIndentedString(deferredIncomeLiabilityAccountId)).append("\n");
    sb.append("    delinquencyBucketId: ").append(toIndentedString(delinquencyBucketId)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    digitsAfterDecimal: ").append(toIndentedString(digitsAfterDecimal)).append("\n");
    sb.append("    disallowExpectedDisbursements: ").append(toIndentedString(disallowExpectedDisbursements)).append("\n");
    sb.append("    disallowInterestCalculationOnPastDue: ").append(toIndentedString(disallowInterestCalculationOnPastDue)).append("\n");
    sb.append("    disbursedAmountPercentageForDownPayment: ").append(toIndentedString(disbursedAmountPercentageForDownPayment)).append("\n");
    sb.append("    dueDaysForRepaymentEvent: ").append(toIndentedString(dueDaysForRepaymentEvent)).append("\n");
    sb.append("    enableAccrualActivityPosting: ").append(toIndentedString(enableAccrualActivityPosting)).append("\n");
    sb.append("    enableAutoRepaymentForDownPayment: ").append(toIndentedString(enableAutoRepaymentForDownPayment)).append("\n");
    sb.append("    enableBuyDownFee: ").append(toIndentedString(enableBuyDownFee)).append("\n");
    sb.append("    enableDownPayment: ").append(toIndentedString(enableDownPayment)).append("\n");
    sb.append("    enableIncomeCapitalization: ").append(toIndentedString(enableIncomeCapitalization)).append("\n");
    sb.append("    enableInstallmentLevelDelinquency: ").append(toIndentedString(enableInstallmentLevelDelinquency)).append("\n");
    sb.append("    externalId: ").append(toIndentedString(externalId)).append("\n");
    sb.append("    feeToIncomeAccountMappings: ").append(toIndentedString(feeToIncomeAccountMappings)).append("\n");
    sb.append("    fixedLength: ").append(toIndentedString(fixedLength)).append("\n");
    sb.append("    fixedPrincipalPercentagePerInstallment: ").append(toIndentedString(fixedPrincipalPercentagePerInstallment)).append("\n");
    sb.append("    fundId: ").append(toIndentedString(fundId)).append("\n");
    sb.append("    fundSourceAccountId: ").append(toIndentedString(fundSourceAccountId)).append("\n");
    sb.append("    goodwillCreditAccountId: ").append(toIndentedString(goodwillCreditAccountId)).append("\n");
    sb.append("    graceOnArrearsAgeing: ").append(toIndentedString(graceOnArrearsAgeing)).append("\n");
    sb.append("    graceOnInterestPayment: ").append(toIndentedString(graceOnInterestPayment)).append("\n");
    sb.append("    graceOnPrincipalPayment: ").append(toIndentedString(graceOnPrincipalPayment)).append("\n");
    sb.append("    holdGuaranteeFunds: ").append(toIndentedString(holdGuaranteeFunds)).append("\n");
    sb.append("    inArrearsTolerance: ").append(toIndentedString(inArrearsTolerance)).append("\n");
    sb.append("    inMultiplesOf: ").append(toIndentedString(inMultiplesOf)).append("\n");
    sb.append("    includeInBorrowerCycle: ").append(toIndentedString(includeInBorrowerCycle)).append("\n");
    sb.append("    incomeFromBuyDownAccountId: ").append(toIndentedString(incomeFromBuyDownAccountId)).append("\n");
    sb.append("    incomeFromCapitalizationAccountId: ").append(toIndentedString(incomeFromCapitalizationAccountId)).append("\n");
    sb.append("    incomeFromChargeOffFeesAccountId: ").append(toIndentedString(incomeFromChargeOffFeesAccountId)).append("\n");
    sb.append("    incomeFromChargeOffInterestAccountId: ").append(toIndentedString(incomeFromChargeOffInterestAccountId)).append("\n");
    sb.append("    incomeFromChargeOffPenaltyAccountId: ").append(toIndentedString(incomeFromChargeOffPenaltyAccountId)).append("\n");
    sb.append("    incomeFromFeeAccountId: ").append(toIndentedString(incomeFromFeeAccountId)).append("\n");
    sb.append("    incomeFromGoodwillCreditFeesAccountId: ").append(toIndentedString(incomeFromGoodwillCreditFeesAccountId)).append("\n");
    sb.append("    incomeFromGoodwillCreditInterestAccountId: ").append(toIndentedString(incomeFromGoodwillCreditInterestAccountId)).append("\n");
    sb.append("    incomeFromGoodwillCreditPenaltyAccountId: ").append(toIndentedString(incomeFromGoodwillCreditPenaltyAccountId)).append("\n");
    sb.append("    incomeFromPenaltyAccountId: ").append(toIndentedString(incomeFromPenaltyAccountId)).append("\n");
    sb.append("    incomeFromRecoveryAccountId: ").append(toIndentedString(incomeFromRecoveryAccountId)).append("\n");
    sb.append("    installmentAmountInMultiplesOf: ").append(toIndentedString(installmentAmountInMultiplesOf)).append("\n");
    sb.append("    interestCalculationPeriodType: ").append(toIndentedString(interestCalculationPeriodType)).append("\n");
    sb.append("    interestOnLoanAccountId: ").append(toIndentedString(interestOnLoanAccountId)).append("\n");
    sb.append("    interestRateFrequencyType: ").append(toIndentedString(interestRateFrequencyType)).append("\n");
    sb.append("    interestRatePerPeriod: ").append(toIndentedString(interestRatePerPeriod)).append("\n");
    sb.append("    interestRateVariationsForBorrowerCycle: ").append(toIndentedString(interestRateVariationsForBorrowerCycle)).append("\n");
    sb.append("    interestRecalculationCompoundingMethod: ").append(toIndentedString(interestRecalculationCompoundingMethod)).append("\n");
    sb.append("    interestRecognitionOnDisbursementDate: ").append(toIndentedString(interestRecognitionOnDisbursementDate)).append("\n");
    sb.append("    interestType: ").append(toIndentedString(interestType)).append("\n");
    sb.append("    isArrearsBasedOnOriginalSchedule: ").append(toIndentedString(isArrearsBasedOnOriginalSchedule)).append("\n");
    sb.append("    isCompoundingToBePostedAsTransaction: ").append(toIndentedString(isCompoundingToBePostedAsTransaction)).append("\n");
    sb.append("    isEqualAmortization: ").append(toIndentedString(isEqualAmortization)).append("\n");
    sb.append("    isInterestRecalculationEnabled: ").append(toIndentedString(isInterestRecalculationEnabled)).append("\n");
    sb.append("    isLinkedToFloatingInterestRates: ").append(toIndentedString(isLinkedToFloatingInterestRates)).append("\n");
    sb.append("    loanPortfolioAccountId: ").append(toIndentedString(loanPortfolioAccountId)).append("\n");
    sb.append("    loanScheduleProcessingType: ").append(toIndentedString(loanScheduleProcessingType)).append("\n");
    sb.append("    loanScheduleType: ").append(toIndentedString(loanScheduleType)).append("\n");
    sb.append("    locale: ").append(toIndentedString(locale)).append("\n");
    sb.append("    maxInterestRatePerPeriod: ").append(toIndentedString(maxInterestRatePerPeriod)).append("\n");
    sb.append("    maxNumberOfRepayments: ").append(toIndentedString(maxNumberOfRepayments)).append("\n");
    sb.append("    maxPrincipal: ").append(toIndentedString(maxPrincipal)).append("\n");
    sb.append("    maxTrancheCount: ").append(toIndentedString(maxTrancheCount)).append("\n");
    sb.append("    merchantBuyDownFee: ").append(toIndentedString(merchantBuyDownFee)).append("\n");
    sb.append("    minInterestRatePerPeriod: ").append(toIndentedString(minInterestRatePerPeriod)).append("\n");
    sb.append("    minNumberOfRepayments: ").append(toIndentedString(minNumberOfRepayments)).append("\n");
    sb.append("    minPrincipal: ").append(toIndentedString(minPrincipal)).append("\n");
    sb.append("    minimumDaysBetweenDisbursalAndFirstRepayment: ").append(toIndentedString(minimumDaysBetweenDisbursalAndFirstRepayment)).append("\n");
    sb.append("    multiDisburseLoan: ").append(toIndentedString(multiDisburseLoan)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    numberOfRepaymentVariationsForBorrowerCycle: ").append(toIndentedString(numberOfRepaymentVariationsForBorrowerCycle)).append("\n");
    sb.append("    numberOfRepayments: ").append(toIndentedString(numberOfRepayments)).append("\n");
    sb.append("    outstandingLoanBalance: ").append(toIndentedString(outstandingLoanBalance)).append("\n");
    sb.append("    overAppliedCalculationType: ").append(toIndentedString(overAppliedCalculationType)).append("\n");
    sb.append("    overAppliedNumber: ").append(toIndentedString(overAppliedNumber)).append("\n");
    sb.append("    overDueDaysForRepaymentEvent: ").append(toIndentedString(overDueDaysForRepaymentEvent)).append("\n");
    sb.append("    overdueDaysForNPA: ").append(toIndentedString(overdueDaysForNPA)).append("\n");
    sb.append("    overpaymentLiabilityAccountId: ").append(toIndentedString(overpaymentLiabilityAccountId)).append("\n");
    sb.append("    paymentAllocation: ").append(toIndentedString(paymentAllocation)).append("\n");
    sb.append("    paymentChannelToFundSourceMappings: ").append(toIndentedString(paymentChannelToFundSourceMappings)).append("\n");
    sb.append("    penaltyToIncomeAccountMappings: ").append(toIndentedString(penaltyToIncomeAccountMappings)).append("\n");
    sb.append("    preClosureInterestCalculationStrategy: ").append(toIndentedString(preClosureInterestCalculationStrategy)).append("\n");
    sb.append("    principal: ").append(toIndentedString(principal)).append("\n");
    sb.append("    principalThresholdForLastInstallment: ").append(toIndentedString(principalThresholdForLastInstallment)).append("\n");
    sb.append("    principalVariationsForBorrowerCycle: ").append(toIndentedString(principalVariationsForBorrowerCycle)).append("\n");
    sb.append("    rates: ").append(toIndentedString(rates)).append("\n");
    sb.append("    recalculationCompoundingFrequencyInterval: ").append(toIndentedString(recalculationCompoundingFrequencyInterval)).append("\n");
    sb.append("    recalculationCompoundingFrequencyOnDayType: ").append(toIndentedString(recalculationCompoundingFrequencyOnDayType)).append("\n");
    sb.append("    recalculationCompoundingFrequencyType: ").append(toIndentedString(recalculationCompoundingFrequencyType)).append("\n");
    sb.append("    recalculationRestFrequencyInterval: ").append(toIndentedString(recalculationRestFrequencyInterval)).append("\n");
    sb.append("    recalculationRestFrequencyType: ").append(toIndentedString(recalculationRestFrequencyType)).append("\n");
    sb.append("    receivableFeeAccountId: ").append(toIndentedString(receivableFeeAccountId)).append("\n");
    sb.append("    receivableInterestAccountId: ").append(toIndentedString(receivableInterestAccountId)).append("\n");
    sb.append("    receivablePenaltyAccountId: ").append(toIndentedString(receivablePenaltyAccountId)).append("\n");
    sb.append("    repaymentEvery: ").append(toIndentedString(repaymentEvery)).append("\n");
    sb.append("    repaymentFrequencyType: ").append(toIndentedString(repaymentFrequencyType)).append("\n");
    sb.append("    repaymentStartDateType: ").append(toIndentedString(repaymentStartDateType)).append("\n");
    sb.append("    rescheduleStrategyMethod: ").append(toIndentedString(rescheduleStrategyMethod)).append("\n");
    sb.append("    shortName: ").append(toIndentedString(shortName)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    supportedInterestRefundTypes: ").append(toIndentedString(supportedInterestRefundTypes)).append("\n");
    sb.append("    transactionProcessingStrategyCode: ").append(toIndentedString(transactionProcessingStrategyCode)).append("\n");
    sb.append("    transfersInSuspenseAccountId: ").append(toIndentedString(transfersInSuspenseAccountId)).append("\n");
    sb.append("    useBorrowerCycle: ").append(toIndentedString(useBorrowerCycle)).append("\n");
    sb.append("    writeOffAccountId: ").append(toIndentedString(writeOffAccountId)).append("\n");
    sb.append("    writeOffReasonsToExpenseMappings: ").append(toIndentedString(writeOffReasonsToExpenseMappings)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

