/*
 * Apache Fineract REST API
 * Apache Fineract is a secure, multi-tenanted microfinance platform. The goal of the Apache Fineract API is to empower developers to build apps on top of the Apache Fineract Platform. The [reference app](https://cui.fineract.dev) (username: mifos, password: password) works on the same demo tenant as the interactive links in this documentation. Until we complete the new REST API documentation you still have the legacy documentation available [here](https://fineract.apache.org/docs/legacy/). Please check [the current Fineract documentation](https://fineract.apache.org/docs/current/) for more information.
 *
 * The version of the OpenAPI document: 1.13.0
 * Contact: dev@fineract.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.fineract.client.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.fineract.client.models.PutLoansLoanIdChanges;
import org.apache.fineract.client.models.PutLoansLoanIdCollateral;
import org.apache.fineract.client.models.PutLoansLoanIdDisbursementData;

/**
 * PutLoansLoanIdRequest
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
public class PutLoansLoanIdRequest {
  public static final String SERIALIZED_NAME_AMORTIZATION_TYPE = "amortizationType";
  @SerializedName(SERIALIZED_NAME_AMORTIZATION_TYPE)
  private Integer amortizationType;

  public static final String SERIALIZED_NAME_CHARGES = "charges";
  @SerializedName(SERIALIZED_NAME_CHARGES)
  private List<PutLoansLoanIdChanges> charges;

  public static final String SERIALIZED_NAME_CLIENT_ID = "clientId";
  @SerializedName(SERIALIZED_NAME_CLIENT_ID)
  private Long clientId;

  public static final String SERIALIZED_NAME_COLLATERAL = "collateral";
  @SerializedName(SERIALIZED_NAME_COLLATERAL)
  private List<PutLoansLoanIdCollateral> collateral;

  public static final String SERIALIZED_NAME_CREATE_STANDING_INSTRUCTION_AT_DISBURSEMENT = "createStandingInstructionAtDisbursement";
  @SerializedName(SERIALIZED_NAME_CREATE_STANDING_INSTRUCTION_AT_DISBURSEMENT)
  private Boolean createStandingInstructionAtDisbursement;

  public static final String SERIALIZED_NAME_DATE_FORMAT = "dateFormat";
  @SerializedName(SERIALIZED_NAME_DATE_FORMAT)
  private String dateFormat;

  public static final String SERIALIZED_NAME_DISBURSED_AMOUNT_PERCENTAGE_FOR_DOWN_PAYMENT = "disbursedAmountPercentageForDownPayment";
  @SerializedName(SERIALIZED_NAME_DISBURSED_AMOUNT_PERCENTAGE_FOR_DOWN_PAYMENT)
  private BigDecimal disbursedAmountPercentageForDownPayment;

  public static final String SERIALIZED_NAME_DISBURSEMENT_DATA = "disbursementData";
  @SerializedName(SERIALIZED_NAME_DISBURSEMENT_DATA)
  private List<PutLoansLoanIdDisbursementData> disbursementData;

  public static final String SERIALIZED_NAME_ENABLE_AUTO_REPAYMENT_FOR_DOWN_PAYMENT = "enableAutoRepaymentForDownPayment";
  @SerializedName(SERIALIZED_NAME_ENABLE_AUTO_REPAYMENT_FOR_DOWN_PAYMENT)
  private Boolean enableAutoRepaymentForDownPayment;

  public static final String SERIALIZED_NAME_ENABLE_DOWN_PAYMENT = "enableDownPayment";
  @SerializedName(SERIALIZED_NAME_ENABLE_DOWN_PAYMENT)
  private Boolean enableDownPayment;

  public static final String SERIALIZED_NAME_ENABLE_INSTALLMENT_LEVEL_DELINQUENCY = "enableInstallmentLevelDelinquency";
  @SerializedName(SERIALIZED_NAME_ENABLE_INSTALLMENT_LEVEL_DELINQUENCY)
  private Boolean enableInstallmentLevelDelinquency;

  public static final String SERIALIZED_NAME_EXPECTED_DISBURSEMENT_DATE = "expectedDisbursementDate";
  @SerializedName(SERIALIZED_NAME_EXPECTED_DISBURSEMENT_DATE)
  private String expectedDisbursementDate;

  public static final String SERIALIZED_NAME_FIXED_LENGTH = "fixedLength";
  @SerializedName(SERIALIZED_NAME_FIXED_LENGTH)
  private Integer fixedLength;

  public static final String SERIALIZED_NAME_FIXED_PRINCIPAL_PERCENTAGE_PER_INSTALLMENT = "fixedPrincipalPercentagePerInstallment";
  @SerializedName(SERIALIZED_NAME_FIXED_PRINCIPAL_PERCENTAGE_PER_INSTALLMENT)
  private BigDecimal fixedPrincipalPercentagePerInstallment;

  public static final String SERIALIZED_NAME_FRAUD = "fraud";
  @SerializedName(SERIALIZED_NAME_FRAUD)
  private Boolean fraud;

  public static final String SERIALIZED_NAME_GRACE_ON_ARREARS_AGEING = "graceOnArrearsAgeing";
  @SerializedName(SERIALIZED_NAME_GRACE_ON_ARREARS_AGEING)
  private Integer graceOnArrearsAgeing;

  public static final String SERIALIZED_NAME_INTEREST_CALCULATION_PERIOD_TYPE = "interestCalculationPeriodType";
  @SerializedName(SERIALIZED_NAME_INTEREST_CALCULATION_PERIOD_TYPE)
  private Integer interestCalculationPeriodType;

  public static final String SERIALIZED_NAME_INTEREST_CHARGED_FROM_DATE = "interestChargedFromDate";
  @SerializedName(SERIALIZED_NAME_INTEREST_CHARGED_FROM_DATE)
  private String interestChargedFromDate;

  public static final String SERIALIZED_NAME_INTEREST_RATE_FREQUENCY_TYPE = "interestRateFrequencyType";
  @SerializedName(SERIALIZED_NAME_INTEREST_RATE_FREQUENCY_TYPE)
  private Integer interestRateFrequencyType;

  public static final String SERIALIZED_NAME_INTEREST_RATE_PER_PERIOD = "interestRatePerPeriod";
  @SerializedName(SERIALIZED_NAME_INTEREST_RATE_PER_PERIOD)
  private BigDecimal interestRatePerPeriod;

  public static final String SERIALIZED_NAME_INTEREST_RECOGNITION_ON_DISBURSEMENT_DATE = "interestRecognitionOnDisbursementDate";
  @SerializedName(SERIALIZED_NAME_INTEREST_RECOGNITION_ON_DISBURSEMENT_DATE)
  private Boolean interestRecognitionOnDisbursementDate;

  public static final String SERIALIZED_NAME_INTEREST_TYPE = "interestType";
  @SerializedName(SERIALIZED_NAME_INTEREST_TYPE)
  private Integer interestType;

  public static final String SERIALIZED_NAME_IS_EQUAL_AMORTIZATION = "isEqualAmortization";
  @SerializedName(SERIALIZED_NAME_IS_EQUAL_AMORTIZATION)
  private Boolean isEqualAmortization;

  public static final String SERIALIZED_NAME_IS_TOPUP = "isTopup";
  @SerializedName(SERIALIZED_NAME_IS_TOPUP)
  private Boolean isTopup;

  public static final String SERIALIZED_NAME_LINK_ACCOUNT_ID = "linkAccountId";
  @SerializedName(SERIALIZED_NAME_LINK_ACCOUNT_ID)
  private Long linkAccountId;

  public static final String SERIALIZED_NAME_LOAN_ID_TO_CLOSE = "loanIdToClose";
  @SerializedName(SERIALIZED_NAME_LOAN_ID_TO_CLOSE)
  private Long loanIdToClose;

  public static final String SERIALIZED_NAME_LOAN_SCHEDULE_PROCESSING_TYPE = "loanScheduleProcessingType";
  @SerializedName(SERIALIZED_NAME_LOAN_SCHEDULE_PROCESSING_TYPE)
  private String loanScheduleProcessingType;

  public static final String SERIALIZED_NAME_LOAN_TERM_FREQUENCY = "loanTermFrequency";
  @SerializedName(SERIALIZED_NAME_LOAN_TERM_FREQUENCY)
  private Integer loanTermFrequency;

  public static final String SERIALIZED_NAME_LOAN_TERM_FREQUENCY_TYPE = "loanTermFrequencyType";
  @SerializedName(SERIALIZED_NAME_LOAN_TERM_FREQUENCY_TYPE)
  private Integer loanTermFrequencyType;

  public static final String SERIALIZED_NAME_LOAN_TYPE = "loanType";
  @SerializedName(SERIALIZED_NAME_LOAN_TYPE)
  private String loanType;

  public static final String SERIALIZED_NAME_LOCALE = "locale";
  @SerializedName(SERIALIZED_NAME_LOCALE)
  private String locale;

  public static final String SERIALIZED_NAME_MAX_OUTSTANDING_LOAN_BALANCE = "maxOutstandingLoanBalance";
  @SerializedName(SERIALIZED_NAME_MAX_OUTSTANDING_LOAN_BALANCE)
  private Long maxOutstandingLoanBalance;

  public static final String SERIALIZED_NAME_NUMBER_OF_REPAYMENTS = "numberOfRepayments";
  @SerializedName(SERIALIZED_NAME_NUMBER_OF_REPAYMENTS)
  private Integer numberOfRepayments;

  public static final String SERIALIZED_NAME_PRINCIPAL = "principal";
  @SerializedName(SERIALIZED_NAME_PRINCIPAL)
  private Long principal;

  public static final String SERIALIZED_NAME_PRODUCT_ID = "productId";
  @SerializedName(SERIALIZED_NAME_PRODUCT_ID)
  private Long productId;

  public static final String SERIALIZED_NAME_REPAYMENT_EVERY = "repaymentEvery";
  @SerializedName(SERIALIZED_NAME_REPAYMENT_EVERY)
  private Integer repaymentEvery;

  public static final String SERIALIZED_NAME_REPAYMENT_FREQUENCY_DAY_OF_WEEK_TYPE = "repaymentFrequencyDayOfWeekType";
  @SerializedName(SERIALIZED_NAME_REPAYMENT_FREQUENCY_DAY_OF_WEEK_TYPE)
  private Integer repaymentFrequencyDayOfWeekType;

  public static final String SERIALIZED_NAME_REPAYMENT_FREQUENCY_NTH_DAY_TYPE = "repaymentFrequencyNthDayType";
  @SerializedName(SERIALIZED_NAME_REPAYMENT_FREQUENCY_NTH_DAY_TYPE)
  private Integer repaymentFrequencyNthDayType;

  public static final String SERIALIZED_NAME_REPAYMENT_FREQUENCY_TYPE = "repaymentFrequencyType";
  @SerializedName(SERIALIZED_NAME_REPAYMENT_FREQUENCY_TYPE)
  private Integer repaymentFrequencyType;

  public static final String SERIALIZED_NAME_REPAYMENTS_STARTING_FROM_DATE = "repaymentsStartingFromDate";
  @SerializedName(SERIALIZED_NAME_REPAYMENTS_STARTING_FROM_DATE)
  private String repaymentsStartingFromDate;

  public static final String SERIALIZED_NAME_SUBMITTED_ON_DATE = "submittedOnDate";
  @SerializedName(SERIALIZED_NAME_SUBMITTED_ON_DATE)
  private String submittedOnDate;

  public static final String SERIALIZED_NAME_TRANSACTION_PROCESSING_STRATEGY_CODE = "transactionProcessingStrategyCode";
  @SerializedName(SERIALIZED_NAME_TRANSACTION_PROCESSING_STRATEGY_CODE)
  private String transactionProcessingStrategyCode;

  public PutLoansLoanIdRequest() {
  }

  public PutLoansLoanIdRequest amortizationType(Integer amortizationType) {
    
    this.amortizationType = amortizationType;
    return this;
  }

  /**
   * Get amortizationType
   * @return amortizationType
   */
  @javax.annotation.Nullable

  public Integer getAmortizationType() {
    return amortizationType;
  }


  public void setAmortizationType(Integer amortizationType) {
    this.amortizationType = amortizationType;
  }

  public PutLoansLoanIdRequest charges(List<PutLoansLoanIdChanges> charges) {
    
    this.charges = charges;
    return this;
  }

  public PutLoansLoanIdRequest addChargesItem(PutLoansLoanIdChanges chargesItem) {
    if (this.charges == null) {
      this.charges = new ArrayList<>();
    }
    this.charges.add(chargesItem);
    return this;
  }

  /**
   * Get charges
   * @return charges
   */
  @javax.annotation.Nullable

  public List<PutLoansLoanIdChanges> getCharges() {
    return charges;
  }


  public void setCharges(List<PutLoansLoanIdChanges> charges) {
    this.charges = charges;
  }

  public PutLoansLoanIdRequest clientId(Long clientId) {
    
    this.clientId = clientId;
    return this;
  }

  /**
   * Get clientId
   * @return clientId
   */
  @javax.annotation.Nullable

  public Long getClientId() {
    return clientId;
  }


  public void setClientId(Long clientId) {
    this.clientId = clientId;
  }

  public PutLoansLoanIdRequest collateral(List<PutLoansLoanIdCollateral> collateral) {
    
    this.collateral = collateral;
    return this;
  }

  public PutLoansLoanIdRequest addCollateralItem(PutLoansLoanIdCollateral collateralItem) {
    if (this.collateral == null) {
      this.collateral = new ArrayList<>();
    }
    this.collateral.add(collateralItem);
    return this;
  }

  /**
   * Get collateral
   * @return collateral
   */
  @javax.annotation.Nullable

  public List<PutLoansLoanIdCollateral> getCollateral() {
    return collateral;
  }


  public void setCollateral(List<PutLoansLoanIdCollateral> collateral) {
    this.collateral = collateral;
  }

  public PutLoansLoanIdRequest createStandingInstructionAtDisbursement(Boolean createStandingInstructionAtDisbursement) {
    
    this.createStandingInstructionAtDisbursement = createStandingInstructionAtDisbursement;
    return this;
  }

  /**
   * Get createStandingInstructionAtDisbursement
   * @return createStandingInstructionAtDisbursement
   */
  @javax.annotation.Nullable

  public Boolean getCreateStandingInstructionAtDisbursement() {
    return createStandingInstructionAtDisbursement;
  }


  public void setCreateStandingInstructionAtDisbursement(Boolean createStandingInstructionAtDisbursement) {
    this.createStandingInstructionAtDisbursement = createStandingInstructionAtDisbursement;
  }

  public PutLoansLoanIdRequest dateFormat(String dateFormat) {
    
    this.dateFormat = dateFormat;
    return this;
  }

  /**
   * Get dateFormat
   * @return dateFormat
   */
  @javax.annotation.Nullable

  public String getDateFormat() {
    return dateFormat;
  }


  public void setDateFormat(String dateFormat) {
    this.dateFormat = dateFormat;
  }

  public PutLoansLoanIdRequest disbursedAmountPercentageForDownPayment(BigDecimal disbursedAmountPercentageForDownPayment) {
    
    this.disbursedAmountPercentageForDownPayment = disbursedAmountPercentageForDownPayment;
    return this;
  }

  /**
   * Get disbursedAmountPercentageForDownPayment
   * @return disbursedAmountPercentageForDownPayment
   */
  @javax.annotation.Nullable

  public BigDecimal getDisbursedAmountPercentageForDownPayment() {
    return disbursedAmountPercentageForDownPayment;
  }


  public void setDisbursedAmountPercentageForDownPayment(BigDecimal disbursedAmountPercentageForDownPayment) {
    this.disbursedAmountPercentageForDownPayment = disbursedAmountPercentageForDownPayment;
  }

  public PutLoansLoanIdRequest disbursementData(List<PutLoansLoanIdDisbursementData> disbursementData) {
    
    this.disbursementData = disbursementData;
    return this;
  }

  public PutLoansLoanIdRequest addDisbursementDataItem(PutLoansLoanIdDisbursementData disbursementDataItem) {
    if (this.disbursementData == null) {
      this.disbursementData = new ArrayList<>();
    }
    this.disbursementData.add(disbursementDataItem);
    return this;
  }

  /**
   * Get disbursementData
   * @return disbursementData
   */
  @javax.annotation.Nullable

  public List<PutLoansLoanIdDisbursementData> getDisbursementData() {
    return disbursementData;
  }


  public void setDisbursementData(List<PutLoansLoanIdDisbursementData> disbursementData) {
    this.disbursementData = disbursementData;
  }

  public PutLoansLoanIdRequest enableAutoRepaymentForDownPayment(Boolean enableAutoRepaymentForDownPayment) {
    
    this.enableAutoRepaymentForDownPayment = enableAutoRepaymentForDownPayment;
    return this;
  }

  /**
   * Get enableAutoRepaymentForDownPayment
   * @return enableAutoRepaymentForDownPayment
   */
  @javax.annotation.Nullable

  public Boolean getEnableAutoRepaymentForDownPayment() {
    return enableAutoRepaymentForDownPayment;
  }


  public void setEnableAutoRepaymentForDownPayment(Boolean enableAutoRepaymentForDownPayment) {
    this.enableAutoRepaymentForDownPayment = enableAutoRepaymentForDownPayment;
  }

  public PutLoansLoanIdRequest enableDownPayment(Boolean enableDownPayment) {
    
    this.enableDownPayment = enableDownPayment;
    return this;
  }

  /**
   * Get enableDownPayment
   * @return enableDownPayment
   */
  @javax.annotation.Nullable

  public Boolean getEnableDownPayment() {
    return enableDownPayment;
  }


  public void setEnableDownPayment(Boolean enableDownPayment) {
    this.enableDownPayment = enableDownPayment;
  }

  public PutLoansLoanIdRequest enableInstallmentLevelDelinquency(Boolean enableInstallmentLevelDelinquency) {
    
    this.enableInstallmentLevelDelinquency = enableInstallmentLevelDelinquency;
    return this;
  }

  /**
   * Get enableInstallmentLevelDelinquency
   * @return enableInstallmentLevelDelinquency
   */
  @javax.annotation.Nullable

  public Boolean getEnableInstallmentLevelDelinquency() {
    return enableInstallmentLevelDelinquency;
  }


  public void setEnableInstallmentLevelDelinquency(Boolean enableInstallmentLevelDelinquency) {
    this.enableInstallmentLevelDelinquency = enableInstallmentLevelDelinquency;
  }

  public PutLoansLoanIdRequest expectedDisbursementDate(String expectedDisbursementDate) {
    
    this.expectedDisbursementDate = expectedDisbursementDate;
    return this;
  }

  /**
   * Get expectedDisbursementDate
   * @return expectedDisbursementDate
   */
  @javax.annotation.Nullable

  public String getExpectedDisbursementDate() {
    return expectedDisbursementDate;
  }


  public void setExpectedDisbursementDate(String expectedDisbursementDate) {
    this.expectedDisbursementDate = expectedDisbursementDate;
  }

  public PutLoansLoanIdRequest fixedLength(Integer fixedLength) {
    
    this.fixedLength = fixedLength;
    return this;
  }

  /**
   * Get fixedLength
   * @return fixedLength
   */
  @javax.annotation.Nullable

  public Integer getFixedLength() {
    return fixedLength;
  }


  public void setFixedLength(Integer fixedLength) {
    this.fixedLength = fixedLength;
  }

  public PutLoansLoanIdRequest fixedPrincipalPercentagePerInstallment(BigDecimal fixedPrincipalPercentagePerInstallment) {
    
    this.fixedPrincipalPercentagePerInstallment = fixedPrincipalPercentagePerInstallment;
    return this;
  }

  /**
   * Get fixedPrincipalPercentagePerInstallment
   * @return fixedPrincipalPercentagePerInstallment
   */
  @javax.annotation.Nullable

  public BigDecimal getFixedPrincipalPercentagePerInstallment() {
    return fixedPrincipalPercentagePerInstallment;
  }


  public void setFixedPrincipalPercentagePerInstallment(BigDecimal fixedPrincipalPercentagePerInstallment) {
    this.fixedPrincipalPercentagePerInstallment = fixedPrincipalPercentagePerInstallment;
  }

  public PutLoansLoanIdRequest fraud(Boolean fraud) {
    
    this.fraud = fraud;
    return this;
  }

  /**
   * Get fraud
   * @return fraud
   */
  @javax.annotation.Nullable

  public Boolean getFraud() {
    return fraud;
  }


  public void setFraud(Boolean fraud) {
    this.fraud = fraud;
  }

  public PutLoansLoanIdRequest graceOnArrearsAgeing(Integer graceOnArrearsAgeing) {
    
    this.graceOnArrearsAgeing = graceOnArrearsAgeing;
    return this;
  }

  /**
   * Get graceOnArrearsAgeing
   * @return graceOnArrearsAgeing
   */
  @javax.annotation.Nullable

  public Integer getGraceOnArrearsAgeing() {
    return graceOnArrearsAgeing;
  }


  public void setGraceOnArrearsAgeing(Integer graceOnArrearsAgeing) {
    this.graceOnArrearsAgeing = graceOnArrearsAgeing;
  }

  public PutLoansLoanIdRequest interestCalculationPeriodType(Integer interestCalculationPeriodType) {
    
    this.interestCalculationPeriodType = interestCalculationPeriodType;
    return this;
  }

  /**
   * Get interestCalculationPeriodType
   * @return interestCalculationPeriodType
   */
  @javax.annotation.Nullable

  public Integer getInterestCalculationPeriodType() {
    return interestCalculationPeriodType;
  }


  public void setInterestCalculationPeriodType(Integer interestCalculationPeriodType) {
    this.interestCalculationPeriodType = interestCalculationPeriodType;
  }

  public PutLoansLoanIdRequest interestChargedFromDate(String interestChargedFromDate) {
    
    this.interestChargedFromDate = interestChargedFromDate;
    return this;
  }

  /**
   * Get interestChargedFromDate
   * @return interestChargedFromDate
   */
  @javax.annotation.Nullable

  public String getInterestChargedFromDate() {
    return interestChargedFromDate;
  }


  public void setInterestChargedFromDate(String interestChargedFromDate) {
    this.interestChargedFromDate = interestChargedFromDate;
  }

  public PutLoansLoanIdRequest interestRateFrequencyType(Integer interestRateFrequencyType) {
    
    this.interestRateFrequencyType = interestRateFrequencyType;
    return this;
  }

  /**
   * Get interestRateFrequencyType
   * @return interestRateFrequencyType
   */
  @javax.annotation.Nullable

  public Integer getInterestRateFrequencyType() {
    return interestRateFrequencyType;
  }


  public void setInterestRateFrequencyType(Integer interestRateFrequencyType) {
    this.interestRateFrequencyType = interestRateFrequencyType;
  }

  public PutLoansLoanIdRequest interestRatePerPeriod(BigDecimal interestRatePerPeriod) {
    
    this.interestRatePerPeriod = interestRatePerPeriod;
    return this;
  }

  /**
   * Get interestRatePerPeriod
   * @return interestRatePerPeriod
   */
  @javax.annotation.Nullable

  public BigDecimal getInterestRatePerPeriod() {
    return interestRatePerPeriod;
  }


  public void setInterestRatePerPeriod(BigDecimal interestRatePerPeriod) {
    this.interestRatePerPeriod = interestRatePerPeriod;
  }

  public PutLoansLoanIdRequest interestRecognitionOnDisbursementDate(Boolean interestRecognitionOnDisbursementDate) {
    
    this.interestRecognitionOnDisbursementDate = interestRecognitionOnDisbursementDate;
    return this;
  }

  /**
   * Get interestRecognitionOnDisbursementDate
   * @return interestRecognitionOnDisbursementDate
   */
  @javax.annotation.Nullable

  public Boolean getInterestRecognitionOnDisbursementDate() {
    return interestRecognitionOnDisbursementDate;
  }


  public void setInterestRecognitionOnDisbursementDate(Boolean interestRecognitionOnDisbursementDate) {
    this.interestRecognitionOnDisbursementDate = interestRecognitionOnDisbursementDate;
  }

  public PutLoansLoanIdRequest interestType(Integer interestType) {
    
    this.interestType = interestType;
    return this;
  }

  /**
   * Get interestType
   * @return interestType
   */
  @javax.annotation.Nullable

  public Integer getInterestType() {
    return interestType;
  }


  public void setInterestType(Integer interestType) {
    this.interestType = interestType;
  }

  public PutLoansLoanIdRequest isEqualAmortization(Boolean isEqualAmortization) {
    
    this.isEqualAmortization = isEqualAmortization;
    return this;
  }

  /**
   * Get isEqualAmortization
   * @return isEqualAmortization
   */
  @javax.annotation.Nullable

  public Boolean getIsEqualAmortization() {
    return isEqualAmortization;
  }


  public void setIsEqualAmortization(Boolean isEqualAmortization) {
    this.isEqualAmortization = isEqualAmortization;
  }

  public PutLoansLoanIdRequest isTopup(Boolean isTopup) {
    
    this.isTopup = isTopup;
    return this;
  }

  /**
   * Get isTopup
   * @return isTopup
   */
  @javax.annotation.Nullable

  public Boolean getIsTopup() {
    return isTopup;
  }


  public void setIsTopup(Boolean isTopup) {
    this.isTopup = isTopup;
  }

  public PutLoansLoanIdRequest linkAccountId(Long linkAccountId) {
    
    this.linkAccountId = linkAccountId;
    return this;
  }

  /**
   * Get linkAccountId
   * @return linkAccountId
   */
  @javax.annotation.Nullable

  public Long getLinkAccountId() {
    return linkAccountId;
  }


  public void setLinkAccountId(Long linkAccountId) {
    this.linkAccountId = linkAccountId;
  }

  public PutLoansLoanIdRequest loanIdToClose(Long loanIdToClose) {
    
    this.loanIdToClose = loanIdToClose;
    return this;
  }

  /**
   * Get loanIdToClose
   * @return loanIdToClose
   */
  @javax.annotation.Nullable

  public Long getLoanIdToClose() {
    return loanIdToClose;
  }


  public void setLoanIdToClose(Long loanIdToClose) {
    this.loanIdToClose = loanIdToClose;
  }

  public PutLoansLoanIdRequest loanScheduleProcessingType(String loanScheduleProcessingType) {
    
    this.loanScheduleProcessingType = loanScheduleProcessingType;
    return this;
  }

  /**
   * Get loanScheduleProcessingType
   * @return loanScheduleProcessingType
   */
  @javax.annotation.Nullable

  public String getLoanScheduleProcessingType() {
    return loanScheduleProcessingType;
  }


  public void setLoanScheduleProcessingType(String loanScheduleProcessingType) {
    this.loanScheduleProcessingType = loanScheduleProcessingType;
  }

  public PutLoansLoanIdRequest loanTermFrequency(Integer loanTermFrequency) {
    
    this.loanTermFrequency = loanTermFrequency;
    return this;
  }

  /**
   * Get loanTermFrequency
   * @return loanTermFrequency
   */
  @javax.annotation.Nullable

  public Integer getLoanTermFrequency() {
    return loanTermFrequency;
  }


  public void setLoanTermFrequency(Integer loanTermFrequency) {
    this.loanTermFrequency = loanTermFrequency;
  }

  public PutLoansLoanIdRequest loanTermFrequencyType(Integer loanTermFrequencyType) {
    
    this.loanTermFrequencyType = loanTermFrequencyType;
    return this;
  }

  /**
   * Get loanTermFrequencyType
   * @return loanTermFrequencyType
   */
  @javax.annotation.Nullable

  public Integer getLoanTermFrequencyType() {
    return loanTermFrequencyType;
  }


  public void setLoanTermFrequencyType(Integer loanTermFrequencyType) {
    this.loanTermFrequencyType = loanTermFrequencyType;
  }

  public PutLoansLoanIdRequest loanType(String loanType) {
    
    this.loanType = loanType;
    return this;
  }

  /**
   * Get loanType
   * @return loanType
   */
  @javax.annotation.Nullable

  public String getLoanType() {
    return loanType;
  }


  public void setLoanType(String loanType) {
    this.loanType = loanType;
  }

  public PutLoansLoanIdRequest locale(String locale) {
    
    this.locale = locale;
    return this;
  }

  /**
   * Get locale
   * @return locale
   */
  @javax.annotation.Nullable

  public String getLocale() {
    return locale;
  }


  public void setLocale(String locale) {
    this.locale = locale;
  }

  public PutLoansLoanIdRequest maxOutstandingLoanBalance(Long maxOutstandingLoanBalance) {
    
    this.maxOutstandingLoanBalance = maxOutstandingLoanBalance;
    return this;
  }

  /**
   * Get maxOutstandingLoanBalance
   * @return maxOutstandingLoanBalance
   */
  @javax.annotation.Nullable

  public Long getMaxOutstandingLoanBalance() {
    return maxOutstandingLoanBalance;
  }


  public void setMaxOutstandingLoanBalance(Long maxOutstandingLoanBalance) {
    this.maxOutstandingLoanBalance = maxOutstandingLoanBalance;
  }

  public PutLoansLoanIdRequest numberOfRepayments(Integer numberOfRepayments) {
    
    this.numberOfRepayments = numberOfRepayments;
    return this;
  }

  /**
   * Get numberOfRepayments
   * @return numberOfRepayments
   */
  @javax.annotation.Nullable

  public Integer getNumberOfRepayments() {
    return numberOfRepayments;
  }


  public void setNumberOfRepayments(Integer numberOfRepayments) {
    this.numberOfRepayments = numberOfRepayments;
  }

  public PutLoansLoanIdRequest principal(Long principal) {
    
    this.principal = principal;
    return this;
  }

  /**
   * Get principal
   * @return principal
   */
  @javax.annotation.Nullable

  public Long getPrincipal() {
    return principal;
  }


  public void setPrincipal(Long principal) {
    this.principal = principal;
  }

  public PutLoansLoanIdRequest productId(Long productId) {
    
    this.productId = productId;
    return this;
  }

  /**
   * Get productId
   * @return productId
   */
  @javax.annotation.Nullable

  public Long getProductId() {
    return productId;
  }


  public void setProductId(Long productId) {
    this.productId = productId;
  }

  public PutLoansLoanIdRequest repaymentEvery(Integer repaymentEvery) {
    
    this.repaymentEvery = repaymentEvery;
    return this;
  }

  /**
   * Get repaymentEvery
   * @return repaymentEvery
   */
  @javax.annotation.Nullable

  public Integer getRepaymentEvery() {
    return repaymentEvery;
  }


  public void setRepaymentEvery(Integer repaymentEvery) {
    this.repaymentEvery = repaymentEvery;
  }

  public PutLoansLoanIdRequest repaymentFrequencyDayOfWeekType(Integer repaymentFrequencyDayOfWeekType) {
    
    this.repaymentFrequencyDayOfWeekType = repaymentFrequencyDayOfWeekType;
    return this;
  }

  /**
   * Get repaymentFrequencyDayOfWeekType
   * @return repaymentFrequencyDayOfWeekType
   */
  @javax.annotation.Nullable

  public Integer getRepaymentFrequencyDayOfWeekType() {
    return repaymentFrequencyDayOfWeekType;
  }


  public void setRepaymentFrequencyDayOfWeekType(Integer repaymentFrequencyDayOfWeekType) {
    this.repaymentFrequencyDayOfWeekType = repaymentFrequencyDayOfWeekType;
  }

  public PutLoansLoanIdRequest repaymentFrequencyNthDayType(Integer repaymentFrequencyNthDayType) {
    
    this.repaymentFrequencyNthDayType = repaymentFrequencyNthDayType;
    return this;
  }

  /**
   * Get repaymentFrequencyNthDayType
   * @return repaymentFrequencyNthDayType
   */
  @javax.annotation.Nullable

  public Integer getRepaymentFrequencyNthDayType() {
    return repaymentFrequencyNthDayType;
  }


  public void setRepaymentFrequencyNthDayType(Integer repaymentFrequencyNthDayType) {
    this.repaymentFrequencyNthDayType = repaymentFrequencyNthDayType;
  }

  public PutLoansLoanIdRequest repaymentFrequencyType(Integer repaymentFrequencyType) {
    
    this.repaymentFrequencyType = repaymentFrequencyType;
    return this;
  }

  /**
   * Get repaymentFrequencyType
   * @return repaymentFrequencyType
   */
  @javax.annotation.Nullable

  public Integer getRepaymentFrequencyType() {
    return repaymentFrequencyType;
  }


  public void setRepaymentFrequencyType(Integer repaymentFrequencyType) {
    this.repaymentFrequencyType = repaymentFrequencyType;
  }

  public PutLoansLoanIdRequest repaymentsStartingFromDate(String repaymentsStartingFromDate) {
    
    this.repaymentsStartingFromDate = repaymentsStartingFromDate;
    return this;
  }

  /**
   * Get repaymentsStartingFromDate
   * @return repaymentsStartingFromDate
   */
  @javax.annotation.Nullable

  public String getRepaymentsStartingFromDate() {
    return repaymentsStartingFromDate;
  }


  public void setRepaymentsStartingFromDate(String repaymentsStartingFromDate) {
    this.repaymentsStartingFromDate = repaymentsStartingFromDate;
  }

  public PutLoansLoanIdRequest submittedOnDate(String submittedOnDate) {
    
    this.submittedOnDate = submittedOnDate;
    return this;
  }

  /**
   * Get submittedOnDate
   * @return submittedOnDate
   */
  @javax.annotation.Nullable

  public String getSubmittedOnDate() {
    return submittedOnDate;
  }


  public void setSubmittedOnDate(String submittedOnDate) {
    this.submittedOnDate = submittedOnDate;
  }

  public PutLoansLoanIdRequest transactionProcessingStrategyCode(String transactionProcessingStrategyCode) {
    
    this.transactionProcessingStrategyCode = transactionProcessingStrategyCode;
    return this;
  }

  /**
   * Get transactionProcessingStrategyCode
   * @return transactionProcessingStrategyCode
   */
  @javax.annotation.Nullable

  public String getTransactionProcessingStrategyCode() {
    return transactionProcessingStrategyCode;
  }


  public void setTransactionProcessingStrategyCode(String transactionProcessingStrategyCode) {
    this.transactionProcessingStrategyCode = transactionProcessingStrategyCode;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PutLoansLoanIdRequest putLoansLoanIdRequest = (PutLoansLoanIdRequest) o;
    return Objects.equals(this.amortizationType, putLoansLoanIdRequest.amortizationType) &&
        Objects.equals(this.charges, putLoansLoanIdRequest.charges) &&
        Objects.equals(this.clientId, putLoansLoanIdRequest.clientId) &&
        Objects.equals(this.collateral, putLoansLoanIdRequest.collateral) &&
        Objects.equals(this.createStandingInstructionAtDisbursement, putLoansLoanIdRequest.createStandingInstructionAtDisbursement) &&
        Objects.equals(this.dateFormat, putLoansLoanIdRequest.dateFormat) &&
        Objects.equals(this.disbursedAmountPercentageForDownPayment, putLoansLoanIdRequest.disbursedAmountPercentageForDownPayment) &&
        Objects.equals(this.disbursementData, putLoansLoanIdRequest.disbursementData) &&
        Objects.equals(this.enableAutoRepaymentForDownPayment, putLoansLoanIdRequest.enableAutoRepaymentForDownPayment) &&
        Objects.equals(this.enableDownPayment, putLoansLoanIdRequest.enableDownPayment) &&
        Objects.equals(this.enableInstallmentLevelDelinquency, putLoansLoanIdRequest.enableInstallmentLevelDelinquency) &&
        Objects.equals(this.expectedDisbursementDate, putLoansLoanIdRequest.expectedDisbursementDate) &&
        Objects.equals(this.fixedLength, putLoansLoanIdRequest.fixedLength) &&
        Objects.equals(this.fixedPrincipalPercentagePerInstallment, putLoansLoanIdRequest.fixedPrincipalPercentagePerInstallment) &&
        Objects.equals(this.fraud, putLoansLoanIdRequest.fraud) &&
        Objects.equals(this.graceOnArrearsAgeing, putLoansLoanIdRequest.graceOnArrearsAgeing) &&
        Objects.equals(this.interestCalculationPeriodType, putLoansLoanIdRequest.interestCalculationPeriodType) &&
        Objects.equals(this.interestChargedFromDate, putLoansLoanIdRequest.interestChargedFromDate) &&
        Objects.equals(this.interestRateFrequencyType, putLoansLoanIdRequest.interestRateFrequencyType) &&
        Objects.equals(this.interestRatePerPeriod, putLoansLoanIdRequest.interestRatePerPeriod) &&
        Objects.equals(this.interestRecognitionOnDisbursementDate, putLoansLoanIdRequest.interestRecognitionOnDisbursementDate) &&
        Objects.equals(this.interestType, putLoansLoanIdRequest.interestType) &&
        Objects.equals(this.isEqualAmortization, putLoansLoanIdRequest.isEqualAmortization) &&
        Objects.equals(this.isTopup, putLoansLoanIdRequest.isTopup) &&
        Objects.equals(this.linkAccountId, putLoansLoanIdRequest.linkAccountId) &&
        Objects.equals(this.loanIdToClose, putLoansLoanIdRequest.loanIdToClose) &&
        Objects.equals(this.loanScheduleProcessingType, putLoansLoanIdRequest.loanScheduleProcessingType) &&
        Objects.equals(this.loanTermFrequency, putLoansLoanIdRequest.loanTermFrequency) &&
        Objects.equals(this.loanTermFrequencyType, putLoansLoanIdRequest.loanTermFrequencyType) &&
        Objects.equals(this.loanType, putLoansLoanIdRequest.loanType) &&
        Objects.equals(this.locale, putLoansLoanIdRequest.locale) &&
        Objects.equals(this.maxOutstandingLoanBalance, putLoansLoanIdRequest.maxOutstandingLoanBalance) &&
        Objects.equals(this.numberOfRepayments, putLoansLoanIdRequest.numberOfRepayments) &&
        Objects.equals(this.principal, putLoansLoanIdRequest.principal) &&
        Objects.equals(this.productId, putLoansLoanIdRequest.productId) &&
        Objects.equals(this.repaymentEvery, putLoansLoanIdRequest.repaymentEvery) &&
        Objects.equals(this.repaymentFrequencyDayOfWeekType, putLoansLoanIdRequest.repaymentFrequencyDayOfWeekType) &&
        Objects.equals(this.repaymentFrequencyNthDayType, putLoansLoanIdRequest.repaymentFrequencyNthDayType) &&
        Objects.equals(this.repaymentFrequencyType, putLoansLoanIdRequest.repaymentFrequencyType) &&
        Objects.equals(this.repaymentsStartingFromDate, putLoansLoanIdRequest.repaymentsStartingFromDate) &&
        Objects.equals(this.submittedOnDate, putLoansLoanIdRequest.submittedOnDate) &&
        Objects.equals(this.transactionProcessingStrategyCode, putLoansLoanIdRequest.transactionProcessingStrategyCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(amortizationType, charges, clientId, collateral, createStandingInstructionAtDisbursement, dateFormat, disbursedAmountPercentageForDownPayment, disbursementData, enableAutoRepaymentForDownPayment, enableDownPayment, enableInstallmentLevelDelinquency, expectedDisbursementDate, fixedLength, fixedPrincipalPercentagePerInstallment, fraud, graceOnArrearsAgeing, interestCalculationPeriodType, interestChargedFromDate, interestRateFrequencyType, interestRatePerPeriod, interestRecognitionOnDisbursementDate, interestType, isEqualAmortization, isTopup, linkAccountId, loanIdToClose, loanScheduleProcessingType, loanTermFrequency, loanTermFrequencyType, loanType, locale, maxOutstandingLoanBalance, numberOfRepayments, principal, productId, repaymentEvery, repaymentFrequencyDayOfWeekType, repaymentFrequencyNthDayType, repaymentFrequencyType, repaymentsStartingFromDate, submittedOnDate, transactionProcessingStrategyCode);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PutLoansLoanIdRequest {\n");
    sb.append("    amortizationType: ").append(toIndentedString(amortizationType)).append("\n");
    sb.append("    charges: ").append(toIndentedString(charges)).append("\n");
    sb.append("    clientId: ").append(toIndentedString(clientId)).append("\n");
    sb.append("    collateral: ").append(toIndentedString(collateral)).append("\n");
    sb.append("    createStandingInstructionAtDisbursement: ").append(toIndentedString(createStandingInstructionAtDisbursement)).append("\n");
    sb.append("    dateFormat: ").append(toIndentedString(dateFormat)).append("\n");
    sb.append("    disbursedAmountPercentageForDownPayment: ").append(toIndentedString(disbursedAmountPercentageForDownPayment)).append("\n");
    sb.append("    disbursementData: ").append(toIndentedString(disbursementData)).append("\n");
    sb.append("    enableAutoRepaymentForDownPayment: ").append(toIndentedString(enableAutoRepaymentForDownPayment)).append("\n");
    sb.append("    enableDownPayment: ").append(toIndentedString(enableDownPayment)).append("\n");
    sb.append("    enableInstallmentLevelDelinquency: ").append(toIndentedString(enableInstallmentLevelDelinquency)).append("\n");
    sb.append("    expectedDisbursementDate: ").append(toIndentedString(expectedDisbursementDate)).append("\n");
    sb.append("    fixedLength: ").append(toIndentedString(fixedLength)).append("\n");
    sb.append("    fixedPrincipalPercentagePerInstallment: ").append(toIndentedString(fixedPrincipalPercentagePerInstallment)).append("\n");
    sb.append("    fraud: ").append(toIndentedString(fraud)).append("\n");
    sb.append("    graceOnArrearsAgeing: ").append(toIndentedString(graceOnArrearsAgeing)).append("\n");
    sb.append("    interestCalculationPeriodType: ").append(toIndentedString(interestCalculationPeriodType)).append("\n");
    sb.append("    interestChargedFromDate: ").append(toIndentedString(interestChargedFromDate)).append("\n");
    sb.append("    interestRateFrequencyType: ").append(toIndentedString(interestRateFrequencyType)).append("\n");
    sb.append("    interestRatePerPeriod: ").append(toIndentedString(interestRatePerPeriod)).append("\n");
    sb.append("    interestRecognitionOnDisbursementDate: ").append(toIndentedString(interestRecognitionOnDisbursementDate)).append("\n");
    sb.append("    interestType: ").append(toIndentedString(interestType)).append("\n");
    sb.append("    isEqualAmortization: ").append(toIndentedString(isEqualAmortization)).append("\n");
    sb.append("    isTopup: ").append(toIndentedString(isTopup)).append("\n");
    sb.append("    linkAccountId: ").append(toIndentedString(linkAccountId)).append("\n");
    sb.append("    loanIdToClose: ").append(toIndentedString(loanIdToClose)).append("\n");
    sb.append("    loanScheduleProcessingType: ").append(toIndentedString(loanScheduleProcessingType)).append("\n");
    sb.append("    loanTermFrequency: ").append(toIndentedString(loanTermFrequency)).append("\n");
    sb.append("    loanTermFrequencyType: ").append(toIndentedString(loanTermFrequencyType)).append("\n");
    sb.append("    loanType: ").append(toIndentedString(loanType)).append("\n");
    sb.append("    locale: ").append(toIndentedString(locale)).append("\n");
    sb.append("    maxOutstandingLoanBalance: ").append(toIndentedString(maxOutstandingLoanBalance)).append("\n");
    sb.append("    numberOfRepayments: ").append(toIndentedString(numberOfRepayments)).append("\n");
    sb.append("    principal: ").append(toIndentedString(principal)).append("\n");
    sb.append("    productId: ").append(toIndentedString(productId)).append("\n");
    sb.append("    repaymentEvery: ").append(toIndentedString(repaymentEvery)).append("\n");
    sb.append("    repaymentFrequencyDayOfWeekType: ").append(toIndentedString(repaymentFrequencyDayOfWeekType)).append("\n");
    sb.append("    repaymentFrequencyNthDayType: ").append(toIndentedString(repaymentFrequencyNthDayType)).append("\n");
    sb.append("    repaymentFrequencyType: ").append(toIndentedString(repaymentFrequencyType)).append("\n");
    sb.append("    repaymentsStartingFromDate: ").append(toIndentedString(repaymentsStartingFromDate)).append("\n");
    sb.append("    submittedOnDate: ").append(toIndentedString(submittedOnDate)).append("\n");
    sb.append("    transactionProcessingStrategyCode: ").append(toIndentedString(transactionProcessingStrategyCode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

