package org.apache.fineract.client.services;

import org.apache.fineract.client.CollectionFormats.*;

    import retrofit2.Call;
import retrofit2.http.*;

import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okhttp3.MultipartBody;

import org.apache.fineract.client.models.InlineJobRequest;
import org.apache.fineract.client.models.InlineJobResponse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface InlineJobApi {
    /**
    * Starts an inline Job
    * Starts an inline Job
        * @param jobName jobName (required)
        * @param inlineJobRequest  (optional)
    * @return Call&lt;InlineJobResponse&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @POST("v1/jobs/{jobName}/inline")
    Call<InlineJobResponse> executeInlineJob(@retrofit2.http.Path("jobName") String jobName, @retrofit2.http.Body InlineJobRequest inlineJobRequest);


        /**
        * Starts an inline Job
        * Starts an inline Job
            * @param jobName jobName (required)
            * @param inlineJobRequest  (optional)
        * @return Call&lt;InlineJobResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/jobs/{jobName}/inline")
    Call<InlineJobResponse> executeInlineJob(@retrofit2.http.Path("jobName") String jobName);

        /**
        * Starts an inline Job
        * Starts an inline Job
            * @param jobName jobName (required)
            * @param inlineJobRequest  (optional)
        * @return Call&lt;InlineJobResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/jobs/{jobName}/inline")
    Call<InlineJobResponse> executeInlineJob(@retrofit2.http.Path("jobName") String jobName, @retrofit2.http.Body InlineJobRequest inlineJobRequest, @HeaderMap Map<String, String> headers);


        /**
        * Starts an inline Job
        * Starts an inline Job
            * @param jobName jobName (required)
            * @param inlineJobRequest  (optional)
        * @return Call&lt;InlineJobResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/jobs/{jobName}/inline")
    Call<InlineJobResponse> executeInlineJob(@retrofit2.http.Path("jobName") String jobName, @HeaderMap Map<String, String> headers);
}
