/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.deduplicate.asyncprocessing;

import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.operators.deduplicate.asyncprocessing.AsyncStateDeduplicateFunctionBase;
import org.apache.flink.table.runtime.operators.deduplicate.utils.RowTimeDeduplicateFunctionHelper;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.util.Collector;

public class AsyncStateRowTimeDeduplicateFunction
extends AsyncStateDeduplicateFunctionBase<RowData, RowData, RowData, RowData> {
    private static final long serialVersionUID = 1L;
    private final boolean generateUpdateBefore;
    private final boolean generateInsert;
    private final int rowtimeIndex;
    private final boolean keepLastRow;
    private transient RowTimeDeduplicateFunctionHelper helper;

    public AsyncStateRowTimeDeduplicateFunction(InternalTypeInfo<RowData> typeInfo, long minRetentionTime, int rowtimeIndex, boolean generateUpdateBefore, boolean generateInsert, boolean keepLastRow) {
        super(typeInfo, null, minRetentionTime);
        this.generateUpdateBefore = generateUpdateBefore;
        this.generateInsert = generateInsert;
        this.rowtimeIndex = rowtimeIndex;
        this.keepLastRow = keepLastRow;
    }

    @Override
    public void open(OpenContext openContext) throws Exception {
        super.open(openContext);
        this.helper = new AsyncStateRowTimeDeduplicateFunctionHelper();
    }

    public void processElement(RowData input, KeyedProcessFunction.Context ctx, Collector<RowData> out) throws Exception {
        this.state.asyncValue().thenAccept(prevRow -> this.helper.deduplicateOnRowTime(input, (RowData)prevRow, out));
    }

    private class AsyncStateRowTimeDeduplicateFunctionHelper
    extends RowTimeDeduplicateFunctionHelper {
        public AsyncStateRowTimeDeduplicateFunctionHelper() {
            super(AsyncStateRowTimeDeduplicateFunction.this.generateUpdateBefore, AsyncStateRowTimeDeduplicateFunction.this.generateInsert, AsyncStateRowTimeDeduplicateFunction.this.rowtimeIndex, AsyncStateRowTimeDeduplicateFunction.this.keepLastRow);
        }

        @Override
        protected void updateState(RowData currentRow) throws Exception {
            AsyncStateRowTimeDeduplicateFunction.this.state.asyncUpdate((Object)currentRow);
        }
    }
}

