/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.shaded.com.ibm.icu.impl.number.parse;

import org.apache.flink.table.shaded.com.ibm.icu.impl.StaticUnicodeSets;
import org.apache.flink.table.shaded.com.ibm.icu.impl.StringSegment;
import org.apache.flink.table.shaded.com.ibm.icu.impl.number.parse.ParsedNumber;
import org.apache.flink.table.shaded.com.ibm.icu.impl.number.parse.SymbolMatcher;
import org.apache.flink.table.shaded.com.ibm.icu.text.DecimalFormatSymbols;

public class PermilleMatcher
extends SymbolMatcher {
    private static final PermilleMatcher DEFAULT = new PermilleMatcher();

    public static PermilleMatcher getInstance(DecimalFormatSymbols symbols) {
        String symbolString = symbols.getPerMillString();
        if (PermilleMatcher.DEFAULT.uniSet.contains(symbolString)) {
            return DEFAULT;
        }
        return new PermilleMatcher(symbolString);
    }

    private PermilleMatcher(String symbolString) {
        super(symbolString, PermilleMatcher.DEFAULT.uniSet);
    }

    private PermilleMatcher() {
        super(StaticUnicodeSets.Key.PERMILLE_SIGN);
    }

    @Override
    protected boolean isDisabled(ParsedNumber result) {
        return 0 != (result.flags & 4);
    }

    @Override
    protected void accept(StringSegment segment, ParsedNumber result) {
        result.flags |= 4;
        result.setCharsConsumed(segment);
    }

    public String toString() {
        return "<PermilleMatcher>";
    }
}

