/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.index;

import com.lancedb.lance.index.DistanceType;
import com.lancedb.lance.index.vector.VectorIndexParams;
import java.util.Optional;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class IndexParams {
    private final DistanceType distanceType;
    private final Optional<VectorIndexParams> vectorIndexParams;

    private IndexParams(Builder builder) {
        this.distanceType = builder.distanceType;
        this.vectorIndexParams = builder.vectorIndexParams;
    }

    public String getDistanceType() {
        return this.distanceType.toString();
    }

    public Optional<VectorIndexParams> getVectorIndexParams() {
        return this.vectorIndexParams;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("distanceType", (Object)this.distanceType).append("vectorIndexParams", this.vectorIndexParams.orElse(null)).toString();
    }

    public static class Builder {
        private DistanceType distanceType = DistanceType.L2;
        private Optional<VectorIndexParams> vectorIndexParams = Optional.empty();

        public Builder setDistanceType(DistanceType distanceType) {
            this.distanceType = distanceType;
            return this;
        }

        public Builder setVectorIndexParams(VectorIndexParams vectorIndexParams) {
            this.vectorIndexParams = Optional.of(vectorIndexParams);
            return this;
        }

        public IndexParams build() {
            return new IndexParams(this);
        }
    }
}

