/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.client.utils.jdbc;

import io.openlineage.client.utils.jdbc.JdbcExtractor;
import io.openlineage.client.utils.jdbc.JdbcLocation;
import io.openlineage.client.utils.jdbc.OverridingJdbcExtractor;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class OracleJdbcExtractor
implements JdbcExtractor {
    private static final String SCHEME = "oracle";
    private static final String DEFAULT_PORT = "1521";
    private static final String URI_START = "^.*@(//)?";
    private static final String URI_END = "\\?.*$";
    private static final String PROTOCOL_PART = "^\\w+://";

    @Override
    public boolean isDefinedAt(String jdbcUri) {
        return jdbcUri.toLowerCase(Locale.ROOT).startsWith(SCHEME);
    }

    @Override
    public JdbcLocation extract(String rawUri, Properties properties) throws URISyntaxException {
        String uri = rawUri.replaceFirst(URI_START, "").replaceAll(URI_END, "");
        if (uri.contains("(")) {
            throw new URISyntaxException(uri, "TNS format is unsupported for now");
        }
        return this.extractUri(uri, properties);
    }

    private JdbcLocation extractUri(String uri, Properties properties) throws URISyntaxException {
        String normalizedUri = uri.replaceFirst(PROTOCOL_PART, "");
        normalizedUri = "oracle://" + this.fixSidFormat(normalizedUri);
        return new OverridingJdbcExtractor(SCHEME, DEFAULT_PORT).extract(normalizedUri, properties);
    }

    private String fixSidFormat(String uri) {
        if (!uri.contains(":")) {
            return uri;
        }
        List components = Arrays.stream(uri.split(":")).collect(Collectors.toList());
        String last = (String)components.remove(components.size() - 1);
        if (last.contains("]") || last.matches("^\\d+$")) {
            return uri;
        }
        return StringUtils.join(components, (String)":") + "/" + last;
    }
}

