/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.meta;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.gravitino.Auditable;
import org.apache.gravitino.Entity;
import org.apache.gravitino.Field;
import org.apache.gravitino.HasIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.job.JobTemplate;
import org.apache.gravitino.job.ShellJobTemplate;
import org.apache.gravitino.job.SparkJobTemplate;
import org.apache.gravitino.meta.AuditInfo;

public class JobTemplateEntity
implements Entity,
Auditable,
HasIdentifier {
    public static final Field ID = Field.required("id", Long.class, "The unique id of the job template entity.");
    public static final Field NAME = Field.required("name", String.class, "The name of the job template entity.");
    public static final Field COMMENT = Field.optional("comment", String.class, "The comment or description of the job template entity.");
    public static final Field TEMPLATE_CONTENT = Field.required("template_content", TemplateContent.class, "The template content of the job template entity.");
    public static final Field AUDIT_INFO = Field.required("audit_info", AuditInfo.class, "The audit details of the job template entity.");
    private Long id;
    private String name;
    private Namespace namespace;
    private String comment;
    private TemplateContent templateContent;
    private AuditInfo auditInfo;

    private JobTemplateEntity() {
    }

    @Override
    public Map<Field, Object> fields() {
        HashMap fields = Maps.newHashMap();
        fields.put(ID, this.id);
        fields.put(NAME, this.name);
        fields.put(COMMENT, this.comment);
        fields.put(TEMPLATE_CONTENT, this.templateContent);
        fields.put(AUDIT_INFO, this.auditInfo);
        return Collections.unmodifiableMap(fields);
    }

    @Override
    public Long id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Namespace namespace() {
        return this.namespace;
    }

    public String comment() {
        return this.comment;
    }

    public TemplateContent templateContent() {
        return this.templateContent;
    }

    public AuditInfo auditInfo() {
        return this.auditInfo;
    }

    @Override
    public Entity.EntityType type() {
        return Entity.EntityType.JOB_TEMPLATE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JobTemplateEntity)) {
            return false;
        }
        JobTemplateEntity that = (JobTemplateEntity)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.namespace, that.namespace) && Objects.equals(this.comment, that.comment) && Objects.equals(this.templateContent, that.templateContent) && Objects.equals(this.auditInfo, that.auditInfo);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.namespace, this.comment, this.templateContent, this.auditInfo);
    }

    public JobTemplate toJobTemplate() {
        JobTemplate.JobType jobType = this.templateContent.jobType();
        if (jobType == JobTemplate.JobType.SHELL) {
            return ((ShellJobTemplate.Builder)((ShellJobTemplate.Builder)((ShellJobTemplate.Builder)((ShellJobTemplate.Builder)((ShellJobTemplate.Builder)((ShellJobTemplate.Builder)ShellJobTemplate.builder().withName(this.name)).withComment(this.comment)).withExecutable(this.templateContent.executable())).withArguments(this.templateContent.arguments())).withEnvironments(this.templateContent.environments())).withCustomFields(this.templateContent.customFields())).withScripts(this.templateContent.scripts()).build();
        }
        if (jobType == JobTemplate.JobType.SPARK) {
            return ((SparkJobTemplate.Builder)((SparkJobTemplate.Builder)((SparkJobTemplate.Builder)((SparkJobTemplate.Builder)((SparkJobTemplate.Builder)((SparkJobTemplate.Builder)SparkJobTemplate.builder().withName(this.name)).withComment(this.comment)).withExecutable(this.templateContent.executable())).withArguments(this.templateContent.arguments())).withEnvironments(this.templateContent.environments())).withCustomFields(this.templateContent.customFields())).withClassName(this.templateContent.className()).withJars(this.templateContent.jars()).withFiles(this.templateContent.files()).withArchives(this.templateContent.archives()).withConfigs(this.templateContent.configs()).build();
        }
        throw new IllegalStateException("Unsupported job type: " + String.valueOf(jobType));
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "JobTemplateEntity(id=" + this.id + ", name=" + this.name + ", namespace=" + String.valueOf(this.namespace) + ", comment=" + this.comment + ", templateContent=" + String.valueOf(this.templateContent) + ", auditInfo=" + String.valueOf(this.auditInfo) + ")";
    }

    public static class TemplateContent {
        private JobTemplate.JobType jobType;
        private String executable;
        private List<String> arguments;
        private Map<String, String> environments;
        private Map<String, String> customFields;
        private List<String> scripts;
        private String className;
        private List<String> jars;
        private List<String> files;
        private List<String> archives;
        private Map<String, String> configs;

        public static TemplateContent fromJobTemplate(JobTemplate jobTemplate) {
            TemplateContentBuilder builder = TemplateContent.builder().withJobType(jobTemplate.jobType()).withExecutable(jobTemplate.executable()).withArguments(jobTemplate.arguments()).withEnvironments(jobTemplate.environments()).withCustomFields(jobTemplate.customFields());
            if (jobTemplate instanceof ShellJobTemplate) {
                ShellJobTemplate shellJobTemplate = (ShellJobTemplate)jobTemplate;
                builder.withScripts(shellJobTemplate.scripts());
            } else if (jobTemplate instanceof SparkJobTemplate) {
                SparkJobTemplate sparkJobTemplate = (SparkJobTemplate)jobTemplate;
                builder.withClassName(sparkJobTemplate.className()).withJars(sparkJobTemplate.jars()).withFiles(sparkJobTemplate.files()).withArchives(sparkJobTemplate.archives()).withConfigs(sparkJobTemplate.configs());
            }
            return builder.build();
        }

        public static TemplateContentBuilder builder() {
            return new TemplateContentBuilder();
        }

        public JobTemplate.JobType jobType() {
            return this.jobType;
        }

        public String executable() {
            return this.executable;
        }

        public List<String> arguments() {
            return this.arguments;
        }

        public Map<String, String> environments() {
            return this.environments;
        }

        public Map<String, String> customFields() {
            return this.customFields;
        }

        public List<String> scripts() {
            return this.scripts;
        }

        public String className() {
            return this.className;
        }

        public List<String> jars() {
            return this.jars;
        }

        public List<String> files() {
            return this.files;
        }

        public List<String> archives() {
            return this.archives;
        }

        public Map<String, String> configs() {
            return this.configs;
        }

        public String toString() {
            return "JobTemplateEntity.TemplateContent(jobType=" + String.valueOf(this.jobType()) + ", executable=" + this.executable() + ", arguments=" + String.valueOf(this.arguments()) + ", environments=" + String.valueOf(this.environments()) + ", customFields=" + String.valueOf(this.customFields()) + ", scripts=" + String.valueOf(this.scripts()) + ", className=" + this.className() + ", jars=" + String.valueOf(this.jars()) + ", files=" + String.valueOf(this.files()) + ", archives=" + String.valueOf(this.archives()) + ", configs=" + String.valueOf(this.configs()) + ")";
        }

        public TemplateContent() {
        }

        private TemplateContent(JobTemplate.JobType jobType, String executable, List<String> arguments, Map<String, String> environments, Map<String, String> customFields, List<String> scripts, String className, List<String> jars, List<String> files, List<String> archives, Map<String, String> configs) {
            this.jobType = jobType;
            this.executable = executable;
            this.arguments = arguments;
            this.environments = environments;
            this.customFields = customFields;
            this.scripts = scripts;
            this.className = className;
            this.jars = jars;
            this.files = files;
            this.archives = archives;
            this.configs = configs;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TemplateContent)) {
                return false;
            }
            TemplateContent other = (TemplateContent)o;
            if (!other.canEqual(this)) {
                return false;
            }
            JobTemplate.JobType this$jobType = this.jobType();
            JobTemplate.JobType other$jobType = other.jobType();
            if (this$jobType == null ? other$jobType != null : !this$jobType.equals(other$jobType)) {
                return false;
            }
            String this$executable = this.executable();
            String other$executable = other.executable();
            if (this$executable == null ? other$executable != null : !this$executable.equals(other$executable)) {
                return false;
            }
            List<String> this$arguments = this.arguments();
            List<String> other$arguments = other.arguments();
            if (this$arguments == null ? other$arguments != null : !((Object)this$arguments).equals(other$arguments)) {
                return false;
            }
            Map<String, String> this$environments = this.environments();
            Map<String, String> other$environments = other.environments();
            if (this$environments == null ? other$environments != null : !((Object)this$environments).equals(other$environments)) {
                return false;
            }
            Map<String, String> this$customFields = this.customFields();
            Map<String, String> other$customFields = other.customFields();
            if (this$customFields == null ? other$customFields != null : !((Object)this$customFields).equals(other$customFields)) {
                return false;
            }
            List<String> this$scripts = this.scripts();
            List<String> other$scripts = other.scripts();
            if (this$scripts == null ? other$scripts != null : !((Object)this$scripts).equals(other$scripts)) {
                return false;
            }
            String this$className = this.className();
            String other$className = other.className();
            if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
                return false;
            }
            List<String> this$jars = this.jars();
            List<String> other$jars = other.jars();
            if (this$jars == null ? other$jars != null : !((Object)this$jars).equals(other$jars)) {
                return false;
            }
            List<String> this$files = this.files();
            List<String> other$files = other.files();
            if (this$files == null ? other$files != null : !((Object)this$files).equals(other$files)) {
                return false;
            }
            List<String> this$archives = this.archives();
            List<String> other$archives = other.archives();
            if (this$archives == null ? other$archives != null : !((Object)this$archives).equals(other$archives)) {
                return false;
            }
            Map<String, String> this$configs = this.configs();
            Map<String, String> other$configs = other.configs();
            return !(this$configs == null ? other$configs != null : !((Object)this$configs).equals(other$configs));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TemplateContent;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            JobTemplate.JobType $jobType = this.jobType();
            result = result * 59 + ($jobType == null ? 43 : $jobType.hashCode());
            String $executable = this.executable();
            result = result * 59 + ($executable == null ? 43 : $executable.hashCode());
            List<String> $arguments = this.arguments();
            result = result * 59 + ($arguments == null ? 43 : ((Object)$arguments).hashCode());
            Map<String, String> $environments = this.environments();
            result = result * 59 + ($environments == null ? 43 : ((Object)$environments).hashCode());
            Map<String, String> $customFields = this.customFields();
            result = result * 59 + ($customFields == null ? 43 : ((Object)$customFields).hashCode());
            List<String> $scripts = this.scripts();
            result = result * 59 + ($scripts == null ? 43 : ((Object)$scripts).hashCode());
            String $className = this.className();
            result = result * 59 + ($className == null ? 43 : $className.hashCode());
            List<String> $jars = this.jars();
            result = result * 59 + ($jars == null ? 43 : ((Object)$jars).hashCode());
            List<String> $files = this.files();
            result = result * 59 + ($files == null ? 43 : ((Object)$files).hashCode());
            List<String> $archives = this.archives();
            result = result * 59 + ($archives == null ? 43 : ((Object)$archives).hashCode());
            Map<String, String> $configs = this.configs();
            result = result * 59 + ($configs == null ? 43 : ((Object)$configs).hashCode());
            return result;
        }

        public static class TemplateContentBuilder {
            private JobTemplate.JobType jobType;
            private String executable;
            private List<String> arguments;
            private Map<String, String> environments;
            private Map<String, String> customFields;
            private List<String> scripts;
            private String className;
            private List<String> jars;
            private List<String> files;
            private List<String> archives;
            private Map<String, String> configs;

            TemplateContentBuilder() {
            }

            public TemplateContentBuilder withJobType(JobTemplate.JobType jobType) {
                this.jobType = jobType;
                return this;
            }

            public TemplateContentBuilder withExecutable(String executable) {
                this.executable = executable;
                return this;
            }

            public TemplateContentBuilder withArguments(List<String> arguments) {
                this.arguments = arguments;
                return this;
            }

            public TemplateContentBuilder withEnvironments(Map<String, String> environments) {
                this.environments = environments;
                return this;
            }

            public TemplateContentBuilder withCustomFields(Map<String, String> customFields) {
                this.customFields = customFields;
                return this;
            }

            public TemplateContentBuilder withScripts(List<String> scripts) {
                this.scripts = scripts;
                return this;
            }

            public TemplateContentBuilder withClassName(String className) {
                this.className = className;
                return this;
            }

            public TemplateContentBuilder withJars(List<String> jars) {
                this.jars = jars;
                return this;
            }

            public TemplateContentBuilder withFiles(List<String> files) {
                this.files = files;
                return this;
            }

            public TemplateContentBuilder withArchives(List<String> archives) {
                this.archives = archives;
                return this;
            }

            public TemplateContentBuilder withConfigs(Map<String, String> configs) {
                this.configs = configs;
                return this;
            }

            public TemplateContent build() {
                return new TemplateContent(this.jobType, this.executable, this.arguments, this.environments, this.customFields, this.scripts, this.className, this.jars, this.files, this.archives, this.configs);
            }

            public String toString() {
                return "JobTemplateEntity.TemplateContent.TemplateContentBuilder(jobType=" + String.valueOf(this.jobType) + ", executable=" + this.executable + ", arguments=" + String.valueOf(this.arguments) + ", environments=" + String.valueOf(this.environments) + ", customFields=" + String.valueOf(this.customFields) + ", scripts=" + String.valueOf(this.scripts) + ", className=" + this.className + ", jars=" + String.valueOf(this.jars) + ", files=" + String.valueOf(this.files) + ", archives=" + String.valueOf(this.archives) + ", configs=" + String.valueOf(this.configs) + ")";
            }
        }
    }

    public static class Builder {
        private final JobTemplateEntity jobTemplateEntity = new JobTemplateEntity();

        private Builder() {
        }

        public Builder withId(Long id) {
            this.jobTemplateEntity.id = id;
            return this;
        }

        public Builder withName(String name) {
            this.jobTemplateEntity.name = name;
            return this;
        }

        public Builder withNamespace(Namespace namespace) {
            this.jobTemplateEntity.namespace = namespace;
            return this;
        }

        public Builder withComment(String comment) {
            this.jobTemplateEntity.comment = comment;
            return this;
        }

        public Builder withTemplateContent(TemplateContent templateContent) {
            this.jobTemplateEntity.templateContent = templateContent;
            return this;
        }

        public Builder withAuditInfo(AuditInfo auditInfo) {
            this.jobTemplateEntity.auditInfo = auditInfo;
            return this;
        }

        public JobTemplateEntity build() {
            this.jobTemplateEntity.validate();
            return this.jobTemplateEntity;
        }
    }
}

