/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.org.roaringbitmap;

import org.apache.paimon.shade.org.roaringbitmap.ArrayContainer;
import org.apache.paimon.shade.org.roaringbitmap.ContainerBatchIterator;
import org.apache.paimon.shade.org.roaringbitmap.Util;

public final class ArrayBatchIterator
implements ContainerBatchIterator {
    private int index = 0;
    private ArrayContainer array;

    public ArrayBatchIterator(ArrayContainer array) {
        this.wrap(array);
    }

    @Override
    public int next(int key, int[] buffer, int offset) {
        int consumed = 0;
        char[] data = this.array.content;
        while (offset + consumed < buffer.length && this.index < this.array.getCardinality()) {
            buffer[offset + consumed++] = key + data[this.index++];
        }
        return consumed;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.array.getCardinality();
    }

    @Override
    public ContainerBatchIterator clone() {
        try {
            return (ContainerBatchIterator)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void releaseContainer() {
        this.array = null;
    }

    @Override
    public void advanceIfNeeded(char target) {
        int position = Util.unsignedBinarySearch(this.array.content, 0, this.array.getCardinality(), target);
        this.index = position < 0 ? -position - 1 : position;
    }

    void wrap(ArrayContainer array) {
        this.array = array;
        this.index = 0;
    }
}

