/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.lookup.rocksdb;

import java.time.Duration;
import org.apache.paimon.annotation.Documentation;
import org.apache.paimon.options.ConfigOption;
import org.apache.paimon.options.ConfigOptions;
import org.apache.paimon.options.MemorySize;
import org.apache.paimon.options.Options;
import org.apache.paimon.options.description.Description;
import org.apache.paimon.options.description.InlineElement;
import org.apache.paimon.options.description.LinkElement;
import org.apache.paimon.options.description.TextElement;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.BloomFilter;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.CompactionStyle;
import org.rocksdb.CompressionType;
import org.rocksdb.DBOptions;
import org.rocksdb.Filter;
import org.rocksdb.InfoLogLevel;
import org.rocksdb.PlainTableConfig;
import org.rocksdb.TableFormatConfig;

public class RocksDBOptions {
    public static final ConfigOption<Long> LOOKUP_CACHE_ROWS = ConfigOptions.key((String)"lookup.cache-rows").longType().defaultValue((Object)10000L).withDescription("The maximum number of rows to store in the cache.");
    public static final ConfigOption<Duration> LOOKUP_CONTINUOUS_DISCOVERY_INTERVAL = ConfigOptions.key((String)"lookup.continuous.discovery-interval").durationType().noDefaultValue().withDescription("The discovery interval of lookup continuous reading. This is used as an SQL hint. If it's not configured, the lookup function will fallback to 'continuous.discovery-interval'.");
    public static final ConfigOption<Integer> MAX_BACKGROUND_THREADS = ConfigOptions.key((String)"rocksdb.thread.num").intType().defaultValue((Object)2).withDescription("The maximum number of concurrent background flush and compaction jobs (per stateful operator). The default value is '2'.");
    public static final ConfigOption<Integer> MAX_OPEN_FILES = ConfigOptions.key((String)"rocksdb.files.open").intType().defaultValue((Object)-1).withDescription("The maximum number of open files (per stateful operator) that can be used by the DB, '-1' means no limit. The default value is '-1'.");
    @Documentation.ExcludeFromDocumentation(value="Internal use only")
    public static final ConfigOption<MemorySize> LOG_MAX_FILE_SIZE = ConfigOptions.key((String)"rocksdb.log.max-file-size").memoryType().defaultValue((Object)MemorySize.parse((String)"25mb")).withDescription("The maximum size of RocksDB's file used for information logging. If the log files becomes larger than this, a new file will be created. If 0, all logs will be written to one log file. The default maximum file size is '25MB'. ");
    @Documentation.ExcludeFromDocumentation(value="Internal use only")
    public static final ConfigOption<Integer> LOG_FILE_NUM = ConfigOptions.key((String)"rocksdb.log.file-num").intType().defaultValue((Object)4).withDescription("The maximum number of files RocksDB should keep for information logging (Default setting: 4).");
    @Documentation.ExcludeFromDocumentation(value="Internal use only")
    public static final ConfigOption<String> LOG_DIR = ConfigOptions.key((String)"rocksdb.log.dir").stringType().noDefaultValue().withDescription("The directory for RocksDB's information logging files. If empty (Flink default setting), log files will be in the same directory as the Flink log. If non-empty, this directory will be used and the data directory's absolute path will be used as the prefix of the log file name.");
    @Documentation.ExcludeFromDocumentation(value="Internal use only")
    public static final ConfigOption<InfoLogLevel> LOG_LEVEL = ConfigOptions.key((String)"rocksdb.log.level").enumType(InfoLogLevel.class).defaultValue((Object)InfoLogLevel.INFO_LEVEL).withDescription(Description.builder().text("The specified information logging level for RocksDB. If unset, Flink will use %s.", new InlineElement[]{TextElement.code((String)InfoLogLevel.INFO_LEVEL.name())}).linebreak().text("Note: RocksDB info logs will not be written to the TaskManager logs and there is no rolling strategy, unless you configure %s, %s, and %s accordingly. Without a rolling strategy, long-running tasks may lead to uncontrolled disk space usage if configured with increased log levels!", new InlineElement[]{TextElement.code((String)LOG_DIR.key()), TextElement.code((String)LOG_MAX_FILE_SIZE.key()), TextElement.code((String)LOG_FILE_NUM.key())}).linebreak().text("There is no need to modify the RocksDB log level, unless for troubleshooting RocksDB.").build());
    public static final ConfigOption<CompressionType> COMPRESSION_TYPE = ConfigOptions.key((String)"rocksdb.compression.type").enumType(CompressionType.class).defaultValue((Object)CompressionType.LZ4_COMPRESSION).withDescription("The compression type.");
    public static final ConfigOption<CompactionStyle> COMPACTION_STYLE = ConfigOptions.key((String)"rocksdb.compaction.style").enumType(CompactionStyle.class).defaultValue((Object)CompactionStyle.LEVEL).withDescription(String.format("The specified compaction style for DB. Candidate compaction style is %s, %s, %s or %s, and Flink chooses '%s' as default style.", CompactionStyle.LEVEL.name(), CompactionStyle.FIFO.name(), CompactionStyle.UNIVERSAL.name(), CompactionStyle.NONE.name(), CompactionStyle.LEVEL.name()));
    public static final ConfigOption<Boolean> USE_DYNAMIC_LEVEL_SIZE = ConfigOptions.key((String)"rocksdb.compaction.level.use-dynamic-size").booleanType().defaultValue((Object)false).withDescription(Description.builder().text("If true, RocksDB will pick target size of each level dynamically. From an empty DB, ").text("RocksDB would make last level the base level, which means merging L0 data into the last level, ").text("until it exceeds max_bytes_for_level_base. And then repeat this process for second last level and so on. ").text("The default value is 'false'. ").text("For more information, please refer to %s", new InlineElement[]{LinkElement.link((String)"https://github.com/facebook/rocksdb/wiki/Leveled-Compaction#level_compaction_dynamic_level_bytes-is-true", (String)"RocksDB's doc.")}).build());
    public static final ConfigOption<MemorySize> TARGET_FILE_SIZE_BASE = ConfigOptions.key((String)"rocksdb.compaction.level.target-file-size-base").memoryType().defaultValue((Object)MemorySize.parse((String)"64mb")).withDescription("The target file size for compaction, which determines a level-1 file size. The default value is '64MB'.");
    public static final ConfigOption<MemorySize> MAX_SIZE_LEVEL_BASE = ConfigOptions.key((String)"rocksdb.compaction.level.max-size-level-base").memoryType().defaultValue((Object)MemorySize.parse((String)"256mb")).withDescription("The upper-bound of the total size of level base files in bytes. The default value is '256MB'.");
    public static final ConfigOption<MemorySize> WRITE_BUFFER_SIZE = ConfigOptions.key((String)"rocksdb.writebuffer.size").memoryType().defaultValue((Object)MemorySize.parse((String)"64mb")).withDescription("The amount of data built up in memory (backed by an unsorted log on disk) before converting to a sorted on-disk files. The default writebuffer size is '64MB'.");
    public static final ConfigOption<Integer> MAX_WRITE_BUFFER_NUMBER = ConfigOptions.key((String)"rocksdb.writebuffer.count").intType().defaultValue((Object)2).withDescription("The maximum number of write buffers that are built up in memory. The default value is '2'.");
    public static final ConfigOption<Integer> MIN_WRITE_BUFFER_NUMBER_TO_MERGE = ConfigOptions.key((String)"rocksdb.writebuffer.number-to-merge").intType().defaultValue((Object)1).withDescription("The minimum number of write buffers that will be merged together before writing to storage. The default value is '1'.");
    public static final ConfigOption<MemorySize> BLOCK_SIZE = ConfigOptions.key((String)"rocksdb.block.blocksize").memoryType().defaultValue((Object)MemorySize.parse((String)"4kb")).withDescription("The approximate size (in bytes) of user data packed per block. The default blocksize is '4KB'.");
    public static final ConfigOption<MemorySize> METADATA_BLOCK_SIZE = ConfigOptions.key((String)"rocksdb.block.metadata-blocksize").memoryType().defaultValue((Object)MemorySize.parse((String)"4kb")).withDescription("Approximate size of partitioned metadata packed per block. Currently applied to indexes block when partitioned index/filters option is enabled. The default blocksize is '4KB'.");
    public static final ConfigOption<MemorySize> BLOCK_CACHE_SIZE = ConfigOptions.key((String)"rocksdb.block.cache-size").memoryType().defaultValue((Object)MemorySize.parse((String)"128mb")).withDescription("The amount of the cache for data blocks in RocksDB.");
    public static final ConfigOption<Boolean> USE_BLOOM_FILTER = ConfigOptions.key((String)"rocksdb.use-bloom-filter").booleanType().defaultValue((Object)false).withDescription("If true, every newly created SST file will contain a Bloom filter. It is disabled by default.");
    public static final ConfigOption<Double> BLOOM_FILTER_BITS_PER_KEY = ConfigOptions.key((String)"rocksdb.bloom-filter.bits-per-key").doubleType().defaultValue((Object)10.0).withDescription("Bits per key that bloom filter will use, this only take effect when bloom filter is used. The default value is 10.0.");
    public static final ConfigOption<Boolean> BLOOM_FILTER_BLOCK_BASED_MODE = ConfigOptions.key((String)"rocksdb.bloom-filter.block-based-mode").booleanType().defaultValue((Object)false).withDescription("If true, RocksDB will use block-based filter instead of full filter, this only take effect when bloom filter is used. The default value is 'false'.");

    public static DBOptions createDBOptions(DBOptions currentOptions, Options options) {
        currentOptions.setMaxBackgroundJobs(((Integer)options.get(MAX_BACKGROUND_THREADS)).intValue());
        currentOptions.setMaxOpenFiles(((Integer)options.get(MAX_OPEN_FILES)).intValue());
        currentOptions.setInfoLogLevel((InfoLogLevel)options.get(LOG_LEVEL));
        String logDir = (String)options.get(LOG_DIR);
        if (logDir != null && !logDir.isEmpty()) {
            currentOptions.setDbLogDir(logDir);
        }
        currentOptions.setMaxLogFileSize(((MemorySize)options.get(LOG_MAX_FILE_SIZE)).getBytes());
        currentOptions.setKeepLogFileNum((long)((Integer)options.get(LOG_FILE_NUM)).intValue());
        return currentOptions;
    }

    public static ColumnFamilyOptions createColumnOptions(ColumnFamilyOptions currentOptions, Options options) {
        BlockBasedTableConfig blockBasedTableConfig;
        currentOptions.setCompressionType((CompressionType)options.get(COMPRESSION_TYPE));
        currentOptions.setCompactionStyle((CompactionStyle)options.get(COMPACTION_STYLE));
        currentOptions.setLevelCompactionDynamicLevelBytes(((Boolean)options.get(USE_DYNAMIC_LEVEL_SIZE)).booleanValue());
        currentOptions.setTargetFileSizeBase(((MemorySize)options.get(TARGET_FILE_SIZE_BASE)).getBytes());
        currentOptions.setMaxBytesForLevelBase(((MemorySize)options.get(MAX_SIZE_LEVEL_BASE)).getBytes());
        currentOptions.setWriteBufferSize(((MemorySize)options.get(WRITE_BUFFER_SIZE)).getBytes());
        currentOptions.setMaxWriteBufferNumber(((Integer)options.get(MAX_WRITE_BUFFER_NUMBER)).intValue());
        currentOptions.setMinWriteBufferNumberToMerge(((Integer)options.get(MIN_WRITE_BUFFER_NUMBER_TO_MERGE)).intValue());
        TableFormatConfig tableFormatConfig = currentOptions.tableFormatConfig();
        if (tableFormatConfig == null) {
            blockBasedTableConfig = new BlockBasedTableConfig();
        } else {
            if (tableFormatConfig instanceof PlainTableConfig) {
                return currentOptions;
            }
            blockBasedTableConfig = (BlockBasedTableConfig)tableFormatConfig;
        }
        blockBasedTableConfig.setBlockSize(((MemorySize)options.get(BLOCK_SIZE)).getBytes());
        blockBasedTableConfig.setMetadataBlockSize(((MemorySize)options.get(METADATA_BLOCK_SIZE)).getBytes());
        blockBasedTableConfig.setBlockCacheSize(((MemorySize)options.get(BLOCK_CACHE_SIZE)).getBytes());
        if (((Boolean)options.get(USE_BLOOM_FILTER)).booleanValue()) {
            double bitsPerKey = (Double)options.get(BLOOM_FILTER_BITS_PER_KEY);
            boolean blockBasedMode = (Boolean)options.get(BLOOM_FILTER_BLOCK_BASED_MODE);
            BloomFilter bloomFilter = new BloomFilter(bitsPerKey, blockBasedMode);
            blockBasedTableConfig.setFilterPolicy((Filter)bloomFilter);
        }
        return currentOptions.setTableFormatConfig((TableFormatConfig)blockBasedTableConfig);
    }
}

