/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.SimulatedFSDataset;
import org.junit.Assert;
import org.junit.Test;

public class TestDataNodeTransferSocketSize {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSpecifiedDataSocketSize() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.datanode.transfer.socket.recv.buffer.size", 4096);
        SimulatedFSDataset.setFactory((Configuration)conf);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        try {
            ArrayList<DataNode> datanodes = cluster.getDataNodes();
            DataNode datanode = (DataNode)datanodes.get(0);
            Assert.assertEquals((String)"Receive buffer size should be 4K", (long)4096L, (long)datanode.getXferServer().getPeerServer().getReceiveBufferSize());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAutoTuningDataSocketSize() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.datanode.transfer.socket.recv.buffer.size", 0);
        SimulatedFSDataset.setFactory((Configuration)conf);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        try {
            ArrayList<DataNode> datanodes = cluster.getDataNodes();
            DataNode datanode = (DataNode)datanodes.get(0);
            Assert.assertTrue((String)"Receive buffer size should be a default value (determined by kernel)", (datanode.getXferServer().getPeerServer().getReceiveBufferSize() > 0 ? 1 : 0) != 0);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

