/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import org.apache.hadoop.hbase.ServerTask;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class ServerTaskBuilder {
    private String description = "";
    private String status = "";
    private ServerTask.State state = ServerTask.State.RUNNING;
    private long startTime;
    private long completionTime;

    public static ServerTaskBuilder newBuilder() {
        return new ServerTaskBuilder();
    }

    private ServerTaskBuilder() {
    }

    public ServerTaskBuilder setDescription(String description) {
        this.description = description;
        return this;
    }

    public ServerTaskBuilder setStatus(String status) {
        this.status = status;
        return this;
    }

    public ServerTaskBuilder setState(ServerTask.State state) {
        this.state = state;
        return this;
    }

    public ServerTaskBuilder setStartTime(long startTime) {
        this.startTime = startTime;
        return this;
    }

    public ServerTaskBuilder setCompletionTime(long completionTime) {
        this.completionTime = completionTime;
        return this;
    }

    public ServerTask build() {
        return new ServerTaskImpl(this.description, this.status, this.state, this.startTime, this.completionTime);
    }

    private static final class ServerTaskImpl
    implements ServerTask {
        private final String description;
        private final String status;
        private final ServerTask.State state;
        private final long startTime;
        private final long completionTime;

        private ServerTaskImpl(String description, String status, ServerTask.State state, long startTime, long completionTime) {
            this.description = description;
            this.status = status;
            this.state = state;
            this.startTime = startTime;
            this.completionTime = completionTime;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public String getStatus() {
            return this.status;
        }

        @Override
        public ServerTask.State getState() {
            return this.state;
        }

        @Override
        public long getStartTime() {
            return this.startTime;
        }

        @Override
        public long getCompletionTime() {
            return this.completionTime;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(512);
            sb.append(this.getDescription());
            sb.append(": status=");
            sb.append(this.getStatus());
            sb.append(", state=");
            sb.append((Object)this.getState());
            sb.append(", startTime=");
            sb.append(this.getStartTime());
            sb.append(", completionTime=");
            sb.append(this.getCompletionTime());
            return sb.toString();
        }
    }
}

