/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.thrift.ThriftMetrics;
import org.apache.hadoop.hbase.thrift.generated.Hbase;
import org.apache.hadoop.hbase.thrift2.generated.THBaseService;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class HbaseHandlerMetricsProxy
implements InvocationHandler {
    private final Object handler;
    private final ThriftMetrics metrics;

    public static Hbase.Iface newInstance(Hbase.Iface handler, ThriftMetrics metrics, Configuration conf) {
        return (Hbase.Iface)Proxy.newProxyInstance(handler.getClass().getClassLoader(), new Class[]{Hbase.Iface.class}, (InvocationHandler)new HbaseHandlerMetricsProxy(handler, metrics, conf));
    }

    public static THBaseService.Iface newInstance(THBaseService.Iface handler, ThriftMetrics metrics, Configuration conf) {
        return (THBaseService.Iface)Proxy.newProxyInstance(handler.getClass().getClassLoader(), new Class[]{THBaseService.Iface.class}, (InvocationHandler)new HbaseHandlerMetricsProxy(handler, metrics, conf));
    }

    private HbaseHandlerMetricsProxy(Object handler, ThriftMetrics metrics, Configuration conf) {
        this.handler = handler;
        this.metrics = metrics;
    }

    @Override
    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        Object result;
        long start = HbaseHandlerMetricsProxy.now();
        try {
            result = m.invoke(this.handler, args);
        }
        catch (InvocationTargetException e) {
            this.metrics.exception(e.getCause());
            throw e.getTargetException();
        }
        catch (Exception e) {
            this.metrics.exception(e);
            throw new RuntimeException("unexpected invocation exception: " + e.getMessage());
        }
        finally {
            long processTime = HbaseHandlerMetricsProxy.now() - start;
            this.metrics.incMethodTime(m.getName(), processTime);
        }
        return result;
    }

    private static long now() {
        return System.nanoTime();
    }
}

