/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs.webapp.dao;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.hadoop.mapreduce.v2.api.records.AMInfo;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.util.StringHelper;

@XmlRootElement(name="jobAttempt")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class AMAttemptInfo {
    protected String nodeHttpAddress;
    protected String nodeId;
    protected int id;
    protected long startTime;
    protected String containerId;
    protected String logsLink;
    @XmlTransient
    protected String shortLogsLink;

    public AMAttemptInfo() {
    }

    public AMAttemptInfo(AMInfo amInfo, String jobId, String user, String host, String pathPrefix) {
        this.nodeHttpAddress = "";
        this.nodeId = "";
        String nmHost = amInfo.getNodeManagerHost();
        int nmHttpPort = amInfo.getNodeManagerHttpPort();
        int nmPort = amInfo.getNodeManagerPort();
        if (nmHost != null) {
            this.nodeHttpAddress = nmHost + ":" + nmHttpPort;
            NodeId nodeId = NodeId.newInstance((String)nmHost, (int)nmPort);
            this.nodeId = nodeId.toString();
        }
        this.id = amInfo.getAppAttemptId().getAttemptId();
        this.startTime = amInfo.getStartTime();
        this.containerId = "";
        this.logsLink = "";
        this.shortLogsLink = "";
        ContainerId containerId = amInfo.getContainerId();
        if (containerId != null) {
            this.containerId = containerId.toString();
            this.logsLink = StringHelper.join((Object[])new Object[]{host, pathPrefix, StringHelper.ujoin((String)"logs", (String[])new String[]{this.nodeId, this.containerId, jobId, user})});
            this.shortLogsLink = StringHelper.ujoin((String)"logs", (String[])new String[]{this.nodeHttpAddress, this.containerId, jobId, user});
        }
    }

    public String getNodeHttpAddress() {
        return this.nodeHttpAddress;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public int getAttemptId() {
        return this.id;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public String getLogsLink() {
        return this.logsLink;
    }

    public String getShortLogsLink() {
        return this.shortLogsLink;
    }
}

