/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.notice.impl;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hertzbeat.alert.AlerterProperties;
import org.apache.hertzbeat.alert.notice.AlertNoticeException;
import org.apache.hertzbeat.alert.notice.impl.AbstractAlertNotifyHandlerImpl;
import org.apache.hertzbeat.common.entity.alerter.GroupAlert;
import org.apache.hertzbeat.common.entity.alerter.NoticeReceiver;
import org.apache.hertzbeat.common.entity.alerter.NoticeTemplate;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class FeiShuAppAlertNotifyHandlerImpl
extends AbstractAlertNotifyHandlerImpl {
    private static final Logger log = LoggerFactory.getLogger(FeiShuAppAlertNotifyHandlerImpl.class);
    private static final String TENANT_ACCESS_TOKEN_URL = "https://open.feishu.cn/open-apis/auth/v3/tenant_access_token/internal";
    private static final String EMPLOYEE_URL = "https://open.feishu.cn/open-apis/ehr/v1/employees?status=2&status=4&user_id_type=user_id&page_size=100";
    private static final String APP_MESSAGE_URL = "https://open.feishu.cn/open-apis/im/v1/messages";
    private static final String APP_BATCH_MESSAGE_URL = "https://open.feishu.cn/open-apis/message/v4/batch_send/";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final byte USER_RECEIVE_TYPE = 0;
    private static final byte CHAT_RECEIVE_TYPE = 1;
    private static final byte PART_RECEIVE_TYPE = 2;
    private static final byte ALL_RECEIVE_TYPE = 3;
    private final RestTemplate restTemplate;
    private final AlerterProperties alerterProperties;

    @Override
    public void send(NoticeReceiver receiver, NoticeTemplate noticeTemplate, GroupAlert alert) throws AlertNoticeException {
        String appId = receiver.getAppId();
        String appSecret = receiver.getAppSecret();
        Byte larkReceiveIdType = receiver.getLarkReceiveType();
        try {
            String accessToken = this.getAccessToken(appId, appSecret);
            String notificationContent = JsonUtil.toJson((Object)this.renderContent(noticeTemplate, alert));
            JsonNode messageContent = this.createLarkMessage(receiver, notificationContent);
            switch (larkReceiveIdType) {
                case 0: {
                    String[] userIds = receiver.getUserId().split(",");
                    if (userIds.length == 1) {
                        this.sendLarkMessage(accessToken, "user_id", userIds[0], messageContent);
                        break;
                    }
                    this.sendLarkUserBatchMessage(accessToken, userIds, messageContent);
                    break;
                }
                case 1: {
                    this.sendLarkMessage(accessToken, "chat_id", receiver.getChatId(), messageContent);
                    break;
                }
                case 2: {
                    this.sendLarkDepartmentBatchMessage(accessToken, receiver.getPartyId().split(","), messageContent);
                    break;
                }
                case 3: {
                    ArrayList<String> userIds = new ArrayList<String>();
                    this.getLarkEmployeeUserIds(accessToken, null, userIds);
                    this.sendLarkUserBatchMessage(accessToken, userIds.toArray(new String[0]), messageContent);
                    break;
                }
                default: {
                    throw new AlertNoticeException("Invalid larkReceiveIdType: " + larkReceiveIdType);
                }
            }
        }
        catch (Exception e) {
            throw new AlertNoticeException("[FeiShu App Notify Error] " + e.getMessage());
        }
    }

    @Override
    public byte type() {
        return 14;
    }

    private void sendLarkMessage(String accessToken, String receiverIdType, String receiverId, JsonNode messageContent) throws JsonProcessingException {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setBearerAuth(accessToken);
        FeiShuAppMessageDto messageDto = FeiShuAppMessageDto.builder().receiveId(receiverId).content(this.escapedCompactJson(messageContent)).build();
        HttpEntity request = new HttpEntity((Object)messageDto, (MultiValueMap)headers);
        this.call("https://open.feishu.cn/open-apis/im/v1/messages?receive_id_type=" + receiverIdType, request, HttpMethod.POST, FeiShuAppResponse.class);
    }

    private void sendLarkDepartmentBatchMessage(String accessToken, String[] partyIds, JsonNode messageContent) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setBearerAuth(accessToken);
        FeiShuAppBatchMessageDto batchMessageDto = FeiShuAppBatchMessageDto.builder().departmentIds(partyIds).card(messageContent).build();
        HttpEntity request = new HttpEntity((Object)batchMessageDto, (MultiValueMap)headers);
        this.call(APP_BATCH_MESSAGE_URL, request, HttpMethod.POST, FeiShuAppResponse.class);
    }

    private void sendLarkUserBatchMessage(String accessToken, String[] userIds, JsonNode messageContent) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setBearerAuth(accessToken);
        FeiShuAppBatchMessageDto batchMessageDto = FeiShuAppBatchMessageDto.builder().userIds(userIds).card(messageContent).build();
        HttpEntity request = new HttpEntity((Object)batchMessageDto, (MultiValueMap)headers);
        FeiShuAppResponse call = this.call(APP_BATCH_MESSAGE_URL, request, HttpMethod.POST, FeiShuAppResponse.class);
    }

    private String getAccessToken(String appId, String appSecret) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        FeiShuAppAccessTokenDto accessTokenRequest = FeiShuAppAccessTokenDto.builder().appId(appId).appSecret(appSecret).build();
        HttpEntity request = new HttpEntity((Object)accessTokenRequest, (MultiValueMap)headers);
        FeiShuAppAccessTokenResponse data = this.call(TENANT_ACCESS_TOKEN_URL, request, HttpMethod.POST, FeiShuAppAccessTokenResponse.class);
        return data.getTenantAccessToken();
    }

    private void getLarkEmployeeUserIds(String accessToken, String pageToken, List<String> userIds) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setBearerAuth(accessToken);
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        Object url = StringUtils.isNotBlank((CharSequence)pageToken) ? "https://open.feishu.cn/open-apis/ehr/v1/employees?status=2&status=4&user_id_type=user_id&page_size=100&page_token=" + pageToken : EMPLOYEE_URL;
        FeiShuAppEmployeeResponse employeeResponse = this.call((String)url, request, HttpMethod.GET, FeiShuAppEmployeeResponse.class);
        if (Objects.equals(employeeResponse.getCode(), 0)) {
            userIds.addAll(employeeResponse.getData().getItems().stream().map(FeiShuAppEmployeeResponse.Employee::getUserId).toList());
            Boolean hasMore = employeeResponse.getData().getHasMore();
            if (Boolean.TRUE.equals(hasMore)) {
                this.getLarkEmployeeUserIds(accessToken, employeeResponse.getData().getPageToken(), userIds);
            }
        }
    }

    private <R extends FeiShuAppResponse, E> R call(String url, HttpEntity<E> request, HttpMethod httpMethod, Class<R> responseType) {
        ResponseEntity response = this.restTemplate.exchange(url, httpMethod, request, responseType, new Object[0]);
        if (Objects.nonNull(response.getBody()) && !Objects.equals(((FeiShuAppResponse)response.getBody()).getCode(), 0)) {
            log.warn("Send FeiShu App Error: {}", (Object)((FeiShuAppResponse)response.getBody()).getMsg());
            throw new AlertNoticeException("Http StatusCode " + response.getStatusCode() + " Error: " + ((FeiShuAppResponse)response.getBody()).getMsg());
        }
        return (R)((FeiShuAppResponse)response.getBody());
    }

    private JsonNode createLarkMessage(NoticeReceiver receiver, String notificationContent) throws JsonProcessingException {
        String larkCardMessage = "{\n      \"schema\": \"2.0\",\n      \"config\": {\n          \"update_multi\": true,\n          \"locales\": [\n              \"en_us\",\n              \"zh_cn\"\n          ],\n          \"style\": {\n              \"text_size\": {\n                  \"normal_v2\": {\n                      \"default\": \"normal\",\n                      \"pc\": \"normal\",\n                      \"mobile\": \"heading\"\n                  }\n              }\n          }\n      },\n      \"body\": {\n          \"direction\": \"vertical\",\n          \"padding\": \"12px 12px 12px 12px\",\n          \"elements\": [\n              {\n                  \"tag\": \"markdown\",\n                  \"content\": \"%s\",\n                  \"i18n_content\": {\n                      \"en_us\": \"\"\n                  },\n                  \"text_align\": \"left\",\n                  \"text_size\": \"normal_v2\",\n                  \"margin\": \"0px 0px 0px 0px\"\n              },\n              {\n                  \"tag\": \"hr\",\n                  \"margin\": \"0px 0px 0px 0px\"\n              },\n              {\n                  \"tag\": \"column_set\",\n                  \"horizontal_align\": \"left\",\n                  \"columns\": [\n                      {\n                          \"tag\": \"column\",\n                          \"width\": \"weighted\",\n                          \"elements\": [\n                              {\n                                  \"tag\": \"button\",\n                                  \"text\": {\n                                      \"tag\": \"plain_text\",\n                                      \"content\": \"\u767b\u5165\u63a7\u5236\u53f0\",\n                                      \"i18n_content\": {\n                                          \"en_us\": \"Login In\"\n                                      }\n                                  },\n                                  \"type\": \"default\",\n                                  \"width\": \"default\",\n                                  \"size\": \"medium\",\n                                  \"behaviors\": [\n                                      {\n                                          \"type\": \"open_url\",\n                                          \"default_url\": \"%s\",\n                                          \"pc_url\": \"\",\n                                          \"ios_url\": \"\",\n                                          \"android_url\": \"\"\n                                      }\n                                  ]\n                              }\n                          ],\n                          \"direction\": \"horizontal\",\n                          \"vertical_spacing\": \"8px\",\n                          \"horizontal_align\": \"left\",\n                          \"vertical_align\": \"top\",\n                          \"weight\": 1\n                      }\n                  ],\n                  \"margin\": \"0px 0px 0px 0px\"\n              }\n          ]\n      },\n      \"header\": {\n          \"title\": {\n              \"tag\": \"plain_text\",\n              \"content\": \"HertzBeat \u544a\u8b66\",\n              \"i18n_content\": {\n                  \"en_us\": \"HertzBeat Alarm\"\n              }\n          },\n          \"subtitle\": {\n              \"tag\": \"plain_text\",\n              \"content\": \"\"\n          },\n          \"template\": \"red\",\n          \"padding\": \"12px 12px 12px 12px\"\n      }\n  }\n";
        Byte larkReceiveIdType = receiver.getLarkReceiveType();
        String userId = receiver.getUserId();
        Object atUserElement = "";
        if (Objects.equals(larkReceiveIdType, (byte)1) && StringUtils.isNotBlank((CharSequence)userId)) {
            atUserElement = "\\n" + Arrays.stream(userId.split(",")).map(id -> "<at id=" + id + "></at>").collect(Collectors.joining(" "));
        }
        if (notificationContent.startsWith("\"") && notificationContent.endsWith("\"")) {
            notificationContent = StringUtils.removeStart((String)notificationContent, (String)"\"");
            notificationContent = StringUtils.removeEnd((String)notificationContent, (String)"\"");
        }
        String jsonStr = String.format(larkCardMessage, notificationContent.replace("\"", "\\\"") + (String)atUserElement, this.alerterProperties.getConsoleUrl());
        return OBJECT_MAPPER.readTree(jsonStr);
    }

    private String escapedCompactJson(JsonNode json) throws JsonProcessingException {
        return OBJECT_MAPPER.writeValueAsString((Object)json);
    }

    public FeiShuAppAlertNotifyHandlerImpl(RestTemplate restTemplate, AlerterProperties alerterProperties) {
        this.restTemplate = restTemplate;
        this.alerterProperties = alerterProperties;
    }

    protected static class FeiShuAppMessageDto {
        @JsonProperty(value="receive_id")
        private String receiveId;
        @JsonProperty(value="msg_type")
        private String msgType;
        @JsonProperty(value="content")
        private String content;
        private final String uuid;

        private static String $default$msgType() {
            return "interactive";
        }

        private static String $default$uuid() {
            return UUID.randomUUID().toString();
        }

        public static FeiShuAppMessageDtoBuilder builder() {
            return new FeiShuAppMessageDtoBuilder();
        }

        public String getReceiveId() {
            return this.receiveId;
        }

        public String getMsgType() {
            return this.msgType;
        }

        public String getContent() {
            return this.content;
        }

        public String getUuid() {
            return this.uuid;
        }

        @JsonProperty(value="receive_id")
        public void setReceiveId(String receiveId) {
            this.receiveId = receiveId;
        }

        @JsonProperty(value="msg_type")
        public void setMsgType(String msgType) {
            this.msgType = msgType;
        }

        @JsonProperty(value="content")
        public void setContent(String content) {
            this.content = content;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FeiShuAppMessageDto)) {
                return false;
            }
            FeiShuAppMessageDto other = (FeiShuAppMessageDto)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$receiveId = this.getReceiveId();
            String other$receiveId = other.getReceiveId();
            if (this$receiveId == null ? other$receiveId != null : !this$receiveId.equals(other$receiveId)) {
                return false;
            }
            String this$msgType = this.getMsgType();
            String other$msgType = other.getMsgType();
            if (this$msgType == null ? other$msgType != null : !this$msgType.equals(other$msgType)) {
                return false;
            }
            String this$content = this.getContent();
            String other$content = other.getContent();
            if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
                return false;
            }
            String this$uuid = this.getUuid();
            String other$uuid = other.getUuid();
            return !(this$uuid == null ? other$uuid != null : !this$uuid.equals(other$uuid));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FeiShuAppMessageDto;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $receiveId = this.getReceiveId();
            result = result * 59 + ($receiveId == null ? 43 : $receiveId.hashCode());
            String $msgType = this.getMsgType();
            result = result * 59 + ($msgType == null ? 43 : $msgType.hashCode());
            String $content = this.getContent();
            result = result * 59 + ($content == null ? 43 : $content.hashCode());
            String $uuid = this.getUuid();
            result = result * 59 + ($uuid == null ? 43 : $uuid.hashCode());
            return result;
        }

        public String toString() {
            return "FeiShuAppAlertNotifyHandlerImpl.FeiShuAppMessageDto(receiveId=" + this.getReceiveId() + ", msgType=" + this.getMsgType() + ", content=" + this.getContent() + ", uuid=" + this.getUuid() + ")";
        }

        public FeiShuAppMessageDto(String receiveId, String msgType, String content, String uuid) {
            this.receiveId = receiveId;
            this.msgType = msgType;
            this.content = content;
            this.uuid = uuid;
        }

        public FeiShuAppMessageDto() {
            this.msgType = FeiShuAppMessageDto.$default$msgType();
            this.uuid = FeiShuAppMessageDto.$default$uuid();
        }

        public static class FeiShuAppMessageDtoBuilder {
            private String receiveId;
            private boolean msgType$set;
            private String msgType$value;
            private String content;
            private boolean uuid$set;
            private String uuid$value;

            FeiShuAppMessageDtoBuilder() {
            }

            @JsonProperty(value="receive_id")
            public FeiShuAppMessageDtoBuilder receiveId(String receiveId) {
                this.receiveId = receiveId;
                return this;
            }

            @JsonProperty(value="msg_type")
            public FeiShuAppMessageDtoBuilder msgType(String msgType) {
                this.msgType$value = msgType;
                this.msgType$set = true;
                return this;
            }

            @JsonProperty(value="content")
            public FeiShuAppMessageDtoBuilder content(String content) {
                this.content = content;
                return this;
            }

            public FeiShuAppMessageDtoBuilder uuid(String uuid) {
                this.uuid$value = uuid;
                this.uuid$set = true;
                return this;
            }

            public FeiShuAppMessageDto build() {
                String msgType$value = this.msgType$value;
                if (!this.msgType$set) {
                    msgType$value = FeiShuAppMessageDto.$default$msgType();
                }
                String uuid$value = this.uuid$value;
                if (!this.uuid$set) {
                    uuid$value = FeiShuAppMessageDto.$default$uuid();
                }
                return new FeiShuAppMessageDto(this.receiveId, msgType$value, this.content, uuid$value);
            }

            public String toString() {
                return "FeiShuAppAlertNotifyHandlerImpl.FeiShuAppMessageDto.FeiShuAppMessageDtoBuilder(receiveId=" + this.receiveId + ", msgType$value=" + this.msgType$value + ", content=" + this.content + ", uuid$value=" + this.uuid$value + ")";
            }
        }
    }

    protected static class FeiShuAppResponse {
        private Integer code;
        private String msg;

        public Integer getCode() {
            return this.code;
        }

        public String getMsg() {
            return this.msg;
        }

        public void setCode(Integer code) {
            this.code = code;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FeiShuAppResponse)) {
                return false;
            }
            FeiShuAppResponse other = (FeiShuAppResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$code = this.getCode();
            Integer other$code = other.getCode();
            if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
                return false;
            }
            String this$msg = this.getMsg();
            String other$msg = other.getMsg();
            return !(this$msg == null ? other$msg != null : !this$msg.equals(other$msg));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FeiShuAppResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $code = this.getCode();
            result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
            String $msg = this.getMsg();
            result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
            return result;
        }

        public String toString() {
            return "FeiShuAppAlertNotifyHandlerImpl.FeiShuAppResponse(code=" + this.getCode() + ", msg=" + this.getMsg() + ")";
        }
    }

    protected static class FeiShuAppBatchMessageDto {
        @JsonProperty(value="msg_type")
        private final String msgType;
        private JsonNode card;
        @JsonProperty(value="department_ids")
        private String[] departmentIds;
        @JsonProperty(value="user_ids")
        private String[] userIds;

        private static String $default$msgType() {
            return "interactive";
        }

        public static FeiShuAppBatchMessageDtoBuilder builder() {
            return new FeiShuAppBatchMessageDtoBuilder();
        }

        public String getMsgType() {
            return this.msgType;
        }

        public JsonNode getCard() {
            return this.card;
        }

        public String[] getDepartmentIds() {
            return this.departmentIds;
        }

        public String[] getUserIds() {
            return this.userIds;
        }

        public void setCard(JsonNode card) {
            this.card = card;
        }

        @JsonProperty(value="department_ids")
        public void setDepartmentIds(String[] departmentIds) {
            this.departmentIds = departmentIds;
        }

        @JsonProperty(value="user_ids")
        public void setUserIds(String[] userIds) {
            this.userIds = userIds;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FeiShuAppBatchMessageDto)) {
                return false;
            }
            FeiShuAppBatchMessageDto other = (FeiShuAppBatchMessageDto)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$msgType = this.getMsgType();
            String other$msgType = other.getMsgType();
            if (this$msgType == null ? other$msgType != null : !this$msgType.equals(other$msgType)) {
                return false;
            }
            JsonNode this$card = this.getCard();
            JsonNode other$card = other.getCard();
            if (this$card == null ? other$card != null : !this$card.equals(other$card)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getDepartmentIds(), other.getDepartmentIds())) {
                return false;
            }
            return Arrays.deepEquals(this.getUserIds(), other.getUserIds());
        }

        protected boolean canEqual(Object other) {
            return other instanceof FeiShuAppBatchMessageDto;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $msgType = this.getMsgType();
            result = result * 59 + ($msgType == null ? 43 : $msgType.hashCode());
            JsonNode $card = this.getCard();
            result = result * 59 + ($card == null ? 43 : $card.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getDepartmentIds());
            result = result * 59 + Arrays.deepHashCode(this.getUserIds());
            return result;
        }

        public String toString() {
            return "FeiShuAppAlertNotifyHandlerImpl.FeiShuAppBatchMessageDto(msgType=" + this.getMsgType() + ", card=" + this.getCard() + ", departmentIds=" + Arrays.deepToString(this.getDepartmentIds()) + ", userIds=" + Arrays.deepToString(this.getUserIds()) + ")";
        }

        public FeiShuAppBatchMessageDto(String msgType, JsonNode card, String[] departmentIds, String[] userIds) {
            this.msgType = msgType;
            this.card = card;
            this.departmentIds = departmentIds;
            this.userIds = userIds;
        }

        public FeiShuAppBatchMessageDto() {
            this.msgType = FeiShuAppBatchMessageDto.$default$msgType();
        }

        public static class FeiShuAppBatchMessageDtoBuilder {
            private boolean msgType$set;
            private String msgType$value;
            private JsonNode card;
            private String[] departmentIds;
            private String[] userIds;

            FeiShuAppBatchMessageDtoBuilder() {
            }

            @JsonProperty(value="msg_type")
            public FeiShuAppBatchMessageDtoBuilder msgType(String msgType) {
                this.msgType$value = msgType;
                this.msgType$set = true;
                return this;
            }

            public FeiShuAppBatchMessageDtoBuilder card(JsonNode card) {
                this.card = card;
                return this;
            }

            @JsonProperty(value="department_ids")
            public FeiShuAppBatchMessageDtoBuilder departmentIds(String[] departmentIds) {
                this.departmentIds = departmentIds;
                return this;
            }

            @JsonProperty(value="user_ids")
            public FeiShuAppBatchMessageDtoBuilder userIds(String[] userIds) {
                this.userIds = userIds;
                return this;
            }

            public FeiShuAppBatchMessageDto build() {
                String msgType$value = this.msgType$value;
                if (!this.msgType$set) {
                    msgType$value = FeiShuAppBatchMessageDto.$default$msgType();
                }
                return new FeiShuAppBatchMessageDto(msgType$value, this.card, this.departmentIds, this.userIds);
            }

            public String toString() {
                return "FeiShuAppAlertNotifyHandlerImpl.FeiShuAppBatchMessageDto.FeiShuAppBatchMessageDtoBuilder(msgType$value=" + this.msgType$value + ", card=" + this.card + ", departmentIds=" + Arrays.deepToString(this.departmentIds) + ", userIds=" + Arrays.deepToString(this.userIds) + ")";
            }
        }
    }

    protected static class FeiShuAppAccessTokenDto {
        @JsonProperty(value="app_id")
        private String appId;
        @JsonProperty(value="app_secret")
        private String appSecret;

        public static FeiShuAppAccessTokenDtoBuilder builder() {
            return new FeiShuAppAccessTokenDtoBuilder();
        }

        public String getAppId() {
            return this.appId;
        }

        public String getAppSecret() {
            return this.appSecret;
        }

        @JsonProperty(value="app_id")
        public void setAppId(String appId) {
            this.appId = appId;
        }

        @JsonProperty(value="app_secret")
        public void setAppSecret(String appSecret) {
            this.appSecret = appSecret;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FeiShuAppAccessTokenDto)) {
                return false;
            }
            FeiShuAppAccessTokenDto other = (FeiShuAppAccessTokenDto)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$appId = this.getAppId();
            String other$appId = other.getAppId();
            if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
                return false;
            }
            String this$appSecret = this.getAppSecret();
            String other$appSecret = other.getAppSecret();
            return !(this$appSecret == null ? other$appSecret != null : !this$appSecret.equals(other$appSecret));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FeiShuAppAccessTokenDto;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $appId = this.getAppId();
            result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
            String $appSecret = this.getAppSecret();
            result = result * 59 + ($appSecret == null ? 43 : $appSecret.hashCode());
            return result;
        }

        public String toString() {
            return "FeiShuAppAlertNotifyHandlerImpl.FeiShuAppAccessTokenDto(appId=" + this.getAppId() + ", appSecret=" + this.getAppSecret() + ")";
        }

        public FeiShuAppAccessTokenDto(String appId, String appSecret) {
            this.appId = appId;
            this.appSecret = appSecret;
        }

        public FeiShuAppAccessTokenDto() {
        }

        public static class FeiShuAppAccessTokenDtoBuilder {
            private String appId;
            private String appSecret;

            FeiShuAppAccessTokenDtoBuilder() {
            }

            @JsonProperty(value="app_id")
            public FeiShuAppAccessTokenDtoBuilder appId(String appId) {
                this.appId = appId;
                return this;
            }

            @JsonProperty(value="app_secret")
            public FeiShuAppAccessTokenDtoBuilder appSecret(String appSecret) {
                this.appSecret = appSecret;
                return this;
            }

            public FeiShuAppAccessTokenDto build() {
                return new FeiShuAppAccessTokenDto(this.appId, this.appSecret);
            }

            public String toString() {
                return "FeiShuAppAlertNotifyHandlerImpl.FeiShuAppAccessTokenDto.FeiShuAppAccessTokenDtoBuilder(appId=" + this.appId + ", appSecret=" + this.appSecret + ")";
            }
        }
    }

    protected static class FeiShuAppAccessTokenResponse
    extends FeiShuAppResponse {
        @JsonProperty(value="tenant_access_token")
        private String tenantAccessToken;

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FeiShuAppAccessTokenResponse)) {
                return false;
            }
            FeiShuAppAccessTokenResponse other = (FeiShuAppAccessTokenResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$tenantAccessToken = this.getTenantAccessToken();
            String other$tenantAccessToken = other.getTenantAccessToken();
            return !(this$tenantAccessToken == null ? other$tenantAccessToken != null : !this$tenantAccessToken.equals(other$tenantAccessToken));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof FeiShuAppAccessTokenResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $tenantAccessToken = this.getTenantAccessToken();
            result = result * 59 + ($tenantAccessToken == null ? 43 : $tenantAccessToken.hashCode());
            return result;
        }

        public String getTenantAccessToken() {
            return this.tenantAccessToken;
        }

        @JsonProperty(value="tenant_access_token")
        public void setTenantAccessToken(String tenantAccessToken) {
            this.tenantAccessToken = tenantAccessToken;
        }

        @Override
        public String toString() {
            return "FeiShuAppAlertNotifyHandlerImpl.FeiShuAppAccessTokenResponse(tenantAccessToken=" + this.getTenantAccessToken() + ")";
        }
    }

    protected static class FeiShuAppEmployeeResponse
    extends FeiShuAppResponse {
        private EmployeeResponseData data;

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FeiShuAppEmployeeResponse)) {
                return false;
            }
            FeiShuAppEmployeeResponse other = (FeiShuAppEmployeeResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            EmployeeResponseData this$data = this.getData();
            EmployeeResponseData other$data = other.getData();
            return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof FeiShuAppEmployeeResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            EmployeeResponseData $data = this.getData();
            result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
            return result;
        }

        public EmployeeResponseData getData() {
            return this.data;
        }

        public void setData(EmployeeResponseData data) {
            this.data = data;
        }

        @Override
        public String toString() {
            return "FeiShuAppAlertNotifyHandlerImpl.FeiShuAppEmployeeResponse(data=" + this.getData() + ")";
        }

        private static class EmployeeResponseData {
            @JsonProperty(value="page_token")
            private String pageToken;
            @JsonProperty(value="has_more")
            private Boolean hasMore;
            private List<Employee> items;

            public String getPageToken() {
                return this.pageToken;
            }

            public Boolean getHasMore() {
                return this.hasMore;
            }

            public List<Employee> getItems() {
                return this.items;
            }

            @JsonProperty(value="page_token")
            public void setPageToken(String pageToken) {
                this.pageToken = pageToken;
            }

            @JsonProperty(value="has_more")
            public void setHasMore(Boolean hasMore) {
                this.hasMore = hasMore;
            }

            public void setItems(List<Employee> items) {
                this.items = items;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof EmployeeResponseData)) {
                    return false;
                }
                EmployeeResponseData other = (EmployeeResponseData)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$hasMore = this.getHasMore();
                Boolean other$hasMore = other.getHasMore();
                if (this$hasMore == null ? other$hasMore != null : !((Object)this$hasMore).equals(other$hasMore)) {
                    return false;
                }
                String this$pageToken = this.getPageToken();
                String other$pageToken = other.getPageToken();
                if (this$pageToken == null ? other$pageToken != null : !this$pageToken.equals(other$pageToken)) {
                    return false;
                }
                List<Employee> this$items = this.getItems();
                List<Employee> other$items = other.getItems();
                return !(this$items == null ? other$items != null : !((Object)this$items).equals(other$items));
            }

            protected boolean canEqual(Object other) {
                return other instanceof EmployeeResponseData;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $hasMore = this.getHasMore();
                result = result * 59 + ($hasMore == null ? 43 : ((Object)$hasMore).hashCode());
                String $pageToken = this.getPageToken();
                result = result * 59 + ($pageToken == null ? 43 : $pageToken.hashCode());
                List<Employee> $items = this.getItems();
                result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
                return result;
            }

            public String toString() {
                return "FeiShuAppAlertNotifyHandlerImpl.FeiShuAppEmployeeResponse.EmployeeResponseData(pageToken=" + this.getPageToken() + ", hasMore=" + this.getHasMore() + ", items=" + this.getItems() + ")";
            }
        }

        private static class Employee {
            @JsonProperty(value="user_id")
            private String userId;

            public String getUserId() {
                return this.userId;
            }

            @JsonProperty(value="user_id")
            public void setUserId(String userId) {
                this.userId = userId;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Employee)) {
                    return false;
                }
                Employee other = (Employee)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$userId = this.getUserId();
                String other$userId = other.getUserId();
                return !(this$userId == null ? other$userId != null : !this$userId.equals(other$userId));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Employee;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $userId = this.getUserId();
                result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
                return result;
            }

            public String toString() {
                return "FeiShuAppAlertNotifyHandlerImpl.FeiShuAppEmployeeResponse.Employee(userId=" + this.getUserId() + ")";
            }
        }
    }
}

