/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.mp;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.snmp4j.event.CounterEvent;
import org.snmp4j.event.CounterListener;

public class CounterSupport {
    protected static CounterSupport instance = null;
    private transient List<CounterListener> counterListeners = new CopyOnWriteArrayList<CounterListener>();

    public static CounterSupport getInstance() {
        if (instance == null) {
            instance = new CounterSupport();
        }
        return instance;
    }

    public void addCounterListener(CounterListener listener) {
        if (!this.counterListeners.contains(listener)) {
            this.counterListeners.add(listener);
        }
    }

    public void removeCounterListener(CounterListener listener) {
        this.counterListeners.remove(listener);
    }

    public void fireIncrementCounter(CounterEvent event) {
        if (this.counterListeners != null) {
            for (CounterListener l : this.counterListeners) {
                l.incrementCounter(event);
            }
        }
    }
}

