/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal.InstrumentDescriptor;
import io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal.RegisteredObservable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Measurable;

final class KafkaMetricRegistry {
    private static final Set<String> groups = new HashSet<String>(Arrays.asList("consumer", "producer"));
    private static final Map<Class<?>, String> measurableToInstrumentType = new HashMap();
    private static final Map<String, String> descriptionCache = new ConcurrentHashMap<String, String>();

    @Nullable
    static RegisteredObservable getRegisteredObservable(Meter meter, KafkaMetric kafkaMetric) {
        Class<? extends Measurable> measurable = KafkaMetricRegistry.getMeasurable(kafkaMetric);
        if (measurable == null) {
            return null;
        }
        MetricName metricName = kafkaMetric.metricName();
        Optional<String> matchingGroup = groups.stream().filter(group -> metricName.group().contains((CharSequence)group)).findFirst();
        if (!matchingGroup.isPresent()) {
            return null;
        }
        String instrumentName = "kafka." + matchingGroup.get() + "." + metricName.name().replace("-", "_");
        String instrumentDescription = descriptionCache.computeIfAbsent(instrumentName, s -> metricName.description());
        String instrumentType = measurableToInstrumentType.getOrDefault(measurable, "DOUBLE_OBSERVABLE_GAUGE");
        InstrumentDescriptor instrumentDescriptor = KafkaMetricRegistry.toInstrumentDescriptor(instrumentType, instrumentName, instrumentDescription);
        Attributes attributes = KafkaMetricRegistry.toAttributes(metricName.tags());
        AutoCloseable observable = KafkaMetricRegistry.createObservable(meter, attributes, instrumentDescriptor, kafkaMetric);
        return RegisteredObservable.create(metricName, instrumentDescriptor, attributes, observable);
    }

    @Nullable
    private static Class<? extends Measurable> getMeasurable(KafkaMetric kafkaMetric) {
        try {
            return kafkaMetric.measurable().getClass();
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    private static InstrumentDescriptor toInstrumentDescriptor(String instrumentType, String instrumentName, String instrumentDescription) {
        switch (instrumentType) {
            case "DOUBLE_OBSERVABLE_GAUGE": {
                return InstrumentDescriptor.createDoubleGauge(instrumentName, instrumentDescription);
            }
            case "DOUBLE_OBSERVABLE_COUNTER": {
                return InstrumentDescriptor.createDoubleCounter(instrumentName, instrumentDescription);
            }
        }
        throw new IllegalStateException("Unrecognized instrument type. This is a bug.");
    }

    private static Attributes toAttributes(Map<String, String> tags) {
        AttributesBuilder attributesBuilder = Attributes.builder();
        tags.forEach((arg_0, arg_1) -> ((AttributesBuilder)attributesBuilder).put(arg_0, arg_1));
        return attributesBuilder.build();
    }

    private static AutoCloseable createObservable(Meter meter, Attributes attributes, InstrumentDescriptor instrumentDescriptor, KafkaMetric kafkaMetric) {
        Consumer<ObservableDoubleMeasurement> callback = observableMeasurement -> observableMeasurement.record(KafkaMetricRegistry.value(kafkaMetric), attributes);
        switch (instrumentDescriptor.getInstrumentType()) {
            case "DOUBLE_OBSERVABLE_GAUGE": {
                return meter.gaugeBuilder(instrumentDescriptor.getName()).setDescription(instrumentDescriptor.getDescription()).buildWithCallback(callback);
            }
            case "DOUBLE_OBSERVABLE_COUNTER": {
                return meter.counterBuilder(instrumentDescriptor.getName()).setDescription(instrumentDescriptor.getDescription()).ofDoubles().buildWithCallback(callback);
            }
        }
        throw new IllegalStateException("Unrecognized instrument type. This is a bug.");
    }

    private static double value(KafkaMetric kafkaMetric) {
        return kafkaMetric.measurable().measure(kafkaMetric.config(), System.currentTimeMillis());
    }

    private KafkaMetricRegistry() {
    }

    static {
        HashMap<String, String> classNameToType = new HashMap<String, String>();
        classNameToType.put("org.apache.kafka.common.metrics.stats.Rate", "DOUBLE_OBSERVABLE_GAUGE");
        classNameToType.put("org.apache.kafka.common.metrics.stats.Avg", "DOUBLE_OBSERVABLE_GAUGE");
        classNameToType.put("org.apache.kafka.common.metrics.stats.Max", "DOUBLE_OBSERVABLE_GAUGE");
        classNameToType.put("org.apache.kafka.common.metrics.stats.Value", "DOUBLE_OBSERVABLE_GAUGE");
        classNameToType.put("org.apache.kafka.common.metrics.stats.CumulativeSum", "DOUBLE_OBSERVABLE_COUNTER");
        classNameToType.put("org.apache.kafka.common.metrics.stats.CumulativeCount", "DOUBLE_OBSERVABLE_COUNTER");
        for (Map.Entry entry : classNameToType.entrySet()) {
            try {
                measurableToInstrumentType.put(Class.forName((String)entry.getKey()), (String)entry.getValue());
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
    }
}

