/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa.support;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import org.springframework.aot.generate.AccessControl;
import org.springframework.aot.hint.ExecutableMode;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.javapoet.ClassName;
import org.springframework.javapoet.CodeBlock;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

class InjectionCodeGenerator {
    private final ClassName targetClassName;
    private final RuntimeHints hints;

    InjectionCodeGenerator(ClassName targetClassName, RuntimeHints hints) {
        Assert.notNull((Object)targetClassName, (String)"ClassName must not be null");
        Assert.notNull((Object)hints, (String)"RuntimeHints must not be null");
        this.targetClassName = targetClassName;
        this.hints = hints;
    }

    CodeBlock generateInjectionCode(Member member, String instanceVariable, CodeBlock resourceToInject) {
        if (member instanceof Field) {
            Field field = (Field)member;
            return this.generateFieldInjectionCode(field, instanceVariable, resourceToInject);
        }
        if (member instanceof Method) {
            Method method = (Method)member;
            return this.generateMethodInjectionCode(method, instanceVariable, resourceToInject);
        }
        throw new IllegalStateException("Unsupported member type " + member.getClass().getName());
    }

    private CodeBlock generateFieldInjectionCode(Field field, String instanceVariable, CodeBlock resourceToInject) {
        CodeBlock.Builder code = CodeBlock.builder();
        AccessControl accessControl = AccessControl.forMember((Member)field);
        if (!accessControl.isAccessibleFrom(this.targetClassName)) {
            this.hints.reflection().registerField(field);
            code.addStatement("$T field = $T.findField($T.class, $S)", new Object[]{Field.class, ReflectionUtils.class, field.getDeclaringClass(), field.getName()});
            code.addStatement("$T.makeAccessible($L)", new Object[]{ReflectionUtils.class, "field"});
            code.addStatement("$T.setField($L, $L, $L)", new Object[]{ReflectionUtils.class, "field", instanceVariable, resourceToInject});
        } else {
            code.addStatement("$L.$L = $L", new Object[]{instanceVariable, field.getName(), resourceToInject});
        }
        return code.build();
    }

    private CodeBlock generateMethodInjectionCode(Method method, String instanceVariable, CodeBlock resourceToInject) {
        Assert.isTrue((method.getParameterCount() == 1 ? 1 : 0) != 0, () -> "Method '" + method.getName() + "' must declare a single parameter");
        CodeBlock.Builder code = CodeBlock.builder();
        AccessControl accessControl = AccessControl.forMember((Member)method);
        if (!accessControl.isAccessibleFrom(this.targetClassName)) {
            this.hints.reflection().registerMethod(method, ExecutableMode.INVOKE);
            code.addStatement("$T method = $T.findMethod($T.class, $S, $T.class)", new Object[]{Method.class, ReflectionUtils.class, method.getDeclaringClass(), method.getName(), method.getParameterTypes()[0]});
            code.addStatement("$T.makeAccessible($L)", new Object[]{ReflectionUtils.class, "method"});
            code.addStatement("$T.invokeMethod($L, $L, $L)", new Object[]{ReflectionUtils.class, "method", instanceVariable, resourceToInject});
        } else {
            code.addStatement("$L.$L($L)", new Object[]{instanceVariable, method.getName(), resourceToInject});
        }
        return code.build();
    }
}

