/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.servlets;

import java.io.StringWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.catalina.servlets.WebdavServlet;
import org.apache.catalina.util.DOMWriter;
import org.apache.catalina.util.XMLWriter;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;
import org.w3c.dom.Node;

public class DataSourcePropertyStore
implements WebdavServlet.PropertyStore {
    protected static final StringManager sm = StringManager.getManager(DataSourcePropertyStore.class);
    private final Log log = LogFactory.getLog(DataSourcePropertyStore.class);
    private static String ADD_PROPERTY_STMT = "INSERT INTO properties (path, namespace, name, node) VALUES (?, ?, ?, ?)";
    private static String SET_PROPERTY_STMT = "UPDATE properties SET node = ? WHERE path = ? AND namespace = ? AND name = ?";
    private static String REMOVE_ALL_PROPERTIES_STMT = "DELETE FROM properties WHERE path = ?";
    private static String REMOVE_PROPERTY_STMT = "DELETE FROM properties WHERE path = ? AND namespace = ? AND name = ?";
    private static String GET_PROPERTY_STMT = "SELECT node FROM properties WHERE path = ? AND namespace = ? AND name = ?";
    private static String GET_PROPERTIES_NAMES_STMT = "SELECT namespace, name FROM properties WHERE path = ?";
    private static String GET_PROPERTIES_STMT = "SELECT namespace, name, node FROM properties WHERE path = ?";
    private static String GET_PROPERTIES_NODES_STMT = "SELECT node FROM properties WHERE path = ?";
    private String dataSourceName = "WebdavPropertyStore";
    private final ReentrantReadWriteLock dbLock = new ReentrantReadWriteLock();
    private final Lock dbReadLock = this.dbLock.readLock();
    private final Lock dbWriteLock = this.dbLock.writeLock();
    protected DataSource dataSource = null;

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    @Override
    public void init() {
        if (this.dataSource == null) {
            try {
                this.dataSource = (DataSource)new InitialContext().lookup("java:comp/env/" + this.dataSourceName);
            }
            catch (NamingException e) {
                throw new IllegalArgumentException(sm.getString("webdavservlet.dataSourceStore.noDataSource", this.dataSourceName), e);
            }
        }
    }

    @Override
    public void destroy() {
    }

    @Override
    public void periodicEvent() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copy(String source, String destination) {
        block38: {
            if (this.dataSource == null) {
                return;
            }
            this.dbWriteLock.lock();
            try (Connection connection = this.dataSource.getConnection();
                 PreparedStatement statement = connection.prepareStatement(GET_PROPERTIES_STMT);){
                statement.setString(1, source);
                if (!statement.execute()) break block38;
                ResultSet rs = statement.getResultSet();
                while (rs.next()) {
                    String namespace = rs.getString(1);
                    String name = rs.getString(2);
                    String node = rs.getString(3);
                    boolean found = false;
                    try (PreparedStatement statement2 = connection.prepareStatement(GET_PROPERTY_STMT);){
                        ResultSet rs2;
                        statement2.setString(1, destination);
                        statement2.setString(2, namespace);
                        statement2.setString(3, name);
                        if (statement2.execute() && (rs2 = statement2.getResultSet()).next()) {
                            found = true;
                        }
                    }
                    if (found) {
                        statement2 = connection.prepareStatement(SET_PROPERTY_STMT);
                        try {
                            statement2.setString(1, node);
                            statement2.setString(2, destination);
                            statement2.setString(3, namespace);
                            statement2.setString(4, name);
                            statement2.execute();
                            continue;
                        }
                        finally {
                            if (statement2 != null) {
                                statement2.close();
                            }
                            continue;
                        }
                    }
                    statement2 = connection.prepareStatement(ADD_PROPERTY_STMT);
                    try {
                        statement2.setString(1, destination);
                        statement2.setString(2, namespace);
                        statement2.setString(3, name);
                        statement2.setString(4, node);
                        statement2.execute();
                    }
                    finally {
                        if (statement2 == null) continue;
                        statement2.close();
                    }
                }
            }
            catch (SQLException e) {
                this.log.warn(sm.getString("webdavservlet.dataSourceStore.error", "copy", source), e);
            }
            finally {
                this.dbWriteLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String resource) {
        if (this.dataSource == null) {
            return;
        }
        this.dbWriteLock.lock();
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(REMOVE_ALL_PROPERTIES_STMT);){
            statement.setString(1, resource);
            statement.execute();
        }
        catch (SQLException e) {
            this.log.warn(sm.getString("webdavservlet.dataSourceStore.error", "delete", resource), e);
        }
        finally {
            this.dbWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean propfind(String resource, Node property, boolean nameOnly, XMLWriter generatedXML) {
        if (this.dataSource == null) {
            return false;
        }
        if (nameOnly) {
            this.dbReadLock.lock();
            try (Connection connection = this.dataSource.getConnection();
                 PreparedStatement statement = connection.prepareStatement(GET_PROPERTIES_NAMES_STMT);){
                statement.setString(1, resource);
                if (!statement.execute()) return false;
                ResultSet rs = statement.getResultSet();
                while (rs.next()) {
                    String namespace = rs.getString(1);
                    String name = rs.getString(2);
                    generatedXML.writeElement(null, namespace, name, 2);
                }
                return false;
            }
            catch (SQLException e) {
                this.log.warn(sm.getString("webdavservlet.dataSourceStore.error", "propfind", resource), e);
                return false;
            }
            finally {
                this.dbReadLock.unlock();
            }
        }
        if (property != null) {
            this.dbReadLock.lock();
            try (Connection connection = this.dataSource.getConnection();
                 PreparedStatement statement = connection.prepareStatement(GET_PROPERTY_STMT);){
                ResultSet rs;
                statement.setString(1, resource);
                statement.setString(2, property.getNamespaceURI());
                statement.setString(3, property.getLocalName());
                if (!statement.execute() || !(rs = statement.getResultSet()).next()) return false;
                String node = rs.getString(1);
                generatedXML.writeRaw(node);
                boolean bl = true;
                return bl;
            }
            catch (SQLException e) {
                this.log.warn(sm.getString("webdavservlet.dataSourceStore.error", "propfind", resource), e);
                return false;
            }
            finally {
                this.dbReadLock.unlock();
            }
        }
        this.dbReadLock.lock();
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(GET_PROPERTIES_NODES_STMT);){
            statement.setString(1, resource);
            if (!statement.execute()) return false;
            ResultSet rs = statement.getResultSet();
            while (rs.next()) {
                String node = rs.getString(1);
                generatedXML.writeRaw(node);
            }
            return false;
        }
        catch (SQLException e) {
            this.log.warn(sm.getString("webdavservlet.dataSourceStore.error", "propfind", resource), e);
            return false;
        }
        finally {
            this.dbReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void proppatch(String resource, ArrayList<WebdavServlet.ProppatchOperation> operations) {
        boolean protectedProperty = false;
        for (WebdavServlet.ProppatchOperation operation : operations) {
            if (!operation.getProtectedProperty()) continue;
            protectedProperty = true;
            operation.setStatusCode(403);
        }
        if (protectedProperty) {
            for (WebdavServlet.ProppatchOperation operation : operations) {
                if (operation.getProtectedProperty()) continue;
                operation.setStatusCode(424);
            }
        } else {
            if (this.dataSource == null) {
                for (WebdavServlet.ProppatchOperation operation : operations) {
                    operation.setStatusCode(500);
                }
                return;
            }
            boolean failure = false;
            this.dbWriteLock.lock();
            try (Connection connection = this.dataSource.getConnection();){
                connection.setAutoCommit(false);
                for (WebdavServlet.ProppatchOperation operation : operations) {
                    Node node;
                    block52: {
                        if (operation.getUpdateType() == WebdavServlet.PropertyUpdateType.SET) {
                            node = operation.getPropertyNode().cloneNode(true);
                            StringWriter strWriter = new StringWriter();
                            DOMWriter domWriter = new DOMWriter(strWriter);
                            domWriter.print(node);
                            String serializedNode = strWriter.toString();
                            boolean found = false;
                            try {
                                try (PreparedStatement statement = connection.prepareStatement(GET_PROPERTY_STMT);){
                                    ResultSet rs;
                                    statement.setString(1, resource);
                                    statement.setString(2, node.getNamespaceURI());
                                    statement.setString(3, node.getLocalName());
                                    if (statement.execute() && (rs = statement.getResultSet()).next()) {
                                        found = true;
                                    }
                                }
                                if (found) {
                                    statement = connection.prepareStatement(SET_PROPERTY_STMT);
                                    try {
                                        statement.setString(1, serializedNode);
                                        statement.setString(2, resource);
                                        statement.setString(3, node.getNamespaceURI());
                                        statement.setString(4, node.getLocalName());
                                        statement.execute();
                                        break block52;
                                    }
                                    finally {
                                        if (statement != null) {
                                            statement.close();
                                        }
                                    }
                                }
                                statement = connection.prepareStatement(ADD_PROPERTY_STMT);
                                try {
                                    statement.setString(1, resource);
                                    statement.setString(2, node.getNamespaceURI());
                                    statement.setString(3, node.getLocalName());
                                    statement.setString(4, serializedNode);
                                    statement.execute();
                                }
                                finally {
                                    if (statement != null) {
                                        statement.close();
                                    }
                                }
                            }
                            catch (SQLException e) {
                                failure = true;
                                operation.setStatusCode(500);
                                break;
                            }
                        }
                    }
                    if (operation.getUpdateType() != WebdavServlet.PropertyUpdateType.REMOVE) continue;
                    node = operation.getPropertyNode();
                    try {
                        PreparedStatement statement = connection.prepareStatement(REMOVE_PROPERTY_STMT);
                        try {
                            statement.setString(1, resource);
                            statement.setString(2, node.getNamespaceURI());
                            statement.setString(3, node.getLocalName());
                            statement.execute();
                        }
                        finally {
                            if (statement == null) continue;
                            statement.close();
                        }
                    }
                    catch (SQLException e) {
                        failure = true;
                        operation.setStatusCode(500);
                        break;
                    }
                }
                if (failure) {
                    connection.rollback();
                    for (WebdavServlet.ProppatchOperation operation : operations) {
                        if (operation.getStatusCode() != 200) continue;
                        operation.setStatusCode(424);
                    }
                }
                connection.commit();
            }
            catch (SQLException e) {
                this.log.warn(sm.getString("webdavservlet.dataSourceStore.error", "proppatch", resource), e);
                for (WebdavServlet.ProppatchOperation operation : operations) {
                    operation.setStatusCode(500);
                }
            }
            finally {
                this.dbWriteLock.unlock();
            }
        }
    }
}

