/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.warehouse.db;

import java.util.List;
import java.util.Map;
import org.apache.hertzbeat.common.entity.dto.query.DatasourceQuery;
import org.apache.hertzbeat.common.entity.dto.query.DatasourceQueryData;
import org.apache.hertzbeat.warehouse.db.QueryExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public abstract class SqlQueryExecutor
implements QueryExecutor {
    private static final Logger log = LoggerFactory.getLogger(SqlQueryExecutor.class);
    private static final String supportQueryLanguage = "sql";
    protected final RestTemplate restTemplate;
    protected final HttpSqlProperties httpSqlProperties;

    SqlQueryExecutor(RestTemplate restTemplate, HttpSqlProperties httpSqlProperties) {
        this.restTemplate = restTemplate;
        this.httpSqlProperties = httpSqlProperties;
    }

    @Override
    public List<Map<String, Object>> execute(String query) {
        return null;
    }

    @Override
    public DatasourceQueryData query(DatasourceQuery datasourceQuery) {
        return null;
    }

    @Override
    public boolean support(String queryLanguage) {
        return StringUtils.hasText((String)queryLanguage) && queryLanguage.equalsIgnoreCase(supportQueryLanguage);
    }

    protected record HttpSqlProperties(String url, String username, String password) {
    }
}

