/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.warehouse.store;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.List;
import java.util.Optional;
import org.apache.hertzbeat.common.entity.manager.Monitor;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.queue.CommonDataQueue;
import org.apache.hertzbeat.common.support.exception.CommonDataQueueUnknownException;
import org.apache.hertzbeat.common.util.BackoffUtils;
import org.apache.hertzbeat.common.util.ExponentialBackoff;
import org.apache.hertzbeat.plugin.PostCollectPlugin;
import org.apache.hertzbeat.plugin.runner.PluginRunner;
import org.apache.hertzbeat.warehouse.WarehouseWorkerPool;
import org.apache.hertzbeat.warehouse.store.history.tsdb.HistoryDataWriter;
import org.apache.hertzbeat.warehouse.store.realtime.RealTimeDataWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Component
public class DataStorageDispatch {
    private static final Logger log = LoggerFactory.getLogger(DataStorageDispatch.class);
    private final CommonDataQueue commonDataQueue;
    private final WarehouseWorkerPool workerPool;
    private final JdbcTemplate jdbcTemplate;
    private final RealTimeDataWriter realTimeDataWriter;
    private final Optional<HistoryDataWriter> historyDataWriter;
    private final PluginRunner pluginRunner;
    private static final int LOG_BATCH_SIZE = 1000;
    @PersistenceContext
    private EntityManager entityManager;

    public DataStorageDispatch(CommonDataQueue commonDataQueue, WarehouseWorkerPool workerPool, JdbcTemplate jdbcTemplate, Optional<HistoryDataWriter> historyDataWriter, RealTimeDataWriter realTimeDataWriter, PluginRunner pluginRunner) {
        this.commonDataQueue = commonDataQueue;
        this.workerPool = workerPool;
        this.jdbcTemplate = jdbcTemplate;
        this.realTimeDataWriter = realTimeDataWriter;
        this.historyDataWriter = historyDataWriter;
        this.pluginRunner = pluginRunner;
        this.startPersistentDataStorage();
        this.startLogDataStorage();
    }

    protected void startPersistentDataStorage() {
        Runnable runnable = () -> {
            Thread.currentThread().setName("warehouse-persistent-data-storage");
            ExponentialBackoff backoff = new ExponentialBackoff(50L, 1000L);
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    CollectRep.MetricsData metricsData = this.commonDataQueue.pollMetricsDataToStorage();
                    if (metricsData == null) continue;
                    backoff.reset();
                    try {
                        this.calculateMonitorStatus(metricsData);
                        this.historyDataWriter.ifPresent(dataWriter -> dataWriter.saveData(metricsData));
                        this.pluginRunner.pluginExecute(PostCollectPlugin.class, (postCollectPlugin, pluginContext) -> postCollectPlugin.execute(metricsData, pluginContext));
                    }
                    finally {
                        this.realTimeDataWriter.saveData(metricsData);
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                catch (CommonDataQueueUnknownException ue) {
                    if (BackoffUtils.shouldContinueAfterBackoff((ExponentialBackoff)backoff)) continue;
                    break;
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        };
        this.workerPool.executeJob(runnable);
    }

    protected void startLogDataStorage() {
        Runnable runnable = () -> {
            ExponentialBackoff backoff = new ExponentialBackoff(50L, 1000L);
            Thread.currentThread().setName("warehouse-log-data-storage");
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    List logEntries = this.commonDataQueue.pollLogEntryToStorageBatch(1000);
                    if (logEntries == null || logEntries.isEmpty()) continue;
                    backoff.reset();
                    this.historyDataWriter.ifPresent(dataWriter -> {
                        try {
                            dataWriter.saveLogDataBatch(logEntries);
                        }
                        catch (Exception e) {
                            log.error("Failed to save log entries batch: {}", (Object)e.getMessage(), (Object)e);
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                catch (CommonDataQueueUnknownException ue) {
                    if (BackoffUtils.shouldContinueAfterBackoff((ExponentialBackoff)backoff)) continue;
                    break;
                }
                catch (Exception e) {
                    log.error("Error in log data storage thread: {}", (Object)e.getMessage(), (Object)e);
                }
            }
        };
        this.workerPool.executeJob(runnable);
    }

    protected void calculateMonitorStatus(CollectRep.MetricsData metricsData) {
        if (metricsData.getPriority() == 0) {
            long id = metricsData.getId();
            CollectRep.Code code = metricsData.getCode();
            try {
                String sql = "UPDATE hzb_monitor SET status = ? WHERE id = ? AND status = ?";
                int status = code == CollectRep.Code.SUCCESS ? 1 : 2;
                int preStatus = code == CollectRep.Code.SUCCESS ? 2 : 1;
                int matchedRows = this.jdbcTemplate.update(sql, new Object[]{status, id, preStatus});
                if (matchedRows > 0) {
                    this.entityManager.getEntityManagerFactory().getCache().evict(Monitor.class, (Object)id);
                }
            }
            catch (Exception e) {
                log.error("Update monitor status failed for monitor id: {}", (Object)id, (Object)e);
            }
        }
    }
}

