/*
 * Decompiled with CFR 0.152.
 */
package io.questdb;

import io.questdb.ServerConfigurationException;
import io.questdb.std.Chars;
import io.questdb.std.Files;
import io.questdb.std.LowerCaseCharSequenceObjHashMap;
import io.questdb.std.Mutable;
import io.questdb.std.str.Path;
import io.questdb.std.str.Utf8s;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VolumeDefinitions
implements Mutable {
    private static final char SEPARATOR = ',';
    private final LowerCaseCharSequenceObjHashMap<String> aliasToVolumeRoot = new LowerCaseCharSequenceObjHashMap(4);
    private int hi;
    private int limit;
    private int lo;

    @Override
    public void clear() {
        this.aliasToVolumeRoot.clear();
        this.limit = 0;
        this.hi = 0;
        this.lo = 0;
    }

    public void forEach(LowerCaseCharSequenceObjHashMap.CharSequenceObjConsumer<String> action) {
        this.aliasToVolumeRoot.forEach(action);
    }

    public VolumeDefinitions of(@Nullable CharSequence definitions, @NotNull Path path, @NotNull String root) throws ServerConfigurationException {
        if (definitions != null) {
            this.aliasToVolumeRoot.clear();
            this.limit = definitions.length();
            this.lo = 0;
            int separatorCount = 0;
            String alias = null;
            for (int i = 0; i < this.limit; ++i) {
                char c = definitions.charAt(i);
                if (c == '-' && i + 1 < this.limit && definitions.charAt(i + 1) == '>') {
                    if (alias != null) {
                        throw new ServerConfigurationException("invalid syntax, missing volume path at offset " + this.lo);
                    }
                    alias = Chars.toString(this.popToken(definitions, i, false));
                    this.lo = ++i + 1;
                    continue;
                }
                if (',' != c) continue;
                if (alias == null) {
                    throw new ServerConfigurationException("invalid syntax, missing alias at offset " + this.lo);
                }
                this.addVolumeDefinition(alias, this.popToken(definitions, i, false), path, root);
                alias = null;
                this.lo = i + 1;
                ++separatorCount;
            }
            this.finishVolumeDefinitions(alias, this.popToken(definitions, this.limit, true), path, root, separatorCount);
        }
        return this;
    }

    @Nullable
    public CharSequence resolveAlias(@NotNull CharSequence alias) {
        return this.aliasToVolumeRoot.get(alias);
    }

    @Nullable
    public CharSequence resolvePath(@NotNull CharSequence path) {
        int n = this.aliasToVolumeRoot.keys().size();
        for (int i = 0; i < n; ++i) {
            CharSequence candidateAlias = (CharSequence)this.aliasToVolumeRoot.keys().get(i);
            CharSequence candidatePath = this.aliasToVolumeRoot.get(candidateAlias);
            if (!Chars.equals(candidatePath, path)) continue;
            return candidateAlias;
        }
        return null;
    }

    private void addVolumeDefinition(String alias, CharSequence volumePath, Path path, String root) throws ServerConfigurationException {
        int len = volumePath.length();
        if (len > 0 && volumePath.charAt(len - 1) == Files.SEPARATOR) {
            --len;
        }
        if (!Files.isDirOrSoftLinkDir(path.of(volumePath, 0, len).$())) {
            throw new ServerConfigurationException("inaccessible volume [path=" + String.valueOf(volumePath) + "]");
        }
        String volumeRoot = Utf8s.toString(path);
        if (volumeRoot.equals(root)) {
            throw new ServerConfigurationException("standard volume cannot have an alias [alias=" + alias + ", root=" + root + "]");
        }
        if (!this.aliasToVolumeRoot.put(alias, volumeRoot)) {
            throw new ServerConfigurationException("duplicate alias [alias=" + alias + "]");
        }
    }

    private void finishVolumeDefinitions(String alias, CharSequence volumePath, Path path, String root, int separatorCount) throws ServerConfigurationException {
        if (volumePath != null) {
            if (alias == null) {
                throw new ServerConfigurationException("invalid syntax, dangling alias [alias=" + String.valueOf(volumePath) + ", offset=" + this.lo + "]");
            }
            this.addVolumeDefinition(alias, volumePath, path, root);
        } else {
            if (alias != null) {
                throw new ServerConfigurationException("invalid syntax, missing volume path at offset " + this.hi);
            }
            if (separatorCount > 0) {
                throw new ServerConfigurationException("invalid syntax, dangling separator [sep=',']");
            }
        }
    }

    private CharSequence popToken(CharSequence definitions, int i, boolean isOptional) throws ServerConfigurationException {
        while (this.lo < this.limit && definitions.charAt(this.lo) == ' ') {
            ++this.lo;
        }
        this.hi = i;
        while (this.hi > this.lo && definitions.charAt(this.hi - 1) == ' ') {
            --this.hi;
        }
        if (this.hi < this.lo + 1) {
            if (isOptional) {
                return null;
            }
            throw new ServerConfigurationException("empty value at offset " + this.hi);
        }
        if (definitions.charAt(this.hi - 1) == '\'') {
            if (definitions.charAt(this.lo) != '\'') {
                throw new ServerConfigurationException("missing opening quote at offset " + this.lo);
            }
            if (--this.hi < ++this.lo + 1) {
                if (isOptional) {
                    return null;
                }
                throw new ServerConfigurationException("empty value at offset " + this.hi);
            }
        } else if (definitions.charAt(this.lo) == '\'') {
            throw new ServerConfigurationException("missing closing quote at offset " + (this.hi - 1));
        }
        return definitions.subSequence(this.lo, this.hi);
    }
}

