/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.PartitionBy;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryMR;
import io.questdb.cairo.vm.api.MemoryW;
import io.questdb.std.FilesFacade;
import io.questdb.std.IntList;
import io.questdb.std.LongList;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import io.questdb.std.Unsafe;
import io.questdb.std.datetime.microtime.TimestampFormatUtils;
import io.questdb.std.str.LPSZ;
import io.questdb.std.str.StringSink;
import java.io.Closeable;

public class TxReader
implements Closeable,
Mutable {
    public static final long DEFAULT_PARTITION_TIMESTAMP = 0L;
    public static final long PARTITION_FLAGS_MASK = 0x7FFFF00000000000L;
    public static final long PARTITION_SIZE_MASK = -9223354444668731393L;
    protected static final int NONE_COL_STRUCTURE_VERSION = Integer.MIN_VALUE;
    protected static final int PARTITION_MASKED_SIZE_OFFSET = 1;
    protected static final int PARTITION_MASK_PARQUET_FORMAT_BIT_OFFSET = 61;
    protected static final int PARTITION_MASK_READ_ONLY_BIT_OFFSET = 62;
    protected static final int PARTITION_NAME_TX_OFFSET = 2;
    protected static final int PARTITION_PARQUET_FILE_SIZE_OFFSET = 3;
    protected static final int PARTITION_TS_OFFSET = 0;
    protected final LongList attachedPartitions = new LongList();
    protected final FilesFacade ff;
    private final IntList symbolCountSnapshot = new IntList();
    protected int attachedPartitionsSize = 0;
    protected long columnVersion;
    protected long dataVersion;
    protected long fixedRowCount;
    protected long lagMaxTimestamp;
    protected long lagMinTimestamp;
    protected boolean lagOrdered;
    protected int lagRowCount;
    protected int lagTxnCount;
    protected long maxTimestamp;
    protected long minTimestamp;
    protected int partitionBy;
    protected long partitionTableVersion;
    protected long seqTxn;
    protected long structureVersion;
    protected int symbolColumnCount;
    protected long transientRowCount;
    protected long truncateVersion;
    protected long txn;
    private int baseOffset;
    private PartitionBy.PartitionCeilMethod partitionCeilMethod;
    private PartitionBy.PartitionFloorMethod partitionFloorMethod;
    private int partitionSegmentSize;
    private MemoryMR roTxMemBase;
    private long size;
    private int symbolsSize;
    private long version;

    public TxReader(FilesFacade ff) {
        this.ff = ff;
    }

    public boolean attachedPartitionsContains(long ts) {
        return (long)this.findAttachedPartitionRawIndexByLoTimestamp(ts) > -1L;
    }

    @Override
    public void clear() {
        this.clearData();
        Misc.free(this.roTxMemBase);
    }

    @Override
    public void close() {
        this.roTxMemBase = Misc.free(this.roTxMemBase);
        this.clear();
    }

    public void dumpRawTxPartitionInfo(LongList container) {
        container.add(this.attachedPartitions);
    }

    public void dumpTo(MemoryW mem) {
        mem.putLong(0L, this.version);
        boolean isA = (this.version & 1L) == 0L;
        int baseOffset = TableUtils.TX_BASE_HEADER_SIZE;
        mem.putInt(isA ? 8L : 32L, baseOffset);
        mem.putInt(isA ? 12L : 36L, this.symbolsSize);
        mem.putInt(isA ? 16L : 40L, this.partitionSegmentSize);
        mem.putLong((long)baseOffset + 0L, this.txn);
        mem.putLong((long)baseOffset + 8L, this.transientRowCount);
        mem.putLong((long)baseOffset + 16L, this.fixedRowCount);
        mem.putLong((long)baseOffset + 24L, this.minTimestamp);
        mem.putLong((long)baseOffset + 32L, this.maxTimestamp);
        mem.putLong((long)baseOffset + 40L, this.structureVersion);
        mem.putLong((long)baseOffset + 48L, this.dataVersion);
        mem.putLong((long)baseOffset + 56L, this.partitionTableVersion);
        mem.putLong((long)baseOffset + 64L, this.columnVersion);
        mem.putLong((long)baseOffset + 72L, this.truncateVersion);
        mem.putLong((long)baseOffset + 80L, this.seqTxn);
        mem.putInt((long)baseOffset + 96L, this.lagRowCount);
        mem.putLong((long)baseOffset + 100L, this.lagMinTimestamp);
        mem.putLong((long)baseOffset + 108L, this.lagMaxTimestamp);
        mem.putInt((long)baseOffset + 92L, this.lagOrdered ? this.lagTxnCount : -this.lagTxnCount);
        mem.putInt((long)baseOffset + 128L, this.symbolColumnCount);
        int symbolMapCount = this.symbolCountSnapshot.size();
        for (int i = 0; i < symbolMapCount; ++i) {
            long offset = TableUtils.getSymbolWriterIndexOffset(i);
            int symCount = this.symbolCountSnapshot.getQuick(i);
            mem.putInt((long)baseOffset + offset, symCount);
            mem.putInt((long)baseOffset + (offset += 4L), symCount);
        }
        int size = this.attachedPartitions.size();
        long partitionTableOffset = TableUtils.getPartitionTableSizeOffset(symbolMapCount);
        mem.putInt((long)baseOffset + partitionTableOffset, size * 8);
        for (int i = 0; i < size; ++i) {
            long offset = TableUtils.getPartitionTableIndexOffset(partitionTableOffset, i);
            mem.putLong((long)baseOffset + offset, this.attachedPartitions.getQuick(i));
        }
    }

    public int findAttachedPartitionIndexByLoTimestamp(long ts) {
        int index = this.attachedPartitions.binarySearchBlock(TableUtils.LONGS_PER_TX_ATTACHED_PARTITION_MSB, ts, -1);
        if (index < 0) {
            return -((-index - 1) / 4) - 1;
        }
        return index / 4;
    }

    public int getBaseOffset() {
        return this.baseOffset;
    }

    public int getColumnStructureVersion() {
        int columnStructureVersion = Numbers.decodeHighInt(this.structureVersion);
        return columnStructureVersion == 0 ? this.getMetadataVersion() : (columnStructureVersion == Integer.MIN_VALUE ? 0 : columnStructureVersion);
    }

    public long getColumnVersion() {
        return this.columnVersion;
    }

    public long getDataVersion() {
        return this.dataVersion;
    }

    public long getFixedRowCount() {
        return this.fixedRowCount;
    }

    public long getLagMaxTimestamp() {
        return this.lagMaxTimestamp;
    }

    public long getLagMinTimestamp() {
        return this.lagMinTimestamp;
    }

    public int getLagRowCount() {
        return this.lagRowCount;
    }

    public int getLagTxnCount() {
        return this.lagTxnCount;
    }

    public long getLastPartitionTimestamp() {
        if (PartitionBy.isPartitioned(this.partitionBy)) {
            return this.getPartitionTimestampByTimestamp(this.maxTimestamp);
        }
        return 0L;
    }

    public long getLogicalPartitionTimestamp(long timestamp) {
        return this.getPartitionFloor(timestamp);
    }

    public long getMaxTimestamp() {
        return this.maxTimestamp;
    }

    public int getMetadataVersion() {
        return Numbers.decodeLowInt(this.structureVersion);
    }

    public long getMinTimestamp() {
        return this.minTimestamp;
    }

    public long getNextLogicalPartitionTimestamp(long timestamp) {
        if (this.partitionCeilMethod != null) {
            return this.partitionCeilMethod.ceil(timestamp);
        }
        assert (this.partitionBy == 3);
        return Long.MAX_VALUE;
    }

    public long getNextPartitionTimestamp(long timestamp) {
        if (this.partitionBy == 3) {
            return Long.MAX_VALUE;
        }
        int index = this.attachedPartitions.binarySearchBlock(TableUtils.LONGS_PER_TX_ATTACHED_PARTITION_MSB, timestamp, -1);
        index = index < 0 ? -index - 1 : (index += 4);
        int nextIndex = index + 0;
        if (nextIndex < this.attachedPartitions.size()) {
            long nextPartitionTs = this.attachedPartitions.getQuick(nextIndex);
            if (this.partitionFloorMethod.floor(timestamp) == this.partitionFloorMethod.floor(nextPartitionTs)) {
                return nextPartitionTs;
            }
        }
        return this.partitionCeilMethod.ceil(timestamp);
    }

    public long getNextExistingPartitionTimestamp(long timestamp) {
        if (this.partitionBy == 3) {
            return Long.MAX_VALUE;
        }
        int index = this.attachedPartitions.binarySearchBlock(TableUtils.LONGS_PER_TX_ATTACHED_PARTITION_MSB, timestamp, -1);
        index = index < 0 ? -index - 1 : (index += 4);
        int nextIndex = index + 0;
        if (nextIndex < this.attachedPartitions.size()) {
            return this.attachedPartitions.get(nextIndex);
        }
        return Long.MAX_VALUE;
    }

    public int getPartitionCount() {
        return this.attachedPartitions.size() / 4;
    }

    public long getPartitionFloor(long timestamp) {
        return this.partitionFloorMethod != null ? (timestamp != Long.MIN_VALUE ? this.partitionFloorMethod.floor(timestamp) : Long.MIN_VALUE) : 0L;
    }

    public int getPartitionIndex(long ts) {
        int index = this.findAttachedPartitionRawIndexByLoTimestamp(this.getPartitionTimestampByTimestamp(ts));
        if (index > -1) {
            return index / 4;
        }
        return -1;
    }

    public long getPartitionNameTxn(int i) {
        return this.getPartitionNameTxnByRawIndex(i * 4);
    }

    public long getPartitionNameTxnByPartitionTimestamp(long ts) {
        return this.getPartitionNameTxnByPartitionTimestamp(ts, -1L);
    }

    public long getPartitionNameTxnByPartitionTimestamp(long ts, long defaultValue) {
        int index = this.findAttachedPartitionRawIndexByLoTimestamp(ts);
        if (index > -1) {
            return this.attachedPartitions.getQuick(index + 2);
        }
        return defaultValue;
    }

    public long getPartitionNameTxnByRawIndex(int index) {
        return TxReader.getPartitionNameTxnByRawIndex(this.attachedPartitions, index);
    }

    public long getPartitionParquetFileSize(int partitionIndex) {
        long fileSize = this.getPartitionParquetFileSizeByRawIndex(partitionIndex * 4);
        assert (fileSize > 0L || !this.isPartitionParquet(partitionIndex));
        return fileSize;
    }

    public long getPartitionRowCountByTimestamp(long ts) {
        int indexRaw = this.findAttachedPartitionRawIndexByLoTimestamp(ts);
        if (indexRaw > -1) {
            return this.attachedPartitions.getQuick(indexRaw + 1) & 0x80000FFFFFFFFFFFL;
        }
        return -1L;
    }

    public long getPartitionSize(int i) {
        return this.getPartitionSizeByRawIndex(i * 4);
    }

    public long getPartitionSizeByRawIndex(int index) {
        return TxReader.getPartitionSizeByRawIndex(this.attachedPartitions, index);
    }

    public long getPartitionTableVersion() {
        return this.partitionTableVersion;
    }

    public long getPartitionTimestampByIndex(int i) {
        return this.attachedPartitions.getQuick(i * 4 + 0);
    }

    public long getPartitionTimestampByTimestamp(long timestamp) {
        int indexRaw = this.findAttachedPartitionRawIndex(timestamp);
        if (indexRaw > -1) {
            return this.attachedPartitions.getQuick(indexRaw + 0);
        }
        return this.getPartitionFloor(timestamp);
    }

    public long getRecordSize() {
        return this.size;
    }

    public long getRowCount() {
        return this.transientRowCount + this.fixedRowCount;
    }

    public long getSeqTxn() {
        return this.seqTxn;
    }

    public int getSymbolColumnCount() {
        return this.symbolColumnCount;
    }

    public int getSymbolValueCount(int i) {
        return this.symbolCountSnapshot.get(i);
    }

    public long getTransientRowCount() {
        return this.transientRowCount;
    }

    public long getTruncateVersion() {
        return this.truncateVersion;
    }

    public long getTxn() {
        return this.txn;
    }

    public long getVersion() {
        return this.version;
    }

    public void initRO(MemoryMR txnFile, int partitionBy) {
        this.roTxMemBase = txnFile;
        this.partitionFloorMethod = PartitionBy.getPartitionFloorMethod(partitionBy);
        this.partitionCeilMethod = PartitionBy.getPartitionCeilMethod(partitionBy);
        this.partitionBy = partitionBy;
    }

    public boolean isLagOrdered() {
        return this.lagOrdered;
    }

    public boolean isPartitionParquet(int i) {
        return this.isPartitionParquetByRawIndex(i * 4);
    }

    public boolean isPartitionParquetByRawIndex(int indexRaw) {
        return this.checkPartitionOptionBit(indexRaw, 61);
    }

    public boolean isPartitionReadOnly(int i) {
        return this.isPartitionReadOnlyByRawIndex(i * 4);
    }

    public boolean isPartitionReadOnlyByPartitionTimestamp(long ts) {
        int indexRaw = this.findAttachedPartitionRawIndexByLoTimestamp(ts);
        if (indexRaw > -1) {
            return this.isPartitionReadOnlyByRawIndex(indexRaw);
        }
        return false;
    }

    public boolean isPartitionReadOnlyByRawIndex(int indexRaw) {
        return this.checkPartitionOptionBit(indexRaw, 62);
    }

    public void loadAllFrom(TxReader srcReader) {
        this.baseOffset = srcReader.baseOffset;
        this.size = srcReader.size;
        this.attachedPartitionsSize = srcReader.attachedPartitionsSize;
        this.partitionBy = srcReader.partitionBy;
        this.partitionFloorMethod = srcReader.partitionFloorMethod;
        this.partitionCeilMethod = srcReader.partitionCeilMethod;
        this.version = srcReader.version;
        this.symbolsSize = srcReader.symbolsSize;
        this.partitionSegmentSize = srcReader.partitionSegmentSize;
        this.txn = srcReader.txn;
        this.transientRowCount = srcReader.transientRowCount;
        this.fixedRowCount = srcReader.fixedRowCount;
        this.minTimestamp = srcReader.minTimestamp;
        this.maxTimestamp = srcReader.maxTimestamp;
        this.structureVersion = srcReader.structureVersion;
        this.dataVersion = srcReader.dataVersion;
        this.partitionTableVersion = srcReader.partitionTableVersion;
        this.columnVersion = srcReader.columnVersion;
        this.truncateVersion = srcReader.truncateVersion;
        this.seqTxn = srcReader.seqTxn;
        this.lagRowCount = srcReader.lagRowCount;
        this.lagMinTimestamp = srcReader.lagMinTimestamp;
        this.lagMaxTimestamp = srcReader.lagMaxTimestamp;
        this.lagOrdered = srcReader.lagOrdered;
        this.lagTxnCount = srcReader.lagTxnCount;
        this.symbolColumnCount = srcReader.symbolColumnCount;
        this.symbolCountSnapshot.clear();
        this.symbolCountSnapshot.addAll(srcReader.symbolCountSnapshot);
        this.attachedPartitions.clear();
        this.attachedPartitions.addAll(srcReader.attachedPartitions);
    }

    public TxReader ofRO(LPSZ path, int partitionBy) {
        this.clear();
        try {
            this.openTxnFile(this.ff, path);
            this.partitionFloorMethod = PartitionBy.getPartitionFloorMethod(partitionBy);
            this.partitionCeilMethod = PartitionBy.getPartitionCeilMethod(partitionBy);
            this.partitionBy = partitionBy;
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
        return this;
    }

    public String toString() {
        StringSink sink = new StringSink();
        sink.put("{");
        sink.put("txn: ").put(this.txn);
        sink.put(", attachedPartitions: [");
        for (int i = 0; i < this.attachedPartitions.size(); i += 4) {
            long timestamp = this.getPartitionTimestampByIndex(i / 4);
            long rowCount = this.attachedPartitions.getQuick(i + 1) & 0x80000FFFFFFFFFFFL;
            if (i / 4 == this.getPartitionCount()) {
                rowCount = this.transientRowCount;
            }
            long nameTxn = this.getPartitionNameTxnByRawIndex(i);
            long parquetSize = this.getPartitionParquetFileSizeByRawIndex(i);
            if (i > 0) {
                sink.put(",");
            }
            sink.put("\n{ts: '");
            TimestampFormatUtils.appendDateTime(sink, timestamp);
            sink.put("', rowCount: ").put(rowCount);
            sink.put(", nameTxn: ").put(nameTxn);
            if (this.isPartitionParquet(i / 4)) {
                sink.put(", parquetSize: ").put(parquetSize);
            }
            if (this.isPartitionReadOnlyByRawIndex(i)) {
                sink.put(", readOnly=true");
            }
            sink.put("}");
        }
        sink.put("\n], transientRowCount: ").put(this.transientRowCount);
        sink.put(", fixedRowCount: ").put(this.fixedRowCount);
        sink.put(", minTimestamp: '");
        TimestampFormatUtils.appendDateTime(sink, this.minTimestamp);
        sink.put("', maxTimestamp: '");
        TimestampFormatUtils.appendDateTime(sink, this.maxTimestamp);
        sink.put("', dataVersion: ").put(this.dataVersion);
        sink.put(", structureVersion: ").put(this.structureVersion);
        sink.put(", partitionTableVersion: ").put(this.partitionTableVersion);
        sink.put(", columnVersion: ").put(this.columnVersion);
        sink.put(", truncateVersion: ").put(this.truncateVersion);
        sink.put(", seqTxn: ").put(this.seqTxn);
        sink.put(", symbolColumnCount: ").put(this.symbolColumnCount);
        sink.put(", lagRowCount: ").put(this.lagRowCount);
        sink.put(", lagMinTimestamp: '");
        TimestampFormatUtils.appendDateTime(sink, this.lagMinTimestamp);
        sink.put("', lagMaxTimestamp: '");
        TimestampFormatUtils.appendDateTime(sink, this.lagMaxTimestamp);
        sink.put("', lagTxnCount: ").put(this.lagTxnCount);
        sink.put(", lagOrdered: ").put(this.lagOrdered);
        sink.put("}");
        return sink.toString();
    }

    public boolean unsafeLoadAll() {
        if (this.unsafeLoadBaseOffset()) {
            this.txn = this.version;
            if (this.txn != this.getLong(0L)) {
                return false;
            }
            this.transientRowCount = this.getLong(8L);
            this.fixedRowCount = this.getLong(16L);
            this.minTimestamp = this.getLong(24L);
            this.maxTimestamp = this.getLong(32L);
            this.dataVersion = this.getLong(48L);
            this.structureVersion = this.getLong(40L);
            long prevPartitionTableVersion = this.partitionTableVersion;
            this.partitionTableVersion = this.getLong(56L);
            long prevColumnVersion = this.columnVersion;
            this.columnVersion = this.unsafeReadColumnVersion();
            this.truncateVersion = this.getLong(72L);
            this.seqTxn = this.getLong(80L);
            this.symbolColumnCount = this.symbolsSize / 8;
            this.lagRowCount = this.getInt(96L);
            this.lagMinTimestamp = this.getLong(100L);
            this.lagMaxTimestamp = this.getLong(108L);
            int lagTxnCountRaw = this.getInt(92L);
            this.lagTxnCount = Math.abs(lagTxnCountRaw);
            this.lagOrdered = lagTxnCountRaw > -1;
            this.unsafeLoadSymbolCounts(this.symbolColumnCount);
            this.unsafeLoadPartitions(prevPartitionTableVersion, prevColumnVersion, this.partitionSegmentSize);
            Unsafe.getUnsafe().loadFence();
            if (this.version == this.unsafeReadVersion()) {
                return true;
            }
        }
        this.clearData();
        return false;
    }

    public boolean unsafeLoadBaseOffset() {
        this.version = this.unsafeReadVersion();
        Unsafe.getUnsafe().loadFence();
        boolean isA = (this.version & 1L) == 0L;
        this.baseOffset = isA ? this.roTxMemBase.getInt(8L) : this.roTxMemBase.getInt(32L);
        this.symbolsSize = isA ? this.roTxMemBase.getInt(12L) : this.roTxMemBase.getInt(36L);
        this.partitionSegmentSize = isA ? this.roTxMemBase.getInt(16L) : this.roTxMemBase.getInt(40L);
        Unsafe.getUnsafe().loadFence();
        if (this.unsafeReadVersion() != this.version) {
            return false;
        }
        this.size = TableUtils.calculateTxRecordSize(this.symbolsSize, this.partitionSegmentSize);
        if (this.size + (long)this.baseOffset > this.roTxMemBase.size()) {
            this.roTxMemBase.extend(this.size + (long)this.baseOffset);
        }
        return true;
    }

    public long unsafeLoadRowCount() {
        if (this.unsafeLoadBaseOffset()) {
            this.txn = this.version;
            if (this.txn != this.getLong(0L)) {
                return -1L;
            }
            long prevPartitionTableVersion = this.partitionTableVersion;
            long prevColumnVersion = this.columnVersion;
            this.unsafeLoadPartitions(prevPartitionTableVersion, prevColumnVersion, this.partitionSegmentSize);
            this.transientRowCount = this.getLong(8L);
            this.fixedRowCount = this.getLong(16L);
            Unsafe.getUnsafe().loadFence();
            if (this.version == this.unsafeReadVersion()) {
                return this.getRowCount();
            }
        }
        this.clearData();
        return -1L;
    }

    public long unsafeReadColumnVersion() {
        return this.getLong(64L);
    }

    public int unsafeReadSymbolColumnCount() {
        return this.getInt(128L);
    }

    public int unsafeReadSymbolCount(int symbolIndex) {
        return this.getInt(TableUtils.getSymbolWriterIndexOffset(symbolIndex));
    }

    public int unsafeReadSymbolTransientCount(int symbolIndex) {
        return this.getInt(TableUtils.getSymbolWriterTransientIndexOffset(symbolIndex));
    }

    public long unsafeReadVersion() {
        return this.roTxMemBase.getLong(0L);
    }

    private boolean checkPartitionOptionBit(int indexRaw, int bitOffset) {
        long maskedSize = this.attachedPartitions.getQuick(indexRaw + 1);
        return (maskedSize >>> bitOffset & 1L) == 1L;
    }

    private int getInt(long readOffset) {
        assert (readOffset + 4L <= this.size) : "offset " + readOffset + ", size " + this.size + ", txn=" + this.txn;
        return this.roTxMemBase.getInt((long)this.baseOffset + readOffset);
    }

    private long getLong(long readOffset) {
        assert (readOffset + 8L <= this.size) : "offset " + readOffset + ", size " + this.size + ", txn=" + this.txn;
        return this.roTxMemBase.getLong((long)this.baseOffset + readOffset);
    }

    private long getPartitionParquetFileSizeByRawIndex(int partitionRawIndex) {
        return this.attachedPartitions.getQuick(partitionRawIndex + 3);
    }

    private void openTxnFile(FilesFacade ff, LPSZ path) {
        if (ff.exists(path)) {
            if (this.roTxMemBase == null) {
                this.roTxMemBase = Vm.getCMRInstance(ff, path, ff.length(path), 0);
            } else {
                this.roTxMemBase.of(ff, path, ff.getPageSize(), ff.length(path), 0);
            }
            return;
        }
        throw CairoException.fileNotFound().put("Cannot open. File does not exist: ").put(path);
    }

    private void unsafeLoadPartitions(long prevPartitionTableVersion, long prevColumnVersion, int partitionTableSize) {
        if (PartitionBy.isPartitioned(this.partitionBy)) {
            int txAttachedPartitionsSize = partitionTableSize / 8;
            if (txAttachedPartitionsSize > 0) {
                if (prevPartitionTableVersion != this.partitionTableVersion || prevColumnVersion != this.columnVersion) {
                    this.attachedPartitions.clear();
                    this.unsafeLoadPartitions0(0, txAttachedPartitionsSize);
                } else if (this.attachedPartitionsSize < txAttachedPartitionsSize) {
                    this.unsafeLoadPartitions0(Math.max(this.attachedPartitionsSize - 4, 0), txAttachedPartitionsSize);
                }
                int offset = txAttachedPartitionsSize - 4 + 1;
                long mask = this.attachedPartitions.getQuick(offset) & 0x7FFFF00000000000L;
                this.attachedPartitions.setQuick(offset, mask | this.transientRowCount & 0x80000FFFFFFFFFFFL);
                this.attachedPartitions.setPos(txAttachedPartitionsSize);
            } else {
                this.attachedPartitionsSize = 0;
                this.attachedPartitions.clear();
            }
        } else {
            this.attachedPartitions.setPos(4);
            this.initPartitionAt(0, 0L, this.transientRowCount, -1L);
        }
    }

    private void unsafeLoadPartitions0(int lo, int hi) {
        this.attachedPartitions.setPos(hi);
        long baseOffset = TableUtils.getPartitionTableSizeOffset(this.symbolColumnCount) + 4L;
        for (int i = lo; i < hi; ++i) {
            this.attachedPartitions.setQuick(i, this.getLong(baseOffset + 8L * (long)i));
        }
        this.attachedPartitionsSize = hi;
    }

    private void unsafeLoadSymbolCounts(int symbolMapCount) {
        this.symbolCountSnapshot.clear();
        for (int i = 0; i < symbolMapCount; ++i) {
            this.symbolCountSnapshot.add(this.getInt(TableUtils.getSymbolWriterIndexOffset(i)));
        }
    }

    static int findPartitionRawIndex(LongList attachedPartitions, long partitionTimestamp) {
        return attachedPartitions.binarySearchBlock(TableUtils.LONGS_PER_TX_ATTACHED_PARTITION_MSB, partitionTimestamp, -1);
    }

    static long getPartitionNameTxnByRawIndex(LongList attachedPartitions, int index) {
        return attachedPartitions.getQuick(index + 2);
    }

    static long getPartitionSizeByRawIndex(LongList attachedPartitions, int index) {
        return attachedPartitions.getQuick(index + 1) & 0x80000FFFFFFFFFFFL;
    }

    void clearData() {
        this.baseOffset = 0;
        this.size = 0L;
        this.partitionTableVersion = -1L;
        this.attachedPartitionsSize = -1;
        this.attachedPartitions.clear();
        this.version = -1L;
        this.txn = -1L;
        this.seqTxn = -1L;
    }

    protected int findAttachedPartitionRawIndex(long ts) {
        int indexRaw = this.findAttachedPartitionRawIndexByLoTimestamp(ts);
        if ((long)indexRaw > -1L) {
            return indexRaw;
        }
        int prevIndexRaw = -indexRaw - 1 - 4;
        if (prevIndexRaw < 0) {
            return -1;
        }
        long prevPartitionTimestamp = this.attachedPartitions.getQuick(prevIndexRaw + 0);
        if (this.getPartitionFloor(prevPartitionTimestamp) == this.getPartitionFloor(ts)) {
            return prevIndexRaw;
        }
        return -1;
    }

    int findAttachedPartitionRawIndexByLoTimestamp(long ts) {
        return this.attachedPartitions.binarySearchBlock(TableUtils.LONGS_PER_TX_ATTACHED_PARTITION_MSB, ts, -1);
    }

    protected void initPartitionAt(int index, long partitionTimestampLo, long partitionSize, long partitionNameTxn) {
        this.attachedPartitions.setQuick(index + 0, partitionTimestampLo);
        this.attachedPartitions.setQuick(index + 1, partitionSize & 0x80000FFFFFFFFFFFL);
        this.attachedPartitions.setQuick(index + 2, partitionNameTxn);
        this.attachedPartitions.setQuick(index + 3, -1L);
    }

    protected void switchRecord(int readBaseOffset, long readRecordSize) {
        this.baseOffset = readBaseOffset;
        this.size = readRecordSize;
    }

    protected long unsafeReadFixedRowCount() {
        return this.getLong(16L);
    }

    protected int unsafeReadSymbolWriterIndexOffset(int denseSymbolIndex) {
        return this.getInt(TableUtils.getSymbolWriterIndexOffset(denseSymbolIndex));
    }
}

