/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.file;

import io.questdb.std.Zip;

public class BlockFileUtils {
    public static final int BLOCK_LENGTH_OFFSET = 0;
    public static final int BLOCK_TYPE_OFFSET = 4;
    public static final int BLOCK_HEADER_SIZE = 8;
    public static final int HEADER_VERSION_OFFSET = 0;
    public static final int HEADER_REGION_A_OFFSET = 8;
    public static final int HEADER_REGION_A_LENGTH = 16;
    public static final int HEADER_REGION_B_OFFSET = 24;
    public static final int HEADER_REGION_B_LENGTH = 32;
    public static final int HEADER_SIZE = 40;
    public static final int REGION_CHECKSUM_OFFSET = 0;
    public static final int REGION_BLOCK_COUNT_OFFSET = 4;
    public static final int REGION_HEADER_SIZE = 8;

    public static int checksum(long checksumAddress, long checksumSize) {
        int checksum = 0;
        while (checksumSize > 0L) {
            int chunkSize = (int)Math.min(Integer.MAX_VALUE, checksumSize);
            checksum = Zip.crc32(checksum, checksumAddress, chunkSize);
            checksumAddress += (long)chunkSize;
            checksumSize -= (long)chunkSize;
        }
        return checksum;
    }

    public static long getRegionLengthOffset(long version) {
        return BlockFileUtils.isRegionA(version) ? 16L : 32L;
    }

    public static long getRegionOffsetOffset(long version) {
        return BlockFileUtils.isRegionA(version) ? 8L : 24L;
    }

    public static boolean isRegionA(long version) {
        return (version & 1L) != 0L;
    }
}

