/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.sql;

import io.questdb.cairo.ColumnType;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.sql.InvalidColumnException;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.Plannable;
import io.questdb.std.str.Utf16Sink;

public interface RecordMetadata
extends ColumnTypes,
Plannable {
    public static final int COLUMN_NOT_FOUND = -1;

    @Override
    public int getColumnCount();

    default public int getColumnIndex(CharSequence columnName) {
        int columnIndex = this.getColumnIndexQuiet(columnName);
        if (columnIndex > -1) {
            return columnIndex;
        }
        throw InvalidColumnException.INSTANCE;
    }

    default public int getColumnIndexQuiet(CharSequence columnName) {
        return this.getColumnIndexQuiet(columnName, 0, columnName.length());
    }

    public int getColumnIndexQuiet(CharSequence var1, int var2, int var3);

    public TableColumnMetadata getColumnMetadata(int var1);

    public String getColumnName(int var1);

    @Override
    public int getColumnType(int var1);

    default public int getColumnType(CharSequence columnName) {
        return this.getColumnType(this.getColumnIndex(columnName));
    }

    public int getIndexValueBlockCapacity(int var1);

    default public int getIndexValueBlockCapacity(CharSequence columnName) {
        return this.getIndexValueBlockCapacity(this.getColumnIndex(columnName));
    }

    default public RecordMetadata getMetadata(int columnIndex) {
        return null;
    }

    public int getTimestampIndex();

    public int getWriterIndex(int var1);

    public boolean hasColumn(int var1);

    public boolean isColumnIndexed(int var1);

    public boolean isDedupKey(int var1);

    default public boolean isSymbolTableStatic(CharSequence columnName) {
        return this.isSymbolTableStatic(this.getColumnIndex(columnName));
    }

    public boolean isSymbolTableStatic(int var1);

    default public boolean isWalEnabled() {
        return false;
    }

    default public void toJson(Utf16Sink sink) {
        sink.put('{');
        ((Utf16Sink)((Utf16Sink)sink.putAsciiQuoted("columnCount")).put(':')).put(this.getColumnCount());
        sink.put(',');
        ((Utf16Sink)sink.putAsciiQuoted("columns")).put(':');
        sink.put('[');
        int n = this.getColumnCount();
        for (int i = 0; i < n; ++i) {
            int type = this.getColumnType(i);
            if (i > 0) {
                sink.putAscii(',');
            }
            sink.put('{');
            ((Utf16Sink)((Utf16Sink)sink.putAsciiQuoted("index")).putAscii(':').put(i)).putAscii(',');
            ((Utf16Sink)((Utf16Sink)sink.putAsciiQuoted("name")).putAscii(':').putQuoted(this.getColumnName(i))).putAscii(',');
            ((Utf16Sink)sink.putAsciiQuoted("type")).putAscii(':').putQuoted(ColumnType.nameOf(type));
            if (this.isColumnIndexed(i)) {
                ((Utf16Sink)sink.putAscii(',').putAsciiQuoted("indexed")).putAscii(":true");
                ((Utf16Sink)sink.putAscii(',').putAsciiQuoted("indexValueBlockCapacity")).putAscii(':').put(this.getIndexValueBlockCapacity(i));
            }
            sink.putAscii('}');
        }
        sink.putAscii(']');
        ((Utf16Sink)sink.putAscii(',').putAsciiQuoted("timestampIndex")).putAscii(':').put(this.getTimestampIndex());
        sink.putAscii('}');
    }

    @Override
    default public void toPlan(PlanSink sink) {
        int n = this.getColumnCount();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                sink.val(',');
            }
            sink.val(this.getColumnName(i));
        }
    }
}

