/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.sql.async;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.async.AdaptiveWorkStealingStrategy;
import io.questdb.cairo.sql.async.AlwaysWorkStealingStrategy;
import io.questdb.cairo.sql.async.WorkStealingStrategy;

public class WorkStealingStrategyFactory {
    private WorkStealingStrategyFactory() {
    }

    public static WorkStealingStrategy getInstance(CairoConfiguration configuration, int workerCount) {
        int noStealingThreshold = configuration.getSqlParallelWorkStealingThreshold();
        if (workerCount >= 4 * noStealingThreshold) {
            return new AdaptiveWorkStealingStrategy(noStealingThreshold);
        }
        return AlwaysWorkStealingStrategy.INSTANCE;
    }
}

