/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.wal;

import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TxReader;
import io.questdb.cairo.wal.seq.SeqTxnTracker;
import io.questdb.cairo.wal.seq.TableSequencerAPI;
import io.questdb.mp.SynchronizedJob;
import io.questdb.std.FilesFacade;
import io.questdb.std.ObjHashSet;
import io.questdb.std.datetime.millitime.MillisecondClock;
import io.questdb.std.str.LPSZ;
import io.questdb.std.str.Path;
import org.jetbrains.annotations.NotNull;

public class CheckWalTransactionsJob
extends SynchronizedJob {
    private final long checkInterval;
    private final TableSequencerAPI.TableSequencerCallback checkNotifyOutstandingTxnInWalRef;
    private final CharSequence dbRoot;
    private final CairoEngine engine;
    private final FilesFacade ff;
    private final MillisecondClock millisecondClock;
    private final long spinLockTimeout;
    private final ObjHashSet<TableToken> tableTokenBucket = new ObjHashSet();
    private final TxReader txReader;
    private long lastProcessedCount = 0L;
    private long lastRunMs;
    private boolean notificationQueueIsFull = false;
    private Path threadLocalPath;

    public CheckWalTransactionsJob(CairoEngine engine) {
        this.engine = engine;
        this.ff = engine.getConfiguration().getFilesFacade();
        this.txReader = new TxReader(engine.getConfiguration().getFilesFacade());
        this.dbRoot = engine.getConfiguration().getDbRoot();
        this.millisecondClock = engine.getConfiguration().getMillisecondClock();
        this.spinLockTimeout = engine.getConfiguration().getSpinLockTimeout();
        this.checkNotifyOutstandingTxnInWalRef = (tableId, token, txn) -> this.checkNotifyOutstandingTxnInWal(token, txn);
        this.checkInterval = engine.getConfiguration().getSequencerCheckInterval();
        this.lastRunMs = this.millisecondClock.getTicks();
    }

    public void checkMissingWalTransactions() {
        this.threadLocalPath = Path.PATH.get().of(this.dbRoot);
        this.engine.getTableSequencerAPI().forAllWalTables(this.tableTokenBucket, true, this.checkNotifyOutstandingTxnInWalRef);
    }

    public void checkNotifyOutstandingTxnInWal(@NotNull TableToken tableToken, long seqTxn) {
        block16: {
            if (this.notificationQueueIsFull) {
                return;
            }
            if (seqTxn < 0L && TableUtils.exists(this.ff, this.threadLocalPath, this.dbRoot, tableToken.getDirName()) == 0) {
                this.notificationQueueIsFull = !this.engine.notifyWalTxnCommitted(tableToken);
            } else if (this.engine.getTableSequencerAPI().isTxnTrackerInitialised(tableToken)) {
                if (this.engine.getTableSequencerAPI().notifyOnCheck(tableToken, seqTxn)) {
                    this.notificationQueueIsFull = !this.engine.notifyWalTxnCommitted(tableToken);
                }
            } else {
                LPSZ txnPath = this.threadLocalPath.trimTo(this.dbRoot.length()).concat(tableToken).concat("_txn").$();
                if (this.ff.exists(txnPath)) {
                    try (TxReader txReader = this.txReader.ofRO(txnPath, 3);){
                        TableUtils.safeReadTxn(this.txReader, this.millisecondClock, this.spinLockTimeout);
                        if (this.engine.getTableSequencerAPI().initTxnTracker(tableToken, txReader.getSeqTxn(), seqTxn)) {
                            this.notificationQueueIsFull = !this.engine.notifyWalTxnCommitted(tableToken);
                        }
                    }
                    catch (CairoException e) {
                        if (e.errnoFileCannotRead()) break block16;
                        throw e;
                    }
                }
            }
        }
    }

    @Override
    public boolean runSerially() {
        long unpublishedWalTxnCount = this.engine.getUnpublishedWalTxnCount();
        if (unpublishedWalTxnCount == this.lastProcessedCount || this.notificationQueueIsFull) {
            long t = this.millisecondClock.getTicks();
            if (this.lastRunMs + this.checkInterval < t) {
                this.lastRunMs = t;
                this.notificationQueueIsFull = !this.republishNotificationsFromTrackers();
            }
            return false;
        }
        this.checkMissingWalTransactions();
        this.lastProcessedCount = unpublishedWalTxnCount;
        return !this.notificationQueueIsFull;
    }

    private boolean republishNotificationsFromTrackers() {
        this.engine.getTableTokens(this.tableTokenBucket, false);
        int n = this.tableTokenBucket.size();
        for (int i = 0; i < n; ++i) {
            TableToken tableToken = this.tableTokenBucket.get(i);
            SeqTxnTracker tracker = this.engine.getTableSequencerAPI().getTxnTracker(tableToken);
            if (tracker.isSuspended() || tracker.getWriterTxn() >= tracker.getSeqTxn() || this.engine.notifyWalTxnCommitted(tableToken)) continue;
            return false;
        }
        return true;
    }
}

