/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.wal;

public interface TableWriterPressureControl {
    public static final TableWriterPressureControl EMPTY = new NoPressureControl();

    public long getMaxBlockRowCount();

    public void updateInflightPartitions(int var1);

    public int getMemoryPressureLevel();

    public int getMemoryPressureRegulationValue();

    public boolean isReadyToProcess();

    public boolean onEnoughMemory();

    public void onOutOfMemory();

    public void setMaxBlockRowCount(int var1);

    public void updateInflightTxnBlockLength(long var1, long var3);

    public void onBlockApplyError();

    public static class NoPressureControl
    implements TableWriterPressureControl {
        @Override
        public long getMaxBlockRowCount() {
            return Integer.MAX_VALUE;
        }

        @Override
        public int getMemoryPressureLevel() {
            return 0;
        }

        @Override
        public int getMemoryPressureRegulationValue() {
            return Integer.MAX_VALUE;
        }

        @Override
        public boolean isReadyToProcess() {
            return true;
        }

        @Override
        public boolean onEnoughMemory() {
            return true;
        }

        @Override
        public void onOutOfMemory() {
        }

        @Override
        public void setMaxBlockRowCount(int count) {
        }

        @Override
        public void updateInflightPartitions(int count) {
        }

        @Override
        public void updateInflightTxnBlockLength(long txnCount, long rowCount) {
        }

        @Override
        public void onBlockApplyError() {
        }
    }
}

