/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.wal;

import io.questdb.cairo.AbstractRecordMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.TableRecordMetadata;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryMARW;
import io.questdb.cairo.vm.api.MemoryMR;
import io.questdb.cairo.wal.seq.TableRecordMetadataSink;
import io.questdb.std.FilesFacade;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.str.Path;

public class WalWriterMetadata
extends AbstractRecordMetadata
implements TableRecordMetadata,
TableRecordMetadataSink {
    private final FilesFacade ff;
    private final MemoryMARW metaMem;
    private final MemoryMR roMetaMem;
    private long structureVersion = -1L;
    private boolean suspended;
    private int tableId;
    private TableToken tableToken;

    public WalWriterMetadata(FilesFacade ff) {
        this(ff, false);
    }

    public WalWriterMetadata(FilesFacade ff, boolean readonly) {
        this.ff = ff;
        if (!readonly) {
            this.metaMem = Vm.getCMARWInstance();
            this.roMetaMem = this.metaMem;
        } else {
            this.metaMem = null;
            this.roMetaMem = Vm.getCMRInstance();
        }
    }

    public static void syncToMetaFile(MemoryMARW metaMem, long structureVersion, int columnCount, int timestampIndex, int tableId, boolean suspended, RecordMetadata metadata) {
        boolean firstWrite = metaMem.getAppendOffset() == 0L;
        metaMem.jumpTo(0L);
        if (firstWrite) {
            metaMem.putInt(0);
        } else {
            metaMem.skip(4L);
        }
        metaMem.putInt(0);
        metaMem.putLong(structureVersion);
        long columnCountOffset = metaMem.getAppendOffset();
        if (firstWrite) {
            metaMem.putInt(0);
        } else {
            metaMem.skip(4L);
        }
        metaMem.putInt(timestampIndex);
        metaMem.putInt(tableId);
        metaMem.putBool(suspended);
        for (int i = 0; i < columnCount; ++i) {
            int columnType = metadata.getColumnType(i);
            metaMem.putInt(columnType);
            metaMem.putStr(metadata.getColumnName(i));
        }
        long size = metaMem.getAppendOffset();
        metaMem.putInt(0L, (int)size);
        metaMem.putInt(columnCountOffset, columnCount);
    }

    @Override
    public void addColumn(String columnName, int columnType, boolean columnIndexed, int indexValueBlockCapacity, boolean symbolTableStatic, int writerIndex, boolean isDedupKey, boolean symbolIsCached, int symbolCapacity) {
        this.addColumn0(columnName, columnType, symbolCapacity, symbolIsCached, isDedupKey);
    }

    public void addColumn(CharSequence columnName, int columnType, boolean isDedupKey, boolean symbolIsCached, int symbolCapacity) {
        this.addColumn0(columnName, columnType, symbolCapacity, symbolIsCached, isDedupKey);
        ++this.structureVersion;
    }

    public void changeColumnType(CharSequence columnName, int columnType, int symbolCapacity, boolean symbolCacheFlag, boolean isIndexed, int indexValueBlockCapacity) {
        TableUtils.changeColumnTypeInMetadata(columnName, columnType, symbolCapacity, symbolCacheFlag, isIndexed, indexValueBlockCapacity, this.columnNameIndexMap, this.columnMetadata);
        ++this.columnCount;
        ++this.structureVersion;
    }

    @Override
    public void close() {
        this.clear(true, (byte)0);
    }

    public void close(boolean truncate, byte truncateMode) {
        this.clear(truncate, truncateMode);
    }

    public void disableDeduplicate() {
        ++this.structureVersion;
    }

    public boolean enableDeduplicationWithUpsertKeys() {
        boolean isSubsetOfOldKeys = true;
        for (int columnIndex = 0; columnIndex < this.columnCount; ++columnIndex) {
            isSubsetOfOldKeys &= this.isDedupKey(columnIndex);
        }
        ++this.structureVersion;
        return isSubsetOfOldKeys;
    }

    @Override
    public long getMetadataVersion() {
        return this.structureVersion;
    }

    @Override
    public int getTableId() {
        return this.tableId;
    }

    @Override
    public TableToken getTableToken() {
        return this.tableToken;
    }

    @Override
    public boolean isWalEnabled() {
        return true;
    }

    @Override
    public void of(TableToken tableToken, int tableId, int timestampIndex, int compressedTimestampIndex, boolean suspended, long structureVersion, int columnCount, IntList readColumnOrder) {
        this.tableToken = tableToken;
        this.tableId = tableId;
        this.timestampIndex = timestampIndex;
        this.suspended = suspended;
        this.structureVersion = structureVersion;
    }

    public void removeColumn(CharSequence columnName) {
        TableUtils.removeColumnFromMetadata(columnName, this.columnNameIndexMap, this.columnMetadata);
        ++this.structureVersion;
    }

    public void renameColumn(CharSequence columnName, CharSequence newName) {
        TableUtils.renameColumnInMetadata(columnName, newName, this.columnNameIndexMap, this.columnMetadata);
        ++this.structureVersion;
    }

    public void renameTable(TableToken toTableToken) {
        assert (toTableToken != null);
        this.tableToken = toTableToken;
        ++this.structureVersion;
    }

    public void switchTo(Path path, int pathLen, boolean truncate) {
        if (this.metaMem.getFd() > -1L) {
            this.metaMem.close(truncate, (byte)1);
        }
        TableUtils.openSmallFile(this.ff, path, pathLen, this.metaMem, "_meta", 8);
        WalWriterMetadata.syncToMetaFile(this.metaMem, this.structureVersion, this.columnCount, this.timestampIndex, this.tableId, this.suspended, this);
    }

    private void addColumn0(CharSequence columnName, int columnType, int symbolCapacity, boolean symbolCacheFlag, boolean isDedupKey) {
        String name = columnName.toString();
        if (columnType > 0) {
            this.columnNameIndexMap.put(name, this.columnMetadata.size());
        }
        this.columnMetadata.add(new TableColumnMetadata(name, columnType, false, 0, false, null, this.columnMetadata.size(), isDedupKey, 0, symbolCacheFlag, symbolCapacity));
        ++this.columnCount;
    }

    private void reset() {
        this.columnMetadata.clear();
        this.columnNameIndexMap.clear();
        this.columnCount = 0;
        this.timestampIndex = -1;
        this.tableToken = null;
        this.tableId = -1;
        this.suspended = false;
    }

    protected void clear(boolean truncate, byte truncateMode) {
        this.reset();
        if (this.metaMem != null) {
            this.metaMem.close(truncate, truncateMode);
        }
        Misc.free(this.roMetaMem);
    }
}

