/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http.processors;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.DataUnavailableException;
import io.questdb.cairo.EntryUnavailableException;
import io.questdb.cairo.GeoHashes;
import io.questdb.cairo.arr.ArrayTypeDriver;
import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.sql.OperationFuture;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cutlass.http.HttpChunkedResponse;
import io.questdb.cutlass.http.HttpConnectionContext;
import io.questdb.cutlass.http.HttpConstants;
import io.questdb.cutlass.http.HttpKeywords;
import io.questdb.cutlass.http.HttpRequestHeader;
import io.questdb.cutlass.http.HttpResponseArrayWriteState;
import io.questdb.cutlass.http.processors.JsonQueryProcessor;
import io.questdb.cutlass.text.Utf8Exception;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContextImpl;
import io.questdb.griffin.engine.ops.Operation;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.log.LogRecord;
import io.questdb.mp.SCSequence;
import io.questdb.network.NoSpaceLeftInResponseBufferException;
import io.questdb.network.PeerDisconnectedException;
import io.questdb.network.PeerIsSlowToReadException;
import io.questdb.std.IntList;
import io.questdb.std.Interval;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.NanosecondClock;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.Rnd;
import io.questdb.std.Unsafe;
import io.questdb.std.Uuid;
import io.questdb.std.str.DirectUtf8Sequence;
import io.questdb.std.str.StringSink;
import io.questdb.std.str.Utf16Sink;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8Sink;
import io.questdb.std.str.Utf8s;
import java.io.Closeable;
import org.jetbrains.annotations.Nullable;

public class JsonQueryProcessorState
implements Mutable,
Closeable {
    public static final String HIDDEN = "hidden";
    static final int QUERY_METADATA = 2;
    static final int QUERY_METADATA_SUFFIX = 3;
    static final int QUERY_PREFIX = 1;
    static final int QUERY_RECORD = 5;
    static final int QUERY_RECORD_PREFIX = 9;
    static final int QUERY_RECORD_START = 4;
    static final int QUERY_RECORD_SUFFIX = 6;
    static final int QUERY_SEND_RECORDS_LOOP = 8;
    static final int QUERY_SETUP_FIRST_RECORD = 0;
    static final int QUERY_SUFFIX = 7;
    private static final byte DEFAULT_API_VERSION = 1;
    private static final Log LOG = LogFactory.getLog(JsonQueryProcessorState.class);
    private final HttpResponseArrayWriteState arrayState = new HttpResponseArrayWriteState();
    private final ObjList<String> columnNames = new ObjList();
    private final IntList columnSkewList = new IntList();
    private final IntList columnTypesAndFlags = new IntList();
    private final RecordCursor.Counter counter = new RecordCursor.Counter();
    private final SCSequence eventSubSequence = new SCSequence();
    private final HttpConnectionContext httpConnectionContext;
    private final CharSequence keepAliveHeader;
    private final NanosecondClock nanosecondClock;
    private final StringSink query = new StringSink();
    private final ObjList<StateResumeAction> resumeActions = new ObjList();
    private final StringSink sink = new StringSink();
    private final long statementTimeout;
    private byte apiVersion = 1;
    private SqlExecutionCircuitBreaker circuitBreaker;
    private int columnCount;
    private int columnIndex;
    private boolean columnValueFullySent;
    private long compilerNanos;
    private boolean containsSecret;
    private long count;
    private boolean countRows = false;
    private RecordCursor cursor;
    private boolean cursorHasRows;
    private long executeStartNanos;
    private boolean explain = false;
    private boolean noMeta = false;
    private Operation operation;
    private OperationFuture operationFuture;
    private boolean pausedQuery = false;
    private boolean queryCacheable = false;
    private boolean queryJitCompiled = false;
    private int queryState = 0;
    private int queryTimestampIndex;
    private short queryType;
    private boolean quoteLargeNum = false;
    private Record record;
    private long recordCountNanos;
    private RecordCursorFactory recordCursorFactory;
    private Rnd rnd;
    private long skip;
    private long stop;
    private boolean timings = false;

    public JsonQueryProcessorState(HttpConnectionContext httpConnectionContext, NanosecondClock nanosecondClock, CharSequence keepAliveHeader) {
        this.httpConnectionContext = httpConnectionContext;
        this.resumeActions.extendAndSet(0, this::onSetupFirstRecord);
        this.resumeActions.extendAndSet(1, this::onQueryPrefix);
        this.resumeActions.extendAndSet(2, this::onQueryMetadata);
        this.resumeActions.extendAndSet(3, this::onQueryMetadataSuffix);
        this.resumeActions.extendAndSet(8, this::onSendRecordsLoop);
        this.resumeActions.extendAndSet(9, this::onQueryRecordPrefix);
        this.resumeActions.extendAndSet(5, this::onQueryRecord);
        this.resumeActions.extendAndSet(6, this::onQueryRecordSuffix);
        this.resumeActions.extendAndSet(7, this::doQuerySuffix);
        this.nanosecondClock = nanosecondClock;
        this.statementTimeout = httpConnectionContext.getRequestHeader().getStatementTimeout();
        this.keepAliveHeader = keepAliveHeader;
    }

    @Override
    public void clear() {
        this.apiVersion = 1;
        this.columnCount = 0;
        this.columnSkewList.clear();
        this.columnTypesAndFlags.clear();
        this.columnNames.clear();
        this.queryTimestampIndex = -1;
        this.cursor = Misc.free(this.cursor);
        this.circuitBreaker = null;
        this.record = null;
        if (this.recordCursorFactory != null) {
            if (this.queryCacheable) {
                this.httpConnectionContext.getSelectCache().put(this.query, this.recordCursorFactory);
            } else {
                this.recordCursorFactory.close();
            }
            this.recordCursorFactory = null;
        }
        this.query.clear();
        this.sink.clear();
        this.queryState = 0;
        this.columnIndex = 0;
        this.columnValueFullySent = true;
        this.arrayState.clear();
        this.countRows = false;
        this.explain = false;
        this.noMeta = false;
        this.timings = false;
        this.pausedQuery = false;
        this.quoteLargeNum = false;
        this.queryJitCompiled = false;
        this.operationFuture = Misc.free(this.operationFuture);
        this.skip = 0L;
        this.count = 0L;
        this.counter.clear();
        this.stop = 0L;
        this.containsSecret = false;
    }

    public void clearFactory() {
        this.columnSkewList.clear();
        this.columnTypesAndFlags.clear();
        this.recordCursorFactory = Misc.free(this.recordCursorFactory);
    }

    @Override
    public void close() {
        this.cursor = Misc.free(this.cursor);
        this.clearFactory();
        this.circuitBreaker = null;
        this.freeAsyncOperation();
    }

    public void configure(HttpRequestHeader request, DirectUtf8Sequence query, long skip, long stop) throws Utf8Exception {
        this.query.clear();
        if (query != null && !Utf8s.utf8ToUtf16(query.lo(), query.hi(), this.query)) {
            throw Utf8Exception.INSTANCE;
        }
        this.skip = skip;
        this.stop = stop;
        this.count = 0L;
        this.counter.clear();
        this.noMeta = HttpKeywords.isTrue(request.getUrlParam(HttpConstants.URL_PARAM_NM));
        this.countRows = HttpKeywords.isTrue(request.getUrlParam(HttpConstants.URL_PARAM_COUNT));
        this.timings = HttpKeywords.isTrue(request.getUrlParam(HttpConstants.URL_PARAM_TIMINGS));
        this.explain = HttpKeywords.isTrue(request.getUrlParam(HttpConstants.URL_PARAM_EXPLAIN));
        this.quoteLargeNum = HttpKeywords.isTrue(request.getUrlParam(HttpConstants.URL_PARAM_QUOTE_LARGE_NUM)) || HttpKeywords.isCon(request.getUrlParam(HttpConstants.URL_PARAM_SRC));
        this.apiVersion = JsonQueryProcessorState.parseApiVersion(request);
    }

    public LogRecord critical() {
        return LOG.critical().$('[').$(this.getFd()).$("] ");
    }

    public LogRecord error() {
        return LOG.error().$('[').$(this.getFd()).$("] ");
    }

    public void freeAsyncOperation() {
        this.operationFuture = Misc.free(this.operationFuture);
        this.operation = Misc.free(this.operation);
    }

    public byte getApiVersion() {
        return this.apiVersion;
    }

    public int getCurrentColumnIndex() {
        return this.columnIndex;
    }

    public String getCurrentColumnName() {
        if (this.columnIndex > -1 && this.columnIndex < this.columnNames.size()) {
            return this.columnNames.getQuick(this.columnIndex);
        }
        return "undefined";
    }

    public SCSequence getEventSubSequence() {
        return this.eventSubSequence;
    }

    public long getExecutionTimeNanos() {
        return this.nanosecondClock.getTicks() - this.executeStartNanos;
    }

    public HttpConnectionContext getHttpConnectionContext() {
        return this.httpConnectionContext;
    }

    public OperationFuture getOperationFuture() {
        return this.operationFuture;
    }

    public CharSequence getQuery() {
        return this.query;
    }

    public CharSequence getQueryOrHidden() {
        return this.containsSecret ? HIDDEN : this.query;
    }

    public short getQueryType() {
        return this.queryType;
    }

    public Rnd getRnd() {
        return this.rnd;
    }

    public long getStatementTimeout() {
        return this.statementTimeout;
    }

    public LogRecord info() {
        return LOG.info().$('[').$(this.getFd()).$("] ");
    }

    public boolean isPausedQuery() {
        return this.pausedQuery;
    }

    public void logBufferTooSmall() {
        this.info().$("response buffer is too small, state=").$(this.queryState).$();
    }

    public void logTimings() {
        this.info().$("timings ").$("[compiler: ").$(this.compilerNanos).$(", count: ").$(this.recordCountNanos).$(", execute: ").$(this.nanosecondClock.getTicks() - this.executeStartNanos).$(", q=`").$safe(this.getQueryOrHidden()).$("`]").$();
    }

    public void setCompilerNanos(long compilerNanos) {
        this.compilerNanos = compilerNanos;
    }

    public void setContainsSecret(boolean containsSecret) {
        this.containsSecret = containsSecret;
    }

    public void setCursor(RecordCursor cursor) {
        this.cursor = cursor;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    public void setOperationFuture(OperationFuture fut) {
        this.operationFuture = fut;
    }

    public void setPausedQuery(boolean pausedQuery) {
        this.pausedQuery = pausedQuery;
    }

    public void setQueryType(short type) {
        this.queryType = type;
    }

    public void setRnd(Rnd rnd) {
        this.rnd = rnd;
    }

    public void startExecutionTimer() {
        this.executeStartNanos = this.nanosecondClock.getTicks();
    }

    private static byte parseApiVersion(HttpRequestHeader header) {
        DirectUtf8Sequence versionStr = header.getUrlParam(HttpConstants.URL_PARAM_VERSION);
        if (versionStr == null) {
            return 1;
        }
        try {
            return (byte)Numbers.parseInt(versionStr);
        }
        catch (NumericException e) {
            return 1;
        }
    }

    private static void putBooleanValue(HttpChunkedResponse response, Record rec, int col) {
        response.put(rec.getBool(col));
    }

    private static void putByteValue(HttpChunkedResponse response, Record rec, int col) {
        response.put((int)rec.getByte(col));
    }

    private static void putCharValue(HttpChunkedResponse response, Record rec, int col) {
        char c = rec.getChar(col);
        if (c == '\u0000') {
            response.putAscii("\"\"");
        } else {
            response.putAscii('\"').put(c).putAscii('\"');
        }
    }

    private static void putDateValue(HttpChunkedResponse response, Record rec, int col) {
        long d = rec.getDate(col);
        if (d == Long.MIN_VALUE) {
            response.putAscii("null");
            return;
        }
        ((Utf8Sink)response.putAscii('\"').putISODateMillis(d)).putAscii('\"');
    }

    private static void putGeoHashStringByteValue(HttpChunkedResponse response, Record rec, int col, int bitFlags) {
        byte l = rec.getGeoByte(col);
        GeoHashes.append(l, bitFlags, response);
    }

    private static void putGeoHashStringIntValue(HttpChunkedResponse response, Record rec, int col, int bitFlags) {
        int l = rec.getGeoInt(col);
        GeoHashes.append(l, bitFlags, response);
    }

    private static void putGeoHashStringLongValue(HttpChunkedResponse response, Record rec, int col, int bitFlags) {
        long l = rec.getGeoLong(col);
        GeoHashes.append(l, bitFlags, response);
    }

    private static void putGeoHashStringShortValue(HttpChunkedResponse response, Record rec, int col, int bitFlags) {
        short l = rec.getGeoShort(col);
        GeoHashes.append(l, bitFlags, response);
    }

    private static void putIPv4Value(HttpChunkedResponse response, Record rec, int col) {
        int i = rec.getIPv4(col);
        if (i == 0) {
            response.putAscii("null");
        } else {
            response.putAscii('\"');
            Numbers.intToIPv4Sink(response, i);
            response.putAscii('\"');
        }
    }

    private static void putIntValue(HttpChunkedResponse response, Record rec, int col) {
        int i = rec.getInt(col);
        if (i == Integer.MIN_VALUE) {
            response.putAscii("null");
        } else {
            response.put(i);
        }
    }

    private static void putIntervalValue(HttpChunkedResponse response, Record rec, int col) {
        Interval interval = rec.getInterval(col);
        if (Interval.NULL.equals(interval)) {
            response.putAscii("null");
            return;
        }
        ((Utf8Sink)response.putAscii('\"').put(interval)).putAscii('\"');
    }

    private static void putLong256Value(HttpChunkedResponse response, Record rec, int col) {
        response.putAscii('\"');
        rec.getLong256(col, response);
        response.putAscii('\"');
    }

    private static void putLongValue(HttpChunkedResponse response, Record rec, int col, boolean quoteLargeNum) {
        long l = rec.getLong(col);
        if (l == Long.MIN_VALUE) {
            response.putAscii("null");
        } else if (quoteLargeNum) {
            ((Utf8Sink)response.putAscii('\"').put(l)).putAscii('\"');
        } else {
            response.put(l);
        }
    }

    private static void putRecValue(HttpChunkedResponse response) {
        JsonQueryProcessorState.putStringOrNull(response, null);
    }

    private static void putShortValue(HttpChunkedResponse response, Record rec, int col) {
        response.put(rec.getShort(col));
    }

    private static void putStrValue(HttpChunkedResponse response, Record rec, int col) {
        JsonQueryProcessorState.putStringOrNull(response, rec.getStrA(col));
    }

    private static void putStringOrNull(HttpChunkedResponse response, CharSequence str) {
        if (str == null) {
            response.putAscii("null");
        } else {
            response.putQuote().escapeJsonStr(str).putQuote();
        }
    }

    private static void putSymValue(HttpChunkedResponse response, Record rec, int col) {
        JsonQueryProcessorState.putStringOrNull(response, rec.getSymA(col));
    }

    private static void putTimestampValue(HttpChunkedResponse response, Record rec, int col) {
        long t = rec.getTimestamp(col);
        if (t == Long.MIN_VALUE) {
            response.putAscii("null");
            return;
        }
        ((Utf8Sink)response.putAscii('\"').putISODate(t)).putAscii('\"');
    }

    private static void putUuidValue(HttpChunkedResponse response, Record rec, int col) {
        long hi;
        long lo = rec.getLong128Lo(col);
        if (Uuid.isNull(lo, hi = rec.getLong128Hi(col))) {
            response.putAscii("null");
            return;
        }
        response.putAscii('\"');
        Numbers.appendUuid(lo, hi, response);
        response.putAscii('\"');
    }

    private void addColumnTypeAndName(RecordMetadata metadata, int i) {
        int columnType = metadata.getColumnType(i);
        String columnName = metadata.getColumnName(i);
        switch (ColumnType.tagOf(columnType)) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 32: 
            case 33: {
                break;
            }
            default: {
                throw CairoException.nonCritical().put("column type not supported [column=").put(columnName).put(", type=").put(ColumnType.nameOf(columnType)).put(']');
            }
        }
        int flags = GeoHashes.getBitFlags(columnType);
        this.columnTypesAndFlags.add(columnType);
        this.columnTypesAndFlags.add(flags);
        this.columnNames.add(columnName);
    }

    private boolean addSunkColumnToOutput(RecordMetadata metadata) throws PeerDisconnectedException, PeerIsSlowToReadException {
        int columnIndex = metadata.getColumnIndexQuiet(this.sink);
        if (columnIndex == -1) {
            this.info().$("column not found: '").$safe(this.sink).$('\'').$();
            HttpChunkedResponse response = this.getHttpConnectionContext().getChunkedResponse();
            JsonQueryProcessor.header(response, this.getHttpConnectionContext(), "", 400);
            ((Utf8Sink)((Utf8Sink)response.putAscii('{').putAsciiQuoted("query")).putAscii(':').putQuote().escapeJsonStr(this.query).putQuote().putAscii(',').putAsciiQuoted("error")).putAscii(':').putAscii('\"').putAscii("column not found: '").escapeJsonStr(this.sink).putAscii("'\"").putAscii('}');
            response.sendChunk(true);
            return true;
        }
        this.addColumnTypeAndName(metadata, columnIndex);
        this.columnSkewList.add(columnIndex);
        return false;
    }

    private void doNextRecordLoop(HttpChunkedResponse response, int columnCount) throws PeerDisconnectedException, PeerIsSlowToReadException {
        if (this.doQueryNextRecord()) {
            this.doRecordFetchLoop(response, columnCount);
        } else {
            this.doQuerySuffix(response, columnCount);
        }
    }

    private void doQueryMetadata(HttpChunkedResponse response, int columnCount) {
        this.queryState = 2;
        while (this.columnIndex < columnCount) {
            response.bookmark();
            if (this.columnIndex > 0) {
                response.putAscii(',');
            }
            int columnType = this.columnTypesAndFlags.getQuick(2 * this.columnIndex);
            ((Utf8Sink)response.putAscii('{').putAsciiQuoted("name")).putAscii(':').putQuote().escapeJsonStr(this.columnNames.getQuick(this.columnIndex)).putQuote().putAscii(',');
            if (ColumnType.tagOf(columnType) == 27) {
                ((Utf8Sink)((Utf8Sink)response.putAsciiQuoted("type")).putAscii(':').putAsciiQuoted("ARRAY")).put(',');
                ((Utf8Sink)((Utf8Sink)response.putAsciiQuoted("dim")).putAscii(':').put(ColumnType.decodeArrayDimensionality(columnType))).put(',');
                ((Utf8Sink)response.putAsciiQuoted("elemType")).putAscii(':').putAsciiQuoted(ColumnType.nameOf(ColumnType.decodeArrayElementType(columnType)));
            } else {
                ((Utf8Sink)response.putAsciiQuoted("type")).putAscii(':').putAsciiQuoted(ColumnType.nameOf(columnType == 33 ? 11 : columnType));
            }
            response.putAscii('}');
            ++this.columnIndex;
        }
    }

    private void doQueryMetadataSuffix(HttpChunkedResponse response) {
        this.queryState = 3;
        response.bookmark();
        response.putAscii("],\"timestamp\":").put(this.queryTimestampIndex);
        response.putAscii(",\"dataset\":[");
    }

    private boolean doQueryNextRecord() {
        if (this.cursor.hasNext()) {
            if (this.count < this.stop) {
                return true;
            }
            this.onNoMoreData();
        }
        return false;
    }

    private boolean doQueryPrefix(HttpChunkedResponse response) {
        if (this.noMeta) {
            response.bookmark();
            ((Utf8Sink)response.putAscii('{').putAsciiQuoted("dataset")).putAscii(":[");
            return false;
        }
        response.bookmark();
        ((Utf8Sink)((Utf8Sink)response.putAscii('{').putAsciiQuoted("query")).putAscii(':').putQuote().escapeJsonStr(this.query).putQuote().putAscii(',').putAsciiQuoted("columns")).putAscii(':').putAscii('[');
        this.columnIndex = 0;
        this.columnValueFullySent = true;
        return true;
    }

    private void doQueryRecord(HttpChunkedResponse response, int columnCount) {
        this.queryState = 5;
        while (this.columnIndex < columnCount) {
            response.bookmark();
            if (this.columnIndex > 0 && this.columnValueFullySent) {
                response.putAscii(',');
            }
            int columnIdx = this.columnSkewList.size() > 0 ? this.columnSkewList.getQuick(this.columnIndex) : this.columnIndex;
            int columnType = this.columnTypesAndFlags.getQuick(2 * this.columnIndex);
            switch (ColumnType.tagOf(columnType)) {
                case 1: {
                    JsonQueryProcessorState.putBooleanValue(response, this.record, columnIdx);
                    break;
                }
                case 2: {
                    JsonQueryProcessorState.putByteValue(response, this.record, columnIdx);
                    break;
                }
                case 10: {
                    this.putDoubleValue(response, this.record, columnIdx);
                    break;
                }
                case 9: {
                    this.putFloatValue(response, this.record, columnIdx);
                    break;
                }
                case 5: {
                    JsonQueryProcessorState.putIntValue(response, this.record, columnIdx);
                    break;
                }
                case 6: {
                    JsonQueryProcessorState.putLongValue(response, this.record, columnIdx, this.quoteLargeNum);
                    break;
                }
                case 7: {
                    JsonQueryProcessorState.putDateValue(response, this.record, columnIdx);
                    break;
                }
                case 8: {
                    JsonQueryProcessorState.putTimestampValue(response, this.record, columnIdx);
                    break;
                }
                case 3: {
                    JsonQueryProcessorState.putShortValue(response, this.record, columnIdx);
                    break;
                }
                case 4: {
                    JsonQueryProcessorState.putCharValue(response, this.record, columnIdx);
                    break;
                }
                case 11: {
                    JsonQueryProcessorState.putStrValue(response, this.record, columnIdx);
                    break;
                }
                case 26: {
                    this.putVarcharValue(response, columnIdx);
                    break;
                }
                case 12: {
                    JsonQueryProcessorState.putSymValue(response, this.record, columnIdx);
                    break;
                }
                case 18: {
                    this.putBinValue(response);
                    break;
                }
                case 13: {
                    JsonQueryProcessorState.putLong256Value(response, this.record, columnIdx);
                    break;
                }
                case 14: {
                    JsonQueryProcessorState.putGeoHashStringByteValue(response, this.record, columnIdx, this.columnTypesAndFlags.getQuick(2 * this.columnIndex + 1));
                    break;
                }
                case 15: {
                    JsonQueryProcessorState.putGeoHashStringShortValue(response, this.record, columnIdx, this.columnTypesAndFlags.getQuick(2 * this.columnIndex + 1));
                    break;
                }
                case 16: {
                    JsonQueryProcessorState.putGeoHashStringIntValue(response, this.record, columnIdx, this.columnTypesAndFlags.getQuick(2 * this.columnIndex + 1));
                    break;
                }
                case 17: {
                    JsonQueryProcessorState.putGeoHashStringLongValue(response, this.record, columnIdx, this.columnTypesAndFlags.getQuick(2 * this.columnIndex + 1));
                    break;
                }
                case 22: {
                    JsonQueryProcessorState.putRecValue(response);
                    break;
                }
                case 33: {
                    response.putAscii("null");
                    break;
                }
                case 19: {
                    JsonQueryProcessorState.putUuidValue(response, this.record, columnIdx);
                    break;
                }
                case 25: {
                    JsonQueryProcessorState.putIPv4Value(response, this.record, columnIdx);
                    break;
                }
                case 32: {
                    JsonQueryProcessorState.putIntervalValue(response, this.record, columnIdx);
                    break;
                }
                case 27: {
                    this.putArrayValue(response, columnIdx, columnType);
                    break;
                }
                default: {
                    throw CairoException.nonCritical().put("column type not supported [type=").put(ColumnType.nameOf(columnType)).put(']');
                }
            }
            ++this.columnIndex;
        }
    }

    private void doQueryRecordPrefix(HttpChunkedResponse response) {
        this.queryState = 9;
        response.bookmark();
        if (this.count > this.skip) {
            response.putAscii(',');
        }
        response.putAscii('[');
        this.columnIndex = 0;
        ++this.count;
        this.counter.inc();
    }

    private void doQueryRecordSuffix(HttpChunkedResponse response) {
        this.queryState = 6;
        response.bookmark();
        response.putAscii(']');
    }

    private void doQuerySuffix(HttpChunkedResponse response, int columnCount) throws PeerDisconnectedException, PeerIsSlowToReadException {
        this.querySuffixWithError(response, 0, null, 0);
    }

    private void doRecordFetchLoop(HttpChunkedResponse response, int columnCount) throws PeerDisconnectedException, PeerIsSlowToReadException {
        try {
            do {
                this.doQueryRecordPrefix(response);
                this.doQueryRecord(response, columnCount);
                this.doQueryRecordSuffix(response);
            } while (this.doQueryNextRecord());
        }
        catch (DataUnavailableException | EntryUnavailableException | NoSpaceLeftInResponseBufferException e) {
            throw e;
        }
        catch (Throwable e) {
            response.resetToBookmark();
            throw e;
        }
        this.doQuerySuffix(response, columnCount);
    }

    private long getFd() {
        return this.httpConnectionContext.getFd();
    }

    private void onNoMoreData() {
        long nanos = this.nanosecondClock.getTicks();
        if (this.countRows) {
            RecordCursor cursor = this.cursor;
            long size = cursor.size();
            this.counter.clear();
            if (size < 0L) {
                try {
                    cursor.calculateSize(this.circuitBreaker, this.counter);
                    this.count += this.counter.get() + 1L;
                }
                catch (DataUnavailableException e) {
                    this.count += this.counter.get();
                    throw e;
                }
            } else {
                this.count = size;
            }
        }
        this.recordCountNanos = this.nanosecondClock.getTicks() - nanos;
    }

    private void onQueryMetadata(HttpChunkedResponse response, int columnCount) throws PeerDisconnectedException, PeerIsSlowToReadException {
        this.doQueryMetadata(response, columnCount);
        this.onQueryMetadataSuffix(response, columnCount);
    }

    private void onQueryMetadataSuffix(HttpChunkedResponse response, int columnCount) throws PeerDisconnectedException, PeerIsSlowToReadException {
        this.doQueryMetadataSuffix(response);
        this.onSendRecordsLoop(response, columnCount);
    }

    private void onQueryPrefix(HttpChunkedResponse response, int columnCount) throws PeerDisconnectedException, PeerIsSlowToReadException {
        if (this.doQueryPrefix(response)) {
            this.doQueryMetadata(response, columnCount);
            this.doQueryMetadataSuffix(response);
        }
        this.onSendRecordsLoop(response, columnCount);
    }

    private void onQueryRecord(HttpChunkedResponse response, int columnCount) throws PeerDisconnectedException, PeerIsSlowToReadException {
        this.doQueryRecord(response, columnCount);
        this.onQueryRecordSuffix(response, columnCount);
    }

    private void onQueryRecordPrefix(HttpChunkedResponse response, int columnCount) throws PeerDisconnectedException, PeerIsSlowToReadException {
        this.doQueryRecordPrefix(response);
        this.onQueryRecord(response, columnCount);
    }

    private void onQueryRecordSuffix(HttpChunkedResponse response, int columnCount) throws PeerDisconnectedException, PeerIsSlowToReadException {
        this.doQueryRecordSuffix(response);
        this.doNextRecordLoop(response, columnCount);
    }

    private void onSendRecordsLoop(HttpChunkedResponse response, int columnCount) throws PeerDisconnectedException, PeerIsSlowToReadException {
        if (this.cursorHasRows) {
            this.doRecordFetchLoop(response, columnCount);
        } else {
            this.doQuerySuffix(response, columnCount);
        }
    }

    private void onSetupFirstRecord(HttpChunkedResponse response, int columnCount) throws PeerIsSlowToReadException, PeerDisconnectedException {
        this.setupFirstRecord();
        this.queryState = 1;
        JsonQueryProcessor.header(response, this.getHttpConnectionContext(), this.keepAliveHeader, 200);
        this.onQueryPrefix(response, columnCount);
    }

    private long parseNextColumnName(long rawLo, long rawHi) {
        boolean quoted = false;
        boolean escaped = false;
        while (rawLo < rawHi) {
            byte b = Unsafe.getUnsafe().getByte(rawLo);
            if (b < 0) {
                int n = Utf8s.utf8DecodeMultiByte(rawLo, rawHi, b, (Utf16Sink)this.sink);
                if (n == -1) {
                    return 0L;
                }
                escaped = false;
                rawLo += (long)n;
                continue;
            }
            ++rawLo;
            if (escaped) {
                escaped = false;
                this.sink.put((char)b);
                continue;
            }
            if (b == 92) {
                escaped = true;
                continue;
            }
            if (b == 34) {
                quoted = !quoted;
                continue;
            }
            if (!quoted && b == 44) {
                return rawLo;
            }
            this.sink.put((char)b);
        }
        return rawLo;
    }

    private void putArrayValue(HttpChunkedResponse response, int columnIdx, int columnType) {
        this.arrayState.of(response);
        ArrayView arrayView = this.arrayState.getArrayView() == null ? this.record.getArray(columnIdx, columnType) : this.arrayState.getArrayView();
        try {
            ArrayTypeDriver.arrayToJson(arrayView, response, this.arrayState);
            this.arrayState.clear();
            this.columnValueFullySent = true;
        }
        catch (Throwable e) {
            this.columnValueFullySent = this.arrayState.isNothingWritten();
            this.arrayState.reset(arrayView);
            throw e;
        }
    }

    private void putBinValue(HttpChunkedResponse response) {
        response.putAscii('[');
        response.putAscii(']');
    }

    private void putDoubleValue(HttpChunkedResponse response, Record rec, int col) {
        response.put(rec.getDouble(col));
    }

    private void putFloatValue(HttpChunkedResponse response, Record rec, int col) {
        response.put(rec.getFloat(col));
    }

    private void putVarcharValue(HttpChunkedResponse response, int columnIdx) {
        Utf8Sequence str = this.record.getVarcharA(columnIdx);
        if (str == null) {
            response.putAscii("null");
        } else {
            response.putQuote().escapeJsonStr(str).putQuote();
        }
    }

    private void setupFirstRecord() {
        if (this.skip > 0L) {
            long target;
            RecordCursor cursor = this.cursor;
            for (target = this.skip + 1L; target > 0L && cursor.hasNext(); --target) {
            }
            if (target > 0L) {
                this.cursorHasRows = false;
                return;
            }
            this.count = this.skip;
            this.counter.set(this.skip);
        } else if (!this.cursor.hasNext()) {
            this.cursorHasRows = false;
            return;
        }
        this.columnIndex = 0;
        this.columnValueFullySent = true;
        this.record = this.cursor.getRecord();
        this.cursorHasRows = true;
    }

    static void prepareExceptionJson(HttpChunkedResponse response, int position, CharSequence message, CharSequence query) throws PeerDisconnectedException, PeerIsSlowToReadException {
        ((Utf8Sink)((Utf8Sink)((Utf8Sink)((Utf8Sink)response.putAscii('{').putAsciiQuoted("query")).putAscii(':').putQuote().escapeJsonStr(query != null ? query : "").putQuote().putAscii(',').putAsciiQuoted("error")).putAscii(':').putQuote().escapeJsonStr(message != null ? message : "").putQuote().putAscii(',').putAsciiQuoted("position")).putAscii(':').put(position)).putAscii('}');
        response.sendChunk(true);
    }

    boolean of(RecordCursorFactory factory, boolean queryCacheable, SqlExecutionContextImpl sqlExecutionContext) throws PeerDisconnectedException, PeerIsSlowToReadException, SqlException {
        int columnCount;
        this.recordCursorFactory = factory;
        this.queryCacheable = queryCacheable;
        this.queryJitCompiled = factory.usesCompiledFilter();
        sqlExecutionContext.setColumnPreTouchEnabledOverride(this.stop == Long.MAX_VALUE);
        this.circuitBreaker = sqlExecutionContext.getCircuitBreaker();
        RecordMetadata metadata = factory.getMetadata();
        this.queryTimestampIndex = metadata.getTimestampIndex();
        HttpRequestHeader header = this.httpConnectionContext.getRequestHeader();
        DirectUtf8Sequence columnNames = header.getUrlParam(HttpConstants.URL_PARAM_COLS);
        this.columnNames.clear();
        this.columnSkewList.clear();
        this.columnTypesAndFlags.clear();
        if (columnNames != null) {
            columnCount = 0;
            long rawLo = columnNames.lo();
            long rawHi = columnNames.hi();
            while (rawLo < rawHi) {
                this.sink.clear();
                rawLo = this.parseNextColumnName(rawLo, rawHi);
                if (rawLo <= 0L) {
                    this.info().$("utf8 error when decoding column list '").$safe(columnNames).$('\'').$();
                    HttpChunkedResponse response = this.getHttpConnectionContext().getChunkedResponse();
                    JsonQueryProcessor.header(response, this.getHttpConnectionContext(), "", 400);
                    ((Utf8Sink)((Utf8Sink)response.putAscii('{').putAsciiQuoted("error")).putAscii(':').putAsciiQuoted("utf8 error in column list")).putAscii('}');
                    response.sendChunk(true);
                    return false;
                }
                if (this.sink.length() == 0) {
                    this.info().$("empty column in query parameter '").$(HttpConstants.URL_PARAM_COLS).$(": ").$safe(columnNames).$('\'').$();
                    HttpChunkedResponse response = this.getHttpConnectionContext().getChunkedResponse();
                    JsonQueryProcessor.header(response, this.getHttpConnectionContext(), "", 400);
                    ((Utf8Sink)((Utf8Sink)((Utf8Sink)response.putAscii('{').putAsciiQuoted("query")).putAscii(':').putQuote().escapeJsonStr(this.query).putQuote().putAscii(',').putAsciiQuoted("error")).putAscii(':').putAsciiQuoted("empty column in query parameter")).putAscii('}');
                    response.sendChunk(true);
                    return false;
                }
                if (this.addSunkColumnToOutput(metadata)) {
                    return false;
                }
                ++columnCount;
            }
        } else {
            columnCount = metadata.getColumnCount();
            for (int i = 0; i < columnCount; ++i) {
                this.addColumnTypeAndName(metadata, i);
            }
        }
        this.columnCount = columnCount;
        return true;
    }

    void querySuffixWithError(HttpChunkedResponse response, int code, @Nullable CharSequence message, int messagePosition) throws PeerDisconnectedException, PeerIsSlowToReadException {
        this.cursor = Misc.free(this.cursor);
        this.circuitBreaker = null;
        this.queryState = 7;
        if (this.count > -1L) {
            this.logTimings();
            response.bookmark();
            if (code > 0) {
                response.putAscii(']');
            }
            response.putAscii(']');
            ((Utf8Sink)response.putAscii(',').putAsciiQuoted("count")).putAscii(':').put(this.count);
            if (code > 0) {
                ((Utf8Sink)response.putAscii(',').putAsciiQuoted("error")).putAscii(':').putQuote().escapeJsonStr(message != null ? message : "Internal server error").putQuote().putAscii(", \"errorPos\"").putAscii(':').put(messagePosition);
            }
            if (this.timings) {
                ((Utf8Sink)((Utf8Sink)((Utf8Sink)((Utf8Sink)((Utf8Sink)((Utf8Sink)((Utf8Sink)((Utf8Sink)((Utf8Sink)response.putAscii(',').putAsciiQuoted("timings")).putAscii(':').putAscii('{').putAsciiQuoted("authentication")).putAscii(':').put(this.httpConnectionContext.getAuthenticationNanos())).putAscii(',').putAsciiQuoted("compiler")).putAscii(':').put(this.compilerNanos)).putAscii(',').putAsciiQuoted("execute")).putAscii(':').put(this.nanosecondClock.getTicks() - this.executeStartNanos)).putAscii(',').putAsciiQuoted("count")).putAscii(':').put(this.recordCountNanos)).putAscii('}');
            }
            if (this.explain) {
                ((Utf8Sink)((Utf8Sink)response.putAscii(',').putAsciiQuoted("explain")).putAscii(':').putAscii('{').putAsciiQuoted("jitCompiled")).putAscii(':').putAscii(this.queryJitCompiled ? "true" : "false").putAscii('}');
            }
            response.putAscii('}');
            this.count = -1L;
            this.counter.set(-1L);
            response.sendChunk(true);
            return;
        }
        response.done();
    }

    void resume(HttpChunkedResponse response) throws PeerDisconnectedException, PeerIsSlowToReadException, SqlException {
        this.resumeActions.getQuick(this.queryState).onResume(response, this.columnCount);
    }

    void setQueryCacheable(boolean queryCacheable) {
        this.queryCacheable = queryCacheable;
    }

    @FunctionalInterface
    static interface StateResumeAction {
        public void onResume(HttpChunkedResponse var1, int var2) throws PeerDisconnectedException, PeerIsSlowToReadException, SqlException;
    }
}

